<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class cuti extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('master_model');
		$this->load->model('cuti_model');
		date_default_timezone_set('Asia/Jakarta');
	}

	public function kebijakan_cuti($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_kebijakan']   = $this->master_model->select_in('m_kebijakan_cuti','*',"order by id");
			$this->load->view('cuti/kebijakan', $data);
	    }
	}

	public function insert_kebijakan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	
		$date1 = DateTime::createFromFormat('d/m/Y', $this->input->post('tanggal_awal'));
		$tgl1 = $date1->format('Y-m-d');

		$date2 = DateTime::createFromFormat('d/m/Y', $this->input->post('tanggal_akhir'));
		$tgl2 = $date2->format('Y-m-d');


		$data = array(
			'nama' => $this->input->post('nama'),
			'tanggal_awal' => $tgl1,
			'tanggal_akhir' => $tgl2,			
			'deskripsi' => $this->input->post('deskripsi'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1			
		);
		$this->db->insert('m_kebijakan_cuti', $data);
		redirect('cuti/kebijakan_cuti/'.$menuid);
	}

	public function detail_kebijakan($menuid, $idheader)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_kebijakan']   = $this->master_model->select_in('m_kebijakan_cuti','*',"where id = $idheader");
			$data['data_detail']   = $this->master_model->select_in('m_detail_kebijakan_cuti','*',"where id_header = $idheader order by tanggal");
			$this->load->view('cuti/detail_kebijakan', $data);
	    }
	}

	public function insert_detail_kebijakan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	
		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('tanggal'));
		$tgl = $date->format('Y-m-d');
		
		$id_header = $this->input->post('id_header');

		$data = array(
			'id_header' => $this->input->post('id_header'),
			'tanggal' => $tgl,			
			'keterangan' => $this->input->post('keterangan'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1			
		);
		$this->db->insert('m_detail_kebijakan_cuti', $data);

		$data = array(
			'jumlah_cuti' => $this->input->post('jml_cuti') + 1,			
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1			
		);
		
		$this->db->where('id', $id_header);
		$this->db->update('m_kebijakan_cuti', $data);

		redirect('cuti/detail_kebijakan/'.$menuid.'/'.$id_header);
	}

	function delete_detail_kebijakan($menuid, $id_header, $id_detail){
				
		$sql="update m_kebijakan_cuti set jumlah_cuti = jumlah_cuti-1 where id = $id_header;";
		$qry = $this->db->query($sql);

        $this->db->where('id',$id_detail);
		$this->db->delete('m_detail_kebijakan_cuti');
		
		redirect('cuti/detail_kebijakan/'.$menuid.'/'.$id_header);
	}

	public function cuti_tahunan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_cuti']   = $this->master_model->select_in('m_cuti_tahunan','*',"where 1=0");
			$this->load->view('cuti/tahunan', $data);
	    }
	}

	public function daftar_cuti_tahunan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

		$tahun = $this->input->post('group-b[0][tahun]');
		
		if (empty($tahun)){
			$tahun = $this->session->userdata('tahun');
		}

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_cuti']   = $this->cuti_model->cuti_tahunan($tahun);
			$this->load->view('cuti/detail_tahunan', $data);
	    }
	}

	public function insert_detail_cuti($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	
		$tahun = $this->input->post('tahun_cuti');
		
		if (empty($tahun)){
			$tahun = $this->session->userdata('tahun');
		}

		$data = array(
			'id_pengelola' => $this->input->post('id_pengelola'),
			'tahun_cuti' => $this->input->post('tahun_cuti'),
			'cuti_tahun_ini' => $this->input->post('cuti_tahun_ini'),
			'sisa_cuti_tahun_lalu' => $this->input->post('sisa_cuti_tahun_lalu'),
			'sisa_cuti_2_tahun_lalu' => $this->input->post('sisa_cuti_2_tahun_lalu'),
			'ijin' => $this->input->post('ijin'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1			
		);
		$this->db->insert('m_cuti_tahunan', $data);

		redirect('cuti/daftar_cuti_tahunan/'.$menuid);
	}

	function delete_detail_tahunan($menuid, $id){
				
        $this->db->where('id',$id);
		$this->db->delete('m_cuti_tahunan');
		
		redirect('cuti/daftar_cuti_tahunan/'.$menuid);
	}

	public function permohonan_cuti($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check = $this->master_model->auth_read($user_id, $menuid);
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_cuti']   = $this->cuti_model->jatah_cuti($pengelola);
			$data['data_cuti_terpakai']   = $this->cuti_model->cuti_terpakai($pengelola);
			$data['data_ijin_terpakai']   = $this->cuti_model->ijin_terpakai($pengelola);
			$data['data_pengelola']   = $this->master_model->select_in('m_pengelola','*',"where id=$pengelola");
			$this->load->view('cuti/permohonan', $data);
	    }
	}

	public function permohonan_ijin($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check = $this->master_model->auth_read($user_id, $menuid);
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_cuti']   = $this->cuti_model->jatah_cuti($pengelola);
			$data['data_cuti_terpakai']   = $this->cuti_model->cuti_terpakai($pengelola);
			$data['data_ijin_terpakai']   = $this->cuti_model->ijin_terpakai($pengelola);
			$data['data_pengelola']   = $this->master_model->select_in('m_pengelola','*',"where id=$pengelola");
			$this->load->view('cuti/permohonan_ijin', $data);
	    }
	}

	public function informasi_sakit($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check = $this->master_model->auth_read($user_id, $menuid);
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {			
			$data['data_pengelola']   = $this->master_model->select_in('m_pengelola','*',"where id=$pengelola");
			$this->load->view('cuti/informasi_sakit', $data);
	    }
	}

	public function get_data() {
		// Fetch data based on the parameter, e.g., from a model		
		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('dt_from'));
		$dtFrom = $date->format('Y-m-d');

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('dt_to'));
		$dtTo = $date->format('Y-m-d');
		
		$cuti = $this->cuti_model->sp_hitung_lama_cuti($dtFrom, $dtTo);
		$hari = $cuti[0]->hari;
		
		// Return the result as JSON
		header('Content-Type: application/json');
		echo json_encode(['lama_cuti' => $hari]);
	}
	
	public function insert_permohonan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_permohonan'));
		$tgl_permohonan = $date->format('Y-m-d');

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('from'));
		$from = $date->format('Y-m-d');

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('to'));
		$to = $date->format('Y-m-d');

		$data = array(
			'id_pengelola' => $this->input->post('id_pengelola'),
			'sisa_cuti' => $this->input->post('sisa_cuti'),
			'tgl_permohonan' => $tgl_permohonan,
			'keperluan' => $this->input->post('keperluan'),
			'tgl_permohonan_mulai' => $from,
			'tgl_permohonan_akhir' => $to,
			'lama_cuti' => $this->input->post('lama_cuti'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1,			
    		'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1			
		);
		$this->db->insert('tr_permohonan_cuti', $data);
		
		$user_id = $this->session->userdata('user_id');
	    $check = $this->master_model->auth_read($user_id, $menuid);
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['modal_message'] = 'Permohonan cuti anda berhasil di kirim dan akan di review oleh Kadiv dan HRD';
			$data['data_cuti']   = $this->cuti_model->jatah_cuti($pengelola);
			$data['data_cuti_terpakai']   = $this->cuti_model->cuti_terpakai($pengelola);
			$data['data_ijin_terpakai']   = $this->cuti_model->ijin_terpakai($pengelola);
			$data['data_pengelola']   = $this->master_model->select_in('m_pengelola','*',"where id=$pengelola");
			$this->load->view('cuti/permohonan', $data);
	    }
	}

	public function daftar_permohonan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check = $this->master_model->auth_read($user_id, $menuid);
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;
		if(empty($pengelola)){
			$pengelola = 0;
		}

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_permohonan']   = $this->cuti_model->permohonan($pengelola);
			$data['data_permohonan_ijin']   = $this->cuti_model->permohonan_ijin($pengelola);
			$data['data_informasi_sakit']   = $this->cuti_model->informasi_sakit($pengelola);
			$this->load->view('cuti/data_permohonan', $data);
	    }
	}

	public function update_status_cuti($menuid) {
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;
								
		$id = $this->input->post('id');
		$persetujuan = $this->input->post('persetujuan_lembur');

		if($persetujuan==0){
			$data = array(
				'tindakan_hrd' => $this->input->post('tindakan'),
				'tgl_tindakan_hrd' => date('Y-m-d'),			
				'catatan_hrd' => $this->input->post('catatan'),
				'update_at' => date('Y-m-d H:i:s'),
				'update_by' => $user_id1			
			);

		} else {
			if($pengelola==0){
				$data = array(
					'tindakan_hrd' => $this->input->post('tindakan'),
					'tgl_tindakan_hrd' => date('Y-m-d'),				
					'catatan_hrd' => $this->input->post('catatan'),
					'update_at' => date('Y-m-d H:i:s'),
					'update_by' => $user_id1			
				);
			} else {
				$data = array(
					'tindakan_kadiv' => $this->input->post('tindakan'),
					'tgl_tindakan_kadiv' => date('Y-m-d'),
					'catatan_kadiv' => $this->input->post('catatan'),
					'update_at' => date('Y-m-d H:i:s'),
					'update_by' => $user_id1			
				);
	
			}	
		}
		
		$this->db->where('id', $id);
		$this->db->update('tr_permohonan_cuti', $data);

		redirect('cuti/daftar_permohonan/'.$menuid);

	}

	public function update_status_ijin($menuid) {
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;
								
		$id = $this->input->post('id');
		$persetujuan = $this->input->post('persetujuan_lembur');

		if($persetujuan==0){
			$data = array(
				'tindakan_hrd' => $this->input->post('tindakan'),
				'tgl_tindakan_hrd' => date('Y-m-d'),			
				'catatan_hrd' => $this->input->post('catatan'),
				'update_at' => date('Y-m-d H:i:s'),
				'update_by' => $user_id1			
			);

		} else {
			if($pengelola==0){
				$data = array(
					'tindakan_hrd' => $this->input->post('tindakan'),
					'tgl_tindakan_hrd' => date('Y-m-d'),				
					'catatan_hrd' => $this->input->post('catatan'),
					'update_at' => date('Y-m-d H:i:s'),
					'update_by' => $user_id1			
				);
			} else {
				$data = array(
					'tindakan_kadiv' => $this->input->post('tindakan'),
					'tgl_tindakan_kadiv' => date('Y-m-d'),
					'catatan_kadiv' => $this->input->post('catatan'),
					'update_at' => date('Y-m-d H:i:s'),
					'update_by' => $user_id1			
				);
	
			}	
		}
		
		$this->db->where('id', $id);
		$this->db->update('tr_permohonan_ijin', $data);

		redirect('cuti/daftar_permohonan/'.$menuid);

	}

	public function update_status_sakit($menuid) {
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;
		
        $id = $this->input->post('id');
		$persetujuan = $this->input->post('persetujuan_lembur');
		
		if($persetujuan==0){
			$data = array(
				'tindakan_hrd' => $this->input->post('tindakan'),
				'tgl_tindakan_hrd' => date('Y-m-d'),			
				'catatan_hrd' => $this->input->post('catatan'),
				'update_at' => date('Y-m-d H:i:s'),
				'update_by' => $user_id1			
			);

		} else {
			if($pengelola==0){
				$data = array(
					'tindakan_hrd' => $this->input->post('tindakan'),
					'tgl_tindakan_hrd' => date('Y-m-d'),				
					'catatan_hrd' => $this->input->post('catatan'),
					'update_at' => date('Y-m-d H:i:s'),
					'update_by' => $user_id1			
				);
			} else {
				$data = array(
					'tindakan_kadiv' => $this->input->post('tindakan'),
					'tgl_tindakan_kadiv' => date('Y-m-d'),
					'catatan_kadiv' => $this->input->post('catatan'),
					'update_at' => date('Y-m-d H:i:s'),
					'update_by' => $user_id1			
				);
	
			}	
		}
		
		$this->db->where('id', $id);
		$this->db->update('tr_permohonan_sakit', $data);

		redirect('cuti/daftar_permohonan/'.$menuid);

	}
	
	public function get_end_time() {
        // Menerima data waktu dari permintaan POST AJAX
        $startTimeValue = $this->input->post('start_time');

        // Melakukan perhitungan end_time
        $endTime = $this->calculateEndTime($startTimeValue);

        // Menyusun hasil dalam format JSON
        $result = ['end_time' => $endTime];

        // Mengirim hasil sebagai respons JSON
        header('Content-Type: application/json');
        echo json_encode($result);
    }

	// Fungsi untuk menghitung end_time
    private function calculateEndTime($startTimeValue) {
		
		$startTimestamp = strtotime($startTimeValue);
		$endTimestamp = $startTimestamp + 4 * 60 * 60;
		$endTime = date('H:i', $endTimestamp);
		
		$calculatedEndTime = $endTime;
	
        return $calculatedEndTime;
    }
		
	public function insert_permohonan_ijin($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_permohonan'));
		$tgl_permohonan = $date->format('Y-m-d');

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_ijin'));
		$tgl_ijin = $date->format('Y-m-d');

		$startTimeValue = $this->input->post('jam_ijin_mulai');
		$startTimestamp = strtotime($startTimeValue);
		$endTimestamp = $startTimestamp + 4 * 60 * 60;
		$endTime = date('H:i', $endTimestamp);

		$data = array(
			'id_pengelola' => $this->input->post('id_pengelola'),
			'sisa_ijin' => $this->input->post('sisa_ijin'),
			'tgl_permohonan' => $tgl_permohonan,
			'keperluan' => $this->input->post('keperluan'),
			'tgl_ijin' => $tgl_ijin,
			'jam_ijin_mulai' => $this->input->post('jam_ijin_mulai'),
			'jam_ijin_akhir' => $endTime,
			'lama_ijin' => 4,
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1			
		);
		$this->db->insert('tr_permohonan_ijin', $data);
		
		$user_id = $this->session->userdata('user_id');
	    $check = $this->master_model->auth_read($user_id, $menuid);
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['modal_message'] = 'Permohonan ijin anda berhasil di kirim dan akan di review oleh Kadiv & HRD';
			$data['data_cuti']   = $this->cuti_model->jatah_cuti($pengelola);
			$data['data_cuti_terpakai']   = $this->cuti_model->cuti_terpakai($pengelola);
			$data['data_ijin_terpakai']   = $this->cuti_model->ijin_terpakai($pengelola);
			$data['data_pengelola']   = $this->master_model->select_in('m_pengelola','*',"where id=$pengelola");
			$this->load->view('cuti/permohonan_ijin', $data);
	    }
	}	

	public function insert_infosakit($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_permohonan'));
		$tgl_permohonan = $date->format('Y-m-d');

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('from'));
		$from = $date->format('Y-m-d');

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('to'));
		$to = $date->format('Y-m-d');

		$data = array(
			'id_pengelola' => $this->input->post('id_pengelola'),			
			'tgl_permohonan' => $tgl_permohonan,
			'keterangan_sakit' => $this->input->post('keterangan_sakit'),
			'tgl_sakit_awal' => $from,
			'tgl_sakit_akhir' => $to,
			'lama_sakit' => $this->input->post('lama_sakit'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1			
		);
		$this->db->insert('tr_permohonan_sakit', $data);
		
		$user_id = $this->session->userdata('user_id');
	    $check = $this->master_model->auth_read($user_id, $menuid);
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['modal_message'] = 'Permohonan cuti anda berhasil di kirim dan akan di review oleh Kadiv dan HRD';
			$data['data_pengelola']   = $this->master_model->select_in('m_pengelola','*',"where id=$pengelola");
			$this->load->view('cuti/informasi_sakit', $data);
	    }
	}

	public function surat_sakit($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check = $this->master_model->auth_read($user_id, $menuid);
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {			
			$data['data_pengelola']   = $this->master_model->select_in('m_pengelola','*',"where id=$pengelola");
			$this->load->view('cuti/upload_surat_sakit', $data);
	    }
	}

	public function insert_surat_sakit($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$this->load->helper(array('form', 'url')); 
		$photo = "";
		$this->load->library('upload');
		$config['upload_path'] = './uploads/dokumen/'; // Sesuaikan sama folder dimana foto akan d simpan
		$config['allowed_types'] = 'jpg|png|jpeg|bmp|pdf';
		$config['max_size'] = '12048';						

		$this->upload->initialize($config);
		if(!$this->upload->do_upload('nama_file')){
			$photo='';
		}else{
			$photo=$this->upload->file_name;
		}

		$data = array(
			'id_pengelola' => $this->input->post('id_pengelola'),						
			'id_permohonan_sakit' => $this->input->post('id_permohonan_sakit'),
			'keterangan_file' => $this->input->post('keterangan_file'),
			'nama_file' => $photo,
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1			
		);
		$this->db->insert('surat_ket_sakit', $data);
		
		$user_id = $this->session->userdata('user_id');
	    $check = $this->master_model->auth_read($user_id, $menuid);
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['modal_message'] = 'Upload File Berhasil Dilakukan';
			$data['data_pengelola']   = $this->master_model->select_in('m_pengelola','*',"where id=$pengelola");
			$this->load->view('cuti/upload_surat_sakit', $data);
	    }
	}

	public function riwayat_permohonan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check = $this->master_model->auth_read($user_id, $menuid);
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;
		if(empty($pengelola)){
			$pengelola = 0;
		}

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_permohonan']   = $this->cuti_model->riwayat_permohonan($pengelola);
			$data['data_permohonan_ijin']   = $this->cuti_model->riwayat_permohonan_ijin($pengelola);
			$data['data_informasi_sakit']   = $this->cuti_model->riwayat_informasi_sakit($pengelola);
			$this->load->view('cuti/riwayat_permohonan', $data);
	    }
	}
	
	function pembatalan_cuti($menuid, $id){
				
		$sql="insert into tr_pembatalan_cuti select * From tr_permohonan_cuti where id = $id;";
		$qry = $this->db->query($sql);

        $this->db->where('id',$id);
		$this->db->delete('tr_permohonan_cuti');
		
		redirect('cuti/riwayat_permohonan/'.$menuid);
	}

	function pembatalan_ijin($menuid, $id){
				
		$sql="insert into tr_permohonan_ijin_batal select * From tr_permohonan_ijin where id = $id;";
		$qry = $this->db->query($sql);

        $this->db->where('id',$id);
		$this->db->delete('tr_permohonan_ijin');
		
		redirect('cuti/riwayat_permohonan/'.$menuid);
	}

	public function koreksi_cuti($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	    $data_cuti   = $this->master_model->select_in('tr_permohonan_cuti','*',"where id = $id");
        $idpengelola = $data_cuti[0]->id_pengelola;
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['koreksi']   = $this->master_model->select_in('tr_permohonan_cuti','*',"where id = $id");
    	    $data['pengelola']   = $this->master_model->select_in('m_pengelola','*',"where id = $idpengelola");	    	
			$this->load->view('cuti/koreksi_permohonan', $data);
	    }
	}

    public function koreksi_ijin($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	    $data_cuti   = $this->master_model->select_in('tr_permohonan_ijin','*',"where id = $id");
        $idpengelola = $data_cuti[0]->id_pengelola;
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['koreksi']   = $this->master_model->select_in('tr_permohonan_ijin','*',"where id = $id");
    	    $data['pengelola']   = $this->master_model->select_in('m_pengelola','*',"where id = $idpengelola");	    	
			$this->load->view('cuti/koreksi_permohonan_ijin', $data);
	    }
	}

    public function koreksi_permohonan($menuid) {
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

        $id = $this->input->post('id');

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('to'));
		$to = $date->format('Y-m-d');
		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('from'));
		$from = $date->format('Y-m-d');
		
		$data = array(
			'tgl_permohonan_akhir' => $to,
			'tgl_permohonan_mulai' => $from,
			'catatan_koreksi' => $this->input->post('catatan_koreksi'),
			'lama_cuti' => $this->input->post('lama_cuti'),
			'koreksi_at' => date('Y-m-d H:i:s'),
			'koreksi_by' => $user_id1			
		);

		$this->db->where('id', $id);
		$this->db->update('tr_permohonan_cuti', $data);

		redirect('cuti/riwayat_permohonan/'.$menuid);

	}
	
	public function koreksi_permohonan_ijin($menuid) {
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

        $id = $this->input->post('id');

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_ijin'));
		$tgl_ijin = $date->format('Y-m-d');

		$startTimeValue = $this->input->post('jam_ijin_mulai');
		$startTimestamp = strtotime($startTimeValue);
		$endTimestamp = $startTimestamp + 4 * 60 * 60;
		$endTime = date('H:i', $endTimestamp);

		$data = array(
			'tgl_ijin' => $tgl_ijin,
			'jam_ijin_mulai' => $this->input->post('jam_ijin_mulai'),
			'jam_ijin_akhir' => $endTime,
			'catatan_koreksi' => $this->input->post('catatan_koreksi'),
			'koreksi_at' => date('Y-m-d H:i:s'),
			'koreksi_by' => $user_id1				
		);

		$this->db->where('id', $id);
		$this->db->update('tr_permohonan_ijin', $data);

		redirect('cuti/riwayat_permohonan/'.$menuid);

	}

	public function laporan_cuti($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_cuti']   = $this->master_model->select_in('tr_absen','*',"where 1=0");
			$this->load->view('cuti/laporan_cuti', $data);
	    }
	}

	public function detail_lap_cuti($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][tanggal1]'));
		$tanggal1 = $date->format('Y-m-d');
		
		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][tanggal2]'));
		$tanggal2 = $date->format('Y-m-d');

		if (empty($tanggal1)){
			$tanggal1 = $this->session->userdata('tanggal1');
			$tanggal2 = $this->session->userdata('tanggal2');
		}

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_cuti']   = $this->cuti_model->laporancuti($tanggal1, $tanggal2);
			$this->load->view('cuti/detail_cuti', $data);
	    }
	}

    public function excel_cuti($menuid, $tanggal1, $tanggal2)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_cuti']   = $this->cuti_model->laporancuti($tanggal1, $tanggal2);
			$this->load->view('cuti/excel_cuti', $data);
	    }
	}


    public function laporan_ijin($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_ijin']   = $this->master_model->select_in('tr_absen','*',"where 1=0");
			$this->load->view('cuti/laporan_ijin', $data);
	    }
	}

	public function detail_lap_ijin($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][tanggal1]'));
		$tanggal1 = $date->format('Y-m-d');
		
		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][tanggal2]'));
		$tanggal2 = $date->format('Y-m-d');

		if (empty($tanggal1)){
			$tanggal1 = $this->session->userdata('tanggal1');
			$tanggal2 = $this->session->userdata('tanggal2');
		}

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_ijin']   = $this->cuti_model->laporanijin($tanggal1, $tanggal2);
			$this->load->view('cuti/detail_ijin', $data);
	    }
	}

    public function excel_ijin($menuid, $tanggal1, $tanggal2)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_ijin']   = $this->cuti_model->laporanijin($tanggal1, $tanggal2);
			$this->load->view('cuti/excel_ijin', $data);
	    }
	}
	
	
	public function laporan_kunjungan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_kunjungan']   = $this->master_model->select_in('tr_absen','*',"where 1=0");
			$this->load->view('cuti/laporan_kunjungan', $data);
	    }
	}

	public function detail_lap_kunjungan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][tanggal1]'));
		$tanggal1 = $date->format('Y-m-d');
		
		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][tanggal2]'));
		$tanggal2 = $date->format('Y-m-d');

		if (empty($tanggal1)){
			$tanggal1 = $this->session->userdata('tanggal1');
			$tanggal2 = $this->session->userdata('tanggal2');
		}

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_kunjungan']   = $this->cuti_model->laporankunjungan($tanggal1, $tanggal2);
			$this->load->view('cuti/detail_kunjungan', $data);
	    }
	}

    public function excel_kunjungan($menuid, $tanggal1, $tanggal2)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_kunjungan']   = $this->cuti_model->laporankunjungan($tanggal1, $tanggal2);
			$this->load->view('cuti/excel_kunjungan', $data);
	    }
	}
	
	public function laporan_sakit($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_sakit']   = $this->master_model->select_in('tr_absen','*',"where 1=0");
			$this->load->view('cuti/laporan_sakit', $data);
	    }
	}

	public function detail_lap_sakit($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][tanggal1]'));
		$tanggal1 = $date->format('Y-m-d');
		
		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][tanggal2]'));
		$tanggal2 = $date->format('Y-m-d');

		if (empty($tanggal1)){
			$tanggal1 = $this->session->userdata('tanggal1');
			$tanggal2 = $this->session->userdata('tanggal2');
		}

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_sakit']   = $this->cuti_model->laporansakit($tanggal1, $tanggal2);
			$this->load->view('cuti/detail_sakit', $data);
	    }
	}

    public function excel_sakit($menuid, $tanggal1, $tanggal2)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_sakit'] = $this->cuti_model->laporansakit($tanggal1, $tanggal2);
			$this->load->view('cuti/excel_sakit', $data);
	    }
	}
	
}
?>
