<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class dashboard extends CI_Controller {

	public function __construct()

	{
		parent :: __construct();	
		$this->load->model('backend_model');
		$this->load->model('master_model');
		$this->load->model('cuti_model');
		$this->load->model('kunjungan_model');
		$this->load->model('absensi_model');
    }


	function index($menuid)
	{		
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;
		
		if(!empty($pengelola)){
			if($check==false)
			{
				redirect('my404');
			}else
			{			
	    		$staff = $this->master_model->select_in('m_pengelola','*',"where id=$pengelola");
        		$kodepengelola = $staff[0]->id_pengelola;

				$data['data_cuti']   = $this->cuti_model->jatah_cuti($pengelola);
				$data['data_cuti_terpakai']   = $this->cuti_model->cuti_terpakai($pengelola);
				$data['data_ijin_terpakai']   = $this->cuti_model->ijin_terpakai($pengelola);
				$data['data_sakit_terpakai']   = $this->cuti_model->sakit_terpakai($pengelola);
				$data['data_telat_tahun']   = $this->cuti_model->telat($kodepengelola);
				$data['data_pulang_tahun']   = $this->cuti_model->tidak_absen_pulang($kodepengelola);
				$data['data_pengelola']   = $this->master_model->select_in('m_pengelola','*',"where id=$pengelola");
				$data['data_pending']   = $this->master_model->select_in('tr_permohonan_cuti','*',"where id_pengelola=$pengelola and tindakan_hrd = 0");
				$data['data_approve']   = $this->master_model->select_in('tr_permohonan_cuti','*',"where id_pengelola=$pengelola and (tindakan_hrd = 1 or tindakan_hrd = 2)");
				$data['data_pending_ijin']   = $this->master_model->select_in('tr_permohonan_ijin','*',"where id_pengelola=$pengelola and tindakan_hrd = 0");
				$data['data_approve_ijin']   = $this->master_model->select_in('tr_permohonan_ijin','*',"where id_pengelola=$pengelola and (tindakan_hrd = 1 or tindakan_hrd = 2)");					
				$data['data_user']   = $this->master_model->select_in('user','*',"where ID=$user_id");

    			$data['data_tetap']   = $this->master_model->select_in('m_pengelola','count(id) as tetap',"where status_pengelola = 1 and is_active = 1");
    			$data['data_percobaan']   = $this->master_model->select_in('m_pengelola','count(id) as percobaan',"where status_pengelola = 2 and is_active = 1");
    			$data['total_pengelola']   = $this->master_model->select_in('m_pengelola','count(id) as jml_pengelola',"where is_active = 1");
    			$data['data_resign']   = $this->master_model->select_in('m_pengelola','count(id) as resign',"where tgl_resign > '1900-01-01'");
    			$data['data_telat']   = $this->absensi_model->telat_hari_ini();
    			$data['data_cuti_hari_ini']   = $this->cuti_model->cuti_hari_ini();
    			$data['data_ijin_hari_ini']   = $this->cuti_model->ijin_hari_ini();
    			$data['data_sakit_hari_ini']   = $this->cuti_model->sakit_hari_ini();
    			$data['data_kunjungan_hari_ini']   = $this->kunjungan_model->kunjungan_hari_ini();

				$this->load->view('dashboard', $data);
			}
		} else {
			$data['data_tetap']   = $this->master_model->select_in('m_pengelola','count(id) as tetap',"where status_pengelola = 1 and is_active = 1");
			$data['data_percobaan']   = $this->master_model->select_in('m_pengelola','count(id) as percobaan',"where status_pengelola = 2 and is_active = 1");
			$data['total_pengelola']   = $this->master_model->select_in('m_pengelola','count(id) as jml_pengelola',"where is_active = 1");
			$data['data_resign']   = $this->master_model->select_in('m_pengelola','count(id) as resign',"where tgl_resign > '1900-01-01'");
			$data['data_telat']   = $this->absensi_model->telat_hari_ini();
			$data['data_cuti_hari_ini']   = $this->cuti_model->cuti_hari_ini();
			$data['data_ijin_hari_ini']   = $this->cuti_model->ijin_hari_ini();
			$data['data_sakit_hari_ini']   = $this->cuti_model->sakit_hari_ini();
			$data['data_kunjungan_hari_ini']   = $this->kunjungan_model->kunjungan_hari_ini();
			$data['data_user']   = $this->master_model->select_in('user','*',"where ID=$user_id");
			$this->load->view('dashboard', $data);
		}
	}

	
}
?>