<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class jurnal extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('master_model');
		$this->load->model('jurnal_model');

		date_default_timezone_set("Asia/Bangkok");
  	}

	public function daftar_jurnal($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$check=$this->master_model->auth_read($user_id, $menuid);

		if($check==false)
		{
			redirect('NotAuthorized');
		}else
		{
			$data['data_jurnal'] = $this->master_model->select_in('acc_journal', '*', "WHERE 1=0");

			$this->load->view('jurnal/daftar_jurnal', $data);
		}
	}  

	public function daftar_jurnal2($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][from_date]'));
		$date1 = $date->format('Y-m-d');

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][to_date]'));
		$date2 = $date->format('Y-m-d');

		$jenis = $this->input->post('group-b[0][jurnal_type]');

		if (empty($date1)){
			$date1 = $this->session->userdata('date1');
			$date2 = $this->session->userdata('date2');
		}

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
		
			$data['data_header']   = $this->jurnal_model->listJournal($date1, $date2, $jenis);

			$this->load->view('jurnal/daftar_jurnal2', $data);
	    }
	}

	public function jurnal_detail($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

		$date1 = new datetime($this->input->post('from_date')); 
		$date1 = $date1->format('Y-m-d');

		$date2 = DateTime::createFromFormat('d/m/Y', $this->input->post('to_date'));
		$date2 = $date2->format('Y-m-d');

		$jenis = $this->input->post('jurnal_type');

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
		
			$data['data_detail']   = $this->jurnal_model->listJournalDetail($date1, $date2, $jenis, $id);

			$this->load->view('jurnal/jurnal_detail', $data);
	    }
	}

	public function jurnal_baru($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$check=$this->master_model->auth_read($user_id, $menuid);

				if($check==false)
		{
			redirect('NotAuthorized');
		}else
		{
			$data['data_jurnal'] = $this->master_model->select_in('acc_journal', '*', "WHERE 1=0");

			$this->load->view('jurnal/input_jurnal', $data);
		}
	}  
	

	public function insert_jurnal($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$locations = $this->input->post('group-c[][repeat]');		
		$a=0; $debet=0; $kredit=0;
		foreach ($locations as $key => $subValue){
	
			$debet =  $debet + $subValue['debet_value'];
			$kredit = $kredit + $subValue['credit_value'];

			$a++; 
		}
		
		if ($debet <> $kredit) {
			$data['error']['jumlah'] = 'Jurnal Tidak Seimbang';
		}

		if ($debet==0 and $kredit==0) {
			$data['error']['jumlah'] = 'Nilai Debet / Kredit Tidak Boleh Nol';
		}

		if (empty($data['error'])) {
			// jika validasi berhasil

			// jurnal header
			$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][tanggal]'));
			$tanggal = $date->format('Y-m-d');

			$data = array(
				'journal_type' => 'GJ',
				'journal_date' => $tanggal,
				'journal_voucher' => '',
				'journal_desc' => $this->input->post('group-b[0][memo_header]'),
				'created_at' => date('Y-m-d H:i:s'),
				'created_by' => $user_id1
			);	
			$this->db->insert('acc_journal', $data);
			
			$data_journal=$this->jurnal_model->getJournalID();
			$jID = $data_journal[0]->last_id;	

			$jDate = $tanggal;
			$jDate = substr($jDate,0,7);

			$data_voucher=$this->jurnal_model->genVoucher($jDate,'J');
			$jVoucher = $data_voucher[0]->journal_voucher;

			$data = array(			
				'journal_voucher' => $jVoucher
			);	

			$this->db->where('id', $jID);
			$this->db->update('acc_journal', $data);

			//jurnal detail

			$locations = $this->input->post('group-c[][coa_id]');
			$a=0;
			foreach ($locations as $key => $subValue){

				$debet = $subValue['debet_value'];
				$kredit = $subValue['credit_value']; 

				$cekDetail = $this->master_model->select_in('acc_journal_detail', '*', "WHERE journal_id = $jID");
				if (empty($cekDetail[0]->journal_id)){
					$detail_id = 1;
				} else {
					$detail_id = 0;
				}

				$data = array(
					'detail_id' => $detail_id,
					'journal_id' => $jID,
					'coa_id' => $subValue['coa_id'],
					'detail_desc' => '',
					'debet_value' => str_replace('.','',$debet),
					'credit_value' => str_replace('.','',$kredit),
					'created_at' => date('Y-m-d H:i:s'),
					'created_by' => $user_id1
				);	
			
				$this->db->insert('acc_journal_detail', $data);	

				$a++;
			}

			// redirect('jurnal/jurnal_baru/'.$menuid);

			$data['hasil'] = 'sukses';			
			
		} else {
			// jika validasi gagal
			$data['hasil'] = 'gagal';
		}
		// tampilkan response dalam format json
		echo json_encode($data);

	}


	public function edit_header($menuid, $meja, $id_header)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', '*', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		$sales = $data_admin[0]->id_sales;



		redirect('order/input_order/'.$menuid.'/'.$id_header);
	}

	public function input_order($menuid, $jID)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_header']    = $this->master_model->select_in('order_header','*',"where id = $jID");
			$data['data_kelompok']    = $this->master_model->select_in('m_kelompok_menu','*',"order by id");
	    	$data['data_menu']    = $this->master_model->select_in('m_menu_resto','*',"ORDER BY id");

    		$this->load->view('order/input_order', $data);
	    }
	}

	public function insert_detail($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$data = array(
			'id_menu' => $this->input->get('menu'),
			'jumlah' => $this->input->get('jumlah'),
			'harga' => $this->input->get('harga'),
			'id_header' => $this->input->get('header'),
			'total' => $this->input->get('jumlah') * $this->input->get('harga'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	
		$this->db->insert('order_detail', $data);		
	}

	function list_transaksi(){
        $faktur = $_GET['faktur'];
        echo "<table id='example1' class='table table-bordered table-striped'>
                <thead><tr><th>No</th><th>Menu</th><th>Jml</th><th>Harga</th><th>Total</th><th>Del</th></tr></thead>";
        $sql = "SELECT tb2.kode_menu,tb2.nama_menu,tb1.jumlah,tb1.harga,tb1.total,tb1.id
                FROM order_detail as tb1, m_menu_resto as tb2
                WHERE tb1.id_menu=tb2.id and tb1.id_header=$faktur order by tb1.id";
        
        $list = $this->db->query($sql)->result();
		$no=1;
		$total=0;
        foreach ($list as $row){
            echo "<tr>
                <td>$no</td>				
				<td>$row->nama_menu</td>
                <td onChange='edit($row->id)'><input type='text' name='jumlah$row->id' id='jumlah$row->id' style='width: 40px;' value='$row->jumlah'></td>
				<td>".number_format($row->harga,0); echo "</td>
				<td>".number_format($row->total,0); echo "</td>
				<td onClick='hapus($row->id)'><button class='btn btn-danger btn-xs'><i class='fa fa-trash-o'></button></td>				
                </tr>";
			$no++;
			$total=$total+$row->total;
		}
		echo" <tr>
			<td></td>			
			<td><strong>TOTAL</strong></td>
			<td></td>
			<td></td>
			<td><strong>".number_format($total,0); echo "</strong></td>
			<td></td>
		</tr>";
        echo" </table>";
	}
	
	function hapus_transaksi(){
        $id = $_GET['id'];
        $this->db->where('id',$id);
        $this->db->delete('order_detail');
	}

	function edit_transaksi(){
		$id = $_GET['id'];
		$jml = $_GET['jumlah'];
		
		$sql="update order_detail set jumlah = $jml, total = $jml * harga where id = $id;";
		$qry = $this->db->query($sql);
	}

	function validasi_pembayaran(){
		$jumlah = $_POST['jumlahbyr'];
		$total = $_POST['totalbyr'];
		// validasi seadanya :v
		if ($jumlah == '') {
			$data['error']['jumlah'] = 'Jumlah Tidak Boleh Kosong';
		}
		if($jumlah < $total){
			$data['error']['jumlah'] = 'Jumlah Pembayaran Kurang';
		}

		if (empty($data['error'])) {
			// jika validasi berhasil
			$data['hasil'] = 'sukses';
			// lakukan proses simpan data disini atau perintah lainnya
			// INSERT INTO bla bla bla...
		} else {
			// jika validasi gagal
			$data['hasil'] = 'gagal';
		}
		// tampilkan response dalam format json
		echo json_encode($data);
	}
}
?>
