<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class master_payroll extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('master_model');
	}

	public function payroll_component($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_component']   = $this->master_model->select_in('mscomponent','id, case when component_type=1 then "Allowance" else "Deduction" end as component_type , component_code, component_name, component_group, case when component_status=1 then "Active" else "Not Active" end as component_status',"ORDER BY component_type, component_code ");
			$this->load->view('pycomp/list', $data);
	    }
	}

	public function insert_component($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	
		$data = array(
			'component_type' => $this->input->post('component_type'),
			'component_code' => $this->input->post('component_code'),
			'component_name' => $this->input->post('component_name'),
			'component_group' => $this->input->post('component_group'),
			'component_status' => $this->input->post('component_status'),
			'component_tax' => $this->input->post('component_tax'),
			'bpjs_based' => $this->input->post('bpjs_based'),
			'ot_based' => $this->input->post('ot_based'),
			'created_at' => date('Y-m-d H:i:s'),
			'created_by' => $user_id1			
		);
		$this->db->insert('mscomponent', $data);
		redirect('master_payroll/payroll_component/'.$menuid);
	}

	public function edit_component($menuid)
	{
		$idComp = $this->input->post('id');
		$data_edit = $this->master_model->mst_data_edit('mscomponent', $idComp);

		echo'
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal">&times;</button>
			<h4 class="modal-title">Edit Payroll Component</h4>
		</div>
		<form action="'.base_url().'master_payroll/edit_process_component/'.$menuid.'/'.$idComp.'" method="post" enctype="multipart/form-data">
			<div class="modal-body">

				<div class="form-group">
					';
					$rd1 = $data_edit[0]->component_type;
					
					if($rd1 == '1') {$sts1 = 'checked="checked"';}else {$sts1="";}
					if($rd1 == '2') {$sts2 = 'checked="checked"';}else {$sts2="";}
					
					echo '
					<label>Component Type</label>
					<br />
					<input type="radio" name="component_type" value="1" '.$sts1.'/> Allowance
					<input type="radio" name="component_type" value="2" '.$sts2.'/> Deduction
				</div>
			
				<div class="form-group">
					<label>Component Code</label>
					<input type="text" value="'.$data_edit[0]->component_code.'" name="component_code" class="form-control" placeholder="Component Code">
				</div>

				<div class="form-group">
					<label>Component Name</label>
					<input type="text" value="'.$data_edit[0]->component_name.'" name="component_name" class="form-control" placeholder="Component Name">
				</div>				

				<div class="form-group">
					';
					$rd1 = $data_edit[0]->component_group;
					
					if($rd1 == '1') {$sts1 = 'checked="checked"';}else {$sts1="";}
					if($rd1 == '2') {$sts2 = 'checked="checked"';}else {$sts2="";}
					
					echo '
					<label>Component Group</label>
					<br />
					<input type="radio" name="component_group" value="1" '.$sts1.'/> Fixed Allowance
					<input type="radio" name="component_group" value="2" '.$sts2.'/> Non Fixed Allowance
				</div>

				<div class="form-group">
					';
					$rd1 = $data_edit[0]->component_tax;
					
					if($rd1 == '0') {$sts0 = 'checked="checked"';}else {$sts0="";}
					if($rd1 == '1') {$sts1 = 'checked="checked"';}else {$sts1="";}
					if($rd1 == '2') {$sts2 = 'checked="checked"';}else {$sts2="";}
					
					echo '
					<label>Component Tax</label>
					<br />
					<input type="radio" name="component_tax" value="0" '.$sts0.'/> (None)
					<input type="radio" name="component_tax" value="1" '.$sts1.'/> Gross Regular
					<input type="radio" name="component_tax" value="2" '.$sts2.'/> Gross Iregular
				</div>

				<div class="form-group">
					';
					$rd1 = $data_edit[0]->component_status;
					
					if($rd1 == '1') {$sts1 = 'checked="checked"';}else {$sts1="";}
					if($rd1 == '2') {$sts2 = 'checked="checked"';}else {$sts2="";}
					
					echo '
					<label>Status</label>
					<br />
					<input type="radio" name="component_status" value="1" '.$sts1.'/> Active
					<input type="radio" name="component_status" value="2" '.$sts2.'/> Not Active
				</div>

				<div class="form-group">
					';
					$rd1 = $data_edit[0]->bpjs_based;
					
					if($rd1 == '1') {$sts1 = 'checked="checked"';}else {$sts1="";}
					if($rd1 == '2') {$sts2 = 'checked="checked"';}else {$sts2="";}
					
					echo '
					<label>BPJS Based</label>
					<br />
					<input type="radio" name="bpjs_based" value="1" '.$sts1.'/> Yes
					<input type="radio" name="bpjs_based" value="2" '.$sts2.'/> No
				</div>

				<div class="form-group">
					';
					$rd1 = $data_edit[0]->ot_based;
					
					if($rd1 == '1') {$sts1 = 'checked="checked"';}else {$sts1="";}
					if($rd1 == '2') {$sts2 = 'checked="checked"';}else {$sts2="";}
					
					echo '
					<label>Overtime Based</label>
					<br />
					<input type="radio" name="ot_based" value="1" '.$sts1.'/> Yes
					<input type="radio" name="ot_based" value="2" '.$sts2.'/> No
				</div>

			</div>
			<div class="modal-footer">
				<button type="submit" value="1" name="submit" class="btn btn-danger btn-fill pull-right save_phone save_email">Save And Close</button>
			</div>
		</form>
		';
	}

	public function edit_process_component($menuid, $idComp)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	
		$data = array(
			'component_type' => $this->input->post('component_type'),
			'component_code' => $this->input->post('component_code'),
			'component_name' => $this->input->post('component_name'),
			'component_group' => $this->input->post('component_group'),
			'component_status' => $this->input->post('component_status'),
			'component_tax' => $this->input->post('component_tax'),
			'bpjs_based' => $this->input->post('bpjs_based'),
			'ot_based' => $this->input->post('ot_based'),
			'updated_at' => date('Y-m-d H:i:s'),
			'updated_by' => $user_id1
		);
		$this->db->where('id', $idComp);
		$this->db->update('mscomponent', $data);
		
		redirect('master_payroll/payroll_component/'.$menuid);
	}

	public function formula($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_formula']   = $this->master_model->select_in('msformula','*',"ORDER BY id DESC");
			$this->load->view('pyformula/list', $data);
	    }
	}

	public function insert_formula($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	
		$data = array(
			'component_code' => $this->input->post('component_code'),
			'formula' => $this->input->post('formula'),
			'created_at' => date('Y-m-d H:i:s'),
			'created_by' => $user_id1			
		);
		$this->db->insert('msformula', $data);
		redirect('master_payroll/formula/'.$menuid);
	}

	public function edit_formula($menuid)
	{
		$idComp = $this->input->post('id');
		$data_edit = $this->master_model->mst_data_edit('msformula', $idComp);

		echo'
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal">&times;</button>
			<h4 class="modal-title">Edit Payroll Formula</h4>
		</div>
		<form action="'.base_url().'master_payroll/edit_process_formula/'.$menuid.'/'.$idComp.'" method="post" enctype="multipart/form-data">
			<div class="modal-body">

			
				<div class="form-group">
					<label>Component Code</label>
					<input type="text" value="'.$data_edit[0]->component_code.'" name="component_code" class="form-control" placeholder="Component Code">
				</div>

				<div class="form-group">
					<label>Formula</label>
					<input type="text" value="'.$data_edit[0]->formula.'" name="formula" class="form-control" placeholder="Component Name">
				</div>				


			</div>
			<div class="modal-footer">
				<button type="submit" value="1" name="submit" class="btn btn-danger btn-fill pull-right save_phone save_email">Save And Close</button>
			</div>
		</form>
		';
	}

	public function edit_process_formula($menuid, $idComp)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	
		$data = array(
			'component_code' => $this->input->post('component_code'),
			'formula' => $this->input->post('formula'),
			'updated_at' => date('Y-m-d H:i:s'),
			'updated_by' => $user_id1
		);
		$this->db->where('id', $idComp);
		$this->db->update('msformula', $data);
		
		redirect('master_payroll/formula/'.$menuid);
	}

	public function delete_formula($menuid, $ID)
	{
		$this->db->where('id', $ID);
		$this->db->delete('msformula');
		redirect('master_payroll/formula/'.$menuid);
	}

	public function parameter($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_parameter']   = $this->master_model->select_in('msparameter','*',"ORDER BY id DESC");
			$this->load->view('pyparameter/list', $data);
	    }
	}

	public function insert_parameter($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	
		$data = array(
			'basic_salary' => $this->input->post('basic_salary'),
			'other_income' => $this->input->post('other_income'),
			'bpjs_tk' => $this->input->post('bpjs_tk'),
			'bpjs_kes' => $this->input->post('bpjs_kes'),
			'bpjs_jht' => $this->input->post('bpjs_jht'),
			'bpjs_pensiun' => $this->input->post('bpjs_pensiun'),
			'thr_bonus' => $this->input->post('thr_bonus'),
			'created_at' => date('Y-m-d H:i:s'),
			'created_by' => $user_id1			
		);
		$this->db->insert('msparameter', $data);
		redirect('master_payroll/parameter/'.$menuid);
	}

	public function edit_parameter($menuid)
	{
		$idComp = $this->input->post('id');
		$data_edit = $this->master_model->mst_data_edit('msparameter', $idComp);

		echo'
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal">&times;</button>
			<h4 class="modal-title">Edit Parameter PPh 21</h4>
		</div>
		<form action="'.base_url().'master_payroll/edit_process_parameter/'.$menuid.'/'.$idComp.'" method="post" enctype="multipart/form-data">
			<div class="modal-body">
			
				<div class="form-group">
					<label>Basic Salary</label>
					<input type="text" value="'.$data_edit[0]->basic_salary.'" name="basic_salary" class="form-control" placeholder="Basic Salary">
				</div>

				<div class="form-group">
					<label>Other Income</label>
					<input type="text" value="'.$data_edit[0]->other_income.'" name="other_income" class="form-control" placeholder="Other Income">
				</div>				

				<div class="form-group">
					<label>BPJS TK</label>
					<input type="text" value="'.$data_edit[0]->bpjs_tk.'" name="bpjs_tk" class="form-control" placeholder="BPJS TK">
				</div>				

				<div class="form-group">
					<label>BPJS Kes</label>
					<input type="text" value="'.$data_edit[0]->bpjs_kes.'" name="bpjs_kes" class="form-control" placeholder="BPJS Kes">
				</div>				

				<div class="form-group">
					<label>BPJS JHT</label>
					<input type="text" value="'.$data_edit[0]->bpjs_jht.'" name="bpjs_jht" class="form-control" placeholder="BPJS JHT">
				</div>				

				<div class="form-group">
					<label>BPJS Pensiun</label>
					<input type="text" value="'.$data_edit[0]->bpjs_pensiun.'" name="bpjs_pensiun" class="form-control" placeholder="BPJS Pensiun">
				</div>				

				<div class="form-group">
					<label>THR / BONUS</label>
					<input type="text" value="'.$data_edit[0]->thr_bonus.'" name="thr_bonus" class="form-control" placeholder="THR / BONUS">
				</div>				


			</div>
			<div class="modal-footer">
				<button type="submit" value="1" name="submit" class="btn btn-danger btn-fill pull-right save_phone save_email">Save And Close</button>
			</div>
		</form>
		';
	}

	public function edit_process_parameter($menuid, $idComp)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	
		$data = array(
			'basic_salary' => $this->input->post('basic_salary'),
			'other_income' => $this->input->post('other_income'),
			'bpjs_tk' => $this->input->post('bpjs_tk'),
			'bpjs_kes' => $this->input->post('bpjs_kes'),
			'bpjs_jht' => $this->input->post('bpjs_jht'),
			'bpjs_pensiun' => $this->input->post('bpjs_pensiun'),
			'thr_bonus' => $this->input->post('thr_bonus'),
			'updated_at' => date('Y-m-d H:i:s'),
			'updated_by' => $user_id1
		);
		$this->db->where('id', $idComp);
		$this->db->update('msparameter', $data);
		
		redirect('master_payroll/parameter/'.$menuid);
	}

	public function delete_parameter($menuid, $ID)
	{
		$this->db->where('id', $ID);
		$this->db->delete('msparameter');
		redirect('master_payroll/parameter/'.$menuid);
	}


}

?>
