<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class pembelian extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('master_model');
		$this->load->model('pembelian_model');
		date_default_timezone_set('Asia/Jakarta');
	}

	public function purchase_order($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_supplier']   = $this->master_model->select_in('mspemasok','*',"ORDER BY id ");
			$this->load->view('pembelian/header', $data);
	    }
	}

	public function insert_header($menuid, $supplier)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', '*', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		
		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_po[0]'));
		$tgl = $date->format('Y-m-d');
		
		$memo = $this->input->post('memo[0]');

		$data = array(
			'id_supplier' => $supplier,
			'tgl_po' => $tgl,
			'memo' => $memo,
			'status' => 'PURCHASE',
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	
		$this->db->insert('purchase_order_header', $data);
		
		$data_header=$this->pembelian_model->getLastPO();
		$jID = $data_header[0]->last_id;	

		$str = $date->format("Ymd");
		$str = substr($str,2,6);
		$dt = $date->format("Ymd");
		$dt = substr($dt,0,6);

		$vend = $this->master_model->select_in('purchase_order_header', '*', "where left(DATE_FORMAT('$tgl', '%Y%m%d'),6)='$dt' order by right(no_po_system,6) desc limit 1;");
		if(empty($vend)){
			$kode = $str.'.PO0001';
		} else {
			$no = substr($vend[0]->no_po_system,9);
			$next1 = $no + 1;
			$panjang = strlen($next1);
			$next2 = str_repeat('0',4-$panjang).$next1;
			$kode = $str.'.PO'.$next2;
		}

		$data = array(			
			'no_po_system' => $kode
		);	

		$this->db->where('id', $jID);
		$this->db->update('purchase_order_header', $data);

		redirect('pembelian/po_detail/'.$menuid.'/'.$jID);
	}

	public function po_detail($menuid, $jID)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_poDetail']    = $this->pembelian_model->poDetail($jID);

    		$this->load->view('pembelian/detail', $data);
	    }
	}

	function validasi(){
		$jumlah = $_POST['jumlah'];
		$harga = $_POST['harga'];

		// validasi seadanya :v
		if ($jumlah == 0) {
			$data['error']['jumlah'] = 'Jumlah tidak boleh nol';
		}
		if ($harga == 0) {
			$data['error']['harga'] = 'Harga tidak boleh nol';
		}

		if (empty($data['error'])) {
			// jika validasi berhasil
			$data['hasil'] = 'sukses';
			// lakukan proses simpan data disini atau perintah lainnya
			// INSERT INTO bla bla bla...
		} else {
			// jika validasi gagal
			$data['hasil'] = 'gagal';
		}
		// tampilkan response dalam format json
		echo json_encode($data);
	}

	public function insert_detail($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$data = array(
			'id_barang' => $this->input->get('barang'),
			'jumlah' => $this->input->get('jumlah'),			
			'harga' => $this->input->get('harga'),
			'total' => $this->input->get('harga') * $this->input->get('jumlah'),
			'id_header' => $this->input->get('header'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	
		$this->db->insert('purchase_order_detail', $data);
		
	}

	function list_transaksi(){

		$faktur = $_GET['faktur'];
		$data_st = $this->master_model->select_in('purchase_order_header', '*', "WHERE id = $faktur");
		$sts = $data_st[0]->status;

		echo "<table id='example1' class='table table-bordered table-striped'>
                <thead><tr><th>No</th><th>Kode Barang</th><th>Nama Barang</th><th>Jumlah</th><th>Harga</th><th>Total</th><th>Aksi</th></tr></thead>";
        $sql = "SELECT tb2.kode_barang,tb2.nama_barang,tb1.jumlah,tb1.harga,tb1.total,tb1.id
                FROM purchase_order_detail as tb1, mspersediaan as tb2
                WHERE tb1.id_barang=tb2.id and tb1.id_header=$faktur";
        
        $list = $this->db->query($sql)->result();
		$no=1;
		$total=0;
        foreach ($list as $row){
            echo "<tr>
                <td width='10'>$no</td>
				<td>$row->kode_barang</td>
				<td>$row->nama_barang</td>
				<td width='100'> ".number_format($row->jumlah,0); echo "</td>
				<td width='120'> ".number_format($row->harga,0); echo "</td>
				<td width='150'> ".number_format($row->total,0); echo "</td>";
				if($sts=='RECEIVED'){
					echo"<td width='100' onClick='hapus($row->id)'><button class='btn btn-danger btn-sm' disabled><i class='fa fa-trash-o'></button></td>";
				} else {
					echo"<td width='100' onClick='hapus($row->id)'><button class='btn btn-danger btn-sm'><i class='fa fa-trash-o'></button></td>";
				}
                echo"</tr>";
			$no++;
		}
        echo" </table>";
	}
	
	public function daftar_po($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$check=$this->master_model->auth_read($user_id, $menuid);
	
		if($check==false)
		{
			redirect('NotAuthorized');
		}else
		{
			$data['data_po']   =  $this->master_model->select_in('purchase_order_header', '*', "where 1=0");
			$this->load->view('pembelian/daftar_po', $data);
		}
	}

	public function data_po($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$check=$this->master_model->auth_read($user_id, $menuid);
		
		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][from_date]'));
		$date1 = $date->format('Y-m-d');

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][to_date]'));
		$date2 = $date->format('Y-m-d');

		if (empty($date1)){
			$date1 = $this->session->userdata('date1');
			$date2 = $this->session->userdata('date2');
		}
		
		if($check==false)
		{
			redirect('NotAuthorized');
		}else
		{
			// $data['data_jual'] = $this->master_model->select_in('trjual_header', '*', "where tgl_jual between '$tgl1' and '$tgl2'" );
			$data['data_po'] = $this->pembelian_model->datapo($date1,$date2);
			
			$this->load->view('pembelian/data_po', $data);
		}

	}

	public function detail_po($menuid, $jID, $date1, $date2)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_poDetail']    = $this->pembelian_model->poDetail($jID);

    		$this->load->view('pembelian/detail_po', $data);
	 
		
		}
	}

	public function terima_barang($menuid, $jID, $date1, $date2)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_sj']    = $this->master_model->select_in('terima_sj_header', '*', "where 1=0" );

    		$this->load->view('pembelian/buat_sj', $data);
	 		
		}
	}

	public function insert_sj($menuid, $poid, $dt1, $dt2)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', '*', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		
		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_terima'));
		$tgl = $date->format('Y-m-d');

		$supplier = $this->input->post('id_supplier');
		$memo = $this->input->post('memo');
		$nosjsupl = $this->input->post('no_sj_supplier');

		$data = array(
			'id_po' => $poid,
			'id_supplier' => $supplier,
			'tgl_terima' => $tgl,
			'no_sj_supplier' => $nosjsupl,
			'memo' => $memo,
			'status' => 'RECEIVED',
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	
		$this->db->insert('terima_sj_header', $data);
		
		$data_header=$this->pembelian_model->getLastSJ();
		$jID = $data_header[0]->last_id;	

		$str = $date->format("Ymd");
		$str = substr($str,2,6);
		$dt = $date->format("Ymd");
		$dt = substr($dt,0,6);

		$vend = $this->master_model->select_in('terima_sj_header', '*', "where left(DATE_FORMAT('$tgl', '%Y%m%d'),6)='$dt' order by right(no_sj_system,6) desc limit 1;");
		if(empty($vend)){
			$kode = $str.'.SJ0001';
		} else {
			$no = substr($vend[0]->no_sj_system,9);
			$next1 = $no + 1;
			$panjang = strlen($next1);
			$next2 = str_repeat('0',4-$panjang).$next1;
			$kode = $str.'.SJ'.$next2;
		}

		$data = array(			
			'no_sj_system' => $kode
		);	

		$this->db->where('id', $jID);
		$this->db->update('terima_sj_header', $data);

		$data = array(			
			'status' => 'RECEIVED',
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $poid);
		$this->db->update('purchase_order_header', $data);

		$sql="insert into terima_sj_detail (id_header, id_barang, jumlah, create_at, create_by)
			select $jID, id_barang, jumlah, now(), '$user_id1' From purchase_order_detail where id_header = $poid;";
		$qry = $this->db->query($sql);

		redirect('pembelian/sj_detail/'.$menuid.'/'.$jID.'/'.$dt1.'/'.$dt2);
	}

	public function sj_detail($menuid, $jID, $date1, $date2)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_sj_h']    = $this->master_model->select_in('terima_sj_header', '*', "where id = $jID" );
			$data['data_sj_d']    = $this->pembelian_model->sjdetail($jID);

    		$this->load->view('pembelian/sj_detail', $data);
	 		
		}
	}

	public function update_inv_detail($menuid, $jID, $dt1, $dt2)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$id = $this->input->post('id');
		$data = array(					
			'harga' => $this->input->post('harga'),
			'total' => $this->input->post('jumlah') * $this->input->post('harga'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('terima_inv_detail', $data);

		redirect('pembelian/inv_detail/'.$menuid.'/'.$jID.'/'.$dt1.'/'.$dt2);
	}

	public function daftar_invoice($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$check=$this->master_model->auth_read($user_id, $menuid);
	
		if($check==false)
		{
			redirect('NotAuthorized');
		}else
		{
			$data['data_inv']   =  $this->master_model->select_in('terima_inv_header', '*', "where 1=0");
			$this->load->view('pembelian/daftar_inv', $data);
		}
	}

	public function data_inv($menuid, $jns)
	{
		$user_id = $this->session->userdata('user_id');
		$check=$this->master_model->auth_read($user_id, $menuid);
		
		if($jns==1){
			$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][from_date]'));
			$date1 = $date->format('Y-m-d');

			$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][to_date]'));
			$date2 = $date->format('Y-m-d');

			if (empty($date1)){
				$date1 = $this->session->userdata('date1');
				$date2 = $this->session->userdata('date2');
			}
		}

		if($jns==2){
			$date1 = $this->session->userdata('date1');
			$date2 = $this->session->userdata('date2');

			// print_r($date1);
			// die;
		}

		if($check==false)
		{
			redirect('NotAuthorized');
		}else
		{
			// $data['data_jual'] = $this->master_model->select_in('trjual_header', '*', "where tgl_jual between '$tgl1' and '$tgl2'" );
			$data['data_inv'] = $this->pembelian_model->datainv($date1,$date2);
			
			$this->load->view('pembelian/data_inv', $data);
		}
	}
	
	public function buat_jurnal($menuid, $jID, $date1, $date2)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_inv_h']    = $this->master_model->select_in('terima_inv_header', '*', "where id = $jID" );
			$data['data_inv_d']    = $this->pembelian_model->invdetail($jID);

    		$this->load->view('pembelian/buat_jurnal', $data);
	 		
		}
	}

	public function update_inv_detail2($menuid, $jID, $dt1, $dt2)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$id = $this->input->post('id');
		$data = array(					
			'harga' => $this->input->post('harga'),
			'total' => $this->input->post('jumlah') * $this->input->post('harga'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('terima_inv_detail', $data);

		redirect('pembelian/buat_jurnal/'.$menuid.'/'.$jID.'/'.$dt1.'/'.$dt2);
	}

	public function insert_jurnal($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$idInv = $this->input->post('group-b[0][inv_id]');
		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][tgl_inv]'));
		$date1 = $date->format('Y-m-d');

		//begin membuat jurnal accounting
			//insert header
			$data = array(
				'journal_type' => 'PJ',
				'journal_date' => $date1,
				'journal_voucher' => '',
				'journal_desc' => 'Terima Invoice Pembelian : '.$this->input->post('group-b[0][no_inv_system]'),
				'id_purchase' => $idInv,
				'created_at' => date('Y-m-d H:i:s'),
				'created_by' => $user_id1
			);	

			$this->db->insert('acc_journal', $data);
			
			$data_journal=$this->pembelian_model->getJournalID();
			$jID = $data_journal[0]->last_id;	

			$jDate = $date1;
			$jDate = substr($jDate,0,7);

			$data_voucher=$this->pembelian_model->genVoucher($jDate, 'P');
			$jVoucher = $data_voucher[0]->journal_voucher;

			$data = array(			
				'journal_voucher' => $jVoucher
			);	

			$this->db->where('id', $jID);
			$this->db->update('acc_journal', $data);
			//end insert header 

			//insert detail
			
			$detail = $this->pembelian_model->getDetailJurnal($idInv);
			$i=1; $total=0; foreach($detail as $det):
				$data = array(
					'detail_id' => $i,
					'journal_id' => $jID,
					'coa_id' => $det->id_coa_persediaan,
					'detail_desc' => '',
					'debet_value' => $det->total,
					'credit_value' => 0,
					'created_at' => date('Y-m-d H:i:s'),
					'created_by' => $user_id1
				);
				$this->db->insert('acc_journal_detail', $data);	
				
			$i++; $total=$total+$det->total; endforeach;	

			$coaHutang = $this->master_model->select_in('parameter_coa', '*', "WHERE jenis = 'Hutang Terima Barang'");
			$coaKredit = $coaHutang[0]->id_coa;

			$data = array(
				'detail_id' => $i,
				'journal_id' => $jID,
				'coa_id' => $coaKredit,
				'detail_desc' => '',
				'debet_value' => 0,
				'credit_value' => $total,
				'created_at' => date('Y-m-d H:i:s'),
				'created_by' => $user_id1
			);	

			$this->db->insert('acc_journal_detail', $data);	

			//end insert detail
		//end membuat jurnal accounting
		
		$data = array(			
			'status' => 'JOURNAL',
		);	

		$this->db->where('id', $idInv);
		$this->db->update('terima_inv_header', $data);

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][from_date]'));
		$date1 = $date->format('Y-m-d');

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][to_date]'));
		$date2 = $date->format('Y-m-d');

		$this->session->set_userdata('date1', $date1);
		$this->session->set_userdata('date2', $date2);
		
		redirect('pembelian/data_inv/'.$menuid.'/'.'2');

	}
}
?>

