<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

use PhpOffice\PhpWord\PhpWord;
use PhpOffice\PhpWord\Writer\Word2007;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpPresentation\PhpPresentation;
use PhpOffice\PhpPresentation\Writer\PowerPoint2007;
use PhpOffice\PhpPresentation\Style\Alignment;
use PhpOffice\PhpWord\Style\Paragraph;
use PhpOffice\PhpWord\Style\Spacing;
use PhpOffice\PhpWord\SimpleType\Jc;
use PhpOffice\PhpWord\Shared\Html;

class perjanjian_pinjaman extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('master_model');
		$this->load->model('pinjaman_model');
  	}

	public function list($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_pengajuan'] = $this->pinjaman_model->pengajuanPinjamanLegal();

    		$this->load->view('perjanjian/list', $data);
	    }
	}

	public function input_perjanjian($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_perjanjian']    = $this->master_model->select_in('perjanjian_pinjaman','*',"where id_pengajuan=$id");

    		$this->load->view('perjanjian/input_perjanjian', $data);
	    }
	}

	public function input_memo_perjanjian($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_perjanjian']    = $this->master_model->select_in('perjanjian_pinjaman','*',"where id_pengajuan=$id");

    		$this->load->view('perjanjian/input_memo_perjanjian', $data);
	    }
	}

	public function insert_perjanjian($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$id = $this->input->post('id');

		if($id==0){
			$data = array(			
				'id_pengajuan' => $this->input->post('id_pengajuan'),
				'no_pp' => $this->input->post('no_pp'),
				'tanggal_pp' => $this->input->post('tanggal_pp'),
				'tanggal_awal' => $this->input->post('tanggal_awal'),
				'tanggal_akhir' => $this->input->post('tanggal_akhir'),
				'tanggal_cicilan_awal' => $this->input->post('tanggal_cicilan_awal'),
				'tanggal_cicilan_akhir' => $this->input->post('tanggal_cicilan_akhir'),
				'ketua_koperasi' => $this->input->post('ketua_koperasi'),
				'koordinator_pinjaman' => $this->input->post('koordinator_pinjaman'),
				'no_off_letter' => $this->input->post('no_off_letter'),				
				'create_at' => date('Y-m-d H:i:s'),
				'create_by' => $user_id1
			);		
			$this->db->insert('perjanjian_pinjaman', $data);
		} else {
			$data = array(							
				'no_pp' => $this->input->post('no_pp'),
				'tanggal_pp' => $this->input->post('tanggal_pp'),
				'tanggal_awal' => $this->input->post('tanggal_awal'),
				'tanggal_akhir' => $this->input->post('tanggal_akhir'),
				'tanggal_cicilan_awal' => $this->input->post('tanggal_cicilan_awal'),
				'tanggal_cicilan_akhir' => $this->input->post('tanggal_cicilan_akhir'),
				'ketua_koperasi' => $this->input->post('ketua_koperasi'),
				'koordinator_pinjaman' => $this->input->post('koordinator_pinjaman'),
				'no_off_letter' => $this->input->post('no_off_letter'),
				'update_at' => date('Y-m-d H:i:s'),
				'update_by' => $user_id1
			);	
	
			$this->db->where('id', $id);
			$this->db->update('perjanjian_pinjaman', $data);
		}		

		redirect('perjanjian_pinjaman/list/'.$menuid);
	}	

	public function insert_memo_perjanjian($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$id = $this->input->post('id');
		
		$data = array(										
			'no_memo_cair' => $this->input->post('no_memo_cair'),
			'tgl_memo_cair' => $this->input->post('tgl_memo_cair'),
			'kpd_memo_cair' => $this->input->post('kpd_memo_cair'),
			'dari_memo_cair' => $this->input->post('dari_memo_cair'),
			'no_memo_instruksi' => $this->input->post('no_memo_instruksi'),
			'tgl_memo_instruksi' => $this->input->post('tgl_memo_instruksi'),
			'kpd_memo_instruksi' => $this->input->post('kpd_memo_instruksi'),
			'dari_memo_instruksi' => $this->input->post('dari_memo_instruksi'),
			'no_rek_cair' => $this->input->post('no_rek_cair'),
			'nm_rek_cair' => $this->input->post('nm_rek_cair'),
			'notes_memo_instruksi' => $this->input->post('notes_memo_instruksi'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('perjanjian_pinjaman', $data);
			

		redirect('perjanjian_pinjaman/listAdmin/'.$menuid);
	}	

	public function biaya_pp($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_biayapp'] = $this->pinjaman_model->biayaPP($id);

    		$this->load->view('perjanjian/biaya_pp', $data);
	    }
	}

	public function insert_biaya_pp($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$idRKP = $this->input->post('id_pengajuan');
		$data = array(			
			'id_pengajuan' => $this->input->post('id_pengajuan'),
			'jenis_biaya_pp' => $this->input->post('jenis_biaya_pp'),
			'keterangan' => $this->input->post('keterangan'),
			'nominal' => $this->input->post('nominal'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);		
		$this->db->insert('biaya_pp', $data);	

		redirect('perjanjian_pinjaman/biaya_pp/'.$menuid.'/'.$idRKP);
	}

	public function update_biaya_pp($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
			
		$idRKP = $this->input->post('id_pengajuan');
		$id = $this->input->post('id');

		$data = array(										
			'jenis_biaya_pp' => $this->input->post('jenis_biaya_pp'),
			'keterangan' => $this->input->post('keterangan'),
			'nominal' => $this->input->post('nominal'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('biaya_pp', $data);
		

		redirect('perjanjian_pinjaman/biaya_pp/'.$menuid.'/'.$idRKP);
	}	

	public function pasal_perjanjian($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pasal']    = $this->master_model->select_in('pasal_perjanjian','*',"WHERE id_pengajuan = $id");

    		$this->load->view('perjanjian/pasal_perjanjian', $data);
	    }
	}

	public function proses_pasal($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$sql="delete from pasal_perjanjian where id_pengajuan = $id;";
		$qry = $this->db->query($sql);

		$data_edit = $this->master_model->select_in('perjanjian_pinjaman','*',"WHERE id_pengajuan = $id");
		$idPP = $data_edit[0]->id;

		$sql="insert into pasal_perjanjian (id_perjanjian, id_pengajuan, pasal_ms, judul_pasal, isi_pasal, pasal_pp,
			create_at, create_by) select $idPP, $id, pasal, judul, isi_pasal, pasal, now(), $user_id from mst_pasal order by pasal;";
		$qry = $this->db->query($sql);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pasal']    = $this->master_model->select_in('pasal_perjanjian','*',"WHERE id_pengajuan = $id");

    		$this->load->view('perjanjian/pasal_perjanjian', $data);
	    }
	}	

	public function update_pasal_perjanjian($menuid, $idRKP)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$dataperjanjian = $this->master_model->select_in('pasal_perjanjian', '*', "WHERE id_pengajuan = $idRKP order by id");
		$i = 1; 
		foreach($dataperjanjian as $by){
			$id = $this->input->post('id'.$i);
			$data = array(			
				'pasal_pp' => $this->input->post('pasal_pp'.$i),
				'update_at' => date('Y-m-d H:i:s'),
				'update_by' => $user_id1
			);	
			$this->db->where('id', $id);
			$this->db->update('pasal_perjanjian', $data);
	
			$i++; 		
		}

		redirect('perjanjian_pinjaman/pasal_perjanjian/'.$menuid.'/'.$idRKP);
	}	


	public function edit_pasal($menuid, $idRKP, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pasal']    = $this->master_model->select_in('pasal_perjanjian','*',"WHERE id = $id");

    		$this->load->view('perjanjian/edit_pasal', $data);
	    }
	}

	public function update_pasal($menuid, $idRKP)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		
		$id = $this->input->post('id');

		$data = array(			
			'pasal_ms' => $this->input->post('pasal'),
			'judul_pasal' => $this->input->post('judul'),
			'isi_pasal' => $this->input->post('isi_pasal'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);	

		$this->db->where('id', $id);
		$this->db->update('pasal_perjanjian', $data);

		redirect('perjanjian_pinjaman/pasal_perjanjian/'.$menuid.'/'.$idRKP);
	}	

	function penyebut($nilai) {
		$nilai = abs($nilai);
		$huruf = array("", "satu", "dua", "tiga", "empat", "lima", "enam", "tujuh", "delapan", "sembilan", "sepuluh", "sebelas");
		$temp = "";
		if ($nilai < 12) {
			$temp = " ". $huruf[$nilai];
		} else if ($nilai <20) {
			$temp = $this->penyebut($nilai - 10). " belas";
		} else if ($nilai < 100) {
			$temp = $this->penyebut($nilai/10)." puluh". $this->penyebut($nilai % 10);
		} else if ($nilai < 200) {
			$temp = " seratus" . $this->penyebut($nilai - 100);
		} else if ($nilai < 1000) {
			$temp = $this->penyebut($nilai/100) . " ratus" . $this->penyebut($nilai % 100);
		} else if ($nilai < 2000) {
			$temp = " seribu" . $this->penyebut($nilai - 1000);
		} else if ($nilai < 1000000) {
			$temp = $this->penyebut($nilai/1000) . " ribu" . $this->penyebut($nilai % 1000);
		} else if ($nilai < 1000000000) {
			$temp = $this->penyebut($nilai/1000000) . " juta" . $this->penyebut($nilai % 1000000);
		} else if ($nilai < 1000000000000) {
			$temp = $this->penyebut($nilai/1000000000) . " milyar" . $this->penyebut(fmod($nilai,1000000000));
		} else if ($nilai < 1000000000000000) {
			$temp = $this->penyebut($nilai/1000000000000) . " trilyun" . $this->penyebut(fmod($nilai,1000000000000));
		}     
		return $temp;
	}
	
	function terbilang($nilai) {
		if($nilai<0) {
			$hasil = "minus ". trim($this->penyebut($nilai));
		} else {
			$hasil = trim($this->penyebut($nilai));
		}     		
		return $hasil;
	}

	public function pp_word()
    {
		$id = $this->uri->segment('4');

		date_default_timezone_set("Asia/Jakarta");

        $phpWord = new PhpWord();
		$section = $phpWord->addSection();
		
		$phpWord->setDefaultFontName('Times New Roman');
		$phpWord->setDefaultFontSize(9);

        $sql = "select a.*, b.nama_pengurus as ketua_koperasi_d, c.nama_pengurus as koordinator_pinjaman_d
			from perjanjian_pinjaman a left join pengurus_koperasi b on 
			a.ketua_koperasi=b.id left join pengurus_koperasi c on 
			a.koordinator_pinjaman=c.id where a.id_pengajuan = $id";
		$rpt = $this->db->query($sql)->row_array();

        $sql = "select a.* from pp_header a ";
		$hdr = $this->db->query($sql)->row_array();

        $sql = "select a.* from pasal_perjanjian a where a.id_pengajuan = $id and pasal_pp > 0";
		$psl = $this->db->query($sql)->result();

		$sql = "select a.ada_penjamin,b.* from pengajuan_pinjaman a left join anggota b on a.id_anggota=b.id where a.id = $id";
		$ang = $this->db->query($sql)->row_array();

		$sql = "select a.* from fasilitas_pinjaman a where a.id_pengajuan = $id";
		$fas = $this->db->query($sql)->row_array();

		$sql = "select sum(a.nominal) as simpanan_wajib from biaya_lain a where a.id_pengajuan = $id and a.is_sw = 'Ya' ";
		$sw = $this->db->query($sql)->row_array();

		$phpWord->setDefaultParagraphStyle(array('spaceAfter' => \PhpOffice\PhpWord\Shared\Converter::pointToTwip(0), 'spacing' => 1));

		$section->addText(htmlspecialchars('PERJANJIAN PINJAMAN'),array('name' => 'Times New Roman', 'size' => '14', 'bold' => TRUE, 'underline' => 'single', 'align'=>'center'), 
		[ 'align' => \PhpOffice\PhpWord\SimpleType\Jc::CENTER ]);

		$section->addText(htmlspecialchars($rpt['no_pp']),array('name' => 'Times New Roman', 'size' => '12', 'bold' => TRUE, 'align'=>'center'), 
		[ 'align' => \PhpOffice\PhpWord\SimpleType\Jc::CENTER ]);
		
		$header = $section->addHeader();
		$header->firstPage();
		$table = $header->addTable();
		$table->addRow();
		$cell = $table->addCell(4500);
		$textrun = $cell->addTextRun();
		$textrun->addText(htmlspecialchars($rpt['no_pp']));
		
		$subsequent = $section->addHeader();
		$subsequent->addText(htmlspecialchars($rpt['no_pp']));

		$footer = $section->addFooter(\PhpOffice\PhpWord\Element\Footer::FIRST);
		$footer->addPreserveText(htmlspecialchars($ang['nama_anggota'].' Page {PAGE} of {NUMPAGES}'), array('align' => 'center'));

		$footer = $section->addFooter(\PhpOffice\PhpWord\Element\Footer::AUTO);
		$footer->addPreserveText(htmlspecialchars($ang['nama_anggota'].' Page {PAGE} of {NUMPAGES}'), array('align' => 'center'));


		$section->addText(htmlspecialchars(''));		
		
		$html = $hdr['header_1']; 

		$daftar_hari = array(
			'Sunday' => 'Minggu',
			'Monday' => 'Senin',
			'Tuesday' => 'Selasa',
			'Wednesday' => 'Rabu',
			'Thursday' => 'Kamis',
			'Friday' => 'Jumat',
			'Saturday' => 'Sabtu'
		);
		$namahari = date('l', strtotime($rpt['tanggal_pp']));
		$namahari = $daftar_hari[$namahari];

		$bulan = array(
			'01' => 'Januari',
			'02' => 'Februari',
			'03' => 'Maret',
			'04' => 'April',
			'05' => 'Mei',
			'06' => 'Juni',
			'07' => 'Juli',
			'08' => 'Agustus',
			'09' => 'September',
			'10' => 'Oktober',
			'11' => 'November',
			'12' => 'Desember',
		);
//
		$str = '';	
		$str = $str . 'NIK 			: '.$ang['no_ktp']. '<br/>';
		$str = $str . 'Nama 			: '.$ang['nama_anggota']. '<br/>';
		$str = $str . 'Tempat/tanggal lahir	: '.$ang['tempat_lahir'].', '.date('d', strtotime($ang['tgl_lahir'])).' '.$bulan[date('m', strtotime($ang['tgl_lahir']))]. ' '. date('Y', strtotime($ang['tgl_lahir'])) .'<br/>';
		$str = $str . 'Tempat tinggal 		: '.$ang['alamat_ktp']. '<br/>';
		$str = $str . 'Pekerjaan 		: '.$ang['bidang_usaha']. '<br/>';

		if($ang['hubungan']<>''){
			$str = $str . 'Untuk melakukan tindakan hukum dalam akte ini telah mendapat persetujuan dari '.$ang['hubungan']. '<br/>';
			$str = $str . 'NIK 			: '.$ang['no_ktp_pasangan']. '<br/>';
			$str = $str . 'Nama 			: '.$ang['nama_pasangan']. '<br/>';
			$str = $str . 'Tempat/tanggal lahir	: '.$ang['tempat_lahir_pasangan'].', '.date('d', strtotime($ang['tgl_lahir_pasangan'])).' '.$bulan[date('m', strtotime($ang['tgl_lahir_pasangan']))]. ' '. date('Y', strtotime($ang['tgl_lahir_pasangan'])). '<br/>';
			$str = $str . 'Tempat tinggal 		: '.$ang['alamat_pasangan']. '<br/>';
			$str = $str . 'Pekerjaan 		: '.$ang['bidang_usaha_pasangan']. '<br/>';
		}
		$html = str_replace('[detail_peminjam]', $str, $html);

		if($ang['ada_penjamin']=='on'){

			$sql = "select * from penjamin_pinjaman where id_pengajuan = $id";		
			$pjm = $this->db->query($sql)->result();
			
			$str = '';	
			foreach ($pjm as $p)
			{
				$str = $str . 'NIK 			: '.$p->nik_penjamin. '<br/>';
				$str = $str . 'Nama 			: '.$p->nama_penjamin. '<br/>';
				$str = $str . 'Tempat/tanggal lahir	: '.$p->tempat_lahir_penjamin.', '.date('d', strtotime($p->tanggal_lahir_penjamin)).' '.$bulan[date('m', strtotime($p->tanggal_lahir_penjamin))]. ' '. date('Y', strtotime($p->tanggal_lahir_penjamin)). '<br/>';
				$str = $str . 'Tempat tinggal 		: '.$p->alamat_penjamin. '<br/>';
				$str = $str . 'Pekerjaan 		: '.$p->pekerjaan_penjamin. '<br/>';
				if($p->hubungan_pasangan<>''){
					$str = $str . 'Untuk melakukan tindakan hukum dalam akte ini telah mendapat persetujuan dari '.$p->hubungan_pasangan. '<br/>';
					$str = $str . 'NIK 			: '.$p->nik_pasangan_penjamin. '<br/>';
					$str = $str . 'Nama 			: '.$p->nama_pasangan_penjamin. '<br/>';
					$str = $str . 'Tempat/tanggal lahir	: '.$p->tempat_lahir_pasangan_penjamin.', '.date('d', strtotime($p->tanggal_lahir_pasangan_penjamin)).' '.$bulan[date('m', strtotime($p->tanggal_lahir_pasangan_penjamin))]. ' '. date('Y', strtotime($p->tanggal_lahir_pasangan_penjamin)). '<br/>';
					$str = $str . 'Tempat tinggal 		: '.$p->alamat_pasangan_penjamin. '<br/>';
					$str = $str . 'Pekerjaan 		: '.$p->pekerjaan_pasangan_penjamin. '<br/>';
				}
			}			
			
			$html = str_replace('[detail_penjamin]', $str, $html);
		} else {
			$html = str_replace('[detail_penjamin]', '', $html);	
		}
//
		$html = str_replace('[hari_pp]', $namahari, $html);
		$html = str_replace('[tanggal_pp]', date('d', strtotime($rpt['tanggal_pp'])).' '.$bulan[date('m', strtotime($rpt['tanggal_pp']))].' '.date('Y', strtotime($rpt['tanggal_pp'])), $html);
		
		\PhpOffice\PhpWord\Shared\Html::addHtml($section, $html);
		$section->addText(htmlspecialchars(''));
		$html = $hdr['header_2']; 

		
		$html = str_replace('[nik_peminjam]', $ang['no_ktp'], $html);
		$html = str_replace('[nama_peminjam]', $ang['nama_anggota'], $html);
		$html = str_replace('[ttl_peminjam]', $ang['tempat_lahir'].','.date('d F Y', strtotime($ang['tgl_lahir'])), $html);
		$html = str_replace('[alamat_peminjam]', $ang['alamat_ktp'], $html);
		$html = str_replace('[pekerjaan_peminjam]', $ang['bidang_usaha'], $html);
		$html = str_replace('[pasangan]', $ang['hubungan'], $html);
		$html = str_replace('[nik_pasangan]', $ang['no_ktp_pasangan'], $html);
		$html = str_replace('[nama_pasangan]', $ang['nama_pasangan'], $html);
		$html = str_replace('[ttl_pasangan]', $ang['tempat_lahir_pasangan'].','.date('d F Y', strtotime($ang['tgl_lahir_pasangan'])), $html);
		$html = str_replace('[alamat_pasangan]', $ang['alamat_pasangan'], $html);
		$html = str_replace('[pekerjaan_pasangan]', $ang['bidang_usaha_pasangan'], $html);
		// $text = strip_tags($text);
		
		$terbilang = ucwords($this->terbilang($fas['plafond_akhir'])). ' Rupiah';
		// $terbilang_bunga = '( '.$this->terbilang($fas['bunga_tahun']);
		// $terbilang_bunga = '( '.$this->terbilang(1.50).' )';
		$terbilang_waktu = ucwords($this->terbilang($fas['jangka_waktu']));
		$terbilang_cicilan = ucwords($this->terbilang($fas['angsuran_bulan']));
		$terbilang_tempo = ucwords($this->terbilang(date('d', strtotime($rpt['tanggal_cicilan_awal']))));
				
		// $section->addText(htmlspecialchars($text),array('name' => 'Times', 'size' => '9', 'align'=>'justify'));				

		\PhpOffice\PhpWord\Shared\Html::addHtml($section, $html);
		$section->addText(htmlspecialchars(''));

		foreach ($psl as $r){

			$section->addText(htmlspecialchars('PASAL '.$r->pasal_pp),array('name' => 'Times New Roman', 'size' => '9', 'bold' => TRUE, 'align'=>'center'), 
			[ 'align' => \PhpOffice\PhpWord\SimpleType\Jc::CENTER ]);			

			$section->addText(htmlspecialchars($r->judul_pasal),array('name' => 'Times New Roman', 'size' => '9', 'bold' => TRUE, 'align'=>'center'), 
			[ 'align' => \PhpOffice\PhpWord\SimpleType\Jc::CENTER ]);
			
			$html = $r->isi_pasal; 
			
			$html = str_replace('[jumlah_fasilitas]', number_format($fas['plafond_akhir'],0), $html);
			$html = str_replace('[terbilang_fasilitas]', $terbilang, $html);
			$html = str_replace('[bunga_pinjaman]', $fas['bunga_tahun']/12, $html);
			$html = str_replace('[provisi]', $fas['provisi'], $html);
			$html = str_replace('[administrasi]', $fas['komisi'], $html);
			// $html = str_replace('[terbilang_bunga_pinjaman]', $terbilang_bunga, $html);
			$html = str_replace('[jangka_waktu]', $fas['jangka_waktu'], $html);
			$html = str_replace('[terbilang_jangka_waktu]', $terbilang_waktu, $html);
			$html = str_replace('[tanggal_awal]', date('d', strtotime($rpt['tanggal_awal'])).' '.$bulan[date('m', strtotime($rpt['tanggal_awal']))].' '.date('Y', strtotime($rpt['tanggal_awal'])), $html);
			$html = str_replace('[tanggal_akhir]', date('d', strtotime($rpt['tanggal_akhir'])).' '.$bulan[date('m', strtotime($rpt['tanggal_akhir']))].' '.date('Y', strtotime($rpt['tanggal_akhir'])), $html);			
			$html = str_replace('[cicilan]', number_format($fas['angsuran_bulan']), $html);
			$html = str_replace('[cicilan_pokok]', number_format($fas['angsuran_pokok']), $html);
			$html = str_replace('[cicilan_bunga]', number_format($fas['angsuran_bunga']), $html);
			$html = str_replace('[simpanan_wajib]', number_format($sw['simpanan_wajib']), $html);
			$html = str_replace('[terbilang_cicilan]', $terbilang_cicilan, $html);
			$html = str_replace('[tanggal_jatuh_tempo]', date('d', strtotime($rpt['tanggal_cicilan_awal'])), $html);
			$html = str_replace('[tanggal_mulai_cicilan]', date('d', strtotime($rpt['tanggal_cicilan_awal'])).' '.$bulan[date('m', strtotime($rpt['tanggal_cicilan_awal']))].' '.date('Y', strtotime($rpt['tanggal_cicilan_awal'])), $html);	
			$html = str_replace('[tanggal_akhir_cicilan]', date('d', strtotime($rpt['tanggal_cicilan_akhir'])).' '.$bulan[date('m', strtotime($rpt['tanggal_cicilan_akhir']))].' '.date('Y', strtotime($rpt['tanggal_cicilan_akhir'])), $html);			
			$html = str_replace('[terbilang_tanggal_jatuh_tempo]', $terbilang_tempo, $html);

			$sql = "select b.jenis_jaminan From jaminan_pinjaman_header a left join jenis_jaminan b
				on a.id_jenis_jaminan = b.id where id_pengajuan = $id";
			$jamh = $this->db->query($sql)->row_array();

			$html = str_replace('[jaminan]', $jamh['jenis_jaminan'], $html);

			$sql = "select b.jenis_jaminan, a.ket_jaminan from jaminan_pinjaman_detail a left join 
				jenis_jaminan b on a.id_jenis_jaminan = b.id
				where a.id_header = (select id from jaminan_pinjaman_header where id_pengajuan = $id) 
				and b.is_rkp='Ya' order by a.id";
			$jam = $this->db->query($sql)->result();

			$str = '';	
			foreach ($jam as $p)
			{
				$str = $str . $p->jenis_jaminan.' : '.$p->ket_jaminan. '<br/>';
			}						
			// print_r($str);
			// die;
			$html = str_replace('[detail_jaminan]', $str, $html);

			\PhpOffice\PhpWord\Shared\Html::addHtml($section, $html);

			$section->addText(htmlspecialchars(''));
		}

		$html = $hdr['header_3']; 

		$html = str_replace('[ketua_koperasi]', $rpt['ketua_koperasi_d'], $html);
		$html = str_replace('[pasangan]', $ang['hubungan'], $html);
		
		\PhpOffice\PhpWord\Shared\Html::addHtml($section, $html);

		
        $writer = new Word2007($phpWord);

        $filename = $ang['nama_anggota'].'-PP-'.$rpt['no_pp'];

        header('Content-Type: application/msword');
        header('Content-Disposition: attachment;filename="' . $filename . '.docx"');
        header('Cache-Control: max-age=0');

        $writer->save('php://output');
	}
	
	public function bapj_word()
    {
		$id = $this->uri->segment('4');

		date_default_timezone_set("Asia/Jakarta");

        $phpWord = new PhpWord();
		$section = $phpWord->addSection();
		
		$phpWord->setDefaultFontName('Times New Roman');
		$phpWord->setDefaultFontSize(9);

		$sql = "select a.*, b.nama_pengurus as ketua_koperasi_d, c.nama_pengurus as koordinator_pinjaman_d
			from perjanjian_pinjaman a left join pengurus_koperasi b on 
			a.ketua_koperasi=b.id left join pengurus_koperasi c on 
			a.koordinator_pinjaman=c.id where a.id_pengajuan = $id";
		$rpt = $this->db->query($sql)->row_array();

        $sql = "select a.* from bapj_header a ";
		$hdr = $this->db->query($sql)->row_array();

        $sql = "select a.* from pasal_perjanjian a where a.id_pengajuan = $id and pasal_pp > 0";
		$psl = $this->db->query($sql)->result();

		$sql = "select b.* from pengajuan_pinjaman a left join anggota b on a.id_anggota=b.id where a.id = $id";
		$ang = $this->db->query($sql)->row_array();

		$sql = "select a.* from fasilitas_pinjaman a where a.id_pengajuan = $id";
		$fas = $this->db->query($sql)->row_array();

		$sql = "select sum(a.nominal) as simpanan_wajib from biaya_lain a where a.id_pengajuan = $id and a.is_sw = 'Ya' ";
		$sw = $this->db->query($sql)->row_array();

		$phpWord->setDefaultParagraphStyle(array('spaceAfter' => \PhpOffice\PhpWord\Shared\Converter::pointToTwip(0), 'spacing' => 1));

		$section->addText(htmlspecialchars('BERITA ACARA PENERIMAAN JAMINAN'),array('name' => 'Times New Roman', 'size' => '14', 'bold' => TRUE, 'underline' => 'single', 'align'=>'center'), 
		[ 'align' => \PhpOffice\PhpWord\SimpleType\Jc::CENTER ]);

		// $section->addText(htmlspecialchars($rpt['no_pp']),array('name' => 'Times New Roman', 'size' => '12', 'bold' => TRUE, 'align'=>'center'), 
		// [ 'align' => \PhpOffice\PhpWord\SimpleType\Jc::CENTER ]);

		$header = $section->addHeader();
		$header->firstPage();
		$table = $header->addTable();
		$table->addRow();
		$cell = $table->addCell(4500);
		$textrun = $cell->addTextRun();
		// $textrun->addText(htmlspecialchars($rpt['no_pp']));
		
		// $subsequent = $section->addHeader();
		// $subsequent->addText(htmlspecialchars($rpt['no_pp']));

		$footer = $section->addFooter(\PhpOffice\PhpWord\Element\Footer::FIRST);
		$footer->addPreserveText(htmlspecialchars($ang['nama_anggota'].' Page {PAGE} of {NUMPAGES}'), array('align' => 'right'));

		$footer = $section->addFooter(\PhpOffice\PhpWord\Element\Footer::AUTO);
		$footer->addPreserveText(htmlspecialchars($ang['nama_anggota'].' Page {PAGE} of {NUMPAGES}'), array('align' => 'right'));

		$section->addText(htmlspecialchars(''));		
		
		$html = $hdr['header_1']; 

		$daftar_hari = array(
			'Sunday' => 'Minggu',
			'Monday' => 'Senin',
			'Tuesday' => 'Selasa',
			'Wednesday' => 'Rabu',
			'Thursday' => 'Kamis',
			'Friday' => 'Jumat',
			'Saturday' => 'Sabtu'
		);
		$namahari = date('l', strtotime($rpt['tanggal_pp']));
		$namahari = $daftar_hari[$namahari];

		$bulan = array(
			'01' => 'Januari',
			'02' => 'Februari',
			'03' => 'Maret',
			'04' => 'April',
			'05' => 'Mei',
			'06' => 'Juni',
			'07' => 'Juli',
			'08' => 'Agustus',
			'09' => 'September',
			'10' => 'Oktober',
			'11' => 'November',
			'12' => 'Desember',
		);

		$html = str_replace('[hari_pp]', $namahari, $html);
		$html = str_replace('[tanggal_pp]', date('d', strtotime($rpt['tanggal_pp'])).' '.$bulan[date('m', strtotime($rpt['tanggal_pp']))].' '.date('Y', strtotime($rpt['tanggal_pp'])), $html);
		$html = str_replace('[nik_peminjam]', $ang['no_ktp'], $html);
		$html = str_replace('[nama_peminjam]', $ang['nama_anggota'], $html);
		$html = str_replace('[ttl_peminjam]', $ang['tempat_lahir'].','.date('d F Y', strtotime($ang['tgl_lahir'])), $html);
		$html = str_replace('[alamat_peminjam]', $ang['alamat_ktp'], $html);		
		$html = str_replace('[pekerjaan_peminjam]', $ang['bidang_usaha'], $html);
		
		$sql = "select b.jenis_jaminan From jaminan_pinjaman_header a left join jenis_jaminan b
			on a.id_jenis_jaminan = b.id where id_pengajuan = $id";
		$jamh = $this->db->query($sql)->row_array();

		$html = str_replace('[jaminan]', $jamh['jenis_jaminan'], $html);		

		$sql = "select b.jenis_jaminan, a.ket_jaminan from jaminan_pinjaman_detail a left join 
			jenis_jaminan b on a.id_jenis_jaminan = b.id
			where a.id_header = (select id from jaminan_pinjaman_header where id_pengajuan = $id) 
			and b.is_rkp='Ya' order by a.id";
		$jam = $this->db->query($sql)->result();

		$str = '';	
		foreach ($jam as $p)
		{
			$str = $str . $p->jenis_jaminan.' : '.$p->ket_jaminan. '<br/>';
		}						
		// print_r($str);
		// die;
		$html = str_replace('[detail_jaminan]', $str, $html);
		$html = str_replace('[no_pp]', $rpt['no_pp'], $html);
		$html = str_replace('[tanggal_pp]', date('d', strtotime($rpt['tanggal_pp'])).' '.$bulan[date('m', strtotime($rpt['tanggal_pp']))].' '.date('Y', strtotime($rpt['tanggal_pp'])), $html);
		$html = str_replace('[ketua_koperasi]', $rpt['ketua_koperasi_d'], $html);
		$html = str_replace('[penerima_jaminan]', $rpt['koordinator_pinjaman_d'], $html);
		// $section->addText(htmlspecialchars(''));

		\PhpOffice\PhpWord\Shared\Html::addHtml($section, $html);
		
        $writer = new Word2007($phpWord);

        $filename = $ang['nama_anggota'].'-Berita Acara-'.$rpt['no_pp'];

        header('Content-Type: application/msword');
        header('Content-Disposition: attachment;filename="' . $filename . '.docx"');
        header('Cache-Control: max-age=0');

        $writer->save('php://output');
	}
	
	public function oflet_word()
    {
		$id = $this->uri->segment('4');

		date_default_timezone_set("Asia/Jakarta");

        $phpWord = new PhpWord();
		$section = $phpWord->addSection();
		
		$phpWord->setDefaultFontName('Times New Roman');
		$phpWord->setDefaultFontSize(11);

		$sql = "select a.*, b.nama_pengurus as ketua_koperasi_d, c.nama_pengurus as koordinator_pinjaman_d
			from perjanjian_pinjaman a left join pengurus_koperasi b on 
			a.ketua_koperasi=b.id left join pengurus_koperasi c on 
			a.koordinator_pinjaman=c.id where a.id_pengajuan = $id";
		$rpt = $this->db->query($sql)->row_array();

        $sql = "select a.* from oflet_header a ";
		$hdr = $this->db->query($sql)->row_array();

        $sql = "select a.* from pasal_perjanjian a where a.id_pengajuan = $id and pasal_pp > 0";
		$psl = $this->db->query($sql)->result();

		$sql = "select b.* from pengajuan_pinjaman a left join anggota b on a.id_anggota=b.id where a.id = $id";
		$ang = $this->db->query($sql)->row_array();

		$sql = "select a.* from fasilitas_pinjaman a where a.id_pengajuan = $id";
		$fas = $this->db->query($sql)->row_array();

		$sql = "select sum(a.nominal) as simpanan_wajib from biaya_lain a where a.id_pengajuan = $id and a.is_sw = 'Ya' ";
		$sw = $this->db->query($sql)->row_array();

		$sql = "select concat(b.tipe_pinjaman, ' (',b.keterangan,')' ) as tipe From fasilitas_pinjaman a left join tipe_pinjaman b 
			on a.id_jenis_pinjaman =b.id where a.id_pengajuan = $id";
		$tipe = $this->db->query($sql)->row_array();

		$phpWord->setDefaultParagraphStyle(array('spaceAfter' => \PhpOffice\PhpWord\Shared\Converter::pointToTwip(0), 'spacing' => 1));

		// $section->addText(htmlspecialchars('BERITA ACARA PENERIMAAN JAMINAN'),array('name' => 'Times New Roman', 'size' => '14', 'bold' => TRUE, 'underline' => 'single', 'align'=>'center'), 
		// [ 'align' => \PhpOffice\PhpWord\SimpleType\Jc::CENTER ]);

		// $section->addText(htmlspecialchars($rpt['no_pp']),array('name' => 'Times New Roman', 'size' => '12', 'bold' => TRUE, 'align'=>'center'), 
		// [ 'align' => \PhpOffice\PhpWord\SimpleType\Jc::CENTER ]);

		$header = $section->addHeader();
		$header->firstPage();
		$table = $header->addTable();
		$table->addRow();
		$cell = $table->addCell(4500);
		$textrun = $cell->addTextRun();
		// $textrun->addText(htmlspecialchars($rpt['no_pp']));
		
		// $subsequent = $section->addHeader();
		// $subsequent->addText(htmlspecialchars($rpt['no_pp']));

		$footer = $section->addFooter(\PhpOffice\PhpWord\Element\Footer::FIRST);
		$footer->addPreserveText(htmlspecialchars($ang['nama_anggota'].' Page {PAGE} of {NUMPAGES}'), array('align' => 'right'));

		$footer = $section->addFooter(\PhpOffice\PhpWord\Element\Footer::AUTO);
		$footer->addPreserveText(htmlspecialchars($ang['nama_anggota'].' Page {PAGE} of {NUMPAGES}'), array('align' => 'right'));

		$section->addText(htmlspecialchars(''));		
		
		$html = $hdr['header_1']; 

		$daftar_hari = array(
			'Sunday' => 'Minggu',
			'Monday' => 'Senin',
			'Tuesday' => 'Selasa',
			'Wednesday' => 'Rabu',
			'Thursday' => 'Kamis',
			'Friday' => 'Jumat',
			'Saturday' => 'Sabtu'
		);
		$namahari = date('l', strtotime($rpt['tanggal_pp']));
		$namahari = $daftar_hari[$namahari];

		$bulan = array(
			'01' => 'Januari',
			'02' => 'Februari',
			'03' => 'Maret',
			'04' => 'April',
			'05' => 'Mei',
			'06' => 'Juni',
			'07' => 'Juli',
			'08' => 'Agustus',
			'09' => 'September',
			'10' => 'Oktober',
			'11' => 'November',
			'12' => 'Desember',
		);

		$terbilang = ucwords($this->terbilang($fas['plafond_akhir'])). ' Rupiah';
		$terbilang_waktu = ucwords($this->terbilang($fas['jangka_waktu']));
		
		$html = str_replace('[no_off_letter]', $rpt['no_off_letter'], $html);
		$html = str_replace('[tanggal_pp]', date('d', strtotime($rpt['tanggal_pp'])).' '.$bulan[date('m', strtotime($rpt['tanggal_pp']))].' '.date('Y', strtotime($rpt['tanggal_pp'])), $html);
		$html = str_replace('[jenis_pinjaman]', $tipe['tipe'], $html);
		$html = str_replace('[jumlah_fasilitas]', number_format($fas['plafond_akhir'],0), $html);
		$html = str_replace('[terbilang_fasilitas]', $terbilang, $html);
		$html = str_replace('[bunga_pinjaman]', $fas['bunga_tahun']/12, $html);
		$html = str_replace('[jangka_waktu]', $fas['jangka_waktu'], $html);
		$html = str_replace('[terbilang_jangka_waktu]', $terbilang_waktu, $html);
		$html = str_replace('[cicilan]', number_format($fas['angsuran_bulan']), $html);
		$html = str_replace('[cicilan_pokok]', number_format($fas['angsuran_pokok']), $html);
		$html = str_replace('[cicilan_bunga]', number_format($fas['angsuran_bunga']), $html);
		$html = str_replace('[simpanan_wajib]', number_format($sw['simpanan_wajib']), $html);

		$html = str_replace('[ketua_koperasi]', $rpt['ketua_koperasi_d'], $html);

		$str = '';	
		$str = $str . '1. Provisi ('.$fas['provisi'].' %)  : Rp. ' . number_format($fas['plafond_akhir'] * ($fas['provisi']/100),0).',-'. '<br/>';
		$str = $str . '2. Biaya Administrasi ('.$fas['komisi'].' %)  : Rp. ' . number_format($fas['plafond_akhir'] * ($fas['komisi']/100),0).',-'. '<br/>';

		$sql = "select concat(b.jenis_biaya_pp,' ',a.keterangan) as ket, a.nominal From biaya_pp a left join mst_biaya_pp b 
			on a.jenis_biaya_pp=b.id where a.id_pengajuan = $id";
		$jam = $this->db->query($sql)->result();

		$provisi = $fas['plafond_akhir'] * ($fas['provisi'] / 100);
		$komisi = $fas['plafond_akhir'] * ($fas['komisi'] / 100);

		$i=3; $total=$provisi+$komisi;
		foreach ($jam as $p)
		{
			$str = $str . $i . '. ' .$p->ket.'  : Rp. '.number_format($p->nominal,0). ',-'. '<br/>';
			$i++;
			$total = $total + $p->nominal;
		}						
		$str = $str . 'TOTAL  : Rp. '.number_format($total,0). ',-'. '<br/>';

		$html = str_replace('[biaya_pp]', $str, $html);
		// $section->addText(htmlspecialchars(''));

		\PhpOffice\PhpWord\Shared\Html::addHtml($section, $html);
		
        $writer = new Word2007($phpWord);

        $filename = $ang['nama_anggota'].'-Offering Letter-'.$rpt['no_pp'];

        header('Content-Type: application/msword');
        header('Content-Disposition: attachment;filename="' . $filename . '.docx"');
        header('Cache-Control: max-age=0');

        $writer->save('php://output');
	}

	public function sk_word()
    {
		$id = $this->uri->segment('4');

		date_default_timezone_set("Asia/Jakarta");

        $phpWord = new PhpWord();
		$section = $phpWord->addSection();
		
		$phpWord->setDefaultFontName('Times New Roman');
		$phpWord->setDefaultFontSize(9);

		$sql = "select a.*, b.nama_pengurus as ketua_koperasi_d, c.nama_pengurus as koordinator_pinjaman_d
			from perjanjian_pinjaman a left join pengurus_koperasi b on 
			a.ketua_koperasi=b.id left join pengurus_koperasi c on 
			a.koordinator_pinjaman=c.id where a.id_pengajuan = $id";
		$rpt = $this->db->query($sql)->row_array();

        $sql = "select a.* from sk_header a ";
		$hdr = $this->db->query($sql)->row_array();

        $sql = "select a.* from pasal_perjanjian a where a.id_pengajuan = $id and pasal_pp > 0";
		$psl = $this->db->query($sql)->result();

		$sql = "select b.* from pengajuan_pinjaman a left join anggota b on a.id_anggota=b.id where a.id = $id";
		$ang = $this->db->query($sql)->row_array();

		$sql = "select a.* from fasilitas_pinjaman a where a.id_pengajuan = $id";
		$fas = $this->db->query($sql)->row_array();

		$sql = "select sum(a.nominal) as simpanan_wajib from biaya_lain a where a.id_pengajuan = $id and a.is_sw = 'Ya' ";
		$sw = $this->db->query($sql)->row_array();

		$phpWord->setDefaultParagraphStyle(array('spaceAfter' => \PhpOffice\PhpWord\Shared\Converter::pointToTwip(0), 'spacing' => 1));

		$section->addText(htmlspecialchars('SURAT KUASA'),array('name' => 'Times New Roman', 'size' => '14', 'bold' => TRUE, 'underline' => 'single', 'align'=>'center'), 
		[ 'align' => \PhpOffice\PhpWord\SimpleType\Jc::CENTER ]);

		// $section->addText(htmlspecialchars($rpt['no_pp']),array('name' => 'Times New Roman', 'size' => '12', 'bold' => TRUE, 'align'=>'center'), 
		// [ 'align' => \PhpOffice\PhpWord\SimpleType\Jc::CENTER ]);

		$header = $section->addHeader();
		$header->firstPage();
		$table = $header->addTable();
		$table->addRow();
		$cell = $table->addCell(4500);
		$textrun = $cell->addTextRun();
		// $textrun->addText(htmlspecialchars($rpt['no_pp']));
		
		// $subsequent = $section->addHeader();
		// $subsequent->addText(htmlspecialchars($rpt['no_pp']));

		$footer = $section->addFooter(\PhpOffice\PhpWord\Element\Footer::FIRST);
		$footer->addPreserveText(htmlspecialchars($ang['nama_anggota'].' Page {PAGE} of {NUMPAGES}'), array('align' => 'right'));

		$footer = $section->addFooter(\PhpOffice\PhpWord\Element\Footer::AUTO);
		$footer->addPreserveText(htmlspecialchars($ang['nama_anggota'].' Page {PAGE} of {NUMPAGES}'), array('align' => 'right'));

		$section->addText(htmlspecialchars(''));		
		
		$html = $hdr['header_1']; 

		$daftar_hari = array(
			'Sunday' => 'Minggu',
			'Monday' => 'Senin',
			'Tuesday' => 'Selasa',
			'Wednesday' => 'Rabu',
			'Thursday' => 'Kamis',
			'Friday' => 'Jumat',
			'Saturday' => 'Sabtu'
		);
		$namahari = date('l', strtotime($rpt['tanggal_pp']));
		$namahari = $daftar_hari[$namahari];

		$bulan = array(
			'01' => 'Januari',
			'02' => 'Februari',
			'03' => 'Maret',
			'04' => 'April',
			'05' => 'Mei',
			'06' => 'Juni',
			'07' => 'Juli',
			'08' => 'Agustus',
			'09' => 'September',
			'10' => 'Oktober',
			'11' => 'November',
			'12' => 'Desember',
		);

		$html = str_replace('[no_pp]', $rpt['no_pp'], $html);
		$html = str_replace('[tanggal_pp]', date('d', strtotime($rpt['tanggal_pp'])).' '.$bulan[date('m', strtotime($rpt['tanggal_pp']))].' '.date('Y', strtotime($rpt['tanggal_pp'])), $html);
		$html = str_replace('[nik_peminjam]', $ang['no_ktp'], $html);
		$html = str_replace('[nama_peminjam]', $ang['nama_anggota'], $html);
		$html = str_replace('[ttl_peminjam]', $ang['tempat_lahir'].','.date('d F Y', strtotime($ang['tgl_lahir'])), $html);
		$html = str_replace('[alamat_peminjam]', $ang['alamat_ktp'], $html);		
		$html = str_replace('[pekerjaan_peminjam]', $ang['bidang_usaha'], $html);
		
		$sql = "select b.jenis_jaminan From jaminan_pinjaman_header a left join jenis_jaminan b
			on a.id_jenis_jaminan = b.id where id_pengajuan = $id";
		$jamh = $this->db->query($sql)->row_array();

		$html = str_replace('[jaminan]', $jamh['jenis_jaminan'], $html);		

		$sql = "select b.jenis_jaminan, a.ket_jaminan from jaminan_pinjaman_detail a left join 
			jenis_jaminan b on a.id_jenis_jaminan = b.id
			where a.id_header = (select id from jaminan_pinjaman_header where id_pengajuan = $id) 
			and b.is_rkp='Ya' order by a.id";
		$jam = $this->db->query($sql)->result();

		$str = '';	
		foreach ($jam as $p)
		{
			$str = $str . $p->jenis_jaminan.' : '.$p->ket_jaminan. '<br/>';
		}						
		// print_r($str);
		// die;
		$html = str_replace('[detail_jaminan]', $str, $html);
		$html = str_replace('[ketua_koperasi]', $rpt['ketua_koperasi_d'], $html);
		$html = str_replace('[penerima_jaminan]', $rpt['koordinator_pinjaman_d'], $html);
		// $section->addText(htmlspecialchars(''));

		\PhpOffice\PhpWord\Shared\Html::addHtml($section, $html);
		
        $writer = new Word2007($phpWord);

        $filename = $ang['nama_anggota'].'-Surat Kuasa-'.$rpt['no_pp'];

        header('Content-Type: application/msword');
        header('Content-Disposition: attachment;filename="' . $filename . '.docx"');
        header('Cache-Control: max-age=0');

        $writer->save('php://output');
	}

	public function sphm_word()
    {
		$id = $this->uri->segment('4');

		date_default_timezone_set("Asia/Jakarta");

        $phpWord = new PhpWord();
		$section = $phpWord->addSection();
		
		$phpWord->setDefaultFontName('Times New Roman');
		$phpWord->setDefaultFontSize(9);

		$sql = "select a.*, b.nama_pengurus as ketua_koperasi_d, c.nama_pengurus as koordinator_pinjaman_d
			from perjanjian_pinjaman a left join pengurus_koperasi b on 
			a.ketua_koperasi=b.id left join pengurus_koperasi c on 
			a.koordinator_pinjaman=c.id where a.id_pengajuan = $id";
		$rpt = $this->db->query($sql)->row_array();

        $sql = "select a.* from sphm_header a ";
		$hdr = $this->db->query($sql)->row_array();

        $sql = "select a.* from pasal_perjanjian a where a.id_pengajuan = $id and pasal_pp > 0";
		$psl = $this->db->query($sql)->result();

		$sql = "select b.* from pengajuan_pinjaman a left join anggota b on a.id_anggota=b.id where a.id = $id";
		$ang = $this->db->query($sql)->row_array();

		$sql = "select a.* from fasilitas_pinjaman a where a.id_pengajuan = $id";
		$fas = $this->db->query($sql)->row_array();

		$sql = "select sum(a.nominal) as simpanan_wajib from biaya_lain a where a.id_pengajuan = $id and a.is_sw = 'Ya' ";
		$sw = $this->db->query($sql)->row_array();

		$phpWord->setDefaultParagraphStyle(array('spaceAfter' => \PhpOffice\PhpWord\Shared\Converter::pointToTwip(0), 'spacing' => 1));

		$section->addText(htmlspecialchars('SURAT KUASA'),array('name' => 'Times New Roman', 'size' => '14', 'bold' => TRUE, 'underline' => 'single', 'align'=>'center'), 
		[ 'align' => \PhpOffice\PhpWord\SimpleType\Jc::CENTER ]);

		// $section->addText(htmlspecialchars($rpt['no_pp']),array('name' => 'Times New Roman', 'size' => '12', 'bold' => TRUE, 'align'=>'center'), 
		// [ 'align' => \PhpOffice\PhpWord\SimpleType\Jc::CENTER ]);

		$header = $section->addHeader();
		$header->firstPage();
		$table = $header->addTable();
		$table->addRow();
		$cell = $table->addCell(4500);
		$textrun = $cell->addTextRun();
		// $textrun->addText(htmlspecialchars($rpt['no_pp']));
		
		// $subsequent = $section->addHeader();
		// $subsequent->addText(htmlspecialchars($rpt['no_pp']));

		$footer = $section->addFooter(\PhpOffice\PhpWord\Element\Footer::FIRST);
		$footer->addPreserveText(htmlspecialchars($ang['nama_anggota'].' Page {PAGE} of {NUMPAGES}'), array('align' => 'right'));

		$footer = $section->addFooter(\PhpOffice\PhpWord\Element\Footer::AUTO);
		$footer->addPreserveText(htmlspecialchars($ang['nama_anggota'].' Page {PAGE} of {NUMPAGES}'), array('align' => 'right'));

		$section->addText(htmlspecialchars(''));		
		
		$html = $hdr['header_1']; 

		$daftar_hari = array(
			'Sunday' => 'Minggu',
			'Monday' => 'Senin',
			'Tuesday' => 'Selasa',
			'Wednesday' => 'Rabu',
			'Thursday' => 'Kamis',
			'Friday' => 'Jumat',
			'Saturday' => 'Sabtu'
		);
		$namahari = date('l', strtotime($rpt['tanggal_pp']));
		$namahari = $daftar_hari[$namahari];

		$bulan = array(
			'01' => 'Januari',
			'02' => 'Februari',
			'03' => 'Maret',
			'04' => 'April',
			'05' => 'Mei',
			'06' => 'Juni',
			'07' => 'Juli',
			'08' => 'Agustus',
			'09' => 'September',
			'10' => 'Oktober',
			'11' => 'November',
			'12' => 'Desember',
		);

		$html = str_replace('[no_pp]', $rpt['no_pp'], $html);
		$html = str_replace('[tanggal_pp]', date('d', strtotime($rpt['tanggal_pp'])).' '.$bulan[date('m', strtotime($rpt['tanggal_pp']))].' '.date('Y', strtotime($rpt['tanggal_pp'])), $html);
		$html = str_replace('[nik_peminjam]', $ang['no_ktp'], $html);
		$html = str_replace('[nama_peminjam]', $ang['nama_anggota'], $html);
		$html = str_replace('[ttl_peminjam]', $ang['tempat_lahir'].','.date('d F Y', strtotime($ang['tgl_lahir'])), $html);
		$html = str_replace('[alamat_peminjam]', $ang['alamat_ktp'], $html);		
		$html = str_replace('[pekerjaan_peminjam]', $ang['bidang_usaha'], $html);
		$html = str_replace('[pasangan]', $ang['hubungan'], $html);
		
		$sql = "select b.jenis_jaminan From jaminan_pinjaman_header a left join jenis_jaminan b
			on a.id_jenis_jaminan = b.id where id_pengajuan = $id";
		$jamh = $this->db->query($sql)->row_array();

		$html = str_replace('[jaminan]', $jamh['jenis_jaminan'], $html);		

		$sql = "select b.jenis_jaminan, a.ket_jaminan from jaminan_pinjaman_detail a left join 
			jenis_jaminan b on a.id_jenis_jaminan = b.id
			where a.id_header = (select id from jaminan_pinjaman_header where id_pengajuan = $id) 
			and b.is_rkp='Ya' order by a.id";
		$jam = $this->db->query($sql)->result();

		$str = '';	
		foreach ($jam as $p)
		{
			$str = $str . $p->jenis_jaminan.' : '.$p->ket_jaminan. '<br/>';
		}						
		// print_r($str);
		// die;
		$html = str_replace('[detail_jaminan]', $str, $html);
		$html = str_replace('[ketua_koperasi]', $rpt['ketua_koperasi_d'], $html);
		$html = str_replace('[penerima_jaminan]', $rpt['koordinator_pinjaman_d'], $html);
		// $section->addText(htmlspecialchars(''));

		\PhpOffice\PhpWord\Shared\Html::addHtml($section, $html);
		
        $writer = new Word2007($phpWord);

        $filename = $ang['nama_anggota'].'-SPHM-'.$rpt['no_pp'];

        header('Content-Type: application/msword');
        header('Content-Disposition: attachment;filename="' . $filename . '.docx"');
        header('Cache-Control: max-age=0');

        $writer->save('php://output');
	}

	public function skfidusia_word()
    {
		$id = $this->uri->segment('4');

		date_default_timezone_set("Asia/Jakarta");

        $phpWord = new PhpWord();
		$section = $phpWord->addSection();
		
		$phpWord->setDefaultFontName('Times New Roman');
		$phpWord->setDefaultFontSize(9);

		$sql = "select a.*, b.nama_pengurus as ketua_koperasi_d, b.jabatan as jabatan_pengurus,
			b.alamat as alamat_pengurus, c.nama_pengurus as koordinator_pinjaman_d
			from perjanjian_pinjaman a left join pengurus_koperasi b on 
			a.ketua_koperasi=b.id left join pengurus_koperasi c on 
			a.koordinator_pinjaman=c.id where a.id_pengajuan = $id";
		$rpt = $this->db->query($sql)->row_array();

        $sql = "select a.* from skfidusia_header a ";
		$hdr = $this->db->query($sql)->row_array();

        $sql = "select a.* from pasal_perjanjian a where a.id_pengajuan = $id and pasal_pp > 0";
		$psl = $this->db->query($sql)->result();

		$sql = "select b.* from pengajuan_pinjaman a left join anggota b on a.id_anggota=b.id where a.id = $id";
		$ang = $this->db->query($sql)->row_array();

		$sql = "select a.* from fasilitas_pinjaman a where a.id_pengajuan = $id";
		$fas = $this->db->query($sql)->row_array();

		$sql = "select sum(a.nominal) as simpanan_wajib from biaya_lain a where a.id_pengajuan = $id and a.is_sw = 'Ya' ";
		$sw = $this->db->query($sql)->row_array();

		$phpWord->setDefaultParagraphStyle(array('spaceAfter' => \PhpOffice\PhpWord\Shared\Converter::pointToTwip(0), 'spacing' => 1));

		$section->addText(htmlspecialchars('SURAT KUASA'),array('name' => 'Times New Roman', 'size' => '14', 'bold' => TRUE, 'underline' => 'single', 'align'=>'center'), 
		[ 'align' => \PhpOffice\PhpWord\SimpleType\Jc::CENTER ]);

		// $section->addText(htmlspecialchars($rpt['no_pp']),array('name' => 'Times New Roman', 'size' => '12', 'bold' => TRUE, 'align'=>'center'), 
		// [ 'align' => \PhpOffice\PhpWord\SimpleType\Jc::CENTER ]);

		$header = $section->addHeader();
		$header->firstPage();
		$table = $header->addTable();
		$table->addRow();
		$cell = $table->addCell(4500);
		$textrun = $cell->addTextRun();
		// $textrun->addText(htmlspecialchars($rpt['no_pp']));
		
		// $subsequent = $section->addHeader();
		// $subsequent->addText(htmlspecialchars($rpt['no_pp']));

		$footer = $section->addFooter(\PhpOffice\PhpWord\Element\Footer::FIRST);
		$footer->addPreserveText(htmlspecialchars($ang['nama_anggota'].' Page {PAGE} of {NUMPAGES}'), array('align' => 'right'));

		$footer = $section->addFooter(\PhpOffice\PhpWord\Element\Footer::AUTO);
		$footer->addPreserveText(htmlspecialchars($ang['nama_anggota'].' Page {PAGE} of {NUMPAGES}'), array('align' => 'right'));

		$section->addText(htmlspecialchars(''));		
		
		$html = $hdr['header_1']; 

		$daftar_hari = array(
			'Sunday' => 'Minggu',
			'Monday' => 'Senin',
			'Tuesday' => 'Selasa',
			'Wednesday' => 'Rabu',
			'Thursday' => 'Kamis',
			'Friday' => 'Jumat',
			'Saturday' => 'Sabtu'
		);
		$namahari = date('l', strtotime($rpt['tanggal_pp']));
		$namahari = $daftar_hari[$namahari];

		$bulan = array(
			'01' => 'Januari',
			'02' => 'Februari',
			'03' => 'Maret',
			'04' => 'April',
			'05' => 'Mei',
			'06' => 'Juni',
			'07' => 'Juli',
			'08' => 'Agustus',
			'09' => 'September',
			'10' => 'Oktober',
			'11' => 'November',
			'12' => 'Desember',
		);

		$html = str_replace('[no_pp]', $rpt['no_pp'], $html);
		$html = str_replace('[tanggal_pp]', date('d', strtotime($rpt['tanggal_pp'])).' '.$bulan[date('m', strtotime($rpt['tanggal_pp']))].' '.date('Y', strtotime($rpt['tanggal_pp'])), $html);
		$html = str_replace('[nik_peminjam]', $ang['no_ktp'], $html);
		$html = str_replace('[nama_peminjam]', $ang['nama_anggota'], $html);
		$html = str_replace('[ttl_peminjam]', $ang['tempat_lahir'].','.date('d F Y', strtotime($ang['tgl_lahir'])), $html);
		$html = str_replace('[alamat_peminjam]', $ang['alamat_ktp'], $html);		
		$html = str_replace('[pekerjaan_peminjam]', $ang['bidang_usaha'], $html);
		$html = str_replace('[pasangan]', $ang['hubungan'], $html);
		
		$sql = "select b.jenis_jaminan From jaminan_pinjaman_header a left join jenis_jaminan b
			on a.id_jenis_jaminan = b.id where id_pengajuan = $id";
		$jamh = $this->db->query($sql)->row_array();

		$html = str_replace('[jaminan]', $jamh['jenis_jaminan'], $html);		

		$sql = "select b.jenis_jaminan, a.ket_jaminan from jaminan_pinjaman_detail a left join 
			jenis_jaminan b on a.id_jenis_jaminan = b.id
			where a.id_header = (select id from jaminan_pinjaman_header where id_pengajuan = $id) 
			and b.is_rkp='Ya' order by a.id";
		$jam = $this->db->query($sql)->result();

		$str = '';	
		foreach ($jam as $p)
		{
			$str = $str . $p->jenis_jaminan.' : '.$p->ket_jaminan. '<br/>';
		}						
		// print_r($str);
		// die;
		$html = str_replace('[detail_jaminan]', $str, $html);
		$html = str_replace('[ketua_koperasi]', $rpt['ketua_koperasi_d'], $html);
		$html = str_replace('[jabatan_pengurus]', $rpt['jabatan_pengurus'], $html);
		$html = str_replace('[alamat_pengurus]', $rpt['alamat_pengurus'], $html);
		$html = str_replace('[penerima_jaminan]', $rpt['koordinator_pinjaman_d'], $html);
		// $section->addText(htmlspecialchars(''));

		\PhpOffice\PhpWord\Shared\Html::addHtml($section, $html);
		
        $writer = new Word2007($phpWord);

        $filename = $ang['nama_anggota'].'-SK Fidusia-'.$rpt['no_pp'];

        header('Content-Type: application/msword');
        header('Content-Disposition: attachment;filename="' . $filename . '.docx"');
        header('Cache-Control: max-age=0');

        $writer->save('php://output');
	}


	function memo_pencairan(){
		$id = $this->uri->segment('4');
		
		$sql = "select a.*, d.no_rkp, e.nama_anggota, e.no_anggota, b.nama_pengurus as ketua_koperasi_d, b.jabatan as jabatan_pengurus,
		b.alamat as alamat_pengurus, c.nama_pengurus as koordinator_pinjaman_d
		from perjanjian_pinjaman a left join pengurus_koperasi b on 
		a.ketua_koperasi=b.id left join pengurus_koperasi c on 
		a.koordinator_pinjaman=c.id left join pengajuan_pinjaman d on a.id_pengajuan=d.id
		left join anggota e on d.id_anggota=e.id 
		where a.id_pengajuan = $id";
		$rpt = $this->db->query($sql)->row_array();

		$this->load->library('pdf');
		$pdf = new FPDF('p', 'mm', 'A4');
		
		// membuat halaman baru
		$pdf->AliasNbPages();
		$pdf->AddPage();
		// setting jenis font yang akan digunakan
		
		$sql = "select a.* from config_global a ";
		$fot = $this->db->query($sql)->result();
		foreach ($fot as $f)
		{				
			$y_awal = $pdf->GetY(); 
			
			$pdf->Image('uploads/foto/'.$f->image,135,$y_awal,50,15,'JPG','');

			$pdf->SetXY(10,$y_awal+15);

			$pdf->Cell(190, 3, '', '', 1, 'C');			
		}

		$pdf->SetFont('Times', 'B', 14);
		// // $pdf->SetXY(10,4);
		$pdf->Cell(190, 6, 'MEMO PENCAIRAN PINJAMAN', 'LTR', 1, 'L');		
		$pdf->SetFont('Times', 'B', 10);			
		$pdf->Cell(45, 4, 'NOMOR', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['no_memo_cair'], 'R', 1, 'L');

		$daftar_hari = array(
			'Sunday' => 'Minggu',
			'Monday' => 'Senin',
			'Tuesday' => 'Selasa',
			'Wednesday' => 'Rabu',
			'Thursday' => 'Kamis',
			'Friday' => 'Jumat',
			'Saturday' => 'Sabtu'
		);
		$namahari = date('l', strtotime($rpt['tgl_memo_cair']));
		$namahari = $daftar_hari[$namahari];

		$bulan = array(
			'01' => 'Januari',
			'02' => 'Februari',
			'03' => 'Maret',
			'04' => 'April',
			'05' => 'Mei',
			'06' => 'Juni',
			'07' => 'Juli',
			'08' => 'Agustus',
			'09' => 'September',
			'10' => 'Oktober',
			'11' => 'November',
			'12' => 'Desember',
		);

		$glMemo = date('d', strtotime($rpt['tgl_memo_cair'])).' '.$bulan[date('m', strtotime($rpt['tgl_memo_cair']))].' '.date('Y', strtotime($rpt['tgl_memo_cair']));

		$pdf->Cell(45, 4, 'HARI/TANGGAL', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $namahari.', '.$glMemo, 'R', 1, 'L');

		$pdf->Cell(45, 4, 'KEPADA', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['kpd_memo_cair'], 'R', 1, 'L');

		$pdf->Cell(45, 4, 'DARI', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['dari_memo_cair'], 'R', 1, 'L');
		
		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(190, 5, 'INFORMASI PINJAMAN', 'LRTB', 1, 'C');
		
		$pdf->SetFont('Times', '', 10);
		$pdf->Cell(45, 4, 'NAMA PEMINJAM', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['nama_anggota'], 'R', 1, 'L');

		$pdf->Cell(45, 4, 'NO ANGGOTA', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['no_anggota'], 'R', 1, 'L');

		$sql = "select a.*, b.tipe_pinjaman, b.keterangan as ket_tipe, c.perhitungan_bunga 
		From fasilitas_pinjaman a left join tipe_pinjaman b on a.id_jenis_pinjaman=b.id
		left join perhitungan_bunga c on a.id_perhitungan_bunga = c.id
		where a.id_pengajuan = $id order by a.id";
		$fas = $this->db->query($sql)->row_array();

		$pdf->Cell(45, 4, 'JENIS PINJAMAN', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $fas['tipe_pinjaman'].' '.$fas['ket_tipe'].' ('.$fas['perhitungan_bunga'].')', 'R', 1, 'L');

		$pdf->Cell(45, 4, 'PLAFON', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, 'Rp. '.number_format($fas['plafond_akhir'],0), 'R', 1, 'L');

		$pdf->Cell(45, 4, 'JANGKA WAKTU', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, number_format($fas['jangka_waktu'],0).' Bulan', 'R', 1, 'L');

		$pdf->Cell(45, 4, 'BUNGA / BULAN', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, number_format($fas['bunga_tahun']/12,0).' %', 'R', 1, 'L');

		$pdf->Cell(45, 4, 'BUNGA / TAHUN', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, number_format($fas['bunga_tahun'],0).' %', 'R', 1, 'L');

		$pdf->Cell(45, 4, 'PROVISI', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, number_format($fas['provisi'],0).' %', 'R', 1, 'L');

		$pdf->Cell(45, 4, 'BIAYA ADMINISTRASI', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, number_format($fas['komisi'],0).' %', 'R', 1, 'L');

		$pdf->Cell(45, 4, 'NO RKP', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['no_rkp'], 'R', 1, 'L');

		$pdf->Cell(45, 4, 'NO PP', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['no_pp'], 'R', 1, 'L');

		$GLOBALS['rkp'] = '';

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(190, 5, 'INFORMASI PENCAIRAN PINJAMAN', 'LRTB', 1, 'C');

		$pdf->Cell(150, 4, 'A) PLAFON', 'L', 0, 'L');
		$pdf->Cell(5, 4, 'Rp', 0, 0, 'L');
		$pdf->Cell(35, 4, number_format($fas['plafond_akhir'],0), 'R', 1, 'R');

		$pdf->Cell(150, 7, '', 'L', 0, 'L');
		$pdf->Cell(5, 7, '', 0, 0, 'L');
		$pdf->Cell(35, 7, '', 'R', 1, 'R');

		$pdf->Cell(150, 4, 'B) BIAYA PENCAIRAN PINJAMAN', 'L', 0, 'L');
		$pdf->Cell(5, 4, '', 0, 0, 'L');
		$pdf->Cell(35, 4, '', 'R', 1, 'R');

		$sql = "select a.* from fasilitas_pinjaman a where a.id_pengajuan = $id";
		$fas = $this->db->query($sql)->row_array();

		$pdf->SetFont('Times', '', 10);

		$pdf->Cell(5, 4, '', 'L', 0, 'L');
		$pdf->Cell(100, 4, '1. Provisi ('.$fas['provisi'].' %)', '', 0, 'L');
		$pdf->Cell(5, 4, 'Rp', 0, 0, 'L');
		$pdf->Cell(35, 4, number_format($fas['plafond_akhir'] * ($fas['provisi']/100),0), '', 0, 'R');
		$pdf->Cell(45, 4, '', 'R', 1, 'R');

		$pdf->Cell(5, 4, '', 'L', 0, 'L');
		$pdf->Cell(100, 4, '2. Biaya Administrasi ('.$fas['komisi'].' %)', '', 0, 'L');
		$pdf->Cell(5, 4, 'Rp', 0, 0, 'L');
		$pdf->Cell(35, 4, number_format($fas['plafond_akhir'] * ($fas['komisi']/100),0), '', 0, 'R');
		$pdf->Cell(45, 4, '', 'R', 1, 'R');

		$sql = "select concat(b.jenis_biaya_pp,' ',a.keterangan) as ket, a.nominal From biaya_pp a left join mst_biaya_pp b 
			on a.jenis_biaya_pp=b.id where a.id_pengajuan = $id";
		$jam = $this->db->query($sql)->result();

		$provisi = $fas['plafond_akhir'] * ($fas['provisi'] / 100);
		$komisi = $fas['plafond_akhir'] * ($fas['komisi'] / 100);

		$i=3; $total=$provisi+$komisi;
		foreach ($jam as $p)
		{
			$pdf->Cell(5, 4, '', 'L', 0, 'L');
			$pdf->Cell(100, 4, $i.'. '.$p->ket, '', 0, 'L');
			$pdf->Cell(5, 4, 'Rp', 0, 0, 'L');
			$pdf->Cell(35, 4, number_format($p->nominal), '', 0, 'R');
			$pdf->Cell(45, 4, '', 'R', 1, 'R');

			$i++;
			$total = $total + $p->nominal;
		}

		$pdf->SetFont('Times', 'B', 10);

		$pdf->Cell(150, 4, '', 'L', 0, 'L');
		$pdf->Cell(5, 4, 'Rp', 0, 0, 'L');
		$pdf->Cell(35, 4, '('.number_format($total,0).')', 'R', 1, 'R');						
		
		$pdf->Cell(150, 7, '', 'L', 0, 'L');
		$pdf->Cell(5, 7, '', 0, 0, 'L');
		$pdf->Cell(35, 7, '', 'R', 1, 'R');

		$pdf->Cell(150, 4, 'C) NILAI PENCAIRAN (diberikan kepada peminjam)', 'L', 0, 'L');
		$pdf->Cell(5, 4, '', 0, 0, 'L');
		$pdf->Cell(35, 4, '('.number_format($fas['plafond_akhir'] - $total,0).')', 'R', 1, 'R');

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(190, 5, 'CATATAN', 'LRTB', 1, 'C');

		$pdf->Cell(150, 4, '', 'L', 0, 'L');
		$pdf->Cell(5, 4, '', 0, 0, 'L');
		$pdf->Cell(35, 4, '', 'R', 1, 'R');

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(64, 5, 'DIBUAT OLEH:', 'LRT', 0, 'C');
		$pdf->Cell(63, 5, 'DIPERIKSA OLEH:', 'RT', 0, 'C');
		$pdf->Cell(63, 5, 'MENYETUJUI:', 'RT', 1, 'C');

		$pdf->Cell(64, 20, '', 'LRT', 0, 'C');
		$pdf->Cell(63, 20, '', 'RT', 0, 'C');
		$pdf->Cell(63, 20, '', 'RT', 1, 'C');

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(190, 5, 'TELAH DITINDAKLANJUT', 'LRTB', 1, 'L');

		$pdf->Cell(150, 20, '', 'BL', 0, 'L');
		$pdf->Cell(5, 20, '', 'B', 0, 'L');
		$pdf->Cell(35, 20, '', 'BR', 1, 'R');

		$pdf->Output();
	}

	public function ttr_word()
    {
		$id = $this->uri->segment('4');

		date_default_timezone_set("Asia/Jakarta");

        $phpWord = new PhpWord();
		$section = $phpWord->addSection();
		
		$phpWord->setDefaultFontName('Times New Roman');
		$phpWord->setDefaultFontSize(9);

		$sql = "select a.*, b.nama_pengurus as ketua_koperasi_d, c.nama_pengurus as koordinator_pinjaman_d
			from perjanjian_pinjaman a left join pengurus_koperasi b on 
			a.ketua_koperasi=b.id left join pengurus_koperasi c on 
			a.koordinator_pinjaman=c.id where a.id_pengajuan = $id";
		$rpt = $this->db->query($sql)->row_array();

        $sql = "select a.* from tdtrmjam_header a ";
		$hdr = $this->db->query($sql)->row_array();

        $sql = "select a.* from pasal_perjanjian a where a.id_pengajuan = $id and pasal_pp > 0";
		$psl = $this->db->query($sql)->result();

		$sql = "select b.* from pengajuan_pinjaman a left join anggota b on a.id_anggota=b.id where a.id = $id";
		$ang = $this->db->query($sql)->row_array();

		$sql = "select a.* from fasilitas_pinjaman a where a.id_pengajuan = $id";
		$fas = $this->db->query($sql)->row_array();

		$sql = "select sum(a.nominal) as simpanan_wajib from biaya_lain a where a.id_pengajuan = $id and a.is_sw = 'Ya' ";
		$sw = $this->db->query($sql)->row_array();

		$phpWord->setDefaultParagraphStyle(array('spaceAfter' => \PhpOffice\PhpWord\Shared\Converter::pointToTwip(0), 'spacing' => 1));

		$section->addText(htmlspecialchars('TANDA TERIMA JAMINAN'),array('name' => 'Times New Roman', 'size' => '14', 'bold' => TRUE, 'underline' => 'single', 'align'=>'center'), 
		[ 'align' => \PhpOffice\PhpWord\SimpleType\Jc::CENTER ]);

		// $section->addText(htmlspecialchars($rpt['no_pp']),array('name' => 'Times New Roman', 'size' => '12', 'bold' => TRUE, 'align'=>'center'), 
		// [ 'align' => \PhpOffice\PhpWord\SimpleType\Jc::CENTER ]);

		$header = $section->addHeader();
		$header->firstPage();
		$table = $header->addTable();
		$table->addRow();
		$cell = $table->addCell(4500);
		$textrun = $cell->addTextRun();
		// $textrun->addText(htmlspecialchars($rpt['no_pp']));
		
		// $subsequent = $section->addHeader();
		// $subsequent->addText(htmlspecialchars($rpt['no_pp']));

		$footer = $section->addFooter(\PhpOffice\PhpWord\Element\Footer::FIRST);
		$footer->addPreserveText(htmlspecialchars($ang['nama_anggota'].' Page {PAGE} of {NUMPAGES}'), array('align' => 'right'));

		$footer = $section->addFooter(\PhpOffice\PhpWord\Element\Footer::AUTO);
		$footer->addPreserveText(htmlspecialchars($ang['nama_anggota'].' Page {PAGE} of {NUMPAGES}'), array('align' => 'right'));

		$section->addText(htmlspecialchars(''));		
		
		$html = $hdr['header_1']; 

		$daftar_hari = array(
			'Sunday' => 'Minggu',
			'Monday' => 'Senin',
			'Tuesday' => 'Selasa',
			'Wednesday' => 'Rabu',
			'Thursday' => 'Kamis',
			'Friday' => 'Jumat',
			'Saturday' => 'Sabtu'
		);
		$namahari = date('l', strtotime($rpt['tanggal_pp']));
		$namahari = $daftar_hari[$namahari];

		$bulan = array(
			'01' => 'Januari',
			'02' => 'Februari',
			'03' => 'Maret',
			'04' => 'April',
			'05' => 'Mei',
			'06' => 'Juni',
			'07' => 'Juli',
			'08' => 'Agustus',
			'09' => 'September',
			'10' => 'Oktober',
			'11' => 'November',
			'12' => 'Desember',
		);

		$html = str_replace('[hari_pp]', $namahari, $html);
		$html = str_replace('[tanggal_pp]', date('d', strtotime($rpt['tanggal_pp'])).' '.$bulan[date('m', strtotime($rpt['tanggal_pp']))].' '.date('Y', strtotime($rpt['tanggal_pp'])), $html);
		$html = str_replace('[nik_peminjam]', $ang['no_ktp'], $html);		
		$html = str_replace('[nama_peminjam]', $ang['nama_anggota'], $html);
		$html = str_replace('[ttl_peminjam]', $ang['tempat_lahir'].','.date('d F Y', strtotime($ang['tgl_lahir'])), $html);
		$html = str_replace('[alamat_peminjam]', $ang['alamat_ktp'], $html);		
		$html = str_replace('[pekerjaan_peminjam]', $ang['bidang_usaha'], $html);
		
		$sql = "select b.jenis_jaminan From jaminan_pinjaman_header a left join jenis_jaminan b
			on a.id_jenis_jaminan = b.id where id_pengajuan = $id";
		$jamh = $this->db->query($sql)->row_array();

		$html = str_replace('[jaminan]', $jamh['jenis_jaminan'], $html);		

		$sql = "select b.jenis_jaminan, a.ket_jaminan from jaminan_pinjaman_detail a left join 
			jenis_jaminan b on a.id_jenis_jaminan = b.id
			where a.id_header = (select id from jaminan_pinjaman_header where id_pengajuan = $id) 
			and b.is_rkp='Ya' order by a.id";
		$jam = $this->db->query($sql)->result();

		$str = '';	
		foreach ($jam as $p)
		{
			$str = $str . $p->jenis_jaminan.' : '.$p->ket_jaminan. '<br/>';
		}						
		// print_r($str);
		// die;
		$html = str_replace('[detail_jaminan]', $str, $html);
		$html = str_replace('[no_pp]', $rpt['no_pp'], $html);
		$html = str_replace('[tanggal_pp]', date('d', strtotime($rpt['tanggal_pp'])).' '.$bulan[date('m', strtotime($rpt['tanggal_pp']))].' '.date('Y', strtotime($rpt['tanggal_pp'])), $html);
		$html = str_replace('[ketua_koperasi]', $rpt['ketua_koperasi_d'], $html);
		$html = str_replace('[penerima_jaminan]', $rpt['koordinator_pinjaman_d'], $html);
		// $section->addText(htmlspecialchars(''));

		\PhpOffice\PhpWord\Shared\Html::addHtml($section, $html);
		
        $writer = new Word2007($phpWord);

        $filename = $ang['nama_anggota'].'-Tanda Terima Jaminan-'.$rpt['no_pp'];

        header('Content-Type: application/msword');
        header('Content-Disposition: attachment;filename="' . $filename . '.docx"');
        header('Cache-Control: max-age=0');

        $writer->save('php://output');
	}

	public function upload_doc_legal($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_doc_legal']    = $this->master_model->select_in('dokumen_legal', '*', "WHERE id_pengajuan = $id");

    		$this->load->view('perjanjian/upload_doc', $data);
	    }
	}


	public function input_doc_legal($menuid, $idRKP)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_doc_legal'] = $this->master_model->select_in('dokumen_legal','*',"where 1=0");

    		$this->load->view('perjanjian/input_doc_legal', $data);
	    }
	}

	public function insert_doc_legal($menuid, $idRKP)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$this->load->helper(array('form', 'url')); 
		$photo = "";
		$this->load->library('upload');
		$config['upload_path'] = './uploads/foto/'; // Sesuaikan sama folder dimana foto akan d simpan
		$config['allowed_types'] = 'pdf';
		$config['max_size'] = '2048';
		// $config['max_width']  = '1288';
		// $config['max_height']  = '768';
		
		$this->upload->initialize($config);
		  if(!$this->upload->do_upload('gambar')){
			  $photo="";
		  }else{
			  $photo=$this->upload->file_name;
		}

		$data = array(
			'id_pengajuan' => $idRKP,
			'nama_dokumen' => $this->input->post('nama_dokumen'),
			'nama_file' => $photo,
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);
		$this->db->insert('dokumen_legal', $data);
		redirect('perjanjian_pinjaman/upload_doc_legal/'.$menuid.'/'.$idRKP);
	}
	
	public function pdf($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['pdf']  = $this->pinjaman_model->pdf($id);

			$this->load->view('perjanjian/pdf',$data);			
	    }
	}

	public function delete_doc_legal($menuid, $idRKP, $ID)
	{
		$this->db->where('id', $ID);
		$this->db->delete('dokumen_legal');

		redirect('perjanjian_pinjaman/upload_doc_legal/'.$menuid.'/'.$idRKP);
	}

	public function listKabag($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_pengajuan'] = $this->pinjaman_model->pengajuanPinjamanKabag();

    		$this->load->view('perjanjian/listKabag', $data);
	    }
	}

	public function doc_legal_kabag($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_doc_legal']    = $this->master_model->select_in('dokumen_legal', '*', "WHERE id_pengajuan = $id");

    		$this->load->view('perjanjian/doc_legal_kabag', $data);
	    }
	}

	public function doc_legal_admin($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_doc_legal']    = $this->master_model->select_in('dokumen_legal', '*', "WHERE id_pengajuan = $id");

    		$this->load->view('perjanjian/doc_legal_admin', $data);
	    }
	}

	public function listAdmin($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_pengajuan'] = $this->pinjaman_model->pengajuanPinjamanAdmin();

    		$this->load->view('perjanjian/listAdmin', $data);
	    }
	}

	function memo_instruksi(){
		$id = $this->uri->segment('4');

		$sql = "select a.*, d.no_rkp, e.nama_anggota, e.no_anggota, b.nama_pengurus as ketua_koperasi_d, b.jabatan as jabatan_pengurus,
		b.alamat as alamat_pengurus, c.nama_pengurus as koordinator_pinjaman_d
		from perjanjian_pinjaman a left join pengurus_koperasi b on 
		a.ketua_koperasi=b.id left join pengurus_koperasi c on 
		a.koordinator_pinjaman=c.id left join pengajuan_pinjaman d on a.id_pengajuan=d.id
		left join anggota e on d.id_anggota=e.id 
		where a.id_pengajuan = $id";
		$rpt = $this->db->query($sql)->row_array();

		$this->load->library('pdf');
		$pdf = new FPDF('p', 'mm', 'A4');
		
		// membuat halaman baru
		$pdf->AliasNbPages();
		$pdf->AddPage();
		// setting jenis font yang akan digunakan
		
		$sql = "select a.* from config_global a ";
		$fot = $this->db->query($sql)->result();
		foreach ($fot as $f)
		{				
			$y_awal = $pdf->GetY(); 
			
			$pdf->Image('uploads/foto/'.$f->image,135,$y_awal,50,15,'JPG','');

			$pdf->SetXY(10,$y_awal+15);

			$pdf->Cell(190, 3, '', '', 1, 'C');			
		}

		$pdf->SetFont('Times', 'B', 14);
		// // $pdf->SetXY(10,4);
		$pdf->Cell(190, 6, 'MEMO INFORMASI PINJAMAN - ADM', 'LTR', 1, 'L');		
		$pdf->SetFont('Times', 'B', 10);			
		$pdf->Cell(45, 4, 'NOMOR', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['no_memo_instruksi'], 'R', 1, 'L');

		$daftar_hari = array(
			'Sunday' => 'Minggu',
			'Monday' => 'Senin',
			'Tuesday' => 'Selasa',
			'Wednesday' => 'Rabu',
			'Thursday' => 'Kamis',
			'Friday' => 'Jumat',
			'Saturday' => 'Sabtu'
		);
		$namahari = date('l', strtotime($rpt['tgl_memo_instruksi']));
		$namahari = $daftar_hari[$namahari];

		$bulan = array(
			'01' => 'Januari',
			'02' => 'Februari',
			'03' => 'Maret',
			'04' => 'April',
			'05' => 'Mei',
			'06' => 'Juni',
			'07' => 'Juli',
			'08' => 'Agustus',
			'09' => 'September',
			'10' => 'Oktober',
			'11' => 'November',
			'12' => 'Desember',
		);

		$glMemo = date('d', strtotime($rpt['tgl_memo_instruksi'])).' '.$bulan[date('m', strtotime($rpt['tgl_memo_instruksi']))].' '.date('Y', strtotime($rpt['tgl_memo_instruksi']));

		$pdf->Cell(45, 4, 'HARI/TANGGAL', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $namahari.', '.$glMemo, 'R', 1, 'L');

		$pdf->Cell(45, 4, 'KEPADA', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['kpd_memo_instruksi'], 'R', 1, 'L');

		$pdf->Cell(45, 4, 'DARI', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, $rpt['dari_memo_instruksi'], 'R', 1, 'L');

		$pdf->Cell(45, 4, 'PERIHAL', 'L', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(140, 4, 'Pencairan Pinjaman', 'R', 1, 'L');
		
		$pdf->SetFont('Times', '', 10);
		$pdf->Cell(190, 5, '', 'LRT', 1, 'C');				

		$sql = "select a.*, b.tipe_pinjaman, b.keterangan as ket_tipe, c.perhitungan_bunga 
		From fasilitas_pinjaman a left join tipe_pinjaman b on a.id_jenis_pinjaman=b.id
		left join perhitungan_bunga c on a.id_perhitungan_bunga = c.id
		where a.id_pengajuan = $id order by a.id";
		$fas = $this->db->query($sql)->row_array();

		$GLOBALS['rkp'] = '';

		$prov = $fas['plafond_akhir'] * ($fas['provisi']/100);
		$komi = $fas['plafond_akhir'] * ($fas['komisi']/100);
		$sql = "select sum(nominal) as biaya_pp From biaya_pp where id_pengajuan = $id";
		$pp = $this->db->query($sql)->row_array();
		$biaya = $prov+$komi+$pp['biaya_pp'];
	
		$text1 = 'Konfirmasi Pencairan '.$fas['tipe_pinjaman'].' '.$fas['perhitungan_bunga']. ' sebesar '.'Rp. '.number_format($fas['plafond_akhir'],0).',-';
		$text1 = $text1 . ' selama '.number_format($fas['jangka_waktu'],0).' bulan, an. '.$rpt['nama_anggota'].' pada tanggal '.$glMemo;
		$text1 = $text1 . ' dengan biaya sebesar Rp. '. number_format($biaya,0) . ' dengan rincian sebagai berikut :';

		$y_awal=$pdf->GetY(); // ini ...
		$pdf->SetXY(15,$y_awal);
		$pdf->MultiCell(185, 4, $text1, 'R', 'J', false);	
		$y_akhir=$pdf->GetY(); // dan ini dipake buat perhitungan tinggi baris yg lain		
		$tinggi=$y_akhir-$y_awal;

		$pdf->SetXY(10,$y_awal);
		$pdf->MultiCell(5, $tinggi, '1', 'L', 'J', false);	

		$pdf->Cell(190, 2, '', 'LR', 1, 'L');

		$pdf->Cell(5, 4, '', 'L', 0, 'L');
		$pdf->Cell(100, 4, 'Plafon:', '', 0, 'L');
		$pdf->Cell(5, 4, 'Rp', 0, 0, 'L');
		$pdf->Cell(35, 4, number_format($fas['plafond_akhir'],0), '', 0, 'R');
		$pdf->Cell(45, 4, '', 'R', 1, 'R');
	
		$pdf->Cell(5, 4, '', 'L', 0, 'L');
		$pdf->Cell(145, 4, 'Biaya Pencairan Pinjaman:', '', 0, 'L');
		$pdf->Cell(5, 4, '', 0, 0, 'L');
		$pdf->Cell(35, 4, '', 'R', 1, 'R');

		$sql = "select a.* from fasilitas_pinjaman a where a.id_pengajuan = $id";
		$fas = $this->db->query($sql)->row_array();

		$pdf->SetFont('Times', '', 10);

		$pdf->Cell(5, 4, '', 'L', 0, 'L');
		$pdf->Cell(100, 4, '1. Provisi ('.$fas['provisi'].' %)', '', 0, 'L');
		$pdf->Cell(5, 4, 'Rp', 0, 0, 'L');
		$pdf->Cell(35, 4, number_format($fas['plafond_akhir'] * ($fas['provisi']/100),0), '', 0, 'R');
		$pdf->Cell(45, 4, '', 'R', 1, 'R');

		$pdf->Cell(5, 4, '', 'L', 0, 'L');
		$pdf->Cell(100, 4, '2. Biaya Administrasi ('.$fas['komisi'].' %)', '', 0, 'L');
		$pdf->Cell(5, 4, 'Rp', 0, 0, 'L');
		$pdf->Cell(35, 4, number_format($fas['plafond_akhir'] * ($fas['komisi']/100),0), '', 0, 'R');
		$pdf->Cell(45, 4, '', 'R', 1, 'R');

		$sql = "select concat(b.jenis_biaya_pp,' ',a.keterangan) as ket, a.nominal From biaya_pp a left join mst_biaya_pp b 
			on a.jenis_biaya_pp=b.id where a.id_pengajuan = $id";
		$jam = $this->db->query($sql)->result();

		$provisi = $fas['plafond_akhir'] * ($fas['provisi'] / 100);
		$komisi = $fas['plafond_akhir'] * ($fas['komisi'] / 100);

		$i=3; $total=$provisi+$komisi;
		foreach ($jam as $p)
		{
			$pdf->Cell(5, 4, '', 'L', 0, 'L');
			$pdf->Cell(100, 4, $i.'. '.$p->ket, '', 0, 'L');
			$pdf->Cell(5, 4, 'Rp', 0, 0, 'L');
			$pdf->Cell(35, 4, number_format($p->nominal), '', 0, 'R');
			$pdf->Cell(45, 4, '', 'R', 1, 'R');

			$i++;
			$total = $total + $p->nominal;
		}

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(105, 4, '', 'L', 0, 'L');
		$pdf->Cell(5, 4, 'Rp', 0, 0, 'L');
		$pdf->Cell(35, 4, number_format($total,0), 'T', 0, 'R');
		$pdf->Cell(45, 4, '', 'R', 1, 'R');
		
		$pdf->Cell(190, 2, '', 'LR', 1, 'L');

		$pdf->SetFont('Times', '', 10);
		
		$text2 = 'Konfirmasi Pencairan Pinjaman dicairkan ke Rek. Simpanan harian an. '.$rpt['nama_anggota']. ' sebesar '.'Rp. '.number_format($fas['plafond_akhir'],0).',-';
		$text2 = $text2 . ' pada tanggal '.$glMemo.'.';

		$y_awal=$pdf->GetY(); // ini ...
		$pdf->SetXY(15,$y_awal);
		$pdf->MultiCell(185, 4, $text2, 'R', 'J', false);	
		$y_akhir=$pdf->GetY(); // dan ini dipake buat perhitungan tinggi baris yg lain		
		$tinggi=$y_akhir-$y_awal;

		$pdf->SetXY(10,$y_awal);
		$pdf->MultiCell(5, $tinggi, '2', 'L', 'J', false);	

		$pdf->Cell(190, 2, '', 'LR', 1, 'L');
		
		$text3 = 'Pencairan Pinjaman sebesar Rp. '.number_format($fas['plafond_akhir'] - $total,0). ' akan dicairkan melalui tarik tunai cek ';
		$text3 = $text3 . ' pada tanggal '.$glMemo.' dan disetor melalui transfer dengan rincian sebagai berikut :';

		$y_awal=$pdf->GetY(); // ini ...
		$pdf->SetXY(15,$y_awal);
		$pdf->MultiCell(185, 4, $text3, 'R', 'J', false);	
		$y_akhir=$pdf->GetY(); // dan ini dipake buat perhitungan tinggi baris yg lain		
		$tinggi=$y_akhir-$y_awal;

		$pdf->SetXY(10,$y_awal);
		$pdf->MultiCell(5, $tinggi, '3', 'L', 'J', false);	

		$pdf->Cell(190, 2, '', 'LR', 1, 'L');

		$pdf->Cell(6, 4, '', 'L', 0, 'L');
		$pdf->Cell(30, 4, 'No. Rek. Tujuan', 'LRTB', 0, 'C');
		$pdf->Cell(45, 4, 'Atas Nama', 'LRTB', 0, 'C');
		$pdf->Cell(35, 4, 'Nominal', 'LRTB', 0, 'C');
		$pdf->Cell(68, 4, 'Terbilang', 'LRTB', 0, 'C');
		$pdf->Cell(6, 4, '', 'R', 1, 'L');

		$terbilang = ucwords($this->terbilang($fas['plafond_akhir']- $total)). ' Rupiah';

		$y_awal=$pdf->GetY(); // ini ...
		$pdf->SetXY(126,$y_awal);
		$pdf->MultiCell(68, 4, $terbilang, 'RB', 'C', false);
		$y_akhir=$pdf->GetY(); // dan ini dipake buat perhitungan tinggi baris yg lain		
		$tinggi=$y_akhir-$y_awal;

		$pdf->SetXY(10,$y_awal);
		$pdf->Cell(6, $tinggi, '', 'L', 0, 'C');		
		$pdf->Cell(30, $tinggi, $rpt['no_rek_cair'], 'LB', 0, 'C');

		$y_awal=$pdf->GetY(); // ini ...
		$pdf->SetXY(46,$y_awal);
		$pdf->MultiCell(45, $tinggi, $rpt['nm_rek_cair'], 'LBR', 'C', false);

		$pdf->SetXY(91,$y_awal);
		$pdf->MultiCell(35, $tinggi, 'Rp. '.number_format($fas['plafond_akhir'] - $total,0).',-', 'LBR', 'C', false);

		$pdf->SetXY(194,$y_awal);
		$pdf->Cell(6, $tinggi, '', 'R', 1, 'C');


		$pdf->Cell(190, 4, '', 'LR', 1, 'C');
		
		$pdf->Cell(190, 4, 'Note :', 'LR', 1, 'L');
		$pdf->MultiCell(190, 4, $rpt['notes_memo_instruksi'], 'LR', 'C', false);

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(64, 5, 'DIBUAT OLEH:', 'LRT', 0, 'C');
		$pdf->Cell(63, 5, 'DIPERIKSA OLEH:', 'RT', 0, 'C');
		$pdf->Cell(63, 5, 'MENYETUJUI:', 'RT', 1, 'C');

		$pdf->Cell(64, 20, '', 'LRT', 0, 'C');
		$pdf->Cell(63, 20, '', 'RT', 0, 'C');
		$pdf->Cell(63, 20, '', 'RT', 1, 'C');

		$pdf->SetFont('Times', 'B', 10);
		$pdf->Cell(190, 5, 'TELAH DITINDAKLANJUT', 'LRTB', 1, 'L');

		$pdf->Cell(150, 20, '', 'BL', 0, 'L');
		$pdf->Cell(5, 20, '', 'B', 0, 'L');
		$pdf->Cell(35, 20, '', 'BR', 1, 'R');

		$pdf->Output();
	}
}
?>