<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class transaksi_pemakaian extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('transaksi_model');
	}

	public function pemakaian($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_header']   = $this->master_model->select_in('trpemakaian_header','*',"WHERE 1 = 0");

			$this->load->view('pemakaian/header', $data);
	    }
	}


	public function pemakaian2($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
		$date1 = $this->input->post('from_date');
		$date2 = $this->input->post('to_date');

		if (empty($date1)){
			$date1 = $this->session->userdata('date1');
			$date2 = $this->session->userdata('date2');
		}

		$sql="delete from trpemakaian_header where id not in (select id_header from trpemakaian_detail);";
		$qry = $this->db->query($sql);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_header']   = $this->transaksi_model->listPakaiHeader($date1, $date2);

			$this->load->view('pemakaian/header2', $data);
	    }
	}

	public function insert_pemakaian($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$data = array(
			'id_kantor' => $this->input->post('id_kantor'),
			'tanggal_pakai' => $this->input->post('tanggal_beli'),
			'keterangan' => $this->input->post('keterangan'),
			'created_at' => date('Y-m-d H:i:s'),
			'created_by' => $user_id1
		);	

		$this->db->insert('trpemakaian_header', $data);
		
		$data_journal=$this->transaksi_model->getPakaiHeaderID();
		$jID = $data_journal[0]->last_id;	
		
		redirect('transaksi_pemakaian/pakai_detail/'.$menuid.'/'.$jID);

	}


	public function insert_pakai_detail($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$jID = 	$this->input->post('id_header');
		$idBarang = $this->input->post('id_persediaan');
		$jml = $this->input->post('jumlah');
		$kantor = $this->input->post('id_kantor');

		$cekStok = $this->master_model->select_in('viewStok','*',"where id_kantor = $kantor and id = $idBarang");
		if ($cekStok[0]->stok_akhir < $jml){
			echo '<script language="javascript">alert("'.$cekStok[0]->nama_barang.' - Stok Tidak Mencukupi!");window.history.go(-1);</script>';
			exit();
		}else{
			$data = array(
				'id_header' => $this->input->post('id_header'),
				'id_persediaan' => $this->input->post('id_persediaan'),
				'jumlah' => $this->input->post('jumlah'),
				'keterangan' => $this->input->post('keterangan'),
				'created_at' => date('Y-m-d H:i:s'),
				'created_by' => $user_id1
			);	
			$this->db->insert('trpemakaian_detail', $data);
	
			redirect('transaksi_pemakaian/pakai_detail/'.$menuid.'/'.$jID);
		}
	}

	public function pakai_detail($menuid, $jID)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_detail']   = $this->transaksi_model->ListPakaiDetail($jID);

			$this->load->view('pemakaian/detail', $data);
	    }
	}

	function delete_pakai_detail($menuid, $id)
	{
		$header = $this->master_model->mst_edit_dr('trpemakaian_detail',$id);
		$jID = $header[0]->id_header;

		$this->db->where('id',$id);
		$this->db->delete('trpemakaian_detail');
		
		redirect('transaksi_pemakaian/pakai_detail/'.$menuid.'/'.$jID);		
	}

	public function edit_pakai_detail($menuid)
	{
		$id= $this->input->post('id');

		$submit = $this->input->post('submit');
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		$admin = $this->session->userdata('username');

		$jID = $this->input->post('id_header');
		$idBarang = $this->input->post('id_persediaan');
		$jml = $this->input->post('jumlah');
		$kantor = $this->input->post('id_kantor');
		$temp = $this->input->post('temp_jumlah');

		$cekStok = $this->master_model->select_in('viewStok','*',"where id_kantor = $kantor and id = $idBarang");
		if ($cekStok[0]->stok_akhir + $temp - $jml < 0){
			echo '<script language="javascript">alert("'.$cekStok[0]->nama_barang.' - Stok Tidak Mencukupi!");window.history.go(-1);</script>';
			exit();
		}else{

			$data = array
			(		
				'id_persediaan' => $this->input->post('id_persediaan'),
				'jumlah' => $this->input->post('jumlah'),
				'keterangan' => $this->input->post('keterangan'),
				'updated_at' => date('Y-m-d H:i:s'),
				'updated_by' => $user_id1			
			);
			$this->db->where('id', $id);
			$this->db->update('trpemakaian_detail', $data);

			if($submit==1)
			{
				redirect('transaksi_pemakaian/pakai_detail/'.$menuid.'/'.$jID);
			}
		}
	}	

	function delete_pemakaian($menuid, $id)
	{
		$this->db->where('id',$id);
		$this->db->delete('trpemakaian_header');

		$this->db->where('id_header',$id);
		$this->db->delete('trpemakaian_detail');
		
		redirect('transaksi_pemakaian/pemakaian2/'.$menuid);		
	}

	public function edit_pakai_header($menuid)
	{
		$submit = $this->input->post('submit');
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		$admin = $this->session->userdata('username');

		$jID = $this->input->post('id_header');

		$data = array
		(		
			'id_kantor' => $this->input->post('id_kantor'),
			'tanggal_pakai' => $this->input->post('tanggal_beli'),
			'keterangan' => $this->input->post('keterangan'),
			'updated_at' => date('Y-m-d H:i:s'),
			'updated_by' => $user_id1			
		);
		$this->db->where('id', $jID);
		$this->db->update('trpemakaian_header', $data);

		if($submit==1)
		{
			redirect('transaksi_pemakaian/pakai_detail/'.$menuid.'/'.$jID);
	  }
	}	

	function print_cd(){
		$voucher = substr($this->uri->uri_string(3),28);

		$sql = "select a.*, b.coa_code, b.coa_name, c.journal_date, c.journal_voucher, c.journal_desc
			FROM acc_journal_detail a left join acc_coa b on a.coa_id=b.id
			left join acc_journal c on a.journal_id=c.id where c.journal_type = 'CD'
			and c.journal_voucher = '$voucher' order by a.journal_id, a.id";

		$rpt = $this->db->query($sql)->row_array();

		$this->load->library('pdf');
		$pdf = new FPDF('l', 'mm', 'A5');
		// membuat halaman baru
		$pdf->AddPage();
		// setting jenis font yang akan digunakan
		$pdf->SetFont('Arial', 'B', 11);
		$pdf->Cell(80, 12, 'Journal Voucher', 0, 1, 'l');

		$pdf->SetFont('Arial', '', 11);
		$pdf->Cell(30, 5, 'Date', 0, 0, 'l');
		$pdf->Cell(10, 5, ': ', 0, 0, 'l');
		$pdf->Cell(30, 5, date('F d Y', strtotime($rpt['journal_date'])), 0, 1, 'l');			
		$pdf->Cell(30, 5, 'Voucher #', 0, 0, 'l');
		$pdf->Cell(10, 5, ': ', 0, 0, 'l');
		$pdf->Cell(30, 5, $rpt['journal_voucher'], 0, 1, 'l');
		$pdf->Cell(30, 5, 'Memo', 0, 0, 'l');
		$pdf->Cell(10, 5, ': ', 0, 0, 'l');
		$pdf->Cell(30, 5, $rpt['journal_desc'], 0, 1, 'l');
		$pdf->Cell(10, 5, ' ', 0, 1, 'l');

		$pdf->SetFont('Arial', 'B', 10);
		// tabel detail
		$pdf->Cell(20, 5, 'Code ', 1, 0, 'C');
		$pdf->Cell(60, 5, 'Account Name ', 1, 0, 'C');
		$pdf->Cell(30, 5, 'Debit', 1, 0, 'C');
		$pdf->Cell(30, 5, 'Credit', 1, 0, 'C');
		$pdf->Cell(50, 5, 'Memo', 1, 1, 'C');

		$pdf->SetFont('Arial', '', 9);
		$jurnal = $this->db->query($sql)->result();
		foreach ($jurnal as $p){
		   $pdf->Cell(20, 6, $p->coa_code, 1, 0, 'L');
		   $pdf->Cell(60, 6, $p->coa_name, 1, 0, 'L');
		   $pdf->Cell(30, 6, number_format($p->debet_value,2), 1, 0, 'R');
		   $pdf->Cell(30, 6, number_format($p->credit_value,2), 1, 0, 'R');
		   $pdf->Cell(50, 6, $p->detail_desc, 1, 1, 'L');
	   		   
	    }
		
		$pdf->Output();
	}

	public function getHargaBeli()
	{	
		$idPersediaan = $_GET['id'];
				
		$harga = $this->master_model->select_in('mspersediaan','*',"where id = $idPersediaan");

		$data_harga = array('harga_beli'   =>  $harga[0]->harga_beli);
		echo json_encode($data_harga);
		
	}

	
}
?>
