<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class transaksi_pengajuan extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('transaksi_model');
	}

	public function memo_pengajuan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pengajuan']   = $this->master_model->select_in('trx_pengajuan_header','*',"WHERE 1 = 0");

			$this->load->view('memo_pengajuan/header', $data);
	    }
	}

	
	public function insert_pengajuan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$data = array(			
			'tgl_pengajuan' => $this->input->post('tgl_pengajuan'),
			'kepada' => $this->input->post('kepada'),
			'pemohon' => $this->input->post('pemohon'),
			'id_vendor' => $this->input->post('id_vendor'),
			'catatan' => $this->input->post('catatan'),			
			'diajukan' => $this->input->post('diajukan'),			
			'direkomendasi' => $this->input->post('direkomendasi'),			
			'disetujui' => $this->input->post('disetujui'),	
			'ditindaklanjut' => $this->input->post('ditindaklanjut'),	
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('trx_pengajuan_header', $data);
		
		$data_header=$this->transaksi_model->getPengajuanID();
		$pID = $data_header[0]->last_id;
		
		$data = array(			
			'id_pengajuan' => $pID,
			'tgl_memo' => '',
			'kepada' => 0,
			'dari' => 0,
			'catatan' => '',
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('trx_memo_informasi', $data);

		redirect('transaksi_pengajuan/memo_pengajuan_detail/'.$menuid.'/'.$pID);

	}

	public function memo_pengajuan_detail($menuid, $idPengajuan)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pengajuan_detail']   = $this->transaksi_model->pengajuanDetail($idPengajuan);

			$this->load->view('memo_pengajuan/detail', $data);
	    }
	}

	public function insert_pengajuan_detail($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$pID = 	$this->input->post('id_pengajuan');

		$data = array(
			'id_pengajuan' => $this->input->post('id_pengajuan'),
			'id_barang' => $this->input->post('id_barang'),
			'pengguna' => $this->input->post('pengguna'),
			'jumlah' => $this->input->post('jumlah'),
			'harga_satuan' => $this->input->post('harga_satuan'),
			'total' => $this->input->post('jumlah') * $this->input->post('harga_satuan'),			
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	
		$this->db->insert('trx_pengajuan_detail', $data);

		redirect('transaksi_pengajuan/memo_pengajuan_detail/'.$menuid.'/'.$pID);
	}

	public function update_pengajuan_detail($menuid)
	{
		$id= $this->input->post('id');
		$pID = 	$this->input->post('id_pengajuan');

		$submit = $this->input->post('submit');
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		$admin = $this->session->userdata('username');

		$data = array
		(		
			'id_pengajuan' => $this->input->post('id_pengajuan'),
			// 'id_barang' => $this->input->post('id_barang'),
			'pengguna' => $this->input->post('pengguna'),
			'jumlah' => $this->input->post('jumlah'),
			'harga_satuan' => $this->input->post('harga_satuan'),
			'total' => $this->input->post('jumlah') * $this->input->post('harga_satuan'),			
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1			
		);
		$this->db->where('id', $id);
		$this->db->update('trx_pengajuan_detail', $data);

		if($submit==1)
		{
			redirect('transaksi_pengajuan/memo_pengajuan_detail/'.$menuid.'/'.$pID);
	  }
	}	

	function delete_pengajuan_detail($menuid, $id, $pID)
	{
		$this->db->where('id',$id);
		$this->db->delete('trx_pengajuan_detail');
		
		redirect('transaksi_pengajuan/memo_pengajuan_detail/'.$menuid.'/'.$pID);
	}

	public function daftar_memo_pengajuan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pengajuan']   = $this->master_model->select_in('trx_pengajuan_header','*',"WHERE 1 = 0");

			$this->load->view('memo_pengajuan/list', $data);
	    }
	}

	public function daftar_memo_pengajuan2($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
		$tgl1 = $this->input->post('tgl1');
		$tgl2 = $this->input->post('tgl2');

		if (empty($tgl1)){
			$tgl1 = $this->session->userdata('date1');
			$tgl2 = $this->session->userdata('date2');
		}

		$this->session->set_userdata('date1', $tgl1);
		$this->session->set_userdata('date2', $tgl2);
		
		if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pengajuan']   = $this->transaksi_model->daftarPengajuan($tgl1, $tgl2);

			$this->load->view('memo_pengajuan/list2', $data);
	    }
	}

	public function barang_masuk_excel($menuid, $tgl1, $tgl2)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
		
		if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pengajuan']   = $this->transaksi_model->daftarPengajuanExcel($tgl1, $tgl2);

			$this->load->view('memo_pengajuan/list2excel', $data);
	    }
	}

	public function update_memo_pengajuan($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pengajuan']   = $this->master_model->select_in('trx_pengajuan_header','*',"WHERE id = $id");

			$this->load->view('memo_pengajuan/header_update', $data);
	    }
	}

	public function update_pengajuan($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$data = array
		(		
			'tgl_pengajuan' => $this->input->post('tgl_pengajuan'),
			'kepada' => $this->input->post('kepada'),
			'pemohon' => $this->input->post('pemohon'),
			'id_vendor' => $this->input->post('id_vendor'),
			'catatan' => $this->input->post('catatan'),	
			'diajukan' => $this->input->post('diajukan'),			
			'direkomendasi' => $this->input->post('direkomendasi'),			
			'disetujui' => $this->input->post('disetujui'),	
			'ditindaklanjut' => $this->input->post('ditindaklanjut'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1			
		);
		$this->db->where('id', $id);
		$this->db->update('trx_pengajuan_header', $data);

		redirect('transaksi_pengajuan/memo_pengajuan_detail/'.$menuid.'/'.$id);	  
	}	

	public function update_penerimaan($menuid)
	{
		$id= $this->input->post('id');		
		$tgl1 = $this->input->post('tgl1');
		$tgl2 = $this->input->post('tgl2');
		
		$submit = $this->input->post('submit');
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		$admin = $this->session->userdata('username');

		$data = array
		(		
			'status_diterima' => $this->input->post('status_diterima'),
			'jumlah_diterima' => $this->input->post('jumlah_diterima'),
			'tgl_diterima' => $this->input->post('tgl_diterima'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1			
		);
		$this->db->where('id', $id);
		$this->db->update('trx_pengajuan_detail', $data);

		if($submit==1)
		{
			redirect('transaksi_pengajuan/daftar_memo_pengajuan2/'.$menuid);
	  }
	}	

	
	public function getHargaBeli()
	{	
		$idPersediaan = $_GET['id'];
				
		$harga = $this->master_model->select_in('mspersediaan','*',"where id = $idPersediaan");

		$data_harga = array('harga_beli'   =>  $harga[0]->harga_beli);
		echo json_encode($data_harga);
		
	}

	public function getStok()
	{	
		$idPersediaan = $_GET['id'];
		$kantor = $_GET['kantor'];
				
		$stok = $this->master_model->select_in('viewStok','*',"where id = $idPersediaan and id_kantor = $kantor");

		$data_stok = array('stok_akhir'   =>  $stok[0]->stok_akhir);
		echo json_encode($data_stok);
		
	}

	public function siapkan_memo_informasi($menuid, $id_pengajuan)
	{
		$tgl1 = $this->input->post('tgl1');
		$tgl2 = $this->input->post('tgl2');
		
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;		
		
		$data = array
		(		
			'memo_siap' => 1,
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1			
		);
		$this->db->where('id', $id_pengajuan);
		$this->db->update('trx_pengajuan_header', $data);

		$gabung = $this->transaksi_model->gabungBarang($id_pengajuan);

		$data = array
		(		
			'catatan' => $gabung[0]->gabung_barang,
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1			
		);
		$this->db->where('id_pengajuan', $id_pengajuan);
		$this->db->update('trx_memo_informasi', $data);

		redirect('transaksi_pengajuan/daftar_memo_pengajuan2/'.$menuid);

	}	

	public function memo_informasi($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pengajuan']   = $this->master_model->select_in('trx_pengajuan_header','*',"WHERE 1=0");

			$this->load->view('memo_informasi/list', $data);
	    }
	}

	public function memo_informasi2($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
		$tgl1 = $this->input->post('tgl1');
		$tgl2 = $this->input->post('tgl2');

		if (empty($tgl1)){
			$tgl1 = $this->session->userdata('date1');
			$tgl2 = $this->session->userdata('date2');
		}

		$this->session->set_userdata('date1', $tgl1);
		$this->session->set_userdata('date2', $tgl2);
		
		if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_pengajuan']   = $this->transaksi_model->daftarInformasi($tgl1, $tgl2);

			$this->load->view('memo_informasi/list2', $data);
	    }
	}

	public function update_memo_informasi($menuid)
	{
		$id_pengajuan= $this->input->post('id');		
		$id_memo= $this->input->post('idm');
		$tgl1 = $this->input->post('tgl1');
		$tgl2 = $this->input->post('tgl2');
		
		$submit = $this->input->post('submit');
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		$admin = $this->session->userdata('username');

		$data = array
		(		
			'tgl_memo' => $this->input->post('tgl_memo'),
			'kepada' => $this->input->post('kepada'),
			'dari' => $this->input->post('dari'),
			'catatan' => $this->input->post('catatan'),
			'diajukan' => $this->input->post('diajukan'),
			'diperiksa' => $this->input->post('diperiksa'),
			'disetujui1' => $this->input->post('disetujui1'),
			'disetujui2' => $this->input->post('disetujui2'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1			
		);
		$this->db->where('id', $id_memo);
		$this->db->update('trx_memo_informasi', $data);

		if($submit==1)
		{
			redirect('transaksi_pengajuan/memo_informasi2/'.$menuid);
	  }
	}		

	function penyebut($nilai) {
		$nilai = abs($nilai);
		$huruf = array("", "satu", "dua", "tiga", "empat", "lima", "enam", "tujuh", "delapan", "sembilan", "sepuluh", "sebelas");
		$temp = "";
		if ($nilai < 12) {
			$temp = " ". $huruf[$nilai];
		} else if ($nilai <20) {
			$temp = $this->penyebut($nilai - 10). " belas";
		} else if ($nilai < 100) {
			$temp = $this->penyebut($nilai/10)." puluh". $this->penyebut($nilai % 10);
		} else if ($nilai < 200) {
			$temp = " seratus" . $this->penyebut($nilai - 100);
		} else if ($nilai < 1000) {
			$temp = $this->penyebut($nilai/100) . " ratus" . $this->penyebut($nilai % 100);
		} else if ($nilai < 2000) {
			$temp = " seribu" . $this->penyebut($nilai - 1000);
		} else if ($nilai < 1000000) {
			$temp = $this->penyebut($nilai/1000) . " ribu" . $this->penyebut($nilai % 1000);
		} else if ($nilai < 1000000000) {
			$temp = $this->penyebut($nilai/1000000) . " juta" . $this->penyebut($nilai % 1000000);
		} else if ($nilai < 1000000000000) {
			$temp = $this->penyebut($nilai/1000000000) . " milyar" . $this->penyebut(fmod($nilai,1000000000));
		} else if ($nilai < 1000000000000000) {
			$temp = $this->penyebut($nilai/1000000000000) . " trilyun" . $this->penyebut(fmod($nilai,1000000000000));
		}     
		return $temp;
	}
	
	function terbilang($nilai) {
		if($nilai<0) {
			$hasil = "minus ". trim($this->penyebut($nilai));
		} else {
			$hasil = trim($this->penyebut($nilai));
		}     		
		return $hasil;
	}

	function print_memo_pengajuan(){
		$id = $this->uri->segment('4');

		$sql = "select a.*, b.tgl_pengajuan, c.nama_barang, d.nama_vendor, b.catatan,
		e.divisi as kepada_memo, f.divisi as pemohon_memo, g.pengurus as diajukan, 
		h.pengurus as direkomendasi, i.pengurus as disetujui, j.pengurus as ditindaklanjut
		from trx_pengajuan_detail a left join trx_pengajuan_header b 
		on a.id_pengajuan=b.id left join mst_barang c
		on a.id_barang=c.id left join mst_vendor d
		on b.id_vendor=d.id left join mst_divisi e
		on b.kepada=e.id left join mst_divisi f
		on b.pemohon=f.id left join mst_pengurus g
		on b.diajukan=g.id left join mst_pengurus h
		on b.direkomendasi=h.id left join mst_pengurus i
		on b.disetujui=i.id left join mst_pengurus j
		on b.ditindaklanjut=j.id
		where a.id_pengajuan = $id order by a.id";
		$rpt = $this->db->query($sql)->row_array();
		$det = $this->db->query($sql)->result();

		$this->load->library('pdf');
		$pdf = new FPDF('p', 'mm', 'A4');
		
		// membuat halaman baru
		$pdf->AliasNbPages();
		$pdf->AddPage();
		// setting jenis font yang akan digunakan
		
		$pdf->Cell(190, 3, '', 'LTR', 1, 'L');	
		$pdf->SetFont('Times', 'B', 14);
		// // $pdf->SetXY(10,4);
		$pdf->Cell(5, 6, '', 'L', 0, 'C');
		$pdf->Cell(180, 6, 'MEMO PENGAJUAN', '', 0, 'L');		
		$pdf->SetFont('Times', '', 10);	
		$pdf->Cell(5, 6, '', 'R', 1, 'C');		

		$daftar_hari = array(
			'Sunday' => 'Minggu',
			'Monday' => 'Senin',
			'Tuesday' => 'Selasa',
			'Wednesday' => 'Rabu',
			'Thursday' => 'Kamis',
			'Friday' => 'Jumat',
			'Saturday' => 'Sabtu'
		);
		$namahari = date('l', strtotime($rpt['tgl_pengajuan']));
		$namahari = $daftar_hari[$namahari];

		$bulan = array(
			'01' => 'Januari',
			'02' => 'Februari',
			'03' => 'Maret',
			'04' => 'April',
			'05' => 'Mei',
			'06' => 'Juni',
			'07' => 'Juli',
			'08' => 'Agustus',
			'09' => 'September',
			'10' => 'Oktober',
			'11' => 'November',
			'12' => 'Desember',
		);

		$glMemo = date('d', strtotime($rpt['tgl_pengajuan'])).' '.$bulan[date('m', strtotime($rpt['tgl_pengajuan']))].' '.date('Y', strtotime($rpt['tgl_pengajuan']));

		$pdf->Cell(5, 4, '', 'L', 0, 'C');
		$pdf->Cell(40, 4, 'Hari/Tanggal', '', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(135, 4, $namahari.', '.$glMemo, '', 0, 'L');
		$pdf->Cell(5, 4, '', 'R', 1, 'C');

		$pdf->Cell(190, 2, '', 'LR', 1, 'L');

		$pdf->Cell(5, 4, '', 'L', 0, 'C');
		$pdf->Cell(40, 4, 'Kepada', '', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(135, 4, $rpt['kepada_memo'], '', 0, 'L');
		$pdf->Cell(5, 4, '', 'R', 1, 'C');

		$pdf->Cell(5, 4, '', 'L', 0, 'C');
		$pdf->Cell(40, 4, 'Pemohon', '', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(135, 4, $rpt['pemohon_memo'], '', 0, 'L');
		$pdf->Cell(5, 4, '', 'R', 1, 'C');

		$sql = "select a.* from config_global a ";
		$fot = $this->db->query($sql)->result();
		foreach ($fot as $f)
		{				
			$y_awal = 15; 
			
			$pdf->Image('uploads/foto/'.$f->image,135,$y_awal,50,15,'JPG','');

			$pdf->SetXY(10,$y_awal+15);

			$pdf->Cell(190, 3, '', '', 1, 'C');			
		}
		$GLOBALS['rkp'] = '';
		
		$pdf->Cell(190, 3, '', 'LRB', 1, 'L');
		$pdf->Cell(190, 3, '', 'LR', 1, 'L');
		
		$pdf->Cell(5, 6, '', 'L', 0, 'C');
		$pdf->Cell(180, 3, 'Penjual : '.$rpt['nama_vendor'], '', 0, 'L');
		$pdf->Cell(5, 6, '', 'R', 1, 'C');
		
		$pdf->SetFont('Times', '', 9);

		$pdf->Cell(5, 6, '', 'L', 0, 'C');
		$pdf->Cell(10, 6, 'No', 'LRBT', 0, 'C');
		$pdf->Cell(75, 6, 'Nama Barang', 'RBT', 0, 'C');
		$pdf->Cell(35, 6, 'Pengguna', 'RBT', 0, 'C');
		$pdf->Cell(15, 6, 'Jumlah', 'RBT', 0, 'C');
		$pdf->Cell(20, 6, 'Harga', 'RBT', 0, 'C');
		$pdf->Cell(25, 6, 'Total', 'RBT', 0, 'C');
		
		$pdf->Cell(5, 6, '', 'R', 1, 'C');

		$a=1; $total=0;
		foreach ($det as $p)
		{
			$pdf->Cell(5, 6, '', 'L', 0, 'C');
			$pdf->Cell(10, 6, $a, 'LRB', 0, 'C');
			$pdf->Cell(75, 6, $p->nama_barang, 'RB', 0, 'L');
			$pdf->Cell(35, 6, $p->pengguna, 'RB', 0, 'C');
			$pdf->Cell(15, 6, $p->jumlah_diterima, 'RB', 0, 'C');
			$pdf->Cell(20, 6, 'Rp. '.number_format($p->harga_satuan,0), 'RB', 0, 'C');
			$pdf->Cell(25, 6, 'Rp. '.number_format(($p->jumlah_diterima * $p->harga_satuan),0), 'RB', 0, 'C');
			
			$pdf->Cell(5, 6, '', 'R', 1, 'C');

			$a=$a+1;
			$total=$total+($p->jumlah_diterima * $p->harga_satuan);
		}

		$pdf->Cell(5, 6, '', 'L', 0, 'C');
		$pdf->Cell(10, 6, '', 'LB', 0, 'C');
		$pdf->Cell(145, 6, 'Total', 'RB', 0, 'R');
		$pdf->Cell(25, 6, 'Rp. '.number_format(($total),0), 'RB', 0, 'C');
		
		$pdf->Cell(5, 6, '', 'R', 1, 'C');

		$pdf->Cell(5, 6, '', 'L', 0, 'C');
		$pdf->Cell(180, 6, 'Catatan : ', '', 0, 'L');
		$pdf->Cell(5, 4, '', 'R', 1, 'C');

		$pdf->Cell(5, 6, '', 'L', 0, 'C');
		$pdf->Cell(180, 6, $rpt['catatan'], '', 0, 'L');
		$pdf->Cell(5, 6, '', 'R', 1, 'C');

		$pdf->Cell(190, 4, '', 'LR', 1, 'L');

		$pdf->SetFont('Times', '', 10);
		$pdf->Cell(5, 6, '', 'L', 0, 'C');
		$pdf->Cell(40, 6, 'Diajukan Oleh', 'LRBT', 0, 'C');
		$pdf->Cell(50, 6, 'Direkomendasikan Oleh', 'RBT', 0, 'C');
		$pdf->Cell(45, 6, 'Disetujui Oleh', 'RBT', 0, 'C');
		$pdf->Cell(45, 6, 'Ditindak lanjut Oleh', 'RBT', 0, 'C');
		$pdf->Cell(5, 6, '', 'R', 1, 'C');

		$pdf->Cell(5, 15, '', 'L', 0, 'C');
		$pdf->Cell(40, 15, '', 'LRB', 0, 'C');
		$pdf->Cell(50, 15, '', 'RB', 0, 'C');
		$pdf->Cell(45, 15, '', 'RB', 0, 'C');
		$pdf->Cell(45, 15, '', 'RB', 0, 'C');
		$pdf->Cell(5, 15, '', 'R', 1, 'C');
		
		$pdf->Cell(5, 6, '', 'L', 0, 'C');
		$pdf->Cell(40, 6, $rpt['diajukan'], 'LRBT', 0, 'C');
		$pdf->Cell(50, 6, $rpt['direkomendasi'], 'RBT', 0, 'C');
		$pdf->Cell(45, 6, $rpt['disetujui'], 'RBT', 0, 'C');
		$pdf->Cell(45, 6, $rpt['ditindaklanjut'], 'RBT', 0, 'C');
		$pdf->Cell(5, 6, '', 'R', 1, 'C');
		
		$pdf->Cell(5, 6, '', 'L', 0, 'C');
		$pdf->Cell(180, 6, 'Mengetahui,', 'LR', 0, 'L');
		$pdf->Cell(5, 6, '', 'R', 1, 'C');

		$pdf->Cell(5, 8, '', 'L', 0, 'C');
		$pdf->Cell(180, 8, '', 'LRB', 0, 'L');
		$pdf->Cell(5, 8, '', 'R', 1, 'C');

		$pdf->Cell(190, 6, '', 'LRB', 0, 'C');

		$pdf->Output();
	}

	function print_memo_informasi(){
		$id = $this->uri->segment('4');

		$sql = "select a.*, (select sum(jumlah_diterima * harga_satuan) from trx_pengajuan_detail
		where id_pengajuan = a.id_pengajuan) as total, b.divisi as kepada_memo, c.divisi as dari_memo,
		e.no_rek_vendor, e.nama_rekening, f.pengurus as diajukan, g.pengurus as diperiksa, 
		h.pengurus as disetujui1, i.pengurus as disetujui2
		from trx_memo_informasi a left join mst_divisi b
		on a.kepada = b.id left join mst_divisi c 
		on a.dari = c.id left join trx_pengajuan_header d
		on a.id_pengajuan = d.id left join mst_vendor e
		on d.id_vendor = e.id left join mst_pengurus f
		on a.diajukan = f.id left join mst_pengurus g
		on a.diperiksa = g.id left join mst_pengurus h
		on a.disetujui1 = h.id left join mst_pengurus i
		on a.disetujui2 = i.id 
		
		where a.id = $id";
		$rpt = $this->db->query($sql)->row_array();

		$this->load->library('pdf');
		$pdf = new FPDF('p', 'mm', 'A4');
		
		// membuat halaman baru
		$pdf->AliasNbPages();
		$pdf->AddPage();
		// setting jenis font yang akan digunakan
		
		$pdf->Cell(190, 3, '', 'LTR', 1, 'L');	
		$pdf->SetFont('Times', 'B', 14);
		// // $pdf->SetXY(10,4);
		$pdf->Cell(5, 6, '', 'L', 0, 'C');
		$pdf->Cell(180, 6, 'MEMO INFORMASI', '', 0, 'L');		
		$pdf->SetFont('Times', '', 10);	
		$pdf->Cell(5, 6, '', 'R', 1, 'C');		

		$daftar_hari = array(
			'Sunday' => 'Minggu',
			'Monday' => 'Senin',
			'Tuesday' => 'Selasa',
			'Wednesday' => 'Rabu',
			'Thursday' => 'Kamis',
			'Friday' => 'Jumat',
			'Saturday' => 'Sabtu'
		);
		$namahari = date('l', strtotime($rpt['tgl_memo']));
		$namahari = $daftar_hari[$namahari];

		$bulan = array(
			'01' => 'Januari',
			'02' => 'Februari',
			'03' => 'Maret',
			'04' => 'April',
			'05' => 'Mei',
			'06' => 'Juni',
			'07' => 'Juli',
			'08' => 'Agustus',
			'09' => 'September',
			'10' => 'Oktober',
			'11' => 'November',
			'12' => 'Desember',
		);

		$glMemo = date('d', strtotime($rpt['tgl_memo'])).' '.$bulan[date('m', strtotime($rpt['tgl_memo']))].' '.date('Y', strtotime($rpt['tgl_memo']));

		$pdf->Cell(5, 4, '', 'L', 0, 'C');
		$pdf->Cell(40, 4, 'Hari/Tanggal', '', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(135, 4, $namahari.', '.$glMemo, '', 0, 'L');
		$pdf->Cell(5, 4, '', 'R', 1, 'C');

		$pdf->Cell(190, 2, '', 'LR', 1, 'L');

		$pdf->Cell(5, 4, '', 'L', 0, 'C');
		$pdf->Cell(40, 4, 'Kepada', '', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(135, 4, $rpt['kepada_memo'], '', 0, 'L');
		$pdf->Cell(5, 4, '', 'R', 1, 'C');

		$pdf->Cell(5, 4, '', 'L', 0, 'C');
		$pdf->Cell(40, 4, 'Dari', '', 0, 'L');
		$pdf->Cell(5, 4, ':', 0, 0, 'L');
		$pdf->Cell(135, 4, $rpt['dari_memo'], '', 0, 'L');
		$pdf->Cell(5, 4, '', 'R', 1, 'C');

		$sql = "select a.* from config_global a ";
		$fot = $this->db->query($sql)->result();
		foreach ($fot as $f)
		{				
			$y_awal = 15; 
			
			$pdf->Image('uploads/foto/'.$f->image,135,$y_awal,50,15,'JPG','');

			$pdf->SetXY(10,$y_awal+15);

			$pdf->Cell(190, 3, '', '', 1, 'C');			
		}
		$GLOBALS['rkp'] = '';
		$pdf->Cell(190, 3, '', 'LRB', 1, 'L');
		$pdf->Cell(5, 4, '', 'L', 0, 'C');
		$pdf->Cell(180, 6, 'Mohon untuk dapat melakukan transfer pada tanggal '.$glMemo.' dengan rincian sebagai berikut :', '', 0, 'L');
		$pdf->Cell(5, 4, '', 'R', 1, 'C');
		$pdf->Cell(190, 2, '', 'LR', 1, 'C');

		$pdf->Cell(5, 5, '', 'L', 0, 'C');
		$pdf->Cell(40, 5, 'No. Rekening :', 'LT', 0, 'L');
		$pdf->Cell(140, 5, ' '.$rpt['no_rek_vendor'], 'TLR', 0, 'L');
		$pdf->Cell(5, 5, '', 'R', 1, 'C');

		$pdf->Cell(5, 5, '', 'L', 0, 'C');
		$pdf->Cell(40, 5, 'Atas Nama :', 'LT', 0, 'L');
		$pdf->Cell(140, 5, ' '.$rpt['nama_rekening'], 'TLR', 0, 'L');
		$pdf->Cell(5, 5, '', 'R', 1, 'C');

		$terbilang = ucwords($this->terbilang($rpt['total'])). ' Rupiah';

		$pdf->Cell(5, 5, '', 'L', 0, 'C');
		$pdf->Cell(40, 5, 'Nominal :', 'LT', 0, 'L');
		$pdf->Cell(140, 5, ' Rp. '.number_format($rpt['total'],0), 'TLR', 0, 'L');
		$pdf->Cell(5, 5, '', 'R', 1, 'C');

		$pdf->Cell(5, 5, '', 'L', 0, 'C');
		$pdf->Cell(40, 5, 'Terbilang :', 'LTB', 0, 'L');
		$pdf->Cell(140, 5, ' '.$terbilang, 'TLRB', 0, 'L');
		$pdf->Cell(5, 5, '', 'R', 1, 'C');

		$pdf->Cell(5, 6, '', 'L', 0, 'C');
		$pdf->Cell(180, 6, 'Catatan : ', 'LR', 0, 'L');
		$pdf->Cell(5, 4, '', 'R', 1, 'C');

		$pdf->Cell(5, 6, '', 'L', 0, 'C');
		$pdf->Cell(180, 6, $rpt['catatan'], 'LR', 0, 'L');
		$pdf->Cell(5, 6, '', 'R', 1, 'C');

		$pdf->Cell(5, 2, '', 'L', 0, 'C');
		$pdf->Cell(180, 2, '', 'LRB', 0, 'C');
		$pdf->Cell(5, 2, '', 'R', 1, 'C');

        if(!empty($rpt['disetujui2'])){
    		$pdf->Cell(5, 6, '', 'L', 0, 'C');
    		$pdf->Cell(40, 6, 'Diajukan Oleh', 'LRB', 0, 'C');
    		$pdf->Cell(50, 6, 'Diperiksa Oleh', 'RB', 0, 'C');
    		$pdf->Cell(90, 6, 'Menyetujui', 'RB', 0, 'C');
    		$pdf->Cell(5, 6, '', 'R', 1, 'C');
    
    		$pdf->Cell(5, 15, '', 'L', 0, 'C');
    		$pdf->Cell(40, 15, '', 'LRB', 0, 'C');
    		$pdf->Cell(50, 15, '', 'RB', 0, 'C');
    		$pdf->Cell(45, 15, '', 'RB', 0, 'C');
    		$pdf->Cell(45, 15, '', 'RB', 0, 'C');
    		$pdf->Cell(5, 15, '', 'R', 1, 'C');
    
    		$pdf->Cell(5, 6, '', 'L', 0, 'C');
    		$pdf->Cell(40, 6, $rpt['diajukan'], 'LRB', 0, 'C');
    		$pdf->Cell(50, 6, $rpt['diperiksa'], 'RB', 0, 'C');
    		$pdf->Cell(45, 6, $rpt['disetujui1'], 'RB', 0, 'C');
    		$pdf->Cell(45, 6, $rpt['disetujui2'], 'RB', 0, 'C');
    		$pdf->Cell(5, 6, '', 'R', 1, 'C');
        } else {
    		$pdf->Cell(5, 6, '', 'L', 0, 'C');
    		$pdf->Cell(40, 6, 'Diajukan Oleh', 'LRB', 0, 'C');
    		$pdf->Cell(50, 6, 'Diperiksa Oleh', 'RB', 0, 'C');
    		$pdf->Cell(90, 6, 'Menyetujui', 'RB', 0, 'C');
    		$pdf->Cell(5, 6, '', 'R', 1, 'C');
    
    		$pdf->Cell(5, 15, '', 'L', 0, 'C');
    		$pdf->Cell(40, 15, '', 'LRB', 0, 'C');
    		$pdf->Cell(50, 15, '', 'RB', 0, 'C');
    		$pdf->Cell(90, 15, '', 'RB', 0, 'C');
    		$pdf->Cell(5, 15, '', 'R', 1, 'C');
    
    		$pdf->Cell(5, 6, '', 'L', 0, 'C');
    		$pdf->Cell(40, 6, $rpt['diajukan'], 'LRB', 0, 'C');
    		$pdf->Cell(50, 6, $rpt['diperiksa'], 'RB', 0, 'C');
    		$pdf->Cell(90, 6, $rpt['disetujui1'], 'RB', 0, 'C');
    		$pdf->Cell(5, 6, '', 'R', 1, 'C');
        }

		$pdf->Cell(5, 6, '', 'L', 0, 'C');
		$pdf->Cell(180, 6, 'Telah Ditindak Lanjuti :', 'LR', 0, 'L');
		$pdf->Cell(5, 6, '', 'R', 1, 'C');

		$pdf->Cell(5, 8, '', 'L', 0, 'C');
		$pdf->Cell(180, 8, '', 'LRB', 0, 'L');
		$pdf->Cell(5, 8, '', 'R', 1, 'C');

		$pdf->Cell(190, 6, '', 'LRB', 0, 'C');

		$pdf->Output();
	}

}
?>
