<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class transaksi_pengeluaran extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('transaksi_model');
	}

	public function pengeluaran_barang($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_keluar']   = $this->master_model->select_in('trx_pengeluaran','*',"WHERE 1 = 0");
	    	
	    

			$this->load->view('pengeluaran_barang/header', $data);
	    }
	}

	public function insert_pengeluaran($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$data = array(			
			'tgl_keluar' => $this->input->post('tgl_keluar'),
			'digunakan_oleh' => $this->input->post('digunakan_oleh'),
			'id_barang' => $this->input->post('id_barang'),
			'jumlah' => $this->input->post('jumlah'),			
			'catatan' => $this->input->post('catatan'),			
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);	

		$this->db->insert('trx_pengeluaran', $data);
				
		redirect('transaksi_pengeluaran/pengeluaran_barang/'.$menuid);

	}

	function validasi_stok(){
		$id_barang = $_POST['id_barang'];
		$jumlah = $_POST['jumlah'];
		// validasi 
		// $query = $this->db->query("SELECT * FROM viewstok where id = $id_barang ");
		$stok = $this->master_model->select_in('viewstok','*',"WHERE id = $id_barang");
		if ($jumlah > ($stok[0]->jumlah_unit + $stok[0]->masuk - $stok[0]->keluar)) {
			$data['error']['barang'] = 'Tidak Cukup Stok';
		}

		if (empty($data['error'])) {
			$data['hasil'] = 'sukses';			
		} else {			
			$data['hasil'] = 'gagal';			
		}
		
		echo json_encode($data);
	}	

	public function daftar_pengeluaran($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_keluar']   = $this->master_model->select_in('trx_pengeluaran','*',"WHERE 1 = 0");

			$this->load->view('pengeluaran_barang/list', $data);
	    }
	}

	public function daftar_pengeluaran2($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
		$tgl1 = $this->input->post('tgl1');
		$tgl2 = $this->input->post('tgl2');

		if (empty($tgl1)){
			$tgl1 = $this->session->userdata('date1');
			$tgl2 = $this->session->userdata('date2');
		}

		$this->session->set_userdata('date1', $tgl1);
		$this->session->set_userdata('date2', $tgl2);
		
		if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_keluar']   = $this->transaksi_model->daftarPengeluaran($tgl1, $tgl2);

			$this->load->view('pengeluaran_barang/list2', $data);
	    }
	}

	function delete_pengeluaran($menuid, $id)
	{
		$this->db->where('id',$id);
		$this->db->delete('trx_pengeluaran');
		
		redirect('transaksi_pengeluaran/daftar_pengeluaran2/'.$menuid);
	}

	public function barang_keluar_excel($menuid, $tgl1, $tgl2)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
		
		if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_keluar']   = $this->transaksi_model->daftarPengeluaranExcel($tgl1, $tgl2);

			$this->load->view('pengeluaran_barang/list2excel', $data);
	    }
	}

}
?>
