<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class transaksi_repair extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('master_model');
		$this->load->model('transaksi_model');
		$this->load->model('backend_model');
  	}


	public function repair_maintenance($menuid, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_repair']    = $this->backend_model->repair_maintenance($id);

    		$this->load->view('repair_maintenance/repair', $data);
	    }
	}

	public function repair_maintenance_detail($menuid, $member, $id)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_repair']    = $this->backend_model->repair_maintenance_detail($member, $id);

    		$this->load->view('repair_maintenance/repair_detail', $data);
	    }
	}

	public function update_estimasi($menuid, $member, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		date_default_timezone_set("Asia/Jakarta");

		$data = array(						
			'judul_proposal' => $this->input->post('judul_proposal'),
			'estimasi_kerusakan' => $this->input->post('estimasi_kerusakan'),			
			'tingkat_kesulitan' => $this->input->post('tingkat_kesulitan'),
			'estimasi_jasa' => $this->input->post('estimasi_jasa'),
			'estimasi_dp' => $this->input->post('estimasi_dp'),
			'estimasi_teknisi_utama' => $this->input->post('estimasi_teknisi_utama'),
			'estimasi_teknisi_helper1' => $this->input->post('estimasi_teknisi_helper1'),
			'estimasi_teknisi_helper2' => $this->input->post('estimasi_teknisi_helper2'),
			'estimasi_tanggal_pengerjaan' => $this->input->post('estimasi_tanggal_pengerjaan'),
			'estimasi_lama_pengerjaan' => $this->input->post('estimasi_lama_pengerjaan'),
			'catatan_proposal' => $this->input->post('info_tambahan'),
			'update_estimasi_by' => date('Y-m-d H:i:s'),
			'update_estimasi_date' => $user_id1
		);	

		$this->db->where('ID', $id);
		$this->db->update('repair_maintenance', $data);

		// redirect('transaksi_repair/repair_maintenance/'.$menuid.'/'.$member);
		redirect('transaksi_repair/repair_maintenance_detail/'.$menuid.'/'.$member.'/'.$id.'#tab_1');
	}

	public function kirim_notif_estimasi($menuid, $member, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		date_default_timezone_set("Asia/Jakarta");

		$data = array(			
			'status' => 2
		);	

		$this->db->where('ID', $id);
		$this->db->update('repair_maintenance', $data);
		
		$dtl=$this->backend_model->repair_maintenance_detail($member, $id);
		
		$config = array(
			'protocol'  => 'smtp',
			'smtp_host' => 'uscentral427.accountservergroup.com',
			'smtp_crypto'=>'ssl',
			'smtp_port' => 465,
			'smtp_user' => 'tes@watytjakra.info',
			'smtp_pass' => 'maret27031985',
			'mailtype'  => 'html',
			'charset'   => 'iso-8859-1',
			'wordwrap' => 'TRUE',
		);
         //memanggil library email dan set konfigurasi untuk pengiriman email
		 $this->load->library('email', $config);
		 $this->email->set_newline("\r\n");
			 
		 $this->email->clear();
		 $this->email->set_mailtype("html");
		 $this->email->set_newline("\r\n");
		 $this->email->from('tes@watytjakra.info');
		 $this->email->to('nickysetiawan@gmail.com');
		 
		 $this->email->subject('Verifikasi Akun');
		 $this->email->message("terimakasih telah melakukan registrasi, untuk memverifikasi silahkan klik tautan dibawah ini");
		 
		 if($this->email->send()) {
               echo 'Email berhasil dikirim';
          }
          else {
               echo 'Email tidak berhasil dikirim';
               echo '<br />';
               echo $this->email->print_debugger();
          }

		redirect('transaksi_repair/repair_maintenance/'.$menuid.'/'.$member);
	}

	public function update_status_repair($menuid, $member)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$id = $this->input->post('id');
		
		date_default_timezone_set("Asia/Jakarta");

		$data = array(			
			'status' => $this->input->post('status')
		);	

		$this->db->where('ID', $id);
		$this->db->update('repair_maintenance', $data);

		redirect('transaksi_repair/repair_maintenance/'.$menuid.'/'.$member);
	}

	public function update_aktual($menuid, $member, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		date_default_timezone_set("Asia/Jakarta");

		$data = array(			
			'aktual_dp' => $this->input->post('aktual_dp'),
			'aktual_teknisi_utama' => $this->input->post('aktual_teknisi_utama'),
			'aktual_teknisi_helper1' => $this->input->post('aktual_teknisi_helper1'),
			'aktual_teknisi_helper2' => $this->input->post('aktual_teknisi_helper2'),
			'aktual_tanggal_pengerjaan' => $this->input->post('aktual_tanggal_pengerjaan'),
			'aktual_lama_pengerjaan' => $this->input->post('aktual_lama_pengerjaan'),
			'catatan_dari_teknisi' => $this->input->post('catatan_dari_teknisi'),
			'update_aktual_by' => date('Y-m-d H:i:s'),
			'update_aktual_date' => $user_id1
		);	

		$this->db->where('ID', $id);
		$this->db->update('repair_maintenance', $data);

		redirect('transaksi_repair/repair_maintenance/'.$menuid.'/'.$member);
	}

	public function kirim_notif_selesai($menuid, $member, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		date_default_timezone_set("Asia/Jakarta");

		$data = array(			
			'status' => 6
		);	

		$this->db->where('ID', $id);
		$this->db->update('repair_maintenance', $data);

		redirect('transaksi_repair/repair_maintenance/'.$menuid.'/'.$member);
	}

	public function insert_invoice_repair($menuid, $member, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		date_default_timezone_set("Asia/Jakarta");
		$data = array(
			'id_order' => $id,
			'no_invoice' => '',
			'tgl_invoice' => date('Y-m-d'),
			'keterangan' => $this->input->post('ket'),
			'jumlah' => $this->input->post('jml'),
			'harga' => $this->input->post('harga'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);

		$this->db->insert('invoice_repair_maintenance', $data);
		redirect('transaksi_repair/repair_maintenance_detail/'.$menuid.'/'.$member.'/'.$id.'#tab_3');
	}

	function delete_invoice($menuid, $member, $id, $id_detail)
	{
		$this->db->where('id',$id_detail);
		$this->db->delete('invoice_repair_maintenance');
		
		redirect('transaksi_repair/repair_maintenance_detail/'.$menuid.'/'.$member.'/'.$id.'#tab_3');
	}

	public function update_invoice_repair($menuid, $member, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		date_default_timezone_set("Asia/Jakarta");
		$id_detail = $this->input->post('id');

		$data = array(
			'id_order' => $id,
			'no_invoice' => '',
			// 'tgl_invoice' => date('Y-m-d'),
			'keterangan' => $this->input->post('ket'),
			'jumlah' => $this->input->post('jml'),
			'harga' => $this->input->post('harga'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);

		$this->db->where('id', $id_detail);
		$this->db->update('invoice_repair_maintenance', $data);

		redirect('transaksi_repair/repair_maintenance_detail/'.$menuid.'/'.$member.'/'.$id.'#tab_3');
	}

	public function insert_pembayaran($menuid, $member, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		date_default_timezone_set("Asia/Jakarta");
		$data = array(
			'id_order' => $id,
			'tanggal_bayar' => $this->input->post('tanggal'),
			'jumlah_bayar' => $this->input->post('jml'),
			'pembayaran_melalui' => $this->input->post('melalui'),
			'keterangan_transfer' => $this->input->post('ket'),
			'rek_terima' => $this->input->post('rek'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);

		$this->db->insert('terima_pembayaran', $data);
		redirect('transaksi_repair/repair_maintenance_detail/'.$menuid.'/'.$member.'/'.$id.'#tab_4');
	}

	function delete_pembayaran($menuid, $member, $id, $id_detail)
	{
		$this->db->where('id',$id_detail);
		$this->db->delete('terima_pembayaran');
		
		redirect('transaksi_repair/repair_maintenance_detail/'.$menuid.'/'.$member.'/'.$id.'#tab_4');
	}

	public function update_pembayaran($menuid, $member, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		date_default_timezone_set("Asia/Jakarta");
		$id_detail = $this->input->post('id');

		$data = array(
			'id_order' => $id,
			'tanggal_bayar' => $this->input->post('tanggal'),
			'jumlah_bayar' => $this->input->post('jml'),
			'pembayaran_melalui' => $this->input->post('melalui'),
			'keterangan_transfer' => $this->input->post('ket'),
			'rek_terima' => $this->input->post('rek'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);

		$this->db->where('id', $id_detail);
		$this->db->update('terima_pembayaran', $data);

		redirect('transaksi_repair/repair_maintenance_detail/'.$menuid.'/'.$member.'/'.$id.'#tab_4');
	}

	public function order_selesai($menuid, $member, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
	
		date_default_timezone_set("Asia/Jakarta");

		$data = array(			
			'status' => 8
		);	

		$this->db->where('ID', $id);
		$this->db->update('repair_maintenance', $data);

		redirect('transaksi_repair/repair_maintenance/'.$menuid.'/'.$member);
	}

	function repair_invoice(){
		$member = $this->uri->segment('4');
		$id = $this->uri->segment('5');

		$sql = "select a.*, b.id_member, b.keterangan_keluhan, b.no_transaksi, c.nama, c.email From invoice_repair_maintenance a left join repair_maintenance b 
			on a.id_order=b.ID left join member_customer c on b.id_member=c.ID where a.id_order = $id";

		$rpt = $this->db->query($sql)->row_array();
		$lap = $this->db->query($sql)->result();

		$sql = "select * From config_global"; 
		$hdr = $this->db->query($sql)->row_array();

		$this->load->library('pdf');
		$pdf = new FPDF('p', 'mm', 'A4');
		// membuat halaman baru
		$pdf->AddPage();
		// setting jenis font yang akan digunakan
		$pdf->SetFont('Arial', 'B', 14);
		$pdf->Cell(100, 10, 'INVOICE', 0, 0, 'L');
		$pdf->SetFont('Arial', '', 10);
		$pdf->Cell(100, 10, 'Tanggal       : '.date('d F Y', strtotime($rpt['tgl_invoice'])), 0, 1, 'L');
		$pdf->Cell(100, 5, $hdr['name'], 0, 0, 'L');
		$pdf->Cell(100, 5, 'Pelanggan   :  '.$rpt['nama'], 0, 1, 'L');
		$pdf->Cell(100, 5, $hdr['address'], 0, 0, 'L');
		$pdf->Cell(100, 5, 'Email           :  '.$rpt['email'], 0, 1, 'L');
		// $pdf->Cell(100, 6, $hdr['no_telepon'], 0, 0, 'L');
		// $pdf->Cell(100, 5, 'Merk / Type :  '.$rpt['merk_d'].'/'.$rpt['type_d'].'/'.$rpt['tahun'], 0, 1, 'L');

		$pdf->Cell(190, 2, '', 0, 1, 'C');
		$pdf->Cell(100, 5, 'No. Transaksi : '.$rpt['no_transaksi'], 0, 0, 'L');
		$pdf->Cell(100, 5, 'No. Invoice  : '.$rpt['no_invoice'], 0, 1, 'L');
		

		$pdf->Cell(190, 3, '', 0, 1, 'C');

		$pdf->SetFont('Arial', 'B', 10);
		$pdf->SetFillColor(255,255,255);
		// tabel detail
		$pdf->Cell(10, 12, 'No ', 1, 0, 'C');
		$pdf->Cell(100, 12, ' Keterangan ', 1, 0, 'L');
		$pdf->Cell(20, 12, 'Jml', 1, 0, 'C');
		$pdf->Cell(30, 12, 'Harga', 1,0, 'C');
		$pdf->Cell(30, 12, 'Total', 1,1, 'C');
		
		$pdf->Cell(25, 1, '', 0, 1, 'R');
		$pdf->SetFont('Arial', '', 9);

		for($a=0; $a < count($rpt); $a++)
		// $i = 1; foreach($rpt as $p) 

		$i = 1; $total = 0; foreach ($lap as $p)
		{
			$pdf->Cell(10, 6, $i, 1, 0, 'C');
			$pdf->Cell(100, 6, ' '.$p->keterangan, 1, 0, 'L');
			$pdf->Cell(20, 6, number_format($p->jumlah), 1, 0, 'R');
			$pdf->Cell(30, 6, number_format($p->harga), 1, 0, 'R');			
			$pdf->Cell(30, 6, number_format($p->harga * $p->jumlah), 1, 1, 'R');

			$total = $total + ($p->harga * $p->jumlah);
			$i++; 
			   
	    }
		
		$pdf->SetFont('Arial', 'B', 9);
		$pdf->Cell(25, 1, '', 0, 1, 'R');

		$pdf->Cell(160, 6, 'Total ', 1, 0, 'C');
		$pdf->Cell(30, 6, number_format($total), 1, 0, 'R');

		$pdf->Cell(25, 7, '', 0, 1, 'R');

		$sql = "select * From rekening_perusahaan"; 
		$rek = $this->db->query($sql)->row_array();

		$pdf->SetFont('Arial', '', 9);
		$pdf->Cell(100, 6, 'Harap Transfer Ke Rekening : '. $rek['nama_bank']. ' ' . $rek['no_rekening']. ' Atas Nama : ' . $rek['nama_rekening'], 0, 0, 'L');



		// $pdf->Cell(25, 6, '', 0, 1, 'R');
		// $pdf->Cell(25, 6, '', 0, 1, 'R');

		// $pdf->SetFont('Arial', '', 9);

		// // $pdf->Cell(125, 6, 'tes', 0, 0, 'L');

		// $pdf->Cell(121, 6, '', 0, 0, 'L');
		// $pdf->Cell(30, 6, 'Kasir', 1, 0, 'C');
		// $pdf->Cell(40, 6, 'Pelanggan', 1, 1, 'C');
		// // $pdf->Cell(37, 6, 'Disetujui Oleh', 1, 1, 'C');
		// $pdf->Cell(121, 13, '', 0, 0, 'L');
		// $pdf->Cell(30, 13, '', 1, 0, 'C');
		// $pdf->Cell(40, 13, '', 1, 1, 'C');
		// // $pdf->Cell(37, 16, '', 1, 1, 'C');
		// $pdf->Cell(121, 6, '', 0, 0, 'L');
		// $pdf->Cell(30, 6, $rpt['created_by'], 1, 0, 'C');
		// $pdf->Cell(40, 6, $rpt['nama'], 1, 0, 'C');
		// // $pdf->Cell(37, 6, $hdr['manager'], 1, 1, 'C');
		
		$pdf->Output();
	}

	public function insert_estimasi_repair($menuid, $member, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		date_default_timezone_set("Asia/Jakarta");
		$data = array(
			'id_repair' => $id,			
			'id_sparepart' => $this->input->post('id_sparepart'),
			'jumlah' => $this->input->post('jml'),
			'harga' => $this->input->post('harga'),
			'total' => $this->input->post('jml') * $this->input->post('harga'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);

		$this->db->insert('order_sparepart', $data);

		redirect('transaksi_repair/repair_maintenance_detail/'.$menuid.'/'.$member.'/'.$id.'#tab_1');
	}

	function delete_estimasi($menuid, $member, $id, $id_detail)
	{
		$this->db->where('id',$id_detail);
		$this->db->delete('order_sparepart');
		
		redirect('transaksi_repair/repair_maintenance_detail/'.$menuid.'/'.$member.'/'.$id.'#tab_1');
	}

	public function update_estimasi_repair($menuid, $member, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		date_default_timezone_set("Asia/Jakarta");
		$id_detail = $this->input->post('id');

		$data = array(
			'id_repair' => $id,
			'id_sparepart' => $this->input->post('id_sparepart'),
			'jumlah' => $this->input->post('jml'),
			'harga' => $this->input->post('harga'),
			'total' => $this->input->post('jml') * $this->input->post('harga'),
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);

		$this->db->where('id', $id_detail);
		$this->db->update('order_sparepart', $data);

		redirect('transaksi_repair/repair_maintenance_detail/'.$menuid.'/'.$member.'/'.$id.'#tab_1');
	}

	public function insert_aktual_repair($menuid, $member, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		date_default_timezone_set("Asia/Jakarta");
		$data = array(
			'id_order' => $id,			
			'keterangan' => $this->input->post('ket'),
			'jumlah' => $this->input->post('jml'),
			'harga' => $this->input->post('harga'),
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1
		);

		$this->db->insert('aktual_repair', $data);

		redirect('transaksi_repair/repair_maintenance_detail/'.$menuid.'/'.$member.'/'.$id.'#tab_2');
	}

	function delete_aktual($menuid, $member, $id, $id_detail)
	{
		$this->db->where('id',$id_detail);
		$this->db->delete('aktual_repair');
		
		redirect('transaksi_repair/repair_maintenance_detail/'.$menuid.'/'.$member.'/'.$id.'#tab_2');
	}

	public function update_aktual_repair($menuid, $member, $id)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		date_default_timezone_set("Asia/Jakarta");
		$id_detail = $this->input->post('id');

		$data = array(			
			'jumlah_aktual' => $this->input->post('jml'),			
			'update_at' => date('Y-m-d H:i:s'),
			'update_by' => $user_id1
		);

		$this->db->where('id', $id_detail);
		$this->db->update('order_sparepart', $data);

		$sql="update order_sparepart set total_aktual = jumlah_aktual * harga where id = $id_detail ;";
		$qry = $this->db->query($sql);

		redirect('transaksi_repair/repair_maintenance_detail/'.$menuid.'/'.$member.'/'.$id.'#tab_2');
	}

	public function getHarga()
	{	
		$idSparepart = $_GET['id'];
		
		$user_id = $this->session->userdata('user_id');
				
		$harga = $this->master_model->select_in('sparepart','*',"where id = $idSparepart");

		$data_harga = array('harga'   =>  $harga[0]->harga);
		echo json_encode($data_harga);
		
	}

}
?>
