<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class transaksi_service extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('transaksi_model');
	}

	public function service_kendaraan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_sHeader']   = $this->master_model->select_in('trservice','*',"ORDER BY id DESC");
			$this->load->view('trservice/header', $data);
	    }
	}

	public function emptyJournal($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_jempty']    = $this->transaksi_model->spEmptyJournal();			

			$this->load->view('journal/empty', $data);
	    }
	}

	public function balance_sheet($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_jheader']    = $this->transaksi_model->jHeader();

    		$this->load->view('journal/bs', $data);
	    }
	}

	public function viewBS($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {

			$date = $this->input->post('journal_date');
			// print_r($date);
			$data['data_bs']    = $this->transaksi_model->spBalanceSheet($date);

			$this->load->view('journal/bs_detail', $data);
	    }
	}

	public function viewBSExcel($menuid, $date)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {

			$data['data_bs']    = $this->transaksi_model->spBalanceSheet($date);

			$this->load->view('journal/bs_detail_excel', $data);
	    }
	}

	public function profit_loss($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_jheader']    = $this->transaksi_model->jHeader();

    		$this->load->view('journal/pl', $data);
	    }
	}

	public function viewPL($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$date1 = $this->input->post('journal_date1');
			$date2 = $this->input->post('journal_date2');	
			// print_r($date);
			$data['data_pl']    = $this->transaksi_model->spProfitLoss($date1, $date2);

			$this->load->view('journal/pl_detail', $data);
	    }
	}

	public function viewPLExcel($menuid, $date1, $date2)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_pl']    = $this->transaksi_model->spProfitLoss($date1, $date2);

			$this->load->view('journal/pl_detail_excel', $data);
	    }
	}

	public function service_detail($menuid, $jID)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_sDetail'] = $this->master_model->select_in('trservice_detail','*',"WHERE service_id = $jID");
    		$this->load->view('trservice/detail', $data);
	    }
	}

	public function insert_header($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$data = array(
			'no_kendaraan' => $this->input->post('no_kendaraan'),
			'tanggal' => $this->input->post('tanggal'),
			'created_at' => date('Y-m-d H:i:s'),
			'created_by' => $user_id1
		);	
		$this->db->insert('trservice', $data);
		
		$data_service=$this->transaksi_model->getServiceID();
		$jID = $data_service[0]->last_id;	

		redirect('transaksi_service/service_detail/'.$menuid.'/'.$jID);
	}

	public function insert_detail($menuid, $offset)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$data = array(
			'journal_id' => $offset,
			'coa_id' => $this->input->post('coa_id'),
			'detail_desc' => $this->input->post('detail_desc'),
			'debet_value' => $this->input->post('debet_value'),
			'credit_value' => $this->input->post('credit_value'),
			'updated_at' => date('Y-m-d H:i:s'),
			'updated_by' => $user_id1
		);	
		
		$this->db->insert('acc_journal_detail', $data);		
		redirect('journal_controller/journal_detail/'.$menuid.'/'.$offset);
	}

	public function viewJournal($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_jHeader']    = $this->transaksi_model->jHeader();

    		$this->load->view('journal/main', $data);
	    }
	}

	public function viewJournalDetail($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {

			$jDate = $this->input->post('journal_date');
			if(empty($jDate))
			{
				$jDate = $this->session->userdata('journal_date');
			}
			$jDate = substr($jDate,0,7);

	    	$data['data_journal']    = $this->transaksi_model->viewJournal($jDate);

    		$this->load->view('journal/list', $data);
	    }
	}	
	
	public function general_ledger($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_gl']    = $this->transaksi_model->jHeader();

    		$this->load->view('journal/gl', $data);
	    }
	}

	public function viewGL($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$coa = $this->input->post('coa_id');
			$fDate = $this->input->post('journal_date1');
			$tDate = $this->input->post('journal_date2');

	    	$data['data_gl']    = $this->transaksi_model->spViewGL($coa, $fDate, $tDate);

    		$this->load->view('journal/detailGL', $data);
	    }
	}

	public function viewGLExcel($menuid, $coa, $fDate, $tDate)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_gl']    = $this->transaksi_model->spViewGL($coa, $fDate, $tDate);

    		$this->load->view('journal/detailGLExcel', $data);
	    }
	}

	public function delete_header($menuid, $ID)
	{
		$this->db->where('id', $ID);
		$this->db->delete('acc_journal');
		redirect('journal_controller/emptyJournal/'.$menuid);
	}

	public function delete_detail($menuid, $jID, $ID)
	{
		$this->db->where('id', $ID);
		$this->db->delete('acc_journal_detail');
		redirect('journal_controller/journal_detail/'.$menuid.'/'.$jID);
	}

	public function edit_journal_detail($menuid, $jID)
	{
		$ID = $this->input->post('id');		
		$data_edit=$this->master_model->mst_edit_dr('acc_journal_detail',$ID);
		
		echo'
			<form method="post" action="'.base_url().'journal_controller/edit_process_journal_detail/'.$menuid.'/'.$jID.'/'.$ID.'" enctype="multipart/form-data">
				<div class="modal-header">
				  <button type="button" class="close" data-dismiss="modal">&times;</button>
				  <h4 class="modal-title">Edit Journal Detail</h4>
				</div>
				<div class="modal-body">				
					<div class="form-group">
						<label>Account </label>
						<select name="coa_id" class="form-control select2" >
							<option selected="selected" value="">
								-- Select Account --
							</option>
							';
								$idCoa = $data_edit[0]->coa_id;
								$data_coa = $this->master_model->select_in('acc_coa','*',"ORDER BY id ASC");
								for($a=0; $a < count($data_coa); $a++)
								{
									if($idCoa == $data_coa[$a]->id)
									{
										$select = 'selected="selected"';
									}else {
										$select = '';
									}
									echo'
										<option value="'.$data_coa[$a]->id.'" '.$select.'>
											'.$data_coa[$a]->coa_code.' - '.$data_coa[$a]->coa_name.'
										</option>
									';
								}
							echo'
						</select>
					</div>						

					<div class="form-group">
						<label>Detail Description</label>
						<input type="text" name="detail_desc" value="'.$data_edit[0]->detail_desc.'" class="form-control" >
					</div>

					<div class="form-group">
						<label>Debet Value</label>
						<input type="text" name="debet_value" value="'.$data_edit[0]->debet_value.'" class="form-control" >
					</div>

					<div class="form-group">
						<label>Credit Value</label>
						<input type="text" name="credit_value" value="'.$data_edit[0]->credit_value.'" class="form-control" >
					</div>

                </div>
				<div class="modal-footer">
					<input type="submit" class="btn btn-info btn-fill pull-right" value="Save" id="save">
					<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
				</div>
			</form>
		';
	}

	public function edit_process_journal_detail($menuid, $jID, $ID)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		
		$data = array(			
			'coa_id' => $this->input->post('coa_id'),
			'detail_desc' => $this->input->post('detail_desc'),
			'debet_value' => $this->input->post('debet_value'),
			'credit_value' => $this->input->post('credit_value'),
			'updated_at' => date('Y-m-d H:i:s'),
			'updated_by' => $user_id1
		);	

		$this->db->where('id', $ID);
		$this->db->update('acc_journal_detail', $data);

		redirect('journal_controller/journal_detail/'.$menuid.'/'.$jID);
	}	

	public function edit_header($menuid)
	{
		$ID = $this->input->post('id');		
		$data_edit=$this->master_model->mst_edit_dr('acc_journal',$ID);
		
		echo'
			<form method="post" action="'.base_url().'journal_controller/edit_process_header/'.$menuid.'/'.$ID.'" enctype="multipart/form-data">
				<div class="modal-header">
				  <button type="button" class="close" data-dismiss="modal">&times;</button>
				  <h4 class="modal-title">Edit Journal Header</h4>
				</div>
				<div class="modal-body">				

					<div class="form-group">
						<label>Journal Date </label>
						<input type="date" name="journal_date"  class="form-control datepicker" value="'.$data_edit[0]->journal_date.'" >
					</div>

					<div class="form-group">
						<label>Journal Description</label>
						<input type="text" name="journal_desc" value="'.$data_edit[0]->journal_desc.'" class="form-control" >
					</div>

                </div>
				<div class="modal-footer">
					<input type="submit" class="btn btn-info btn-fill pull-right" value="Save" id="save">
					<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
				</div>
			</form>
		';
	}

	public function edit_process_header($menuid, $ID)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		
		$data = array(			
			'journal_date' => $this->input->post('journal_date'),
			'journal_desc' => $this->input->post('journal_desc'),
			'updated_at' => date('Y-m-d H:i:s'),
			'updated_by' => $user_id1
		);	

		$this->db->where('id', $ID);
		$this->db->update('acc_journal', $data);

		redirect('journal_controller/viewJournalDetail/'.$menuid);
	}	


}
?>
