<?php
    $this->load->view('master/header');
    $modul=$this->uri->segment(2);
    $menuid=$this->uri->segment(3);
?>

<div class="content-wrapper">
    <section class="content-header">
        <h1>
            Laporan Persediaan
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url();?>dashboard/index/8"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Laporan Persediaan</li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <?php
                $idKategori = $this->input->post('id_kategori');
                $idKantor = $this->input->post('id_kantor');
                $date1 = $this->input->post('from_date');
                $date2 = $this->input->post('to_date');

                if (empty($date1)){
                    $idKategori = $this->input->post('id_kategori');
                    $idKantor = $this->session->userdata('id_kantor');
                    $date1 = $this->session->userdata('date1');
                    $date2 = $this->session->userdata('date2');
                }

                $this->session->set_userdata('id_kategori', $idKategori);
                $this->session->set_userdata('id_kantor', $idKantor);
                $this->session->set_userdata('date1', $date1);
                $this->session->set_userdata('date2', $date2);
            ?>   

            <div class="col-xs-12">
                <div class="box">
                    <div class="box-body">
                        <form action="<?php echo base_url();?>laporan/persediaan2/<?php echo $menuid;?>" method="post" enctype="multipart/form-data">
                            <div class="col-xs-3">
                                <div class="form-group">
                                    <label>Jenis Persediaan</label>
                                    <select name="id_kategori" class="form-control"  required = "required">
                                        <option selected="selected" value="" >-- Pilih Kategori --</option>
                                        <?php
                                        $data_kat = $this->master_model->select_in('mst_kategori','*',"ORDER BY id ASC");
                                        for($a=0; $a < count($data_kat); $a++)
                                        {
                                            if($idKategori == $data_kat[$a]->id)
                                            {
                                                $select = 'selected="selected"';
                                            }else {
                                                $select = '';
                                            }
                                            echo'
                                                <option value="'.$data_kat[$a]->id.'" '.$select.'>
                                                    '.$data_kat[$a]->kategori.' 
                                                </option>
                                            ';
                                        }
                                        ?>
                                    </select>
                                </div> 
                            </div>
                            <?php $user_id = $this->session->userdata('user_id');?>
                            <div class="col-xs-3">
                                <div class="form-group">
                                    <label>Kantor</label>
                                    <select name="id_kantor" class="form-control" placeholder="Kantor" required = "required">
                                        <option selected="selected" value="" >-- Pilih Kantor --</option>
                                        <?php
                                        $data_kantor = $this->master_model->select_in('mst_kantor','*',"where id in (select id_kantor from mst_user_kantor where id_user = $user_id) ORDER BY id ASC");
                                        for($a=0; $a < count($data_kantor); $a++)
                                        {
                                            if($idKantor == $data_kantor[$a]->id)
                                            {
                                                $select = 'selected="selected"';
                                            }else {
                                                $select = '';
                                            }
                                            echo'
                                                <option value="'.$data_kantor[$a]->id.'" '.$select.'>
                                                    '.$data_kantor[$a]->nama_kantor.' 
                                                </option>
                                            ';
                                        }
                                        ?>
                                    </select>
                                </div> 
                            </div> 

                            <div class="col-xs-2">
                                <div class="form-group">
                                    <label>Dari Tanggal</label>    
                                    <input type="date" name="from_date" id="tanggal_beli" class="form-control datepicker" value="<?php echo $date1;?>" required="required">
                                </div>
                            </div>
                            <div class="col-xs-2">
                                <div class="form-group">
                                    <label>Hingga Tanggal</label>    
                                    <input type="date" name="to_date" id="tanggal_beli" class="form-control datepicker" value="<?php echo $date2;?>" required="required">
                                </div>
                            </div>
                            <div class="col-xs-1">    
                                <br/> 
                                <button type="submit" value="1" name="submit" class="btn btn-success btn-fill pull-right save_phone save_email">Lihat Data</button>
                            </div>
                            <div class="col-xs-1">    
                                <br/> 
                                <?php echo anchor('laporan/print_persediaan/'.$idKategori.'/'.$idKantor.'/'.$date1.'/'.$date2.'/lap_persediaan','Print',"class='btn btn-warning btn-xd' target='new'")?>
                            </div>

                        </form>  
                    </div>  
                    <!-- /.box-body -->                    
                    <div class="box-header">        
                        <table  class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Kode Barang</th>
                                    <th>Nama Barang</th>
                                    <th>Satuan</th>
                                    <th>Stok Awal</th>
                                    <th>Masuk</th>
                                    <th>Keluar</th>
                                    <th>Harga Satuan</th>
                                    <th>Stok Akhir</th>
                                    <th>Saldo Persediaan</th>
                                </tr>
                            </thead>

                            <tbody>
                            <?php $i = 1; foreach($data_persediaan as $persediaan1 =>$persediaan):  ?>
                                <tr>
                                    <td><?php echo $i; ?></td>
                                    <td><?php echo $persediaan->kode_barang; ?></td>
                                    <td><?php echo $persediaan->nama_barang; ?> </td>
                                    <td><?php echo $persediaan->satuan; ?> </td>
                                    <td><?php echo number_format($persediaan->saldo_awal); ?> </td>
                                    <td><?php echo number_format($persediaan->masuk); ?> </td>
                                    <td><?php echo number_format($persediaan->keluar); ?> </td>
                                    <td><?php echo number_format($persediaan->harga_beli); ?> </td>
                                    <td><?php echo number_format($persediaan->stok_akhir); ?> </td>
                                    <td><?php echo number_format($persediaan->saldo_persediaan); ?> </td>
                                </tr>
                                <?php $i++; endforeach; ?>
                                
                            </tbody>
                        </table>
                    </div>
                    
                </div>
                <!-- /.box -->
            </div>
            <!-- /.col -->

        </div>
        <!-- /.row -->
    </section>
    <!-- /.content -->

</div>



<?php   $this->load->view('master/footer'); ?>