<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class journal_controller extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('transaksi_model');
	}

	public function journal_header($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_jheader']   = $this->transaksi_model->spUnbalanceJournal();
			$data['data_jempty']    = $this->transaksi_model->spEmptyJournal();			

			$this->load->view('journal/header', $data);
	    }
	}

	public function emptyJournal($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_jempty']    = $this->transaksi_model->spEmptyJournal();			

			$this->load->view('journal/empty', $data);
	    }
	}

	public function balance_sheet($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_jheader']    = $this->transaksi_model->jHeader();

    		$this->load->view('journal/bs', $data);
	    }
	}

	public function viewBS($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {

			$date = $this->input->post('journal_date');
			// print_r($date);
			$data['data_bs']    = $this->transaksi_model->spBalanceSheet($date);

			$this->load->view('journal/bs_detail', $data);
	    }
	}

	public function viewBSExcel($menuid, $date)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {

			$data['data_bs']    = $this->transaksi_model->spBalanceSheet($date);

			$this->load->view('journal/bs_detail_excel', $data);
	    }
	}

	public function profit_loss($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_jheader']    = $this->transaksi_model->jHeader();

    		$this->load->view('journal/pl', $data);
	    }
	}

	public function viewPL($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$date1 = $this->input->post('journal_date1');
			$date2 = $this->input->post('journal_date2');	
			// print_r($date);
			$data['data_pl']    = $this->transaksi_model->spProfitLoss($date1, $date2);

			$this->load->view('journal/pl_detail', $data);
	    }
	}

	public function viewPLExcel($menuid, $date1, $date2)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_pl']    = $this->transaksi_model->spProfitLoss($date1, $date2);

			$this->load->view('journal/pl_detail_excel', $data);
	    }
	}

	public function journal_detail($menuid, $jID)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_jdetail']    = $this->transaksi_model->jDetail($jID);

    		$this->load->view('journal/detail', $data);
	    }
	}

	public function insert_header($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$data = array(
			'journal_date' => $this->input->post('journal_date'),
			'journal_voucher' => $this->input->post('journal_voucher'),
			'journal_desc' => $this->input->post('journal_desc'),
			'created_at' => date('Y-m-d H:i:s'),
			'created_by' => $user_id1
		);	
		$this->db->insert('acc_journal', $data);
		
		$data_journal=$this->transaksi_model->getJournalID();
		$jID = $data_journal[0]->last_id;	

		$jDate = $this->input->post('journal_date');
		$jDate = substr($jDate,0,7);

		$data_voucher=$this->transaksi_model->genVoucher($jDate);
		$jVoucher = $data_voucher[0]->journal_voucher;

		$data = array(			
			'journal_voucher' => $jVoucher
		);	

		$this->db->where('id', $jID);
		$this->db->update('acc_journal', $data);

		redirect('journal_controller/journal_detail/'.$menuid.'/'.$jID);
	}

	public function insert_detail($menuid, $offset)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$data = array(
			'journal_id' => $offset,
			'coa_id' => $this->input->post('coa_id'),
			'detail_desc' => $this->input->post('detail_desc'),
			'debet_value' => $this->input->post('debet_value'),
			'credit_value' => $this->input->post('credit_value'),
			'updated_at' => date('Y-m-d H:i:s'),
			'updated_by' => $user_id1
		);	
		
		$this->db->insert('acc_journal_detail', $data);		
		redirect('journal_controller/journal_detail/'.$menuid.'/'.$offset);
	}

	public function viewJournal($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_jHeader']    = $this->transaksi_model->jHeader();

    		$this->load->view('journal/main', $data);
	    }
	}

	public function viewJournalDetail($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {

			$jDate = $this->input->post('journal_date');
			if(empty($jDate))
			{
				$jDate = $this->session->userdata('journal_date');
			}
			$jDate = substr($jDate,0,7);

	    	$data['data_journal']    = $this->transaksi_model->viewJournal($jDate);

    		$this->load->view('journal/list', $data);
	    }
	}	
	
	public function general_ledger($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_gl']    = $this->transaksi_model->jHeader();

    		$this->load->view('journal/gl', $data);
	    }
	}

	public function viewGL($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$coa = $this->input->post('coa_id');
			$fDate = $this->input->post('journal_date1');
			$tDate = $this->input->post('journal_date2');

	    	$data['data_gl']    = $this->transaksi_model->spViewGL($coa, $fDate, $tDate);

    		$this->load->view('journal/detailGL', $data);
	    }
	}

	public function viewGLExcel($menuid, $coa, $fDate, $tDate)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_gl']    = $this->transaksi_model->spViewGL($coa, $fDate, $tDate);

    		$this->load->view('journal/detailGLExcel', $data);
	    }
	}

	public function delete_header($menuid, $ID)
	{
		$this->db->where('id', $ID);
		$this->db->delete('acc_journal');
		redirect('journal_controller/emptyJournal/'.$menuid);
	}

	public function delete_detail($menuid, $jID, $ID)
	{
		$this->db->where('id', $ID);
		$this->db->delete('acc_journal_detail');
		redirect('journal_controller/journal_detail/'.$menuid.'/'.$jID);
	}

	public function edit_journal_detail($menuid, $jID)
	{
		$ID = $this->input->post('id');		
		$data_edit=$this->master_model->mst_edit_dr('acc_journal_detail',$ID);
		
		echo'
			<form method="post" action="'.base_url().'journal_controller/edit_process_journal_detail/'.$menuid.'/'.$jID.'/'.$ID.'" enctype="multipart/form-data">
				<div class="modal-header">
				  <button type="button" class="close" data-dismiss="modal">&times;</button>
				  <h4 class="modal-title">Edit Journal Detail</h4>
				</div>
				<div class="modal-body">				
					<div class="form-group">
						<label>Account </label>
						<select name="coa_id" class="form-control select2" >
							<option selected="selected" value="">
								-- Select Account --
							</option>
							';
								$idCoa = $data_edit[0]->coa_id;
								$data_coa = $this->master_model->select_in('acc_coa','*',"ORDER BY id ASC");
								for($a=0; $a < count($data_coa); $a++)
								{
									if($idCoa == $data_coa[$a]->id)
									{
										$select = 'selected="selected"';
									}else {
										$select = '';
									}
									echo'
										<option value="'.$data_coa[$a]->id.'" '.$select.'>
											'.$data_coa[$a]->coa_code.' - '.$data_coa[$a]->coa_name.'
										</option>
									';
								}
							echo'
						</select>
					</div>						

					<div class="form-group">
						<label>Detail Description</label>
						<input type="text" name="detail_desc" value="'.$data_edit[0]->detail_desc.'" class="form-control" >
					</div>

					<div class="form-group">
						<label>Debet Value</label>
						<input type="text" name="debet_value" value="'.$data_edit[0]->debet_value.'" class="form-control" >
					</div>

					<div class="form-group">
						<label>Credit Value</label>
						<input type="text" name="credit_value" value="'.$data_edit[0]->credit_value.'" class="form-control" >
					</div>

                </div>
				<div class="modal-footer">
					<input type="submit" class="btn btn-info btn-fill pull-right" value="Save" id="save">
					<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
				</div>
			</form>
		';
	}

	public function edit_process_journal_detail($menuid, $jID, $ID)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		
		$data = array(			
			'coa_id' => $this->input->post('coa_id'),
			'detail_desc' => $this->input->post('detail_desc'),
			'debet_value' => $this->input->post('debet_value'),
			'credit_value' => $this->input->post('credit_value'),
			'updated_at' => date('Y-m-d H:i:s'),
			'updated_by' => $user_id1
		);	

		$this->db->where('id', $ID);
		$this->db->update('acc_journal_detail', $data);

		redirect('journal_controller/journal_detail/'.$menuid.'/'.$jID);
	}	

	public function edit_header($menuid)
	{
		$ID = $this->input->post('id');		
		$data_edit=$this->master_model->mst_edit_dr('acc_journal',$ID);
		
		echo'
			<form method="post" action="'.base_url().'journal_controller/edit_process_header/'.$menuid.'/'.$ID.'" enctype="multipart/form-data">
				<div class="modal-header">
				  <button type="button" class="close" data-dismiss="modal">&times;</button>
				  <h4 class="modal-title">Edit Journal Header</h4>
				</div>
				<div class="modal-body">				

					<div class="form-group">
						<label>Journal Date </label>
						<input type="date" name="journal_date"  class="form-control datepicker" value="'.$data_edit[0]->journal_date.'" >
					</div>

					<div class="form-group">
						<label>Journal Description</label>
						<input type="text" name="journal_desc" value="'.$data_edit[0]->journal_desc.'" class="form-control" >
					</div>

                </div>
				<div class="modal-footer">
					<input type="submit" class="btn btn-info btn-fill pull-right" value="Save" id="save">
					<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
				</div>
			</form>
		';
	}

	public function edit_process_header($menuid, $ID)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		
		$data = array(			
			'journal_date' => $this->input->post('journal_date'),
			'journal_desc' => $this->input->post('journal_desc'),
			'updated_at' => date('Y-m-d H:i:s'),
			'updated_by' => $user_id1
		);	

		$this->db->where('id', $ID);
		$this->db->update('acc_journal', $data);

		redirect('journal_controller/viewJournalDetail/'.$menuid);
	}	


	public function spend_header($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_header']   = $this->master_model->select_in('acc_journal','*',"WHERE 1 = 0");

			$this->load->view('spend_money/header', $data);
	    }
	}


	public function spend_header2($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
		$date1 = $this->input->post('from_date');
		$date2 = $this->input->post('to_date');

		if (empty($date1)){
			$date1 = $this->session->userdata('date1');
			$date2 = $this->session->userdata('date2');
		}

		$sql="delete from acc_journal_detail where debet_value = 0 and credit_value = 0;";
		$qry = $this->db->query($sql);

		$sql="delete from acc_journal where id not in (select journal_id from acc_journal_detail);";
		$qry = $this->db->query($sql);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_header']   = $this->transaksi_model->listSpendMoney($date1, $date2);

			$this->load->view('spend_money/header2', $data);
	    }
	}

	public function insert_spend_header($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$data = array(
			'journal_type' => 'CD',
			'journal_date' => $this->input->post('tgl1'),
			'journal_voucher' => '',
			'journal_desc' => $this->input->post('memo_header'),
			'created_at' => date('Y-m-d H:i:s'),
			'created_by' => $user_id1
		);	

		$this->db->insert('acc_journal', $data);
		
		$data_journal=$this->transaksi_model->getJournalID();
		$jID = $data_journal[0]->last_id;	

		$jDate = $this->input->post('tgl1');
		$jDate = substr($jDate,0,7);

		$data_voucher=$this->transaksi_model->genVoucherBank($jDate);
		$jVoucher = $data_voucher[0]->journal_voucher;

		$data = array(			
			'journal_voucher' => $jVoucher
		);	

		$this->db->where('id', $jID);
		$this->db->update('acc_journal', $data);

		$data = array(
			'detail_id' => 1,
			'journal_id' => $jID,
			'coa_id' => $this->input->post('id_coa'),
			'detail_desc' => '',
			'debet_value' => 0,
			'credit_value' => 0,
			'created_at' => date('Y-m-d H:i:s'),
			'created_by' => $user_id1
		);	
		
		$this->db->insert('acc_journal_detail', $data);		

		redirect('journal_controller/spend_detail/'.$menuid.'/'.$jID);

	}


	public function insert_spend_detail($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$amt = $this->input->post('amount');
		if ($amt > 0){
			$debet = $this->input->post('amount');
			$kredit = 0 ;
		}else{
			$debet = 0;
			$kredit = $this->input->post('amount') * -1; 
		}

		$jID = 	$this->input->post('id_header');

		$data = array(
			'detail_id' => 0,
			'journal_id' => $this->input->post('id_header'),
			'coa_id' => $this->input->post('coa_id'),
			'detail_desc' => $this->input->post('memo_detail'),
			'debet_value' => $debet,
			'credit_value' => $kredit,
			'created_at' => date('Y-m-d H:i:s'),
			'created_by' => $user_id1
		);	
		$this->db->insert('acc_journal_detail', $data);

		$sql="call update_spend ($jID);";
		$qry = $this->db->query($sql);				

		redirect('journal_controller/spend_detail/'.$menuid.'/'.$jID);
	}

	public function spend_detail($menuid, $jID)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_detail']   = $this->transaksi_model->listSpendDetail($jID);

			$this->load->view('spend_money/detail', $data);
	    }
	}


	// function list_transaksi_spend(){
    //     $header = $_GET['header'];
    //     echo "<table id='example1' class='table table-bordered table-striped'>
    //             <thead><tr><th>No</th><th>Acccount Code</th><th>Account Name</th><th>Amount</th><th>Memo</th><th>Delete</th></tr></thead>";
    //     $sql = "SELECT a.*, b.coa_code, b.coa_name, a.debet_value - a.credit_value as amount
    //             FROM acc_journal_detail a left join acc_coa b on a.coa_id=b.id
    //             WHERE a.journal_id=$header and a.detail_id = 0 order by a.id" ;
        
    //     $list = $this->db->query($sql)->result();
    //     $no=1;
    //     foreach ($list as $row){
    //         echo "<tr>
    //             <td>$no</td>
    //             <td>$row->coa_code</td>
    //             <td>$row->coa_name</td>
	// 			<td>$row->amount</td>
	// 			<td>$row->detail_desc</td>
    //             <td onClick='hapus($row->id)'><button class='btn btn-danger btn-sm'>Delete</button></td>
    //             </tr>";
    //         $no++;
    //     }
	// 	echo" </table>";
		
	// 	$total=$this->master_model->select_in('acc_journal_detail','*',"where journal_id = $header and detail_id = 1 ");
	// 	$cr = $total[0]->credit_value;

	// 	echo "<div class='col-xs-2'>";
	// 	echo "<div class='form-group'>";
		
	// 	echo "<label>TOTAL : </label> <input type='text' name='credit_value' class='form-control' value=".$cr." disabled>";
	// 	echo "</div>";
	// 	echo "</div>";
		
    // }

    // function delete_spend_detail(){
    //     $id = $_GET['id'];

	// 	$header = $this->master_model->mst_edit_dr('acc_journal_detail',$id);
	// 	$jID = $header[0]->journal_id;

	// 	$this->db->where('id',$id);
	// 	$this->db->delete('acc_journal_detail');

	// 	$sql="call update_spend ($jID);";
	// 	$qry = $this->db->query($sql);

	// }

	function delete_spend_detail($menuid, $id)
	{
		$header = $this->master_model->mst_edit_dr('acc_journal_detail',$id);
		$jID = $header[0]->journal_id;

		$this->db->where('id',$id);
		$this->db->delete('acc_journal_detail');
		
		$sql="call update_spend ($jID);";
		$qry = $this->db->query($sql);

		redirect('journal_controller/spend_detail/'.$menuid.'/'.$jID);		
	}

	public function edit_spend_detail($menuid)
	{
		$id= $this->input->post('id');

		$submit = $this->input->post('submit');
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		$admin = $this->session->userdata('username');

		$amt = $this->input->post('amount');
		if ($amt > 0){
			$debet = $this->input->post('amount');
			$kredit = 0 ;
		}else{
			$debet = 0;
			$kredit = $this->input->post('amount') * -1; 
		}

		$jID = $this->input->post('id_header');

		$data = array
		(		
			'coa_id' => $this->input->post('coa_id'),
			'detail_desc' => $this->input->post('memo_detail'),
			'debet_value' => $debet,
			'credit_value' => $kredit,
			'updated_at' => date('Y-m-d H:i:s'),
			'updated_by' => $user_id1			
		);
		$this->db->where('id', $id);
		$this->db->update('acc_journal_detail', $data);

		$sql="call update_spend ($jID);";
		$qry = $this->db->query($sql);

		if($submit==1)
		{
			redirect('journal_controller/spend_detail/'.$menuid.'/'.$jID);
	  }
	}	

	function delete_spend_money($menuid, $id)
	{
		$this->db->where('id',$id);
		$this->db->delete('acc_journal');

		$this->db->where('journal_id',$id);
		$this->db->delete('acc_journal_detail');
		
		redirect('journal_controller/spend_header2/'.$menuid);		
	}

	public function edit_spend_header($menuid)
	{
		$submit = $this->input->post('submit');
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		$admin = $this->session->userdata('username');

		$jID = $this->input->post('id_header');
		$coa = $this->input->post('id_coa');

		$data = array
		(		
			'journal_date' => $this->input->post('tgl1'),
			'journal_voucher' => $this->input->post('journal_voucher'),
			'journal_desc' => $this->input->post('memo_header'),
			'updated_at' => date('Y-m-d H:i:s'),
			'updated_by' => $user_id1			
		);
		$this->db->where('id', $jID);
		$this->db->update('acc_journal', $data);

		$sql="update acc_journal_detail set coa_id = $coa where journal_id = $jID and detail_id = 1 ;";
		$qry = $this->db->query($sql);

		if($submit==1)
		{
			redirect('journal_controller/spend_detail/'.$menuid.'/'.$jID);
	  }
	}	

	function print_cd(){
		$voucher = substr($this->uri->uri_string(3),28);

		$sql = "select a.*, b.coa_code, b.coa_name, c.journal_date, c.journal_voucher, c.journal_desc
			FROM acc_journal_detail a left join acc_coa b on a.coa_id=b.id
			left join acc_journal c on a.journal_id=c.id where c.journal_type = 'CD'
			and c.journal_voucher = '$voucher' order by a.journal_id, a.id";

		$rpt = $this->db->query($sql)->row_array();

		$this->load->library('pdf');
		$pdf = new FPDF('l', 'mm', 'A5');
		// membuat halaman baru
		$pdf->AddPage();
		// setting jenis font yang akan digunakan
		$pdf->SetFont('Arial', 'B', 11);
		$pdf->Cell(80, 12, 'Journal Voucher', 0, 1, 'l');

		$pdf->SetFont('Arial', '', 11);
		$pdf->Cell(30, 5, 'Date', 0, 0, 'l');
		$pdf->Cell(10, 5, ': ', 0, 0, 'l');
		$pdf->Cell(30, 5, date('F d Y', strtotime($rpt['journal_date'])), 0, 1, 'l');			
		$pdf->Cell(30, 5, 'Voucher #', 0, 0, 'l');
		$pdf->Cell(10, 5, ': ', 0, 0, 'l');
		$pdf->Cell(30, 5, $rpt['journal_voucher'], 0, 1, 'l');
		$pdf->Cell(30, 5, 'Memo', 0, 0, 'l');
		$pdf->Cell(10, 5, ': ', 0, 0, 'l');
		$pdf->Cell(30, 5, $rpt['journal_desc'], 0, 1, 'l');
		$pdf->Cell(10, 5, ' ', 0, 1, 'l');

		$pdf->SetFont('Arial', 'B', 10);
		// tabel detail
		$pdf->Cell(20, 5, 'Code ', 1, 0, 'C');
		$pdf->Cell(60, 5, 'Account Name ', 1, 0, 'C');
		$pdf->Cell(30, 5, 'Debit', 1, 0, 'C');
		$pdf->Cell(30, 5, 'Credit', 1, 0, 'C');
		$pdf->Cell(50, 5, 'Memo', 1, 1, 'C');

		$pdf->SetFont('Arial', '', 9);
		$jurnal = $this->db->query($sql)->result();
		foreach ($jurnal as $p){
		   $pdf->Cell(20, 6, $p->coa_code, 1, 0, 'L');
		   $pdf->Cell(60, 6, $p->coa_name, 1, 0, 'L');
		   $pdf->Cell(30, 6, number_format($p->debet_value,2), 1, 0, 'R');
		   $pdf->Cell(30, 6, number_format($p->credit_value,2), 1, 0, 'R');
		   $pdf->Cell(50, 6, $p->detail_desc, 1, 1, 'L');
	   		   
	    }
		
		$pdf->Output();
	}
	
}
?>
