<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class kunjungan extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('master_model');
		$this->load->model('kunjungan_model');
		date_default_timezone_set('Asia/Jakarta');
	}


	public function pengajuan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check = $this->master_model->auth_read($user_id, $menuid);
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {			
			$data['data_pengelola']   = $this->master_model->select_in('m_pengelola','*',"where id=$pengelola");
			$this->load->view('kunjungan/pengajuan', $data);
	    }
	}

	public function insert_pengajuan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('tgl_dinas'));
		$tgl_dinas = $date->format('Y-m-d');

		$startTimeValue = $this->input->post('jam_ijin_mulai');
		$startTimestamp = strtotime($startTimeValue);
		$endTimestamp = $startTimestamp + 4 * 60 * 60;
		$endTime = date('H:i', $endTimestamp);

        $staff=$this->input->post('id_pengelola');
        $getKadiv=$this->master_model->select_in('m_pengelola', '*', "WHERE id = $staff");
        if($getKadiv[0]->persetujuan_lembur==0){
            $tindakanKadiv = 1;
            $tglTindakanKadiv = $tgl_dinas;
        }else{
            $tindakanKadiv = 0;
            $tglTindakanKadiv = null;
        }

		$data = array(
			'id_pengelola' => $this->input->post('id_pengelola'),			
			'tgl_dinas' => $tgl_dinas,
			'jam_pergi' => $this->input->post('jam_pergi'),
			'jam_pulang' => $this->input->post('jam_pulang'),
			'is_anggota' => $this->input->post('is_anggota'),
			'nama_anggota' => $this->input->post('nama_anggota'),
			'keperluan' => $this->input->post('keperluan'),
			'lokasi_kunjungan' => $this->input->post('lokasi_kunjungan'),
			'tindakan_kadiv' => $tindakanKadiv,
			'tgl_tindakan_kadiv' => $tglTindakanKadiv,
			'create_at' => date('Y-m-d H:i:s'),
			'create_by' => $user_id1			
		);
		$this->db->insert('tr_permohonan_kunjungan', $data);
		
		$user_id = $this->session->userdata('user_id');
	    $check = $this->master_model->auth_read($user_id, $menuid);
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['modal_message'] = 'Pengajuan kunjungan anda berhasil di kirim dan akan di review oleh KADIV dan HRD';
			$data['data_pengelola']   = $this->master_model->select_in('m_pengelola','*',"where id=$pengelola");
			$this->load->view('kunjungan/pengajuan', $data);
	    }
	}	

	public function daftar_kunjungan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check = $this->master_model->auth_read($user_id, $menuid);
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;
		if(empty($pengelola)){
			$pengelola = 0;
		}

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_pengajuan']   = $this->kunjungan_model->pengajuan($pengelola);
			$this->load->view('kunjungan/data_pengajuan', $data);
	    }
	}

	public function update_pengajuan($menuid) {
		$user_id = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $user_id");
		$user_id1 = $data_admin[0]->name;
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;
								
        $id = $this->input->post('id');
		$persetujuan = $this->input->post('persetujuan_lembur');

		if($persetujuan==0){
			$data = array(
				'tindakan_hrd' => $this->input->post('tindakan'),
				'tgl_tindakan_hrd' => date('Y-m-d'),				
				'update_at' => date('Y-m-d H:i:s'),
				'update_by' => $user_id1			
			);

		} else {
			if($pengelola==0){
				$data = array(
					'tindakan_hrd' => $this->input->post('tindakan'),
					'tgl_tindakan_hrd' => date('Y-m-d'),				
					'update_at' => date('Y-m-d H:i:s'),
					'update_by' => $user_id1			
				);
			} else {
				$data = array(
					'tindakan_kadiv' => $this->input->post('tindakan'),
					'tgl_tindakan_kadiv' => date('Y-m-d'),
					'update_at' => date('Y-m-d H:i:s'),
					'update_by' => $user_id1			
				);
	
			}	
		}
		
		
		$this->db->where('id', $id);
		$this->db->update('tr_permohonan_kunjungan', $data);

		redirect('kunjungan/daftar_kunjungan/'.$menuid);

	}

	public function riwayat_kunjungan($menuid)
	{		
		$user_id = $this->session->userdata('user_id');
	    $check = $this->master_model->auth_read($user_id, $menuid);
		$msuser = $this->master_model->select_in('user','*',"where ID=$user_id");
		$pengelola = $msuser[0]->id_pengelola;
		if(empty($pengelola)){
			$pengelola = 0;
		}
		
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
			$data['data_pengajuan']   = $this->kunjungan_model->riwayat_pengajuan($pengelola);
			$this->load->view('kunjungan/riwayat_pengajuan', $data);
	    }
	}
	
	public function laporan_kunjungan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);
	
	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_kunjungan']   = $this->master_model->select_in('tr_absen','*',"where 1=0");
			$this->load->view('kunjungan/laporan_kunjungan', $data);
	    }
	}

	public function detail_lap_kunjungan($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][tanggal1]'));
		$tanggal1 = $date->format('Y-m-d');
		
		$date = DateTime::createFromFormat('d/m/Y', $this->input->post('group-b[0][tanggal2]'));
		$tanggal2 = $date->format('Y-m-d');

		if (empty($tanggal1)){
			$tanggal1 = $this->session->userdata('tanggal1');
			$tanggal2 = $this->session->userdata('tanggal2');
		}

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_kunjungan']   = $this->kunjungan_model->kunjungan($tanggal1, $tanggal2);
			$this->load->view('kunjungan/detail_kunjungan', $data);
	    }
	}

	public function excel_kunjungan($menuid, $tanggal1, $tanggal2)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_kunjungan']   = $this->kunjungan_model->kunjungan($tanggal1, $tanggal2);
			$this->load->view('kunjungan/excel_kunjungan', $data);
	    }
	}

}
?>
