<?php

class pinjaman_model extends CI_Model

{

	function __construct()

	{

        parent::__construct();

    }

	public function pengajuanPinjaman()
	{
	  $sql ="
			  SELECT a.*, b.no_anggota, b.nama_anggota FROM pengajuan_pinjaman a
			  LEFT JOIN anggota b on a.id_anggota=b.id ORDER BY a.no_rkp
		   ";
	  
		  $qry = $this->db->query($sql);
		  $row = $qry->result();
		  return $row;
	  }

	  public function fasilitas($id)
	  {
		$sql ="
				select a.*, b.tipe_pinjaman, b.keterangan, c.perhitungan_bunga from fasilitas_pinjaman a left join tipe_pinjaman b on 
				a.id_jenis_pinjaman=b.id left join perhitungan_bunga c on a.id_perhitungan_bunga=c.id
				where a.id_pengajuan = $id ORDER BY a.id 
			 ";
		
			$qry = $this->db->query($sql);
			$row = $qry->result();
			return $row;
		}

	public function jaminan($id)
	{
		$sql ="
				SELECT a.*, b.no_rkp, c.no_anggota, c.nama_anggota, d.jenis_jaminan
				FROM jaminan_pinjaman_header a left join pengajuan_pinjaman b
				on a.id_pengajuan=b.id left join anggota c
				on b.id_anggota=c.id left join jenis_jaminan d
				on a.id_jenis_jaminan = d.id
				where a.id_pengajuan = $id ORDER BY a.id 
			";
		
			$qry = $this->db->query($sql);
			$row = $qry->result();
			return $row;
		}

	public function jaminanDetail($id)
	{
		$sql ="
			SELECT a.*, c.jenis_jaminan
			FROM jaminan_pinjaman_detail a left join jaminan_pinjaman_header b
			on a.id_header=b.id left join jenis_jaminan c
			on a.id_jenis_jaminan=c.id 
			where a.id_header = $id ORDER BY a.id 
		";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

	public function getLastID()
	
	{
		$sql="
			select max(id) as last_id from pengajuan_pinjaman;		
		";

		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

	function spViewBiaya($id)
	{

		$query = $this->db->query("CALL sp_biaya($id)");
		mysqli_next_result( $this->db->conn_id);
		return $query->result();		
	}
	
	public function getLastIDJaminan()
	
	{
		$sql="
			select max(id) as last_id from jaminan_pinjaman_header;		
		";

		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

    public function getLastIDPendapatan()
	
	{
		$sql="
			select max(id) as last_id from pendapatan_usaha_header;		
		";

		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

	public function getLastIDRek()
	
	{
		$sql="
			select max(id) as last_id from rekening_header;	
		";

		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

	public function getLastIDSurvey()
	
	{
		$sql="
			select max(id) as last_id from survey_nilai_pasar_header;	
		";

		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

	public function nilaiPasar($id)
	{
		$sql ="
			SELECT a.*, b.satuan as satuan_descr
			FROM jaminan_nilai_pasar a left join mst_satuan b
			on a.id_satuan=b.id where a.id_header = $id 
		";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

	public function surveyNilaiPasar($id)
	{
		$sql ="
		SELECT b.*, a.id as id1, a.id_header, a.nama_situs, a.alamat, a.footer, a.taksasi, a.harga_sekarang, c.satuan, d.jaminan as keterangan,
		(select sum(total) from survey_nilai_pasar_detail where id_survey = b.id_survey) as grand_total
		FROM survey_nilai_pasar_header a left join survey_nilai_pasar_detail b on
		a.id=b.id_survey left join mst_satuan c on b.id_satuan=c.id
		left join mst_jaminan d on b.id_jaminan=d.id
		where a.id_header = $id and a.footer = 'Tidak' ORDER BY b.id_survey, b.id
		";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

	public function surveyNilaiPasarFooter($id)
	{
		$sql ="
		SELECT b.*, a.id as id1, a.id_header, a.nama_situs, a.alamat, a.footer, a.taksasi, a.harga_sekarang, c.satuan, d.jaminan as keterangan,
		(select sum(total) from survey_nilai_pasar_detail where id_survey = b.id_survey) as grand_total
		FROM survey_nilai_pasar_header a left join survey_nilai_pasar_detail b on
		a.id=b.id_survey left join mst_satuan c on b.id_satuan=c.id
		left join mst_jaminan d on b.id_jaminan=d.id
		where a.id_header = $id and a.footer = 'Ya' and a.harga_sekarang = 'Tidak' ORDER BY b.id_survey, b.id
		";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

	public function surveyNilaiPasarNow($id)
	{
		$sql ="
		SELECT b.*, a.id as id1, a.id_header, a.nama_situs, a.alamat, a.footer, a.taksasi, a.harga_sekarang, c.satuan, d.jaminan as keterangan,
		(select sum(total) from survey_nilai_pasar_detail where id_survey = b.id_survey) as grand_total
		FROM survey_nilai_pasar_header a left join survey_nilai_pasar_detail b on
		a.id=b.id_survey left join mst_satuan c on b.id_satuan=c.id
		left join mst_jaminan d on b.id_jaminan=d.id
		where a.id_header = $id and a.footer = 'Ya' and a.harga_sekarang = 'Ya' ORDER BY b.id_survey, b.id
		";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

	public function surveyNilaiPasarRata($id)
	{
		$sql ="
		SELECT 'Harga Rata Rata' as ket, b.id_jaminan, c.jaminan, sum(b.harga) / count(id_jaminan) as rata2
		FROM survey_nilai_pasar_header a left join survey_nilai_pasar_detail b on
		a.id=b.id_survey left join mst_jaminan c on b.id_jaminan=c.id
		where a.id_header = $id and a.footer = 'Tidak' group by b.id_jaminan, c.jaminan
		";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}

	public function surveyNilaiPasarDetail($id)
	{
		$sql ="
			SELECT a.*, b.satuan as satuan_descr, c.jaminan as keterangan
			FROM survey_nilai_pasar_detail a left join mst_satuan b
			on a.id_satuan=b.id left join mst_jaminan c on a.id_jaminan=c.id
			where a.id_survey = $id ORDER BY a.id 
		";
	
		$qry = $this->db->query($sql);
		$row = $qry->result();
		return $row;
	}
	
	public function biayaPP($id)
	{
	  $sql ="
		  SELECT a.*, b.jenis_biaya_pp as jenis_biaya_pp_d FROM biaya_pp a
		  LEFT JOIN mst_biaya_pp b on a.jenis_biaya_pp=b.id 
		  where a.id_pengajuan = $id ORDER BY a.id
	   ";
  
	  $qry = $this->db->query($sql);
	  $row = $qry->result();
	  return $row;
    }
    
    public function pengajuanPinjamanLegal()
	  {
		$sql ="
				SELECT a.*, b.no_anggota, b.nama_anggota FROM pengajuan_pinjaman a
				LEFT JOIN anggota b on a.id_anggota=b.id where a.send_to_legal = 1 ORDER BY a.no_rkp
			 ";
		
			$qry = $this->db->query($sql);
			$row = $qry->result();
			return $row;
		}

		public function pengajuanPinjamanKabag()
		{
		  $sql ="
				  SELECT a.*, b.no_anggota, b.nama_anggota FROM pengajuan_pinjaman a
				  LEFT JOIN anggota b on a.id_anggota=b.id where a.send_to_kabag = 1 ORDER BY a.no_rkp
			   ";
		  
			  $qry = $this->db->query($sql);
			  $row = $qry->result();
			  return $row;
		  }

		public function pengajuanPinjamanAdmin()
		{
		$sql ="
				SELECT a.*, b.no_anggota, b.nama_anggota FROM pengajuan_pinjaman a
				LEFT JOIN anggota b on a.id_anggota=b.id where a.send_to_admin = 1 ORDER BY a.no_rkp
				";
		
			$qry = $this->db->query($sql);
			$row = $qry->result();
			return $row;
		}

	public function pdf($id)
	
	{

		$sql="

			SELECT * FROM dokumen_legal
			WHERE id = $id			
	
		";

		$qry = $this->db->query($sql);

		$row = $qry->result();

		return $row;

	}
}

?>
