-- phpMyAdmin SQL Dump
-- version 4.8.3
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Dec 12, 2023 at 10:48 AM
-- Server version: 10.1.37-MariaDB
-- PHP Version: 7.1.24

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `hris`
--

DELIMITER $$
--
-- Procedures
--
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_gen_voucher` (`cPrd` VARCHAR(7), `cType` VARCHAR(1))  BEGIN
	declare voucher varchar(8) ;

	select SUBSTR(journal_voucher,6,3) into voucher From acc_journal where left(journal_date,7) = cPrd and left(journal_voucher,1) = cType 
		order by journal_voucher desc limit 1;

	set @hitung := voucher;

	if @hitung is null THEN
		set @hasil := (select concat(cType,SUBSTR(cPrd,6,2),SUBSTR(cPrd,3,2),'001') );
	else 
		set @hasil := (select concat(cType,SUBSTR(cPrd,6,2),SUBSTR(cPrd,3,2),concat(REPEAT('0', 3-LENGTH(cast(@hitung as UNSIGNED INTEGER) + 1)),cast(@hitung as UNSIGNED INTEGER) + 1)));	
	end if;

	select @hasil as journal_voucher;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_get_level_struktur` (`nCoaID` INT)  BEGIN 
	declare nParent, nLevel, nID int;
	declare cPath, coaCode varchar(150);
	
	SELECT struktur_parent into nParent from m_jabatan where id = nCoaID;
	select kode_struktur into cPath from m_jabatan where id = nCoaID;

	set nLevel = 0;

	WHILE nParent <> 0 do
		set nID = nParent;
		
		SELECT struktur_parent into nParent from m_jabatan where id = nID;
		select kode_struktur into coaCode from m_jabatan where id = nID;

		set nLevel = nLevel + 1;
		set cPath = concat(coaCode,'/',cPath);
	END WHILE;

	DROP TEMPORARY TABLE IF EXISTS temp;
	CREATE TEMPORARY TABLE temp
		select id From m_jabatan where id in (select struktur_parent from m_jabatan);

	update m_jabatan set is_header = 0;
	update m_jabatan set is_header = 1 where struktur_parent = 0;
	update m_jabatan set is_header = 1 where id in (select id from temp);
	update m_jabatan set struktur_level = nLevel, struktur_path = cPath where id = nCoaID;

	select nLevel as level, cPath as coaPath;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_hitung_lama_cuti` (`dt1` DATE, `dt2` DATE)  BEGIN	
	set @dt:=dt1; 
	set @hari:=0;
	
	WHILE @dt <= dt2 DO	
					
		/*Fungsi WEEKDAY() mengembalikan nomor hari kerja untuk tanggal tertentu.*/
		/*Catatan: 0 = Senin, 1 = Selasa, 2 = Rabu, 3 = Kamis, 4 = Jumat, 5 = Sabtu, 6 = Minggu.*/

		set @libur = (select count(tanggal) as libur from m_detail_kebijakan_cuti where tanggal = @dt);
		if @libur = 1 or weekday(@dt)=5 or weekday(@dt)=6 then
			set @hari = @hari + 0;
		ELSE
			set @hari = @hari + 1;
		end if;

		set @dt = (select date_add(@dt, interval 1 day));
		
	END WHILE;

	select @hari as hari;

END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `acc_coa`
--

CREATE TABLE `acc_coa` (
  `id` int(11) NOT NULL,
  `coa_code` varchar(10) NOT NULL,
  `coa_name` varchar(150) NOT NULL,
  `coa_type` int(11) NOT NULL,
  `coa_parent` int(11) NOT NULL DEFAULT '0',
  `coa_level` int(11) NOT NULL,
  `coa_path` varchar(250) NOT NULL,
  `begining_balance` decimal(18,2) NOT NULL,
  `header_account` varchar(20) NOT NULL,
  `coa_group` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  `created_by` varchar(10) NOT NULL,
  `updated_at` datetime NOT NULL,
  `updated_by` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `acc_coa`
--

INSERT INTO `acc_coa` (`id`, `coa_code`, `coa_name`, `coa_type`, `coa_parent`, `coa_level`, `coa_path`, `begining_balance`, `header_account`, `coa_group`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES
(1, '1-0000', 'Assets', 1, 0, 0, '1-0000', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(2, '1-1000', 'Current Assets', 1, 1, 1, '1-0000/1-1000', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(3, '1-1100', 'Cash On Hand', 1, 2, 2, '1-0000/1-1000/1-1100', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(4, '1-1101', 'Checking Account', 1, 3, 3, '1-0000/1-1000/1-1100/1-1101', '0.00', '0', 1, '0000-00-00 00:00:00', '', '2022-04-22 16:49:03', 'Admin'),
(5, '1-1102', 'Payroll Checking Account', 1, 3, 3, '1-0000/1-1000/1-1100/1-1102', '0.00', '0', 1, '0000-00-00 00:00:00', '', '2022-04-22 16:49:11', 'Admin'),
(6, '1-1103', 'Cash Drawer', 1, 3, 3, '1-0000/1-1000/1-1100/1-1103', '0.00', '0', 2, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(7, '1-1104', 'Petty Cash', 1, 3, 3, '1-0000/1-1000/1-1100/1-1104', '0.00', '0', 2, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(8, '1-1105', 'Undeposited Funds', 1, 3, 3, '1-0000/1-1000/1-1100/1-1105', '0.00', '0', 1, '0000-00-00 00:00:00', '', '2022-04-22 16:49:19', 'Admin'),
(9, '1-1106', 'Electronic Clearing Account', 1, 3, 3, '1-0000/1-1000/1-1100/1-1106', '0.00', '0', 1, '0000-00-00 00:00:00', '', '2022-04-22 16:49:27', 'Admin'),
(10, '1-1107', 'Bank BCA', 1, 3, 3, '1-0000/1-1000/1-1100/1-1107', '0.00', '0', 2, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(11, '1-1108', 'Bank Mandiri', 1, 3, 3, '1-0000/1-1000/1-1100/1-1108', '0.00', '0', 2, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(12, '1-1200', 'Account Receivable', 1, 2, 2, '1-0000/1-1000/1-1200', '0.00', '0', 4, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(13, '1-1300', 'Proceed Material Inventory', 1, 2, 2, '1-0000/1-1000/1-1300', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(14, '1-1400', 'Raw Material Inventory', 1, 2, 2, '1-0000/1-1000/1-1400', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(15, '1-1500', 'Work In Process Material Inventory', 1, 2, 2, '1-0000/1-1000/1-1500', '0.00', '0', 1, '0000-00-00 00:00:00', '', '2022-04-22 16:37:10', 'Admin'),
(16, '1-2000', 'Other Assets', 1, 1, 1, '1-0000/1-2000', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(17, '1-2100', 'Deposits Paid', 1, 16, 2, '1-0000/1-2000/1-2100', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(18, '1-2200', 'Prepaid Expenses', 1, 16, 2, '1-0000/1-2000/1-2200', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(19, '1-3000', 'Property, Plant & Equipment', 1, 1, 1, '1-0000/1-3000', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(20, '1-3100', 'Mining Equipment', 1, 19, 2, '1-0000/1-3000/1-3100', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(21, '1-3110', 'Agricultural Equipment Org Cos', 1, 20, 3, '1-0000/1-3000/1-3100/1-3110', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(22, '1-3120', 'Agricultural Equip. Accum Dep', 1, 20, 3, '1-0000/1-3000/1-3100/1-3120', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(23, '1-3200', 'Office Equipment', 1, 19, 2, '1-0000/1-3000/1-3200', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(24, '1-3210', 'Office Equipment Org Cost', 1, 23, 3, '1-0000/1-3000/1-3200/1-3210', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(25, '1-3220', 'Office Equipment Accum Dep', 1, 23, 3, '1-0000/1-3000/1-3200/1-3220', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(26, '1-3300', 'Vehicles Owned', 1, 19, 2, '1-0000/1-3000/1-3300', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(27, '1-3310', 'Vehicles Original Cost', 1, 26, 3, '1-0000/1-3000/1-3300/1-3310', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(28, '1-3320', 'Vehicles Accum Dep', 1, 26, 3, '1-0000/1-3000/1-3300/1-3320', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(29, '1-3400', 'Buildings', 1, 19, 2, '1-0000/1-3000/1-3400', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(30, '1-3410', 'Vehicles Original Cost', 1, 29, 3, '1-0000/1-3000/1-3400/1-3410', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(31, '1-3420', 'Vehicles Accum Dep', 1, 29, 3, '1-0000/1-3000/1-3400/1-3420', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(32, '2-0000', 'Liabilities', 2, 0, 0, '2-0000', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(33, '2-1000', 'Current Liabilities', 2, 32, 1, '2-0000/2-1000', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(34, '2-1100', 'Credit Cards', 2, 33, 2, '2-0000/2-1000/2-1100', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(35, '2-1101', 'American Express', 2, 34, 3, '2-0000/2-1000/2-1100/2-1101', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(36, '2-1102', 'MasterCard', 2, 34, 3, '2-0000/2-1000/2-1100/2-1102', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(37, '2-1103', 'Visa', 2, 34, 3, '2-0000/2-1000/2-1100/2-1103', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(38, '2-1200', 'Accounts Payable', 2, 33, 2, '2-0000/2-1000/2-1200', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(39, '2-1210', 'A/P Accrual - Inventory', 2, 33, 2, '2-0000/2-1000/2-1210', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(40, '2-1300', 'Sales Tax Payable', 2, 33, 2, '2-0000/2-1000/2-1300', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(41, '2-1310', 'Import Duty Payable', 2, 33, 2, '2-0000/2-1000/2-1310', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(42, '2-1400', 'Payroll Withholding', 2, 33, 2, '2-0000/2-1000/2-1400', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(43, '2-1410', 'Default Payroll Withholding', 2, 42, 3, '2-0000/2-1000/2-1400/2-1410', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(44, '2-1420', 'Federal Income Tax Payable', 2, 42, 3, '2-0000/2-1000/2-1400/2-1420', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(45, '2-1430', 'FMed/FSoc Payable', 2, 42, 3, '2-0000/2-1000/2-1400/2-1430', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(46, '2-1440', 'FUTA Payable', 2, 42, 3, '2-0000/2-1000/2-1400/2-1440', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(47, '2-1450', 'State Income Tax Payable', 2, 42, 3, '2-0000/2-1000/2-1400/2-1450', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(48, '2-1460', 'SUI/SDI Payable', 2, 42, 3, '2-0000/2-1000/2-1400/2-1460', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(49, '2-1500', 'Accrued Employer Expenses', 2, 33, 2, '2-0000/2-1000/2-1500', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(50, '2-1600', 'Deposits Collected', 2, 33, 2, '2-0000/2-1000/2-1600', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(51, '2-1700', 'Other Current Liabilities', 2, 33, 2, '2-0000/2-1000/2-1700', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(52, '2-2000', 'Long-Term Liabilities', 2, 32, 1, '2-0000/2-2000', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(53, '2-2100', 'Bank Loans', 2, 52, 2, '2-0000/2-2000/2-2100', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(54, '2-2200', 'Other Long-Term Liabilities', 2, 52, 2, '2-0000/2-2000/2-2200', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(55, '3-0000', 'Equity', 3, 0, 0, '3-0000', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(56, '3-1000', 'Owner\'s Equity', 3, 55, 1, '3-0000/3-1000', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(57, '3-1100', 'Owner\'s Investment', 3, 56, 2, '3-0000/3-1000/3-1100', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(58, '3-1200', 'Owner\'s Withdrawal', 3, 56, 2, '3-0000/3-1000/3-1200', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(59, '3-7000', 'Retained Earnings', 3, 55, 1, '3-0000/3-7000', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(60, '3-8000', 'Current Year Earnings', 3, 55, 1, '3-0000/3-8000', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(61, '3-9000', 'Historical Balancing', 3, 55, 1, '3-0000/3-9000', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(62, '4-0000', 'Income', 4, 0, 0, '4-0000', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(63, '4-1000', 'Sales', 4, 62, 1, '4-0000/4-1000', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(64, '4-1001', 'Maining Sales Income', 4, 63, 2, '4-0000/4-1000/4-1001', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(65, '4-1002', 'tin chemical Sales Income', 4, 63, 2, '4-0000/4-1000/4-1002', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(66, '4-1003', 'shipbuilding services Income', 4, 63, 2, '4-0000/4-1000/4-1003', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(67, '4-1004', 'exploration services Income', 4, 63, 2, '4-0000/4-1000/4-1004', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(68, '4-1005', 'electrical and repair services Income', 4, 63, 2, '4-0000/4-1000/4-1005', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(69, '4-1006', 'Government Subsidies', 4, 63, 2, '4-0000/4-1000/4-1006', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(70, '4-1007', 'Late Fees Collected', 4, 63, 2, '4-0000/4-1000/4-1007', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(71, '5-0000', 'Cost of Sales', 5, 0, 0, '5-0000', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(72, '5-1000', 'Cost of Sales Maining ', 5, 71, 1, '5-0000/5-1000', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(73, '5-2000', 'Cost of Sales Chemical', 5, 71, 1, '5-0000/5-2000', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(74, '5-3000', 'Freight', 5, 71, 1, '5-0000/5-3000', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(75, '5-4000', 'Inderect Cost', 5, 71, 1, '5-0000/5-4000', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(76, '5-4001', 'Employee Cost ', 5, 75, 2, '5-0000/5-4000/5-4001', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(77, '5-4002', 'Electricity', 5, 75, 2, '5-0000/5-4000/5-4002', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(78, '5-4003', 'Equipment Depreciation', 5, 75, 2, '5-0000/5-4000/5-4003', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(79, '6-0000', 'Expenses', 6, 0, 0, '6-0000', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(80, '6-1000', 'Purchases for Resale', 6, 79, 1, '6-0000/6-1000', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(81, '6-1001', 'Advertising', 6, 79, 1, '6-0000/6-1001', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(82, '6-1002', 'Depreciation Expense', 6, 79, 1, '6-0000/6-1002', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(83, '6-1003', 'Dues & Subscriptions', 6, 79, 1, '6-0000/6-1003', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(84, '6-1004', 'Equipment Rental', 6, 79, 1, '6-0000/6-1004', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(85, '6-1005', 'Other Supplies', 6, 79, 1, '6-0000/6-1005', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(86, '6-1006', 'Insurance', 6, 79, 1, '6-0000/6-1006', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(87, '6-1007', 'Late Fees Paid', 6, 79, 1, '6-0000/6-1007', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(88, '6-1008', 'Legal & Accounting', 6, 79, 1, '6-0000/6-1008', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(89, '6-1009', 'License Fees', 6, 79, 1, '6-0000/6-1009', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(90, '6-1010', 'Maintenance', 6, 79, 1, '6-0000/6-1010', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(91, '6-1011', 'Office Supplies', 6, 79, 1, '6-0000/6-1011', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(92, '6-1012', 'Postage & Shipping', 6, 79, 1, '6-0000/6-1012', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(93, '6-1013', 'Rent', 6, 79, 1, '6-0000/6-1013', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(94, '6-1014', 'Repairs', 6, 79, 1, '6-0000/6-1014', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(95, '6-1015', 'Shrinkage/Spoilage', 6, 79, 1, '6-0000/6-1015', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(96, '6-1016', 'Storage', 6, 79, 1, '6-0000/6-1016', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(97, '6-1017', 'Telephone', 6, 79, 1, '6-0000/6-1017', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(98, '6-1018', 'Travel & Entertainment', 6, 79, 1, '6-0000/6-1018', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(99, '6-1019', 'Vet/Medical', 6, 79, 1, '6-0000/6-1019', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(100, '6-2000', 'Payroll', 6, 79, 1, '6-0000/6-2000', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(101, '6-2001', 'Wages', 6, 100, 2, '6-0000/6-2000/6-2001', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(102, '6-2002', 'Vacation Pay Expense', 6, 100, 2, '6-0000/6-2000/6-2002', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(103, '6-2003', 'Employer Expenses', 6, 100, 2, '6-0000/6-2000/6-2003', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(104, '6-3000', 'Utilities', 6, 79, 1, '6-0000/6-3000', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(105, '6-3001', 'Electric', 6, 104, 2, '6-0000/6-3000/6-3001', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(106, '6-3002', 'Heating Fuel', 6, 104, 2, '6-0000/6-3000/6-3002', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(107, '6-3003', 'Water', 6, 104, 2, '6-0000/6-3000/6-3003', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(108, '6-4000', 'Utilities', 6, 79, 1, '6-0000/6-4000', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(109, '6-4001', 'Gasoline', 6, 108, 2, '6-0000/6-4000/6-4001', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(110, '6-4002', 'Vehicle Maintenance', 6, 108, 2, '6-0000/6-4000/6-4002', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(111, '8-0000', 'Other Income', 7, 0, 0, '8-0000', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(112, '8-1000', 'Interest Income', 7, 111, 1, '8-0000/8-1000', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(113, '9-0000', 'Other Expenses', 8, 0, 0, '9-0000', '0.00', '1', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(114, '9-1000', 'Interest Expense', 8, 113, 1, '9-0000/9-1000', '0.00', '0', 1, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(115, '1-1301', 'Ilmenite', 1, 13, 3, '1-0000/1-1000/1-1300/1-1301', '0.00', '0', 1, '2022-04-01 10:47:23', 'Admin', '0000-00-00 00:00:00', ''),
(116, '1-1302', 'Timah', 1, 13, 3, '1-0000/1-1000/1-1300/1-1302', '0.00', '0', 1, '2022-04-01 10:47:58', 'Admin', '0000-00-00 00:00:00', ''),
(117, '1-1303', 'Zircon', 1, 13, 3, '1-0000/1-1000/1-1300/1-1303', '0.00', '0', 1, '2022-04-01 10:48:23', 'Admin', '0000-00-00 00:00:00', ''),
(118, '1-1304', 'Monazite', 1, 13, 3, '1-0000/1-1000/1-1300/1-1304', '0.00', '0', 1, '2022-04-01 10:48:59', 'Admin', '0000-00-00 00:00:00', '');

-- --------------------------------------------------------

--
-- Table structure for table `acc_journal`
--

CREATE TABLE `acc_journal` (
  `id` int(11) NOT NULL,
  `journal_type` varchar(2) NOT NULL,
  `journal_date` date NOT NULL,
  `journal_voucher` varchar(20) NOT NULL,
  `journal_desc` varchar(250) NOT NULL,
  `id_purchase` int(11) NOT NULL,
  `id_sales` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  `created_by` varchar(10) NOT NULL,
  `updated_at` datetime NOT NULL,
  `updated_by` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `acc_journal`
--

INSERT INTO `acc_journal` (`id`, `journal_type`, `journal_date`, `journal_voucher`, `journal_desc`, `id_purchase`, `id_sales`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES
(323, 'GJ', '2023-10-06', 'J1023001', 'tes', 0, 0, '2023-10-09 17:22:44', 'Admin', '0000-00-00 00:00:00', ''),
(324, 'GJ', '2023-10-08', 'J1023002', 'jurnal2', 0, 0, '2023-10-09 22:06:18', 'Admin', '0000-00-00 00:00:00', ''),
(325, 'GJ', '2023-10-07', 'J1023003', 'tes', 0, 0, '2023-10-10 10:19:12', 'Admin', '0000-00-00 00:00:00', ''),
(326, 'GJ', '2023-10-14', 'J1023004', 'tes', 0, 0, '2023-10-10 17:48:45', 'Admin', '0000-00-00 00:00:00', ''),
(327, 'GJ', '2023-10-15', 'J1023005', 'tes', 0, 0, '2023-10-10 17:52:35', 'Admin', '0000-00-00 00:00:00', ''),
(328, 'GJ', '2023-10-15', 'J1023006', 'tes jurnal baru', 0, 0, '2023-10-10 17:54:03', 'Admin', '0000-00-00 00:00:00', ''),
(329, 'GJ', '2023-10-16', 'J1023007', 'tes jurnal baru', 0, 0, '2023-10-10 17:54:36', 'Admin', '0000-00-00 00:00:00', ''),
(330, 'GJ', '2023-10-16', 'J1023008', 'tes jurnal baru', 0, 0, '2023-10-10 18:10:06', 'Admin', '0000-00-00 00:00:00', ''),
(331, 'GJ', '2023-10-16', 'J1023009', 'tes jurnal baru', 0, 0, '2023-10-10 18:10:27', 'Admin', '0000-00-00 00:00:00', ''),
(332, 'GJ', '2023-10-16', 'J1023010', 'tes jurnal baru', 0, 0, '2023-10-10 18:10:57', 'Admin', '0000-00-00 00:00:00', ''),
(333, 'GJ', '2023-10-24', 'J1023011', 'tes', 0, 0, '2023-10-10 18:11:24', 'Admin', '0000-00-00 00:00:00', ''),
(342, 'PJ', '2023-10-22', 'P1023001', 'Terima Invoice Pembelian : 231022.IV0001', 10, 0, '2023-10-24 09:14:40', 'Admin', '0000-00-00 00:00:00', ''),
(343, 'PJ', '2023-10-22', 'P1023002', 'Terima Invoice Pembelian : 231022.IV0001', 10, 0, '2023-10-24 09:32:41', 'Admin', '0000-00-00 00:00:00', ''),
(344, 'PJ', '2023-10-22', 'P1023003', 'Terima Invoice Pembelian : 231022.IV0001', 10, 0, '2023-10-24 09:35:48', 'Admin', '0000-00-00 00:00:00', ''),
(345, 'PJ', '2023-10-20', 'P1023004', 'Terima Invoice Pembelian : 231020.IV0002', 11, 0, '2023-10-24 09:44:52', 'Admin', '0000-00-00 00:00:00', ''),
(346, 'PJ', '2023-10-20', 'P1023005', 'Terima Invoice Pembelian : 231020.IV0002', 11, 0, '2023-10-24 09:45:15', 'Admin', '0000-00-00 00:00:00', ''),
(347, 'PJ', '2023-10-20', 'P1023006', 'Terima Invoice Pembelian : 231020.IV0002', 11, 0, '2023-10-24 09:45:51', 'Admin', '0000-00-00 00:00:00', ''),
(348, 'PJ', '2023-10-23', 'P1023007', 'Terima Invoice Pembelian : 231023.IV0003', 12, 0, '2023-10-24 09:46:35', 'Admin', '0000-00-00 00:00:00', ''),
(349, 'PJ', '2023-10-23', 'P1023008', 'Terima Invoice Pembelian : 231023.IV0003', 12, 0, '2023-10-24 09:47:34', 'Admin', '0000-00-00 00:00:00', ''),
(350, 'PJ', '2023-10-23', 'P1023009', 'Terima Invoice Pembelian : 231023.IV0003', 12, 0, '2023-10-24 09:48:50', 'Admin', '0000-00-00 00:00:00', ''),
(351, 'PJ', '2023-10-23', 'P1023010', 'Terima Invoice Pembelian : 231023.IV0003', 12, 0, '2023-10-24 09:50:03', 'Admin', '0000-00-00 00:00:00', ''),
(352, 'PJ', '2023-10-23', 'P1023011', 'Terima Invoice Pembelian : 231023.IV0003', 12, 0, '2023-10-24 09:57:21', 'Admin', '0000-00-00 00:00:00', ''),
(353, 'PJ', '2023-10-23', 'P1023012', 'Terima Invoice Pembelian : 231023.IV0003', 12, 0, '2023-10-24 09:57:53', 'Admin', '0000-00-00 00:00:00', ''),
(354, 'PJ', '2023-10-23', 'P1023013', 'Terima Invoice Pembelian : 231023.IV0003', 12, 0, '2023-10-24 09:58:06', 'Admin', '0000-00-00 00:00:00', ''),
(355, 'PJ', '2023-10-20', 'P1023014', 'Terima Invoice Pembelian : 231020.IV0002', 11, 0, '2023-10-24 10:14:52', 'Admin', '0000-00-00 00:00:00', ''),
(356, 'PJ', '2023-10-20', 'P1023015', 'Terima Invoice Pembelian : 231020.IV0002', 11, 0, '2023-10-24 10:19:13', 'Admin', '0000-00-00 00:00:00', ''),
(357, 'PJ', '2023-10-22', 'P1023016', 'Terima Invoice Pembelian : 231022.IV0001', 10, 0, '2023-10-24 10:24:52', 'Admin', '0000-00-00 00:00:00', ''),
(358, 'PJ', '2023-10-22', 'P1023017', 'Terima Invoice Pembelian : 231022.IV0001', 10, 0, '2023-10-24 10:26:32', 'Admin', '0000-00-00 00:00:00', ''),
(359, 'PJ', '2023-10-22', 'P1023018', 'Terima Invoice Pembelian : 231022.IV0001', 10, 0, '2023-10-24 10:29:26', 'Admin', '0000-00-00 00:00:00', ''),
(360, 'PJ', '2023-10-22', 'P1023019', 'Terima Invoice Pembelian : 231022.IV0001', 10, 0, '2023-10-24 10:33:34', 'Admin', '0000-00-00 00:00:00', ''),
(361, 'PJ', '2023-10-23', 'P1023020', 'Terima Invoice Pembelian : 231023.IV0003', 12, 0, '2023-10-24 10:33:39', 'Admin', '0000-00-00 00:00:00', ''),
(362, 'PJ', '2023-10-21', 'P1023021', 'Terima Invoice Pembelian : 231021.IV0004', 13, 0, '2023-10-24 10:57:04', 'Admin', '0000-00-00 00:00:00', '');

-- --------------------------------------------------------

--
-- Table structure for table `acc_journal_detail`
--

CREATE TABLE `acc_journal_detail` (
  `id` int(11) NOT NULL,
  `detail_id` int(11) NOT NULL,
  `journal_id` int(11) NOT NULL,
  `coa_id` int(11) NOT NULL,
  `detail_desc` varchar(250) NOT NULL,
  `debet_value` decimal(18,2) NOT NULL,
  `credit_value` decimal(18,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `created_by` varchar(10) NOT NULL,
  `updated_at` datetime NOT NULL,
  `updated_by` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `acc_journal_detail`
--

INSERT INTO `acc_journal_detail` (`id`, `detail_id`, `journal_id`, `coa_id`, `detail_desc`, `debet_value`, `credit_value`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES
(43, 1, 323, 4, '', '100000.00', '0.00', '2023-10-09 17:22:45', 'Admin', '0000-00-00 00:00:00', ''),
(44, 0, 323, 6, '', '0.00', '100000.00', '2023-10-09 17:22:45', 'Admin', '0000-00-00 00:00:00', ''),
(45, 1, 324, 7, '', '100000.00', '0.00', '2023-10-09 22:06:18', 'Admin', '0000-00-00 00:00:00', ''),
(46, 0, 324, 10, '', '0.00', '100000.00', '2023-10-09 22:06:18', 'Admin', '0000-00-00 00:00:00', ''),
(47, 1, 325, 7, '', '20000.00', '0.00', '2023-10-10 10:19:13', 'Admin', '0000-00-00 00:00:00', ''),
(48, 0, 325, 11, '', '0.00', '20000.00', '2023-10-10 10:19:13', 'Admin', '0000-00-00 00:00:00', ''),
(49, 1, 326, 4, '', '100000.00', '0.00', '2023-10-10 17:48:46', 'Admin', '0000-00-00 00:00:00', ''),
(50, 0, 326, 9, '', '0.00', '100000.00', '2023-10-10 17:48:46', 'Admin', '0000-00-00 00:00:00', ''),
(51, 1, 327, 4, '', '100000.00', '0.00', '2023-10-10 17:52:35', 'Admin', '0000-00-00 00:00:00', ''),
(52, 0, 327, 9, '', '0.00', '100000.00', '2023-10-10 17:52:35', 'Admin', '0000-00-00 00:00:00', ''),
(53, 1, 328, 4, '', '100000.00', '0.00', '2023-10-10 17:54:03', 'Admin', '0000-00-00 00:00:00', ''),
(54, 0, 328, 9, '', '0.00', '100000.00', '2023-10-10 17:54:03', 'Admin', '0000-00-00 00:00:00', ''),
(55, 1, 329, 4, '', '100000.00', '0.00', '2023-10-10 17:54:36', 'Admin', '0000-00-00 00:00:00', ''),
(56, 0, 329, 9, '', '0.00', '100000.00', '2023-10-10 17:54:36', 'Admin', '0000-00-00 00:00:00', ''),
(57, 1, 330, 4, '', '100000.00', '0.00', '2023-10-10 18:10:07', 'Admin', '0000-00-00 00:00:00', ''),
(58, 0, 330, 9, '', '0.00', '100000.00', '2023-10-10 18:10:07', 'Admin', '0000-00-00 00:00:00', ''),
(59, 1, 331, 4, '', '100000.00', '0.00', '2023-10-10 18:10:27', 'Admin', '0000-00-00 00:00:00', ''),
(60, 0, 331, 9, '', '0.00', '100000.00', '2023-10-10 18:10:27', 'Admin', '0000-00-00 00:00:00', ''),
(61, 1, 332, 4, '', '100000.00', '0.00', '2023-10-10 18:10:57', 'Admin', '0000-00-00 00:00:00', ''),
(62, 0, 332, 9, '', '0.00', '100000.00', '2023-10-10 18:10:57', 'Admin', '0000-00-00 00:00:00', ''),
(63, 1, 333, 4, '', '100000.00', '0.00', '2023-10-10 18:11:24', 'Admin', '0000-00-00 00:00:00', ''),
(64, 0, 333, 9, '', '0.00', '100000.00', '2023-10-10 18:11:24', 'Admin', '0000-00-00 00:00:00', ''),
(81, 1, 342, 14, '', '550000000.00', '0.00', '2023-10-24 09:14:41', 'Admin', '0000-00-00 00:00:00', ''),
(82, 2, 342, 12, '', '0.00', '550000000.00', '2023-10-24 09:14:41', 'Admin', '0000-00-00 00:00:00', ''),
(83, 1, 343, 14, '', '550000000.00', '0.00', '2023-10-24 09:32:41', 'Admin', '0000-00-00 00:00:00', ''),
(84, 2, 343, 12, '', '0.00', '550000000.00', '2023-10-24 09:32:41', 'Admin', '0000-00-00 00:00:00', ''),
(85, 1, 344, 14, '', '550000000.00', '0.00', '2023-10-24 09:35:48', 'Admin', '0000-00-00 00:00:00', ''),
(86, 2, 344, 12, '', '0.00', '550000000.00', '2023-10-24 09:35:48', 'Admin', '0000-00-00 00:00:00', ''),
(87, 1, 345, 14, '', '27000000.00', '0.00', '2023-10-24 09:44:52', 'Admin', '0000-00-00 00:00:00', ''),
(88, 2, 345, 12, '', '0.00', '27000000.00', '2023-10-24 09:44:52', 'Admin', '0000-00-00 00:00:00', ''),
(89, 1, 346, 14, '', '27000000.00', '0.00', '2023-10-24 09:45:15', 'Admin', '0000-00-00 00:00:00', ''),
(90, 2, 346, 12, '', '0.00', '27000000.00', '2023-10-24 09:45:15', 'Admin', '0000-00-00 00:00:00', ''),
(91, 1, 347, 14, '', '27000000.00', '0.00', '2023-10-24 09:45:51', 'Admin', '0000-00-00 00:00:00', ''),
(92, 2, 347, 12, '', '0.00', '27000000.00', '2023-10-24 09:45:51', 'Admin', '0000-00-00 00:00:00', ''),
(93, 1, 348, 14, '', '300000000.00', '0.00', '2023-10-24 09:46:35', 'Admin', '0000-00-00 00:00:00', ''),
(94, 2, 348, 12, '', '0.00', '300000000.00', '2023-10-24 09:46:35', 'Admin', '0000-00-00 00:00:00', ''),
(95, 1, 349, 14, '', '300000000.00', '0.00', '2023-10-24 09:47:35', 'Admin', '0000-00-00 00:00:00', ''),
(96, 2, 349, 12, '', '0.00', '300000000.00', '2023-10-24 09:47:35', 'Admin', '0000-00-00 00:00:00', ''),
(97, 1, 350, 14, '', '300000000.00', '0.00', '2023-10-24 09:48:50', 'Admin', '0000-00-00 00:00:00', ''),
(98, 2, 350, 12, '', '0.00', '300000000.00', '2023-10-24 09:48:50', 'Admin', '0000-00-00 00:00:00', ''),
(99, 1, 351, 14, '', '300000000.00', '0.00', '2023-10-24 09:50:03', 'Admin', '0000-00-00 00:00:00', ''),
(100, 2, 351, 12, '', '0.00', '300000000.00', '2023-10-24 09:50:03', 'Admin', '0000-00-00 00:00:00', ''),
(101, 1, 352, 14, '', '300000000.00', '0.00', '2023-10-24 09:57:22', 'Admin', '0000-00-00 00:00:00', ''),
(102, 2, 352, 12, '', '0.00', '300000000.00', '2023-10-24 09:57:22', 'Admin', '0000-00-00 00:00:00', ''),
(103, 1, 353, 14, '', '300000000.00', '0.00', '2023-10-24 09:57:54', 'Admin', '0000-00-00 00:00:00', ''),
(104, 2, 353, 12, '', '0.00', '300000000.00', '2023-10-24 09:57:54', 'Admin', '0000-00-00 00:00:00', ''),
(105, 1, 354, 14, '', '300000000.00', '0.00', '2023-10-24 09:58:06', 'Admin', '0000-00-00 00:00:00', ''),
(106, 2, 354, 12, '', '0.00', '300000000.00', '2023-10-24 09:58:06', 'Admin', '0000-00-00 00:00:00', ''),
(107, 1, 355, 14, '', '27000000.00', '0.00', '2023-10-24 10:14:53', 'Admin', '0000-00-00 00:00:00', ''),
(108, 2, 355, 12, '', '0.00', '27000000.00', '2023-10-24 10:14:53', 'Admin', '0000-00-00 00:00:00', ''),
(109, 1, 356, 14, '', '27000000.00', '0.00', '2023-10-24 10:19:13', 'Admin', '0000-00-00 00:00:00', ''),
(110, 2, 356, 12, '', '0.00', '27000000.00', '2023-10-24 10:19:13', 'Admin', '0000-00-00 00:00:00', ''),
(111, 1, 357, 14, '', '550000000.00', '0.00', '2023-10-24 10:24:52', 'Admin', '0000-00-00 00:00:00', ''),
(112, 2, 357, 12, '', '0.00', '550000000.00', '2023-10-24 10:24:53', 'Admin', '0000-00-00 00:00:00', ''),
(113, 1, 358, 14, '', '550000000.00', '0.00', '2023-10-24 10:26:32', 'Admin', '0000-00-00 00:00:00', ''),
(114, 2, 358, 12, '', '0.00', '550000000.00', '2023-10-24 10:26:32', 'Admin', '0000-00-00 00:00:00', ''),
(115, 1, 359, 14, '', '550000000.00', '0.00', '2023-10-24 10:29:26', 'Admin', '0000-00-00 00:00:00', ''),
(116, 2, 359, 12, '', '0.00', '550000000.00', '2023-10-24 10:29:26', 'Admin', '0000-00-00 00:00:00', ''),
(117, 1, 360, 14, '', '550000000.00', '0.00', '2023-10-24 10:33:34', 'Admin', '0000-00-00 00:00:00', ''),
(118, 2, 360, 12, '', '0.00', '550000000.00', '2023-10-24 10:33:34', 'Admin', '0000-00-00 00:00:00', ''),
(119, 1, 361, 14, '', '300000000.00', '0.00', '2023-10-24 10:33:39', 'Admin', '0000-00-00 00:00:00', ''),
(120, 2, 361, 12, '', '0.00', '300000000.00', '2023-10-24 10:33:39', 'Admin', '0000-00-00 00:00:00', ''),
(121, 1, 362, 14, '', '60000000.00', '0.00', '2023-10-24 10:57:04', 'Admin', '0000-00-00 00:00:00', ''),
(122, 2, 362, 12, '', '0.00', '60000000.00', '2023-10-24 10:57:04', 'Admin', '0000-00-00 00:00:00', '');

-- --------------------------------------------------------

--
-- Table structure for table `anggota`
--

CREATE TABLE `anggota` (
  `id` int(11) NOT NULL,
  `no_anggota` varchar(20) NOT NULL,
  `qr_file` varchar(30) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `anggota`
--

INSERT INTO `anggota` (`id`, `no_anggota`, `qr_file`) VALUES
(2538, '11.001.000001', '11.001.000001.png'),
(2539, '11.001.000002', '11.001.000002.png'),
(2540, '11.001.000003', '11.001.000003.png'),
(2541, '11.001.000004', '11.001.000004.png'),
(2542, '11.001.000005', '11.001.000005.png'),
(2543, '11.001.000006', '11.001.000006.png'),
(2544, '11.001.000007', '11.001.000007.png'),
(2545, '11.001.000008', '11.001.000008.png'),
(2546, '11.001.000009', '11.001.000009.png'),
(2547, '11.001.000010', '11.001.000010.png'),
(2548, '11.001.000011', '11.001.000011.png'),
(2549, '11.001.000012', '11.001.000012.png'),
(2550, '11.001.000013', '11.001.000013.png'),
(2551, '11.001.000014', '11.001.000014.png'),
(2552, '11.001.000015', '11.001.000015.png'),
(2553, '11.001.000016', '11.001.000016.png'),
(2554, '11.001.000017', '11.001.000017.png'),
(2555, '11.001.000018', '11.001.000018.png'),
(2556, '11.001.000019', '11.001.000019.png'),
(2557, '11.001.000020', '11.001.000020.png'),
(2558, '11.001.000021', '11.001.000021.png'),
(2559, '11.001.000022', '11.001.000022.png'),
(2560, '11.001.000023', '11.001.000023.png'),
(2561, '11.001.000024', '11.001.000024.png'),
(2562, '11.001.000025', '11.001.000025.png'),
(2563, '11.001.000026', '11.001.000026.png'),
(2564, '11.001.000027', '11.001.000027.png'),
(2565, '11.001.000028', '11.001.000028.png'),
(2566, '11.001.000029', '11.001.000029.png'),
(2567, '11.001.000030', '11.001.000030.png'),
(2568, '11.001.000031', '11.001.000031.png'),
(2569, '11.001.000032', '11.001.000032.png'),
(2570, '11.001.000033', '11.001.000033.png'),
(2571, '11.001.000034', '11.001.000034.png'),
(2572, '11.001.000035', '11.001.000035.png'),
(2573, '11.001.000036', '11.001.000036.png'),
(2574, '11.001.000037', '11.001.000037.png'),
(2575, '11.001.000038', '11.001.000038.png'),
(2576, '11.001.000039', '11.001.000039.png'),
(2577, '11.001.000040', '11.001.000040.png'),
(2578, '11.001.000041', '11.001.000041.png'),
(2579, '11.001.000042', '11.001.000042.png'),
(2580, '11.001.000043', '11.001.000043.png'),
(2581, '11.001.000044', '11.001.000044.png'),
(2582, '11.001.000045', '11.001.000045.png'),
(2583, '11.001.000046', '11.001.000046.png'),
(2584, '11.001.000047', '11.001.000047.png'),
(2585, '11.001.000048', '11.001.000048.png'),
(2586, '11.001.000049', '11.001.000049.png'),
(2587, '11.001.000050', '11.001.000050.png'),
(2588, '11.001.000051', '11.001.000051.png'),
(2589, '11.001.000052', '11.001.000052.png'),
(2590, '11.001.000053', '11.001.000053.png'),
(2591, '11.001.000054', '11.001.000054.png'),
(2592, '11.001.000055', '11.001.000055.png'),
(2593, '11.001.000056', '11.001.000056.png'),
(2594, '11.001.000057', '11.001.000057.png'),
(2595, '11.001.000058', '11.001.000058.png'),
(2596, '11.001.000059', '11.001.000059.png'),
(2597, '11.001.000060', '11.001.000060.png'),
(2598, '11.001.000061', '11.001.000061.png'),
(2599, '11.001.000062', '11.001.000062.png'),
(2600, '11.001.000063', '11.001.000063.png'),
(2601, '11.001.000064', '11.001.000064.png'),
(2602, '11.001.000065', '11.001.000065.png'),
(2603, '11.001.000066', '11.001.000066.png'),
(2604, '11.001.000067', '11.001.000067.png'),
(2605, '11.001.000068', '11.001.000068.png'),
(2606, '11.001.000069', '11.001.000069.png'),
(2607, '11.001.000070', '11.001.000070.png'),
(2608, '11.001.000071', '11.001.000071.png'),
(2609, '11.001.000072', '11.001.000072.png'),
(2610, '11.001.000073', '11.001.000073.png'),
(2611, '11.001.000074', '11.001.000074.png'),
(2612, '11.001.000075', '11.001.000075.png'),
(2613, '11.001.000076', '11.001.000076.png'),
(2614, '11.001.000077', '11.001.000077.png'),
(2615, '11.001.000078', '11.001.000078.png'),
(2616, '11.001.000079', '11.001.000079.png'),
(2617, '11.001.000080', '11.001.000080.png'),
(2618, '11.001.000081', '11.001.000081.png'),
(2619, '11.001.000082', '11.001.000082.png'),
(2620, '11.001.000083', '11.001.000083.png'),
(2621, '11.001.000084', '11.001.000084.png'),
(2622, '11.001.000085', '11.001.000085.png'),
(2623, '11.001.000086', '11.001.000086.png'),
(2624, '11.001.000087', '11.001.000087.png'),
(2625, '11.001.000088', '11.001.000088.png'),
(2626, '11.001.000089', '11.001.000089.png'),
(2627, '11.001.000090', '11.001.000090.png'),
(2628, '11.001.000091', '11.001.000091.png'),
(2629, '11.001.000092', '11.001.000092.png'),
(2630, '11.001.000093', '11.001.000093.png'),
(2631, '11.001.000094', '11.001.000094.png'),
(2632, '11.001.000095', '11.001.000095.png'),
(2633, '11.001.000096', '11.001.000096.png'),
(2634, '11.001.000097', '11.001.000097.png'),
(2635, '11.001.000098', '11.001.000098.png'),
(2636, '11.001.000099', '11.001.000099.png'),
(2637, '11.001.000100', '11.001.000100.png'),
(2638, '11.001.000101', '11.001.000101.png'),
(2639, '11.001.000102', '11.001.000102.png'),
(2640, '11.001.000103', '11.001.000103.png'),
(2641, '11.001.000104', '11.001.000104.png'),
(2642, '11.001.000105', '11.001.000105.png'),
(2643, '11.001.000106', '11.001.000106.png'),
(2644, '11.001.000107', '11.001.000107.png'),
(2645, '11.001.000108', '11.001.000108.png'),
(2646, '11.001.000109', '11.001.000109.png'),
(2647, '11.001.000110', '11.001.000110.png'),
(2648, '11.001.000111', '11.001.000111.png'),
(2649, '11.001.000112', '11.001.000112.png'),
(2650, '11.001.000113', '11.001.000113.png'),
(2651, '11.001.000114', '11.001.000114.png'),
(2652, '11.001.000115', '11.001.000115.png'),
(2653, '11.001.000116', '11.001.000116.png'),
(2654, '11.001.000117', '11.001.000117.png'),
(2655, '11.001.000118', '11.001.000118.png'),
(2656, '11.001.000119', '11.001.000119.png'),
(2657, '11.001.000120', '11.001.000120.png'),
(2658, '11.001.000121', '11.001.000121.png'),
(2659, '11.001.000122', '11.001.000122.png'),
(2660, '11.001.000123', '11.001.000123.png'),
(2661, '11.001.000124', '11.001.000124.png'),
(2662, '11.001.000125', '11.001.000125.png'),
(2663, '11.001.000126', '11.001.000126.png'),
(2664, '11.001.000127', '11.001.000127.png'),
(2665, '11.001.000128', '11.001.000128.png'),
(2666, '11.001.000129', '11.001.000129.png'),
(2667, '11.001.000130', '11.001.000130.png'),
(2668, '11.001.000131', '11.001.000131.png'),
(2669, '11.001.000132', '11.001.000132.png'),
(2670, '11.001.000133', '11.001.000133.png'),
(2671, '11.001.000134', '11.001.000134.png'),
(2672, '11.001.000135', '11.001.000135.png'),
(2673, '11.001.000136', '11.001.000136.png'),
(2674, '11.001.000137', '11.001.000137.png'),
(2675, '11.001.000138', '11.001.000138.png'),
(2676, '11.001.000139', '11.001.000139.png'),
(2677, '11.001.000140', '11.001.000140.png'),
(2678, '11.001.000141', '11.001.000141.png'),
(2679, '11.001.000142', '11.001.000142.png'),
(2680, '11.001.000143', '11.001.000143.png'),
(2681, '11.001.000144', '11.001.000144.png'),
(2682, '11.001.000145', '11.001.000145.png'),
(2683, '11.001.000146', '11.001.000146.png'),
(2684, '11.001.000147', '11.001.000147.png'),
(2685, '11.001.000148', '11.001.000148.png'),
(2686, '11.001.000149', '11.001.000149.png'),
(2687, '11.001.000150', '11.001.000150.png'),
(2688, '11.001.000151', '11.001.000151.png'),
(2689, '11.001.000152', '11.001.000152.png'),
(2690, '11.001.000153', '11.001.000153.png'),
(2691, '11.001.000154', '11.001.000154.png'),
(2692, '11.001.000155', '11.001.000155.png'),
(2693, '11.001.000156', '11.001.000156.png'),
(2694, '11.001.000157', '11.001.000157.png'),
(2695, '11.001.000158', '11.001.000158.png'),
(2696, '11.001.000159', '11.001.000159.png'),
(2697, '11.001.000160', '11.001.000160.png'),
(2698, '11.001.000161', '11.001.000161.png'),
(2699, '11.001.000162', '11.001.000162.png'),
(2700, '11.001.000163', '11.001.000163.png'),
(2701, '11.001.000164', '11.001.000164.png'),
(2702, '11.001.000165', '11.001.000165.png'),
(2703, '11.001.000166', '11.001.000166.png'),
(2704, '11.001.000167', '11.001.000167.png'),
(2705, '11.001.000168', '11.001.000168.png'),
(2706, '11.001.000169', '11.001.000169.png'),
(2707, '11.001.000170', '11.001.000170.png'),
(2708, '11.001.000171', '11.001.000171.png'),
(2709, '11.001.000172', '11.001.000172.png'),
(2710, '11.001.000173', '11.001.000173.png'),
(2711, '11.001.000174', '11.001.000174.png'),
(2712, '11.001.000175', '11.001.000175.png'),
(2713, '11.001.000176', '11.001.000176.png'),
(2714, '11.001.000177', '11.001.000177.png'),
(2715, '11.001.000178', '11.001.000178.png'),
(2716, '11.001.000179', '11.001.000179.png'),
(2717, '11.001.000180', '11.001.000180.png'),
(2718, '11.001.000181', '11.001.000181.png'),
(2719, '11.001.000182', '11.001.000182.png'),
(2720, '11.001.000183', '11.001.000183.png'),
(2721, '11.001.000184', '11.001.000184.png'),
(2722, '11.001.000185', '11.001.000185.png'),
(2723, '11.001.000186', '11.001.000186.png'),
(2724, '11.001.000187', '11.001.000187.png'),
(2725, '11.001.000188', '11.001.000188.png'),
(2726, '11.001.000189', '11.001.000189.png'),
(2727, '11.001.000190', '11.001.000190.png'),
(2728, '11.001.000191', '11.001.000191.png'),
(2729, '11.001.000192', '11.001.000192.png'),
(2730, '11.001.000193', '11.001.000193.png'),
(2731, '11.001.000194', '11.001.000194.png'),
(2732, '11.001.000195', '11.001.000195.png'),
(2733, '11.001.000196', '11.001.000196.png'),
(2734, '11.001.000197', '11.001.000197.png'),
(2735, '11.001.000198', '11.001.000198.png'),
(2736, '11.001.000199', '11.001.000199.png'),
(2737, '11.001.000200', '11.001.000200.png'),
(2738, '11.001.000201', '11.001.000201.png'),
(2739, '11.001.000202', '11.001.000202.png'),
(2740, '11.001.000203', '11.001.000203.png'),
(2741, '11.001.000204', '11.001.000204.png'),
(2742, '11.001.000205', '11.001.000205.png'),
(2743, '11.001.000206', '11.001.000206.png'),
(2744, '11.001.000207', '11.001.000207.png'),
(2745, '11.001.000208', '11.001.000208.png'),
(2746, '11.001.000209', '11.001.000209.png'),
(2747, '11.001.000210', '11.001.000210.png'),
(2748, '11.001.000211', '11.001.000211.png'),
(2749, '11.001.000212', '11.001.000212.png'),
(2750, '11.001.000213', '11.001.000213.png'),
(2751, '11.001.000214', '11.001.000214.png'),
(2752, '11.001.000215', '11.001.000215.png'),
(2753, '11.001.000216', '11.001.000216.png'),
(2754, '11.001.000217', '11.001.000217.png'),
(2755, '11.001.000218', '11.001.000218.png'),
(2756, '11.001.000219', '11.001.000219.png'),
(2757, '11.001.000220', '11.001.000220.png'),
(2758, '11.001.000221', '11.001.000221.png'),
(2759, '11.001.000222', '11.001.000222.png'),
(2760, '11.001.000223', '11.001.000223.png'),
(2761, '11.001.000224', '11.001.000224.png'),
(2762, '11.001.000225', '11.001.000225.png'),
(2763, '11.001.000226', '11.001.000226.png'),
(2764, '11.001.000227', '11.001.000227.png'),
(2765, '11.001.000228', '11.001.000228.png'),
(2766, '11.001.000229', '11.001.000229.png'),
(2767, '11.001.000230', '11.001.000230.png'),
(2768, '11.001.000231', '11.001.000231.png'),
(2769, '11.001.000232', '11.001.000232.png'),
(2770, '11.001.000233', '11.001.000233.png'),
(2771, '11.001.000234', '11.001.000234.png'),
(2772, '11.001.000235', '11.001.000235.png'),
(2773, '11.001.000236', '11.001.000236.png'),
(2774, '11.001.000237', '11.001.000237.png'),
(2775, '11.001.000238', '11.001.000238.png'),
(2776, '11.001.000239', '11.001.000239.png'),
(2777, '11.001.000240', '11.001.000240.png'),
(2778, '11.001.000241', '11.001.000241.png'),
(2779, '11.001.000242', '11.001.000242.png'),
(2780, '11.001.000243', '11.001.000243.png'),
(2781, '11.001.000244', '11.001.000244.png'),
(2782, '11.001.000245', '11.001.000245.png'),
(2783, '11.001.000246', '11.001.000246.png'),
(2784, '11.001.000247', '11.001.000247.png'),
(2785, '11.001.000248', '11.001.000248.png'),
(2786, '11.001.000249', '11.001.000249.png'),
(2787, '11.001.000250', '11.001.000250.png'),
(2788, '11.001.000251', '11.001.000251.png'),
(2789, '11.001.000252', '11.001.000252.png'),
(2790, '11.001.000253', '11.001.000253.png'),
(2791, '11.001.000254', '11.001.000254.png'),
(2792, '11.001.000255', '11.001.000255.png'),
(2793, '11.001.000256', '11.001.000256.png'),
(2794, '11.001.000257', '11.001.000257.png'),
(2795, '11.001.000258', '11.001.000258.png'),
(2796, '11.001.000259', '11.001.000259.png'),
(2797, '11.001.000260', '11.001.000260.png'),
(2798, '11.001.000261', '11.001.000261.png'),
(2799, '11.001.000262', '11.001.000262.png'),
(2800, '11.001.000263', '11.001.000263.png'),
(2801, '11.001.000264', '11.001.000264.png'),
(2802, '11.001.000265', '11.001.000265.png'),
(2803, '11.001.000266', '11.001.000266.png'),
(2804, '11.001.000267', '11.001.000267.png'),
(2805, '11.001.000268', '11.001.000268.png'),
(2806, '11.001.000269', '11.001.000269.png'),
(2807, '11.001.000270', '11.001.000270.png'),
(2808, '11.001.000271', '11.001.000271.png'),
(2809, '11.001.000272', '11.001.000272.png'),
(2810, '11.001.000273', '11.001.000273.png'),
(2811, '11.001.000274', '11.001.000274.png'),
(2812, '11.001.000275', '11.001.000275.png'),
(2813, '11.001.000276', '11.001.000276.png'),
(2814, '11.001.000277', '11.001.000277.png'),
(2815, '11.001.000278', '11.001.000278.png'),
(2816, '11.001.000279', '11.001.000279.png'),
(2817, '11.001.000280', '11.001.000280.png'),
(2818, '11.001.000281', '11.001.000281.png'),
(2819, '11.001.000282', '11.001.000282.png'),
(2820, '11.001.000283', '11.001.000283.png'),
(2821, '11.001.000284', '11.001.000284.png'),
(2822, '11.001.000285', '11.001.000285.png'),
(2823, '11.001.000286', '11.001.000286.png'),
(2824, '11.001.000287', '11.001.000287.png'),
(2825, '11.001.000288', '11.001.000288.png'),
(2826, '11.001.000289', '11.001.000289.png'),
(2827, '11.001.000290', '11.001.000290.png'),
(2828, '11.001.000291', '11.001.000291.png'),
(2829, '11.001.000292', '11.001.000292.png'),
(2830, '11.001.000293', '11.001.000293.png'),
(2831, '11.001.000294', '11.001.000294.png'),
(2832, '11.001.000295', '11.001.000295.png'),
(2833, '11.001.000296', '11.001.000296.png'),
(2834, '11.001.000297', '11.001.000297.png'),
(2835, '11.001.000298', '11.001.000298.png'),
(2836, '11.001.000299', '11.001.000299.png'),
(2837, '11.001.000300', '11.001.000300.png'),
(2838, '11.001.000301', '11.001.000301.png'),
(2839, '11.001.000302', '11.001.000302.png'),
(2840, '11.001.000303', '11.001.000303.png'),
(2841, '11.001.000304', '11.001.000304.png'),
(2842, '11.001.000305', '11.001.000305.png'),
(2843, '11.001.000306', '11.001.000306.png'),
(2844, '11.001.000307', '11.001.000307.png'),
(2845, '11.001.000308', '11.001.000308.png'),
(2846, '11.001.000309', '11.001.000309.png'),
(2847, '11.001.000310', '11.001.000310.png'),
(2848, '11.001.000311', '11.001.000311.png'),
(2849, '11.001.000312', '11.001.000312.png'),
(2850, '11.001.000313', '11.001.000313.png'),
(2851, '11.001.000314', '11.001.000314.png'),
(2852, '11.001.000315', '11.001.000315.png'),
(2853, '11.001.000316', '11.001.000316.png'),
(2854, '11.001.000317', '11.001.000317.png'),
(2855, '11.001.000318', '11.001.000318.png'),
(2856, '11.001.000319', '11.001.000319.png'),
(2857, '11.001.000320', '11.001.000320.png'),
(2858, '11.001.000321', '11.001.000321.png'),
(2859, '11.001.000322', '11.001.000322.png'),
(2860, '11.001.000323', '11.001.000323.png'),
(2861, '11.001.000324', '11.001.000324.png'),
(2862, '11.001.000325', '11.001.000325.png'),
(2863, '11.001.000326', '11.001.000326.png'),
(2864, '11.001.000327', '11.001.000327.png'),
(2865, '11.001.000328', '11.001.000328.png'),
(2866, '11.001.000329', '11.001.000329.png'),
(2867, '11.001.000330', '11.001.000330.png'),
(2868, '11.001.000331', '11.001.000331.png'),
(2869, '11.001.000332', '11.001.000332.png'),
(2870, '11.001.000333', '11.001.000333.png'),
(2871, '11.001.000334', '11.001.000334.png'),
(2872, '11.001.000335', '11.001.000335.png'),
(2873, '11.001.000336', '11.001.000336.png'),
(2874, '11.001.000337', '11.001.000337.png'),
(2875, '11.001.000338', '11.001.000338.png'),
(2876, '11.001.000339', '11.001.000339.png'),
(2877, '11.001.000340', '11.001.000340.png'),
(2878, '11.001.000341', '11.001.000341.png'),
(2879, '11.001.000342', '11.001.000342.png'),
(2880, '11.001.000343', '11.001.000343.png'),
(2881, '11.001.000344', '11.001.000344.png'),
(2882, '11.001.000345', '11.001.000345.png'),
(2883, '11.001.000346', '11.001.000346.png'),
(2884, '11.001.000347', '11.001.000347.png'),
(2885, '11.001.000348', '11.001.000348.png'),
(2886, '11.001.000349', '11.001.000349.png'),
(2887, '11.001.000350', '11.001.000350.png'),
(2888, '11.001.000351', '11.001.000351.png'),
(2889, '11.001.000352', '11.001.000352.png'),
(2890, '11.001.000353', '11.001.000353.png'),
(2891, '11.001.000354', '11.001.000354.png'),
(2892, '11.001.000355', '11.001.000355.png'),
(2893, '11.001.000356', '11.001.000356.png'),
(2894, '11.001.000357', '11.001.000357.png'),
(2895, '11.001.000358', '11.001.000358.png'),
(2896, '11.001.000359', '11.001.000359.png'),
(2897, '11.001.000360', '11.001.000360.png'),
(2898, '11.001.000361', '11.001.000361.png'),
(2899, '11.001.000362', '11.001.000362.png'),
(2900, '11.001.000363', '11.001.000363.png'),
(2901, '11.001.000364', '11.001.000364.png'),
(2902, '11.001.000365', '11.001.000365.png'),
(2903, '11.001.000366', '11.001.000366.png'),
(2904, '11.001.000367', '11.001.000367.png'),
(2905, '11.001.000368', '11.001.000368.png'),
(2906, '11.001.000369', '11.001.000369.png'),
(2907, '11.001.000370', '11.001.000370.png'),
(2908, '11.001.000371', '11.001.000371.png'),
(2909, '11.001.000372', '11.001.000372.png'),
(2910, '11.001.000373', '11.001.000373.png'),
(2911, '11.001.000374', '11.001.000374.png'),
(2912, '11.001.000375', '11.001.000375.png'),
(2913, '11.001.000376', '11.001.000376.png'),
(2914, '11.001.000377', '11.001.000377.png'),
(2915, '11.001.000378', '11.001.000378.png'),
(2916, '11.001.000379', '11.001.000379.png'),
(2917, '11.001.000380', '11.001.000380.png'),
(2918, '11.001.000381', '11.001.000381.png'),
(2919, '11.001.000382', '11.001.000382.png'),
(2920, '11.001.000383', '11.001.000383.png'),
(2921, '11.001.000384', '11.001.000384.png'),
(2922, '11.001.000385', '11.001.000385.png'),
(2923, '11.001.000386', '11.001.000386.png'),
(2924, '11.001.000387', '11.001.000387.png'),
(2925, '11.001.000388', '11.001.000388.png'),
(2926, '11.001.000389', '11.001.000389.png'),
(2927, '11.001.000390', '11.001.000390.png'),
(2928, '11.001.000391', '11.001.000391.png'),
(2929, '11.001.000392', '11.001.000392.png'),
(2930, '11.001.000393', '11.001.000393.png'),
(2931, '11.001.000394', '11.001.000394.png'),
(2932, '11.001.000395', '11.001.000395.png'),
(2933, '11.001.000396', '11.001.000396.png'),
(2934, '11.001.000397', '11.001.000397.png'),
(2935, '11.001.000398', '11.001.000398.png'),
(2936, '11.001.000399', '11.001.000399.png'),
(2937, '11.001.000400', '11.001.000400.png'),
(2938, '11.001.000401', '11.001.000401.png'),
(2939, '11.001.000402', '11.001.000402.png'),
(2940, '11.001.000403', '11.001.000403.png'),
(2941, '11.001.000404', '11.001.000404.png'),
(2942, '11.001.000405', '11.001.000405.png'),
(2943, '11.001.000406', '11.001.000406.png'),
(2944, '11.001.000407', '11.001.000407.png'),
(2945, '11.001.000408', '11.001.000408.png'),
(2946, '11.001.000409', '11.001.000409.png'),
(2947, '11.001.000410', '11.001.000410.png'),
(2948, '11.001.000411', '11.001.000411.png'),
(2949, '11.001.000412', '11.001.000412.png'),
(2950, '11.001.000413', '11.001.000413.png'),
(2951, '11.001.000414', '11.001.000414.png'),
(2952, '11.001.000415', '11.001.000415.png'),
(2953, '11.001.000416', '11.001.000416.png'),
(2954, '11.001.000417', '11.001.000417.png'),
(2955, '11.001.000418', '11.001.000418.png'),
(2956, '11.001.000419', '11.001.000419.png'),
(2957, '11.001.000420', '11.001.000420.png'),
(2958, '11.001.000421', '11.001.000421.png'),
(2959, '11.001.000422', '11.001.000422.png'),
(2960, '11.001.000423', '11.001.000423.png'),
(2961, '11.001.000424', '11.001.000424.png'),
(2962, '11.001.000425', '11.001.000425.png'),
(2963, '11.001.000426', '11.001.000426.png'),
(2964, '11.001.000427', '11.001.000427.png'),
(2965, '11.001.000428', '11.001.000428.png'),
(2966, '11.001.000429', '11.001.000429.png'),
(2967, '11.001.000430', '11.001.000430.png'),
(2968, '11.001.000431', '11.001.000431.png'),
(2969, '11.001.000432', '11.001.000432.png'),
(2970, '11.001.000433', '11.001.000433.png'),
(2971, '11.001.000434', '11.001.000434.png'),
(2972, '11.001.000435', '11.001.000435.png'),
(2973, '11.001.000436', '11.001.000436.png'),
(2974, '11.001.000437', '11.001.000437.png'),
(2975, '11.001.000438', '11.001.000438.png'),
(2976, '11.001.000439', '11.001.000439.png'),
(2977, '11.001.000440', '11.001.000440.png'),
(2978, '11.001.000441', '11.001.000441.png'),
(2979, '11.001.000442', '11.001.000442.png'),
(2980, '11.001.000443', '11.001.000443.png'),
(2981, '11.001.000444', '11.001.000444.png'),
(2982, '11.001.000445', '11.001.000445.png'),
(2983, '11.001.000446', '11.001.000446.png'),
(2984, '11.001.000447', '11.001.000447.png'),
(2985, '11.001.000448', '11.001.000448.png'),
(2986, '11.001.000449', '11.001.000449.png'),
(2987, '11.001.000450', '11.001.000450.png'),
(2988, '11.001.000451', '11.001.000451.png'),
(2989, '11.001.000452', '11.001.000452.png'),
(2990, '11.001.000453', '11.001.000453.png'),
(2991, '11.001.000454', '11.001.000454.png'),
(2992, '11.001.000455', '11.001.000455.png'),
(2993, '11.001.000456', '11.001.000456.png'),
(2994, '11.001.000457', '11.001.000457.png'),
(2995, '11.001.000458', '11.001.000458.png'),
(2996, '11.001.000459', '11.001.000459.png'),
(2997, '11.001.000460', '11.001.000460.png'),
(2998, '11.001.000461', '11.001.000461.png'),
(2999, '11.001.000462', '11.001.000462.png'),
(3000, '11.001.000463', '11.001.000463.png'),
(3001, '11.001.000464', '11.001.000464.png'),
(3002, '11.001.000465', '11.001.000465.png'),
(3003, '11.001.000466', '11.001.000466.png'),
(3004, '11.001.000467', '11.001.000467.png'),
(3005, '11.001.000468', '11.001.000468.png'),
(3006, '11.001.000469', '11.001.000469.png'),
(3007, '11.001.000470', '11.001.000470.png'),
(3008, '11.001.000471', '11.001.000471.png'),
(3009, '11.001.000472', '11.001.000472.png'),
(3010, '11.001.000473', '11.001.000473.png'),
(3011, '11.001.000474', '11.001.000474.png'),
(3012, '11.001.000475', '11.001.000475.png'),
(3013, '11.001.000476', '11.001.000476.png'),
(3014, '11.001.000477', '11.001.000477.png'),
(3015, '11.001.000478', '11.001.000478.png'),
(3016, '11.001.000479', '11.001.000479.png'),
(3017, '11.001.000480', '11.001.000480.png'),
(3018, '11.001.000481', '11.001.000481.png'),
(3019, '11.001.000482', '11.001.000482.png'),
(3020, '11.001.000483', '11.001.000483.png'),
(3021, '11.001.000484', '11.001.000484.png'),
(3022, '11.001.000485', '11.001.000485.png'),
(3023, '11.001.000486', '11.001.000486.png'),
(3024, '11.001.000487', '11.001.000487.png'),
(3025, '11.001.000488', '11.001.000488.png'),
(3026, '11.001.000489', '11.001.000489.png'),
(3027, '11.001.000490', '11.001.000490.png'),
(3028, '11.001.000491', '11.001.000491.png'),
(3029, '11.001.000492', '11.001.000492.png'),
(3030, '11.001.000493', '11.001.000493.png'),
(3031, '11.001.000494', '11.001.000494.png'),
(3032, '11.001.000495', '11.001.000495.png'),
(3033, '11.001.000496', '11.001.000496.png'),
(3034, '11.001.000497', '11.001.000497.png'),
(3035, '11.001.000498', '11.001.000498.png'),
(3036, '11.001.000499', '11.001.000499.png'),
(3037, '11.001.000500', '11.001.000500.png'),
(3038, '11.001.000501', '11.001.000501.png'),
(3039, '11.001.000502', '11.001.000502.png'),
(3040, '11.001.000503', '11.001.000503.png'),
(3041, '11.001.000504', '11.001.000504.png'),
(3042, '11.001.000505', '11.001.000505.png'),
(3043, '11.001.000506', '11.001.000506.png'),
(3044, '11.001.000507', '11.001.000507.png'),
(3045, '11.001.000508', '11.001.000508.png'),
(3046, '11.001.000509', '11.001.000509.png'),
(3047, '11.001.000510', '11.001.000510.png'),
(3048, '11.001.000511', '11.001.000511.png'),
(3049, '11.001.000512', '11.001.000512.png'),
(3050, '11.001.000513', '11.001.000513.png'),
(3051, '11.001.000514', '11.001.000514.png'),
(3052, '11.001.000515', '11.001.000515.png'),
(3053, '11.001.000516', '11.001.000516.png'),
(3054, '11.001.000517', '11.001.000517.png'),
(3055, '11.001.000518', '11.001.000518.png'),
(3056, '11.001.000519', '11.001.000519.png'),
(3057, '11.001.000520', '11.001.000520.png'),
(3058, '11.001.000521', '11.001.000521.png'),
(3059, '11.001.000522', '11.001.000522.png'),
(3060, '11.001.000523', '11.001.000523.png'),
(3061, '11.001.000524', '11.001.000524.png'),
(3062, '11.001.000525', '11.001.000525.png'),
(3063, '11.001.000526', '11.001.000526.png'),
(3064, '11.001.000527', '11.001.000527.png'),
(3065, '11.001.000528', '11.001.000528.png'),
(3066, '11.001.000529', '11.001.000529.png'),
(3067, '11.001.000530', '11.001.000530.png'),
(3068, '11.001.000531', '11.001.000531.png'),
(3069, '11.001.000532', '11.001.000532.png'),
(3070, '11.001.000533', '11.001.000533.png'),
(3071, '11.001.000534', '11.001.000534.png'),
(3072, '11.001.000535', '11.001.000535.png'),
(3073, '11.001.000536', '11.001.000536.png'),
(3074, '11.001.000537', '11.001.000537.png'),
(3075, '11.001.000538', '11.001.000538.png'),
(3076, '11.001.000539', '11.001.000539.png'),
(3077, '11.001.000540', '11.001.000540.png'),
(3078, '11.001.000541', '11.001.000541.png'),
(3079, '11.001.000542', '11.001.000542.png'),
(3080, '11.001.000543', '11.001.000543.png'),
(3081, '11.001.000544', '11.001.000544.png'),
(3082, '11.001.000545', '11.001.000545.png'),
(3083, '11.001.000546', '11.001.000546.png'),
(3084, '11.001.000547', '11.001.000547.png'),
(3085, '11.001.000548', '11.001.000548.png'),
(3086, '11.001.000549', '11.001.000549.png'),
(3087, '11.001.000550', '11.001.000550.png'),
(3088, '11.001.000551', '11.001.000551.png'),
(3089, '11.001.000552', '11.001.000552.png'),
(3090, '11.001.000553', '11.001.000553.png'),
(3091, '11.001.000554', '11.001.000554.png'),
(3092, '11.001.000555', '11.001.000555.png'),
(3093, '11.001.000556', '11.001.000556.png'),
(3094, '11.001.000557', '11.001.000557.png'),
(3095, '11.001.000558', '11.001.000558.png'),
(3096, '11.001.000559', '11.001.000559.png'),
(3097, '11.001.000560', '11.001.000560.png'),
(3098, '11.001.000561', '11.001.000561.png'),
(3099, '11.001.000562', '11.001.000562.png'),
(3100, '11.001.000563', '11.001.000563.png'),
(3101, '11.001.000564', '11.001.000564.png'),
(3102, '11.001.000565', '11.001.000565.png'),
(3103, '11.001.000566', '11.001.000566.png'),
(3104, '11.001.000567', '11.001.000567.png'),
(3105, '11.001.000568', '11.001.000568.png'),
(3106, '11.001.000569', '11.001.000569.png'),
(3107, '11.001.000570', '11.001.000570.png'),
(3108, '11.001.000571', '11.001.000571.png'),
(3109, '11.001.000572', '11.001.000572.png'),
(3110, '11.001.000573', '11.001.000573.png'),
(3111, '11.001.000574', '11.001.000574.png'),
(3112, '11.001.000575', '11.001.000575.png'),
(3113, '11.001.000576', '11.001.000576.png'),
(3114, '11.001.000577', '11.001.000577.png'),
(3115, '11.001.000578', '11.001.000578.png'),
(3116, '11.001.000579', '11.001.000579.png'),
(3117, '11.001.000580', '11.001.000580.png'),
(3118, '11.001.000581', '11.001.000581.png'),
(3119, '11.001.000582', '11.001.000582.png'),
(3120, '11.001.000583', '11.001.000583.png'),
(3121, '11.001.000584', '11.001.000584.png'),
(3122, '11.001.000585', '11.001.000585.png'),
(3123, '11.001.000586', '11.001.000586.png'),
(3124, '11.001.000587', '11.001.000587.png'),
(3125, '11.001.000588', '11.001.000588.png'),
(3126, '11.001.000589', '11.001.000589.png'),
(3127, '11.001.000590', '11.001.000590.png'),
(3128, '11.001.000591', '11.001.000591.png'),
(3129, '11.001.000592', '11.001.000592.png'),
(3130, '11.001.000593', '11.001.000593.png'),
(3131, '11.001.000594', '11.001.000594.png'),
(3132, '11.001.000595', '11.001.000595.png'),
(3133, '11.001.000596', '11.001.000596.png'),
(3134, '11.001.000597', '11.001.000597.png'),
(3135, '11.001.000598', '11.001.000598.png'),
(3136, '11.001.000599', '11.001.000599.png'),
(3137, '11.001.000600', '11.001.000600.png'),
(3138, '11.001.000601', '11.001.000601.png'),
(3139, '11.001.000602', '11.001.000602.png'),
(3140, '11.001.000603', '11.001.000603.png'),
(3141, '11.001.000604', '11.001.000604.png'),
(3142, '11.001.000605', '11.001.000605.png'),
(3143, '11.001.000606', '11.001.000606.png'),
(3144, '11.001.000607', '11.001.000607.png'),
(3145, '11.001.000608', '11.001.000608.png'),
(3146, '11.001.000609', '11.001.000609.png'),
(3147, '11.001.000610', '11.001.000610.png'),
(3148, '11.001.000611', '11.001.000611.png'),
(3149, '11.001.000612', '11.001.000612.png'),
(3150, '11.001.000613', '11.001.000613.png'),
(3151, '11.001.000614', '11.001.000614.png'),
(3152, '11.001.000615', '11.001.000615.png'),
(3153, '11.001.000616', '11.001.000616.png'),
(3154, '11.001.000617', '11.001.000617.png'),
(3155, '11.001.000618', '11.001.000618.png'),
(3156, '11.001.000619', '11.001.000619.png'),
(3157, '11.001.000620', '11.001.000620.png'),
(3158, '11.001.000621', '11.001.000621.png'),
(3159, '11.001.000622', '11.001.000622.png'),
(3160, '11.001.000623', '11.001.000623.png'),
(3161, '11.001.000624', '11.001.000624.png'),
(3162, '11.001.000625', '11.001.000625.png'),
(3163, '11.001.000626', '11.001.000626.png'),
(3164, '11.001.000627', '11.001.000627.png'),
(3165, '11.001.000628', '11.001.000628.png'),
(3166, '11.001.000629', '11.001.000629.png'),
(3167, '11.001.000630', '11.001.000630.png'),
(3168, '11.001.000631', '11.001.000631.png'),
(3169, '11.001.000632', '11.001.000632.png'),
(3170, '11.001.000633', '11.001.000633.png'),
(3171, '11.001.000634', '11.001.000634.png'),
(3172, '11.001.000635', '11.001.000635.png'),
(3173, '11.001.000636', '11.001.000636.png'),
(3174, '11.001.000637', '11.001.000637.png'),
(3175, '11.001.000638', '11.001.000638.png'),
(3176, '11.001.000639', '11.001.000639.png'),
(3177, '11.001.000640', '11.001.000640.png'),
(3178, '11.001.000641', '11.001.000641.png'),
(3179, '11.001.000642', '11.001.000642.png'),
(3180, '11.001.000643', '11.001.000643.png'),
(3181, '11.001.000644', '11.001.000644.png'),
(3182, '11.001.000645', '11.001.000645.png'),
(3183, '11.001.000646', '11.001.000646.png'),
(3184, '11.001.000647', '11.001.000647.png'),
(3185, '11.001.000648', '11.001.000648.png'),
(3186, '11.001.000649', '11.001.000649.png'),
(3187, '11.001.000650', '11.001.000650.png'),
(3188, '11.001.000651', '11.001.000651.png'),
(3189, '11.001.000652', '11.001.000652.png'),
(3190, '11.001.000653', '11.001.000653.png'),
(3191, '11.001.000654', '11.001.000654.png'),
(3192, '11.001.000655', '11.001.000655.png'),
(3193, '11.001.000656', '11.001.000656.png'),
(3194, '11.001.000657', '11.001.000657.png'),
(3195, '11.001.000658', '11.001.000658.png'),
(3196, '11.001.000659', '11.001.000659.png'),
(3197, '11.001.000660', '11.001.000660.png'),
(3198, '11.001.000661', '11.001.000661.png'),
(3199, '11.001.000662', '11.001.000662.png'),
(3200, '11.001.000663', '11.001.000663.png'),
(3201, '11.001.000664', '11.001.000664.png'),
(3202, '11.001.000665', '11.001.000665.png'),
(3203, '11.001.000666', '11.001.000666.png'),
(3204, '11.001.000667', '11.001.000667.png'),
(3205, '11.001.000668', '11.001.000668.png'),
(3206, '11.001.000669', '11.001.000669.png'),
(3207, '11.001.000670', '11.001.000670.png'),
(3208, '11.001.000671', '11.001.000671.png'),
(3209, '11.001.000672', '11.001.000672.png'),
(3210, '11.001.000673', '11.001.000673.png'),
(3211, '11.001.000674', '11.001.000674.png'),
(3212, '11.001.000675', '11.001.000675.png'),
(3213, '11.001.000676', '11.001.000676.png'),
(3214, '11.001.000677', '11.001.000677.png'),
(3215, '11.001.000678', '11.001.000678.png'),
(3216, '11.001.000679', '11.001.000679.png'),
(3217, '11.001.000680', '11.001.000680.png'),
(3218, '11.001.000681', '11.001.000681.png'),
(3219, '11.001.000682', '11.001.000682.png'),
(3220, '11.001.000683', '11.001.000683.png'),
(3221, '11.001.000684', '11.001.000684.png'),
(3222, '11.001.000685', '11.001.000685.png'),
(3223, '11.001.000686', '11.001.000686.png'),
(3224, '11.001.000687', '11.001.000687.png'),
(3225, '11.001.000688', '11.001.000688.png'),
(3226, '11.001.000689', '11.001.000689.png'),
(3227, '11.001.000690', '11.001.000690.png'),
(3228, '11.001.000691', '11.001.000691.png'),
(3229, '11.001.000692', '11.001.000692.png'),
(3230, '11.001.000693', '11.001.000693.png'),
(3231, '11.001.000694', '11.001.000694.png'),
(3232, '11.001.000695', '11.001.000695.png'),
(3233, '11.001.000696', '11.001.000696.png'),
(3234, '11.001.000697', '11.001.000697.png'),
(3235, '11.001.000698', '11.001.000698.png'),
(3236, '11.001.000699', '11.001.000699.png'),
(3237, '11.001.000700', '11.001.000700.png'),
(3238, '11.001.000701', '11.001.000701.png'),
(3239, '11.001.000702', '11.001.000702.png'),
(3240, '11.001.000703', '11.001.000703.png'),
(3241, '11.001.000704', '11.001.000704.png'),
(3242, '11.001.000705', '11.001.000705.png'),
(3243, '11.001.000706', '11.001.000706.png'),
(3244, '11.001.000707', '11.001.000707.png'),
(3245, '11.001.000708', '11.001.000708.png'),
(3246, '11.001.000709', '11.001.000709.png'),
(3247, '11.001.000710', '11.001.000710.png'),
(3248, '11.001.000711', '11.001.000711.png'),
(3249, '11.001.000712', '11.001.000712.png'),
(3250, '11.001.000713', '11.001.000713.png'),
(3251, '11.001.000714', '11.001.000714.png'),
(3252, '11.001.000715', '11.001.000715.png'),
(3253, '11.001.000716', '11.001.000716.png'),
(3254, '11.001.000717', '11.001.000717.png'),
(3255, '11.001.000718', '11.001.000718.png'),
(3256, '11.001.000719', '11.001.000719.png'),
(3257, '11.001.000720', '11.001.000720.png'),
(3258, '11.001.000721', '11.001.000721.png'),
(3259, '11.001.000722', '11.001.000722.png'),
(3260, '11.001.000723', '11.001.000723.png'),
(3261, '11.001.000724', '11.001.000724.png'),
(3262, '11.001.000725', '11.001.000725.png'),
(3263, '11.001.000726', '11.001.000726.png'),
(3264, '11.001.000727', '11.001.000727.png'),
(3265, '11.001.000728', '11.001.000728.png'),
(3266, '11.001.000729', '11.001.000729.png'),
(3267, '11.001.000730', '11.001.000730.png'),
(3268, '11.001.000731', '11.001.000731.png'),
(3269, '11.001.000732', '11.001.000732.png'),
(3270, '11.001.000733', '11.001.000733.png'),
(3271, '11.001.000734', '11.001.000734.png'),
(3272, '11.001.000735', '11.001.000735.png'),
(3273, '11.001.000736', '11.001.000736.png'),
(3274, '11.001.000737', '11.001.000737.png'),
(3275, '11.001.000738', '11.001.000738.png'),
(3276, '11.001.000739', '11.001.000739.png'),
(3277, '11.001.000740', '11.001.000740.png'),
(3278, '11.001.000741', '11.001.000741.png'),
(3279, '11.001.000742', '11.001.000742.png'),
(3280, '11.001.000743', '11.001.000743.png'),
(3281, '11.001.000744', '11.001.000744.png'),
(3282, '11.001.000745', '11.001.000745.png'),
(3283, '11.001.000746', '11.001.000746.png'),
(3284, '11.001.000747', '11.001.000747.png'),
(3285, '11.001.000748', '11.001.000748.png'),
(3286, '11.001.000749', '11.001.000749.png'),
(3287, '11.001.000750', '11.001.000750.png'),
(3288, '11.001.000751', '11.001.000751.png'),
(3289, '11.001.000752', '11.001.000752.png'),
(3290, '11.001.000753', '11.001.000753.png'),
(3291, '11.001.000754', '11.001.000754.png'),
(3292, '11.001.000755', '11.001.000755.png'),
(3293, '11.001.000756', '11.001.000756.png'),
(3294, '11.001.000757', '11.001.000757.png'),
(3295, '11.001.000758', '11.001.000758.png'),
(3296, '11.001.000759', '11.001.000759.png'),
(3297, '11.001.000760', '11.001.000760.png'),
(3298, '11.001.000761', '11.001.000761.png'),
(3299, '11.001.000762', '11.001.000762.png'),
(3300, '11.001.000763', '11.001.000763.png'),
(3301, '11.001.000764', '11.001.000764.png'),
(3302, '11.001.000765', '11.001.000765.png'),
(3303, '11.001.000766', '11.001.000766.png'),
(3304, '11.001.000767', '11.001.000767.png'),
(3305, '11.001.000768', '11.001.000768.png'),
(3306, '11.001.000769', '11.001.000769.png'),
(3307, '11.001.000770', '11.001.000770.png'),
(3308, '11.001.000771', '11.001.000771.png'),
(3309, '11.001.000772', '11.001.000772.png'),
(3310, '11.001.000773', '11.001.000773.png'),
(3311, '11.001.000774', '11.001.000774.png'),
(3312, '11.001.000775', '11.001.000775.png'),
(3313, '11.001.000776', '11.001.000776.png'),
(3314, '11.001.000777', '11.001.000777.png'),
(3315, '11.001.000778', '11.001.000778.png'),
(3316, '11.001.000779', '11.001.000779.png'),
(3317, '11.001.000780', '11.001.000780.png'),
(3318, '11.001.000781', '11.001.000781.png'),
(3319, '11.001.000782', '11.001.000782.png'),
(3320, '11.001.000783', '11.001.000783.png'),
(3321, '11.001.000784', '11.001.000784.png'),
(3322, '11.001.000785', '11.001.000785.png'),
(3323, '11.001.000786', '11.001.000786.png'),
(3324, '11.001.000787', '11.001.000787.png'),
(3325, '11.001.000788', '11.001.000788.png'),
(3326, '11.001.000789', '11.001.000789.png'),
(3327, '11.001.000790', '11.001.000790.png'),
(3328, '11.001.000791', '11.001.000791.png'),
(3329, '11.001.000792', '11.001.000792.png'),
(3330, '11.001.000793', '11.001.000793.png'),
(3331, '11.001.000794', '11.001.000794.png'),
(3332, '11.001.000795', '11.001.000795.png'),
(3333, '11.001.000796', '11.001.000796.png'),
(3334, '11.001.000797', '11.001.000797.png'),
(3335, '11.001.000798', '11.001.000798.png'),
(3336, '11.001.000799', '11.001.000799.png'),
(3337, '11.001.000800', '11.001.000800.png'),
(3338, '11.001.000801', '11.001.000801.png'),
(3339, '11.001.000802', '11.001.000802.png'),
(3340, '11.001.000803', '11.001.000803.png'),
(3341, '11.001.000804', '11.001.000804.png'),
(3342, '11.001.000805', '11.001.000805.png'),
(3343, '11.001.000806', '11.001.000806.png'),
(3344, '11.001.000807', '11.001.000807.png'),
(3345, '11.001.000808', '11.001.000808.png'),
(3346, '11.001.000809', '11.001.000809.png'),
(3347, '11.001.000810', '11.001.000810.png'),
(3348, '11.001.000811', '11.001.000811.png'),
(3349, '11.001.000812', '11.001.000812.png'),
(3350, '11.001.000813', '11.001.000813.png'),
(3351, '11.001.000814', '11.001.000814.png'),
(3352, '11.001.000815', '11.001.000815.png'),
(3353, '11.001.000816', '11.001.000816.png'),
(3354, '11.001.000817', '11.001.000817.png'),
(3355, '11.001.000818', '11.001.000818.png'),
(3356, '11.001.000819', '11.001.000819.png'),
(3357, '11.001.000820', '11.001.000820.png'),
(3358, '11.001.000821', '11.001.000821.png'),
(3359, '11.001.000822', '11.001.000822.png'),
(3360, '11.001.000823', '11.001.000823.png'),
(3361, '11.001.000824', '11.001.000824.png'),
(3362, '11.001.000825', '11.001.000825.png'),
(3363, '11.001.000826', '11.001.000826.png'),
(3364, '11.001.000827', '11.001.000827.png'),
(3365, '11.001.000828', '11.001.000828.png'),
(3366, '11.001.000829', '11.001.000829.png'),
(3367, '11.001.000830', '11.001.000830.png'),
(3368, '11.001.000831', '11.001.000831.png'),
(3369, '11.001.000832', '11.001.000832.png'),
(3370, '11.001.000833', '11.001.000833.png'),
(3371, '11.001.000834', '11.001.000834.png'),
(3372, '11.001.000835', '11.001.000835.png'),
(3373, '11.001.000836', '11.001.000836.png'),
(3374, '11.001.000837', '11.001.000837.png'),
(3375, '11.001.000838', '11.001.000838.png'),
(3376, '11.001.000839', '11.001.000839.png'),
(3377, '11.001.000840', '11.001.000840.png'),
(3378, '11.001.000841', '11.001.000841.png'),
(3379, '11.001.000842', '11.001.000842.png'),
(3380, '11.001.000843', '11.001.000843.png'),
(3381, '11.001.000844', '11.001.000844.png'),
(3382, '11.001.000845', '11.001.000845.png'),
(3383, '11.001.000846', '11.001.000846.png'),
(3384, '11.001.000847', '11.001.000847.png'),
(3385, '11.001.000848', '11.001.000848.png'),
(3386, '11.001.000849', '11.001.000849.png'),
(3387, '11.001.000850', '11.001.000850.png'),
(3388, '11.001.000851', '11.001.000851.png'),
(3389, '11.001.000852', '11.001.000852.png'),
(3390, '11.001.000853', '11.001.000853.png'),
(3391, '11.001.000854', '11.001.000854.png'),
(3392, '11.001.000855', '11.001.000855.png'),
(3393, '11.001.000856', '11.001.000856.png'),
(3394, '11.001.000857', '11.001.000857.png'),
(3395, '11.001.000858', '11.001.000858.png'),
(3396, '11.001.000859', '11.001.000859.png'),
(3397, '11.001.000860', '11.001.000860.png'),
(3398, '11.001.000861', '11.001.000861.png'),
(3399, '11.001.000862', '11.001.000862.png'),
(3400, '11.001.000863', '11.001.000863.png'),
(3401, '11.001.000864', '11.001.000864.png'),
(3402, '11.001.000865', '11.001.000865.png'),
(3403, '11.001.000866', '11.001.000866.png'),
(3404, '11.001.000867', '11.001.000867.png'),
(3405, '11.001.000868', '11.001.000868.png'),
(3406, '11.001.000869', '11.001.000869.png'),
(3407, '11.001.000870', '11.001.000870.png'),
(3408, '11.001.000871', '11.001.000871.png'),
(3409, '11.001.000872', '11.001.000872.png'),
(3410, '11.001.000873', '11.001.000873.png'),
(3411, '11.001.000874', '11.001.000874.png'),
(3412, '11.001.000875', '11.001.000875.png'),
(3413, '11.001.000876', '11.001.000876.png'),
(3414, '11.001.000877', '11.001.000877.png'),
(3415, '11.001.000878', '11.001.000878.png'),
(3416, '11.001.000879', '11.001.000879.png'),
(3417, '11.001.000880', '11.001.000880.png'),
(3418, '11.001.000881', '11.001.000881.png'),
(3419, '11.001.000882', '11.001.000882.png'),
(3420, '11.001.000883', '11.001.000883.png'),
(3421, '11.001.000884', '11.001.000884.png'),
(3422, '11.001.000885', '11.001.000885.png'),
(3423, '11.001.000886', '11.001.000886.png'),
(3424, '11.001.000887', '11.001.000887.png'),
(3425, '11.001.000888', '11.001.000888.png'),
(3426, '11.001.000889', '11.001.000889.png'),
(3427, '11.001.000890', '11.001.000890.png'),
(3428, '11.001.000891', '11.001.000891.png'),
(3429, '11.001.000892', '11.001.000892.png'),
(3430, '11.001.000893', '11.001.000893.png'),
(3431, '11.001.000894', '11.001.000894.png'),
(3432, '11.001.000895', '11.001.000895.png'),
(3433, '11.001.000896', '11.001.000896.png'),
(3434, '11.001.000897', '11.001.000897.png'),
(3435, '11.001.000898', '11.001.000898.png'),
(3436, '11.001.000899', '11.001.000899.png'),
(3437, '11.001.000900', '11.001.000900.png'),
(3438, '11.001.000901', '11.001.000901.png'),
(3439, '11.001.000902', '11.001.000902.png'),
(3440, '11.001.000903', '11.001.000903.png'),
(3441, '11.001.000904', '11.001.000904.png'),
(3442, '11.001.000905', '11.001.000905.png'),
(3443, '11.001.000906', '11.001.000906.png'),
(3444, '11.001.000907', '11.001.000907.png'),
(3445, '11.001.000908', '11.001.000908.png'),
(3446, '11.001.000909', '11.001.000909.png'),
(3447, '11.001.000910', '11.001.000910.png'),
(3448, '11.001.000911', '11.001.000911.png'),
(3449, '11.001.000912', '11.001.000912.png'),
(3450, '11.001.000913', '11.001.000913.png'),
(3451, '11.001.000914', '11.001.000914.png'),
(3452, '11.001.000915', '11.001.000915.png'),
(3453, '11.001.000916', '11.001.000916.png'),
(3454, '11.001.000917', '11.001.000917.png'),
(3455, '11.001.000918', '11.001.000918.png'),
(3456, '11.001.000919', '11.001.000919.png'),
(3457, '11.001.000920', '11.001.000920.png'),
(3458, '11.001.000921', '11.001.000921.png'),
(3459, '11.001.000922', '11.001.000922.png'),
(3460, '11.001.000923', '11.001.000923.png'),
(3461, '11.001.000924', '11.001.000924.png'),
(3462, '11.001.000925', '11.001.000925.png'),
(3463, '11.001.000926', '11.001.000926.png'),
(3464, '11.001.000927', '11.001.000927.png'),
(3465, '11.001.000928', '11.001.000928.png'),
(3466, '11.001.000929', '11.001.000929.png'),
(3467, '11.001.000930', '11.001.000930.png'),
(3468, '11.001.000931', '11.001.000931.png'),
(3469, '11.001.000932', '11.001.000932.png'),
(3470, '11.001.000933', '11.001.000933.png'),
(3471, '11.001.000934', '11.001.000934.png'),
(3472, '11.001.000935', '11.001.000935.png'),
(3473, '11.001.000936', '11.001.000936.png'),
(3474, '11.001.000937', '11.001.000937.png'),
(3475, '11.001.000938', '11.001.000938.png'),
(3476, '11.001.000939', '11.001.000939.png'),
(3477, '11.001.000940', '11.001.000940.png'),
(3478, '11.001.000941', '11.001.000941.png'),
(3479, '11.001.000942', '11.001.000942.png'),
(3480, '11.001.000943', '11.001.000943.png'),
(3481, '11.001.000944', '11.001.000944.png'),
(3482, '11.001.000945', '11.001.000945.png'),
(3483, '11.001.000946', '11.001.000946.png'),
(3484, '11.001.000947', '11.001.000947.png'),
(3485, '11.001.000948', '11.001.000948.png'),
(3486, '11.001.000949', '11.001.000949.png'),
(3487, '11.001.000950', '11.001.000950.png'),
(3488, '11.001.000951', '11.001.000951.png'),
(3489, '11.001.000952', '11.001.000952.png'),
(3490, '11.001.000953', '11.001.000953.png'),
(3491, '11.001.000954', '11.001.000954.png'),
(3492, '11.001.000955', '11.001.000955.png'),
(3493, '11.001.000956', '11.001.000956.png'),
(3494, '11.001.000957', '11.001.000957.png'),
(3495, '11.001.000958', '11.001.000958.png'),
(3496, '11.001.000959', '11.001.000959.png'),
(3497, '11.001.000960', '11.001.000960.png'),
(3498, '11.001.000961', '11.001.000961.png'),
(3499, '11.001.000962', '11.001.000962.png'),
(3500, '11.001.000963', '11.001.000963.png'),
(3501, '11.001.000964', '11.001.000964.png'),
(3502, '11.001.000965', '11.001.000965.png'),
(3503, '11.001.000966', '11.001.000966.png'),
(3504, '11.001.000967', '11.001.000967.png'),
(3505, '11.001.000968', '11.001.000968.png'),
(3506, '11.001.000969', '11.001.000969.png'),
(3507, '11.001.000970', '11.001.000970.png'),
(3508, '11.001.000971', '11.001.000971.png'),
(3509, '11.001.000972', '11.001.000972.png'),
(3510, '11.001.000973', '11.001.000973.png'),
(3511, '11.001.000974', '11.001.000974.png'),
(3512, '11.001.000975', '11.001.000975.png'),
(3513, '11.001.000976', '11.001.000976.png'),
(3514, '11.001.000977', '11.001.000977.png'),
(3515, '11.001.000978', '11.001.000978.png'),
(3516, '11.001.000979', '11.001.000979.png'),
(3517, '11.001.000980', '11.001.000980.png'),
(3518, '11.001.000981', '11.001.000981.png'),
(3519, '11.001.000982', '11.001.000982.png'),
(3520, '11.001.000983', '11.001.000983.png'),
(3521, '11.001.000984', '11.001.000984.png'),
(3522, '11.001.000985', '11.001.000985.png'),
(3523, '11.001.000986', '11.001.000986.png'),
(3524, '11.001.000987', '11.001.000987.png'),
(3525, '11.001.000988', '11.001.000988.png'),
(3526, '11.001.000989', '11.001.000989.png'),
(3527, '11.001.000990', '11.001.000990.png'),
(3528, '11.001.000991', '11.001.000991.png'),
(3529, '11.001.000992', '11.001.000992.png'),
(3530, '11.001.000993', '11.001.000993.png'),
(3531, '11.001.000994', '11.001.000994.png'),
(3532, '11.001.000995', '11.001.000995.png'),
(3533, '11.001.000996', '11.001.000996.png'),
(3534, '11.001.000997', '11.001.000997.png'),
(3535, '11.001.000998', '11.001.000998.png'),
(3536, '11.001.000999', '11.001.000999.png'),
(3537, '11.001.001000', '11.001.001000.png'),
(3538, '11.001.001001', '11.001.001001.png'),
(3539, '11.001.001002', '11.001.001002.png'),
(3540, '11.001.001003', '11.001.001003.png'),
(3541, '11.001.001004', '11.001.001004.png'),
(3542, '11.001.001005', '11.001.001005.png'),
(3543, '11.001.001006', '11.001.001006.png'),
(3544, '11.001.001007', '11.001.001007.png'),
(3545, '11.001.001008', '11.001.001008.png'),
(3546, '11.001.001009', '11.001.001009.png'),
(3547, '11.001.001010', '11.001.001010.png'),
(3548, '11.001.001011', '11.001.001011.png'),
(3549, '11.001.001012', '11.001.001012.png'),
(3550, '11.001.001013', '11.001.001013.png'),
(3551, '11.001.001014', '11.001.001014.png'),
(3552, '11.001.001015', '11.001.001015.png'),
(3553, '11.001.001016', '11.001.001016.png'),
(3554, '11.001.001017', '11.001.001017.png'),
(3555, '11.001.001018', '11.001.001018.png'),
(3556, '11.001.001019', '11.001.001019.png'),
(3557, '11.001.001020', '11.001.001020.png'),
(3558, '11.001.001021', '11.001.001021.png'),
(3559, '11.001.001022', '11.001.001022.png'),
(3560, '11.001.001023', '11.001.001023.png'),
(3561, '11.001.001024', '11.001.001024.png'),
(3562, '11.001.001025', '11.001.001025.png'),
(3563, '11.001.001026', '11.001.001026.png'),
(3564, '11.001.001027', '11.001.001027.png'),
(3565, '11.001.001028', '11.001.001028.png'),
(3566, '11.001.001029', '11.001.001029.png'),
(3567, '11.001.001030', '11.001.001030.png'),
(3568, '11.001.001031', '11.001.001031.png'),
(3569, '11.001.001032', '11.001.001032.png'),
(3570, '11.001.001033', '11.001.001033.png'),
(3571, '11.001.001034', '11.001.001034.png'),
(3572, '11.001.001035', '11.001.001035.png'),
(3573, '11.001.001036', '11.001.001036.png'),
(3574, '11.001.001037', '11.001.001037.png'),
(3575, '11.001.001038', '11.001.001038.png'),
(3576, '11.001.001039', '11.001.001039.png'),
(3577, '11.001.001040', '11.001.001040.png'),
(3578, '11.001.001041', '11.001.001041.png'),
(3579, '11.001.001042', '11.001.001042.png'),
(3580, '11.001.001043', '11.001.001043.png'),
(3581, '11.001.001044', '11.001.001044.png'),
(3582, '11.001.001045', '11.001.001045.png'),
(3583, '11.001.001046', '11.001.001046.png'),
(3584, '11.001.001047', '11.001.001047.png'),
(3585, '11.001.001048', '11.001.001048.png'),
(3586, '11.001.001049', '11.001.001049.png'),
(3587, '11.001.001050', '11.001.001050.png'),
(3588, '11.001.001051', '11.001.001051.png'),
(3589, '11.001.001052', '11.001.001052.png'),
(3590, '11.001.001053', '11.001.001053.png'),
(3591, '11.001.001054', '11.001.001054.png'),
(3592, '11.001.001055', '11.001.001055.png'),
(3593, '11.001.001056', '11.001.001056.png'),
(3594, '11.001.001057', '11.001.001057.png'),
(3595, '11.001.001058', '11.001.001058.png'),
(3596, '11.001.001059', '11.001.001059.png'),
(3597, '11.001.001060', '11.001.001060.png'),
(3598, '11.001.001061', '11.001.001061.png'),
(3599, '11.001.001062', '11.001.001062.png'),
(3600, '11.001.001063', '11.001.001063.png'),
(3601, '11.001.001064', '11.001.001064.png'),
(3602, '11.001.001065', '11.001.001065.png'),
(3603, '11.001.001066', '11.001.001066.png'),
(3604, '11.001.001067', '11.001.001067.png'),
(3605, '11.001.001068', '11.001.001068.png'),
(3606, '11.001.001069', '11.001.001069.png'),
(3607, '11.001.001070', '11.001.001070.png'),
(3608, '11.001.001071', '11.001.001071.png'),
(3609, '11.001.001072', '11.001.001072.png'),
(3610, '11.001.001073', '11.001.001073.png'),
(3611, '11.001.001074', '11.001.001074.png'),
(3612, '11.001.001075', '11.001.001075.png'),
(3613, '11.001.001076', '11.001.001076.png'),
(3614, '11.001.001077', '11.001.001077.png'),
(3615, '11.001.001078', '11.001.001078.png'),
(3616, '11.001.001079', '11.001.001079.png'),
(3617, '11.001.001080', '11.001.001080.png'),
(3618, '11.001.001081', '11.001.001081.png'),
(3619, '11.001.001082', '11.001.001082.png'),
(3620, '11.001.001083', '11.001.001083.png'),
(3621, '11.001.001084', '11.001.001084.png'),
(3622, '11.001.001085', '11.001.001085.png'),
(3623, '11.001.001086', '11.001.001086.png'),
(3624, '11.001.001087', '11.001.001087.png'),
(3625, '11.001.001088', '11.001.001088.png'),
(3626, '11.001.001089', '11.001.001089.png'),
(3627, '11.001.001090', '11.001.001090.png'),
(3628, '11.001.001091', '11.001.001091.png'),
(3629, '11.001.001092', '11.001.001092.png'),
(3630, '11.001.001093', '11.001.001093.png'),
(3631, '11.001.001094', '11.001.001094.png'),
(3632, '11.001.001095', '11.001.001095.png'),
(3633, '11.001.001096', '11.001.001096.png'),
(3634, '11.001.001097', '11.001.001097.png'),
(3635, '11.001.001098', '11.001.001098.png'),
(3636, '11.001.001099', '11.001.001099.png'),
(3637, '11.001.001100', '11.001.001100.png'),
(3638, '11.001.001101', '11.001.001101.png'),
(3639, '11.001.001102', '11.001.001102.png'),
(3640, '11.001.001103', '11.001.001103.png'),
(3641, '11.001.001104', '11.001.001104.png'),
(3642, '11.001.001105', '11.001.001105.png'),
(3643, '11.001.001106', '11.001.001106.png'),
(3644, '11.001.001107', '11.001.001107.png'),
(3645, '11.001.001108', '11.001.001108.png'),
(3646, '11.001.001109', '11.001.001109.png'),
(3647, '11.001.001110', '11.001.001110.png'),
(3648, '11.001.001111', '11.001.001111.png'),
(3649, '11.001.001112', '11.001.001112.png'),
(3650, '11.001.001113', '11.001.001113.png'),
(3651, '11.001.001114', '11.001.001114.png'),
(3652, '11.001.001115', '11.001.001115.png'),
(3653, '11.001.001116', '11.001.001116.png'),
(3654, '11.001.001117', '11.001.001117.png'),
(3655, '11.001.001118', '11.001.001118.png'),
(3656, '11.001.001119', '11.001.001119.png'),
(3657, '11.001.001120', '11.001.001120.png'),
(3658, '11.001.001121', '11.001.001121.png'),
(3659, '11.001.001122', '11.001.001122.png'),
(3660, '11.001.001123', '11.001.001123.png'),
(3661, '11.001.001124', '11.001.001124.png'),
(3662, '11.001.001125', '11.001.001125.png'),
(3663, '11.001.001126', '11.001.001126.png'),
(3664, '11.001.001127', '11.001.001127.png'),
(3665, '11.001.001128', '11.001.001128.png'),
(3666, '11.001.001129', '11.001.001129.png'),
(3667, '11.001.001130', '11.001.001130.png'),
(3668, '11.001.001131', '11.001.001131.png'),
(3669, '11.001.001132', '11.001.001132.png'),
(3670, '11.001.001133', '11.001.001133.png'),
(3671, '11.001.001134', '11.001.001134.png');
INSERT INTO `anggota` (`id`, `no_anggota`, `qr_file`) VALUES
(3672, '11.001.001135', '11.001.001135.png'),
(3673, '11.001.001136', '11.001.001136.png'),
(3674, '11.001.001137', '11.001.001137.png'),
(3675, '11.001.001138', '11.001.001138.png'),
(3676, '11.001.001139', '11.001.001139.png'),
(3677, '11.001.001140', '11.001.001140.png'),
(3678, '11.001.001141', '11.001.001141.png'),
(3679, '11.001.001142', '11.001.001142.png'),
(3680, '11.001.001143', '11.001.001143.png'),
(3681, '11.001.001144', '11.001.001144.png'),
(3682, '11.001.001145', '11.001.001145.png'),
(3683, '11.001.001146', '11.001.001146.png'),
(3684, '11.001.001147', '11.001.001147.png'),
(3685, '11.001.001148', '11.001.001148.png'),
(3686, '11.001.001149', '11.001.001149.png'),
(3687, '11.001.001150', '11.001.001150.png'),
(3688, '11.001.001151', '11.001.001151.png'),
(3689, '11.001.001152', '11.001.001152.png'),
(3690, '11.001.001153', '11.001.001153.png'),
(3691, '11.001.001154', '11.001.001154.png'),
(3692, '11.001.001155', '11.001.001155.png'),
(3693, '11.001.001156', '11.001.001156.png'),
(3694, '11.001.001157', '11.001.001157.png'),
(3695, '11.001.001158', '11.001.001158.png'),
(3696, '11.001.001159', '11.001.001159.png'),
(3697, '11.001.001160', '11.001.001160.png'),
(3698, '11.001.001161', '11.001.001161.png'),
(3699, '11.001.001162', '11.001.001162.png'),
(3700, '11.001.001163', '11.001.001163.png'),
(3701, '11.001.001164', '11.001.001164.png'),
(3702, '11.001.001165', '11.001.001165.png'),
(3703, '11.001.001166', '11.001.001166.png'),
(3704, '11.001.001167', '11.001.001167.png'),
(3705, '11.001.001168', '11.001.001168.png'),
(3706, '11.001.001169', '11.001.001169.png'),
(3707, '11.001.001170', '11.001.001170.png'),
(3708, '11.001.001171', '11.001.001171.png'),
(3709, '11.001.001172', '11.001.001172.png'),
(3710, '11.001.001173', '11.001.001173.png'),
(3711, '11.001.001174', '11.001.001174.png'),
(3712, '11.001.001175', '11.001.001175.png'),
(3713, '11.001.001176', '11.001.001176.png'),
(3714, '11.001.001177', '11.001.001177.png'),
(3715, '11.001.001178', '11.001.001178.png'),
(3716, '11.001.001179', '11.001.001179.png'),
(3717, '11.001.001180', '11.001.001180.png'),
(3718, '11.001.001181', '11.001.001181.png'),
(3719, '11.001.001182', '11.001.001182.png'),
(3720, '11.001.001183', '11.001.001183.png'),
(3721, '11.001.001184', '11.001.001184.png'),
(3722, '11.001.001185', '11.001.001185.png'),
(3723, '11.001.001186', '11.001.001186.png'),
(3724, '11.001.001187', '11.001.001187.png'),
(3725, '11.001.001188', '11.001.001188.png'),
(3726, '11.001.001189', '11.001.001189.png'),
(3727, '11.001.001190', '11.001.001190.png'),
(3728, '11.001.001191', '11.001.001191.png'),
(3729, '11.001.001192', '11.001.001192.png'),
(3730, '11.001.001193', '11.001.001193.png'),
(3731, '11.001.001194', '11.001.001194.png'),
(3732, '11.001.001195', '11.001.001195.png'),
(3733, '11.001.001196', '11.001.001196.png'),
(3734, '11.001.001197', '11.001.001197.png'),
(3735, '11.001.001198', '11.001.001198.png'),
(3736, '11.001.001199', '11.001.001199.png'),
(3737, '11.001.001200', '11.001.001200.png'),
(3738, '11.001.001201', '11.001.001201.png'),
(3739, '11.001.001202', '11.001.001202.png'),
(3740, '11.001.001203', '11.001.001203.png'),
(3741, '11.001.001204', '11.001.001204.png'),
(3742, '11.001.001205', '11.001.001205.png'),
(3743, '11.001.001206', '11.001.001206.png'),
(3744, '11.001.001207', '11.001.001207.png'),
(3745, '11.001.001208', '11.001.001208.png'),
(3746, '11.001.001209', '11.001.001209.png'),
(3747, '11.001.001210', '11.001.001210.png'),
(3748, '11.001.001211', '11.001.001211.png'),
(3749, '11.001.001212', '11.001.001212.png'),
(3750, '11.001.001213', '11.001.001213.png'),
(3751, '11.001.001214', '11.001.001214.png'),
(3752, '11.001.001215', '11.001.001215.png'),
(3753, '11.001.001216', '11.001.001216.png'),
(3754, '11.001.001217', '11.001.001217.png'),
(3755, '11.001.001218', '11.001.001218.png'),
(3756, '11.001.001219', '11.001.001219.png'),
(3757, '11.001.001220', '11.001.001220.png'),
(3758, '11.001.001221', '11.001.001221.png'),
(3759, '11.001.001222', '11.001.001222.png'),
(3760, '11.001.001223', '11.001.001223.png'),
(3761, '11.001.001224', '11.001.001224.png'),
(3762, '11.001.001225', '11.001.001225.png'),
(3763, '11.001.001226', '11.001.001226.png'),
(3764, '11.001.001227', '11.001.001227.png'),
(3765, '11.001.001228', '11.001.001228.png'),
(3766, '11.001.001229', '11.001.001229.png'),
(3767, '11.001.001230', '11.001.001230.png'),
(3768, '11.001.001231', '11.001.001231.png'),
(3769, '11.001.001232', '11.001.001232.png'),
(3770, '11.001.001233', '11.001.001233.png'),
(3771, '11.001.001234', '11.001.001234.png'),
(3772, '11.001.001235', '11.001.001235.png'),
(3773, '11.001.001236', '11.001.001236.png'),
(3774, '11.001.001237', '11.001.001237.png'),
(3775, '11.001.001238', '11.001.001238.png'),
(3776, '11.001.001239', '11.001.001239.png'),
(3777, '11.001.001240', '11.001.001240.png'),
(3778, '11.001.001241', '11.001.001241.png'),
(3779, '11.001.001242', '11.001.001242.png'),
(3780, '11.001.001243', '11.001.001243.png'),
(3781, '11.001.001244', '11.001.001244.png'),
(3782, '11.001.001245', '11.001.001245.png'),
(3783, '11.001.001246', '11.001.001246.png'),
(3784, '11.001.001247', '11.001.001247.png'),
(3785, '11.001.001248', '11.001.001248.png'),
(3786, '11.001.001249', '11.001.001249.png'),
(3787, '11.001.001250', '11.001.001250.png'),
(3788, '11.001.001251', '11.001.001251.png'),
(3789, '11.001.001252', '11.001.001252.png'),
(3790, '11.001.001253', '11.001.001253.png'),
(3791, '11.001.001254', '11.001.001254.png'),
(3792, '11.001.001255', '11.001.001255.png'),
(3793, '11.001.001256', '11.001.001256.png'),
(3794, '11.001.001257', '11.001.001257.png'),
(3795, '11.001.001258', '11.001.001258.png'),
(3796, '11.001.001259', '11.001.001259.png'),
(3797, '11.001.001260', '11.001.001260.png'),
(3798, '11.001.001261', '11.001.001261.png'),
(3799, '11.001.001262', '11.001.001262.png'),
(3800, '11.001.001263', '11.001.001263.png'),
(3801, '11.001.001264', '11.001.001264.png'),
(3802, '11.001.001265', '11.001.001265.png'),
(3803, '11.001.001266', '11.001.001266.png'),
(3804, '11.001.001267', '11.001.001267.png'),
(3805, '11.001.001268', '11.001.001268.png'),
(3806, '11.001.001269', '11.001.001269.png'),
(3807, '11.001.001270', '11.001.001270.png'),
(3808, '11.001.001271', '11.001.001271.png'),
(3809, '11.001.001272', '11.001.001272.png'),
(3810, '11.001.001273', '11.001.001273.png'),
(3811, '11.001.001274', '11.001.001274.png'),
(3812, '11.001.001275', '11.001.001275.png'),
(3813, '11.001.001276', '11.001.001276.png'),
(3814, '11.001.001277', '11.001.001277.png'),
(3815, '11.001.001278', '11.001.001278.png'),
(3816, '11.001.001279', '11.001.001279.png'),
(3817, '11.001.001280', '11.001.001280.png'),
(3818, '11.001.001281', '11.001.001281.png'),
(3819, '11.001.001282', '11.001.001282.png'),
(3820, '11.001.001283', '11.001.001283.png'),
(3821, '11.001.001284', '11.001.001284.png'),
(3822, '11.001.001285', '11.001.001285.png'),
(3823, '11.001.001286', '11.001.001286.png'),
(3824, '11.001.001287', '11.001.001287.png'),
(3825, '11.001.001288', '11.001.001288.png'),
(3826, '11.001.001289', '11.001.001289.png'),
(3827, '11.001.001290', '11.001.001290.png'),
(3828, '11.001.001291', '11.001.001291.png'),
(3829, '11.001.001292', '11.001.001292.png'),
(3830, '11.001.001293', '11.001.001293.png'),
(3831, '11.001.001294', '11.001.001294.png'),
(3832, '11.001.001295', '11.001.001295.png'),
(3833, '11.001.001296', '11.001.001296.png'),
(3834, '11.001.001297', '11.001.001297.png'),
(3835, '11.001.001298', '11.001.001298.png'),
(3836, '11.001.001299', '11.001.001299.png'),
(3837, '11.001.001300', '11.001.001300.png'),
(3838, '11.001.001301', '11.001.001301.png'),
(3839, '11.001.001302', '11.001.001302.png'),
(3840, '11.001.001303', '11.001.001303.png'),
(3841, '11.001.001304', '11.001.001304.png'),
(3842, '11.001.001305', '11.001.001305.png'),
(3843, '11.001.001306', '11.001.001306.png'),
(3844, '11.001.001307', '11.001.001307.png'),
(3845, '11.001.001308', '11.001.001308.png'),
(3846, '11.001.001309', '11.001.001309.png'),
(3847, '11.001.001310', '11.001.001310.png'),
(3848, '11.001.001311', '11.001.001311.png'),
(3849, '11.001.001312', '11.001.001312.png'),
(3850, '11.001.001313', '11.001.001313.png'),
(3851, '11.001.001314', '11.001.001314.png'),
(3852, '11.001.001315', '11.001.001315.png'),
(3853, '11.001.001316', '11.001.001316.png'),
(3854, '11.001.001317', '11.001.001317.png'),
(3855, '11.001.001318', '11.001.001318.png'),
(3856, '11.001.001319', '11.001.001319.png'),
(3857, '11.001.001320', '11.001.001320.png'),
(3858, '11.001.001321', '11.001.001321.png'),
(3859, '11.001.001322', '11.001.001322.png'),
(3860, '11.001.001323', '11.001.001323.png'),
(3861, '11.001.001324', '11.001.001324.png'),
(3862, '11.001.001325', '11.001.001325.png'),
(3863, '11.001.001326', '11.001.001326.png'),
(3864, '11.001.001327', '11.001.001327.png'),
(3865, '11.001.001328', '11.001.001328.png'),
(3866, '11.001.001329', '11.001.001329.png'),
(3867, '11.001.001330', '11.001.001330.png'),
(3868, '11.001.001331', '11.001.001331.png'),
(3869, '11.001.001332', '11.001.001332.png'),
(3870, '11.001.001333', '11.001.001333.png'),
(3871, '11.001.001334', '11.001.001334.png'),
(3872, '11.001.001335', '11.001.001335.png'),
(3873, '11.001.001336', '11.001.001336.png'),
(3874, '11.001.001337', '11.001.001337.png'),
(3875, '11.001.001338', '11.001.001338.png'),
(3876, '11.001.001339', '11.001.001339.png'),
(3877, '11.001.001340', '11.001.001340.png'),
(3878, '11.001.001341', '11.001.001341.png'),
(3879, '11.001.001342', '11.001.001342.png'),
(3880, '11.001.001343', '11.001.001343.png'),
(3881, '11.001.001344', '11.001.001344.png'),
(3882, '11.001.001345', '11.001.001345.png'),
(3883, '11.001.001346', '11.001.001346.png'),
(3884, '11.001.001347', '11.001.001347.png'),
(3885, '11.001.001348', '11.001.001348.png'),
(3886, '11.001.001349', '11.001.001349.png'),
(3887, '11.001.001350', '11.001.001350.png'),
(3888, '11.001.001351', '11.001.001351.png'),
(3889, '11.001.001352', '11.001.001352.png'),
(3890, '11.001.001353', '11.001.001353.png'),
(3891, '11.001.001354', '11.001.001354.png'),
(3892, '11.001.001355', '11.001.001355.png'),
(3893, '11.001.001356', '11.001.001356.png'),
(3894, '11.001.001357', '11.001.001357.png'),
(3895, '11.001.001358', '11.001.001358.png'),
(3896, '11.001.001359', '11.001.001359.png'),
(3897, '11.001.001360', '11.001.001360.png'),
(3898, '11.001.001361', '11.001.001361.png'),
(3899, '11.001.001362', '11.001.001362.png'),
(3900, '11.001.001363', '11.001.001363.png'),
(3901, '11.001.001364', '11.001.001364.png'),
(3902, '11.001.001365', '11.001.001365.png'),
(3903, '11.001.001366', '11.001.001366.png'),
(3904, '11.001.001367', '11.001.001367.png'),
(3905, '11.001.001368', '11.001.001368.png'),
(3906, '11.001.001369', '11.001.001369.png'),
(3907, '11.001.001370', '11.001.001370.png'),
(3908, '11.001.001371', '11.001.001371.png'),
(3909, '11.001.001372', '11.001.001372.png'),
(3910, '11.001.001373', '11.001.001373.png'),
(3911, '11.001.001374', '11.001.001374.png'),
(3912, '11.001.001375', '11.001.001375.png'),
(3913, '11.001.001376', '11.001.001376.png'),
(3914, '11.001.001377', '11.001.001377.png'),
(3915, '11.001.001378', '11.001.001378.png'),
(3916, '11.001.001379', '11.001.001379.png'),
(3917, '11.001.001380', '11.001.001380.png'),
(3918, '11.001.001381', '11.001.001381.png'),
(3919, '11.001.001382', '11.001.001382.png'),
(3920, '11.001.001383', '11.001.001383.png'),
(3921, '11.001.001384', '11.001.001384.png'),
(3922, '11.001.001385', '11.001.001385.png'),
(3923, '11.001.001386', '11.001.001386.png'),
(3924, '11.001.001387', '11.001.001387.png'),
(3925, '11.001.001388', '11.001.001388.png'),
(3926, '11.001.001389', '11.001.001389.png'),
(3927, '11.001.001390', '11.001.001390.png'),
(3928, '11.001.001391', '11.001.001391.png'),
(3929, '11.001.001392', '11.001.001392.png'),
(3930, '11.001.001393', '11.001.001393.png'),
(3931, '11.001.001394', '11.001.001394.png'),
(3932, '11.001.001395', '11.001.001395.png'),
(3933, '11.001.001396', '11.001.001396.png'),
(3934, '11.001.001397', '11.001.001397.png'),
(3935, '11.001.001398', '11.001.001398.png'),
(3936, '11.001.001399', '11.001.001399.png'),
(3937, '11.001.001400', '11.001.001400.png'),
(3938, '11.001.001401', '11.001.001401.png'),
(3939, '11.001.001402', '11.001.001402.png'),
(3940, '11.001.001403', '11.001.001403.png'),
(3941, '11.001.001404', '11.001.001404.png'),
(3942, '11.001.001405', '11.001.001405.png'),
(3943, '11.001.001406', '11.001.001406.png'),
(3944, '11.001.001407', '11.001.001407.png'),
(3945, '11.001.001408', '11.001.001408.png'),
(3946, '11.001.001409', '11.001.001409.png'),
(3947, '11.001.001410', '11.001.001410.png'),
(3948, '11.001.001411', '11.001.001411.png'),
(3949, '11.001.001412', '11.001.001412.png'),
(3950, '11.001.001413', '11.001.001413.png'),
(3951, '11.001.001414', '11.001.001414.png'),
(3952, '11.001.001415', '11.001.001415.png'),
(3953, '11.001.001416', '11.001.001416.png'),
(3954, '11.001.001417', '11.001.001417.png'),
(3955, '11.001.001418', '11.001.001418.png'),
(3956, '11.001.001419', '11.001.001419.png'),
(3957, '11.001.001420', '11.001.001420.png'),
(3958, '11.001.001421', '11.001.001421.png'),
(3959, '11.001.001422', '11.001.001422.png'),
(3960, '11.001.001423', '11.001.001423.png'),
(3961, '11.001.001424', '11.001.001424.png'),
(3962, '11.001.001425', '11.001.001425.png'),
(3963, '11.001.001426', '11.001.001426.png'),
(3964, '11.001.001427', '11.001.001427.png'),
(3965, '11.001.001428', '11.001.001428.png'),
(3966, '11.001.001429', '11.001.001429.png'),
(3967, '11.001.001430', '11.001.001430.png'),
(3968, '11.001.001431', '11.001.001431.png'),
(3969, '11.001.001432', '11.001.001432.png'),
(3970, '11.001.001433', '11.001.001433.png'),
(3971, '11.001.001434', '11.001.001434.png'),
(3972, '11.001.001435', '11.001.001435.png'),
(3973, '11.001.001436', '11.001.001436.png'),
(3974, '11.001.001437', '11.001.001437.png'),
(3975, '11.001.001438', '11.001.001438.png'),
(3976, '11.001.001439', '11.001.001439.png'),
(3977, '11.001.001440', '11.001.001440.png'),
(3978, '11.001.001441', '11.001.001441.png'),
(3979, '11.001.001442', '11.001.001442.png'),
(3980, '11.001.001443', '11.001.001443.png'),
(3981, '11.001.001444', '11.001.001444.png'),
(3982, '11.001.001445', '11.001.001445.png'),
(3983, '11.001.001446', '11.001.001446.png'),
(3984, '11.001.001447', '11.001.001447.png'),
(3985, '11.001.001448', '11.001.001448.png'),
(3986, '11.001.001449', '11.001.001449.png'),
(3987, '11.001.001450', '11.001.001450.png'),
(3988, '11.001.001451', '11.001.001451.png'),
(3989, '11.001.001452', '11.001.001452.png'),
(3990, '11.001.001453', '11.001.001453.png'),
(3991, '11.001.001454', '11.001.001454.png'),
(3992, '11.001.001455', '11.001.001455.png'),
(3993, '11.001.001456', '11.001.001456.png'),
(3994, '11.001.001457', '11.001.001457.png'),
(3995, '11.001.001458', '11.001.001458.png'),
(3996, '11.001.001459', '11.001.001459.png'),
(3997, '11.001.001460', '11.001.001460.png'),
(3998, '11.001.001461', '11.001.001461.png'),
(3999, '11.001.001462', '11.001.001462.png'),
(4000, '11.001.001463', '11.001.001463.png'),
(4001, '11.001.001464', '11.001.001464.png'),
(4002, '11.001.001465', '11.001.001465.png'),
(4003, '11.001.001466', '11.001.001466.png'),
(4004, '11.001.001467', '11.001.001467.png'),
(4005, '11.001.001468', '11.001.001468.png'),
(4006, '11.001.001469', '11.001.001469.png'),
(4007, '11.001.001470', '11.001.001470.png'),
(4008, '11.001.001471', '11.001.001471.png'),
(4009, '11.001.001472', '11.001.001472.png'),
(4010, '11.001.001473', '11.001.001473.png'),
(4011, '11.001.001474', '11.001.001474.png'),
(4012, '11.001.001475', '11.001.001475.png'),
(4013, '11.001.001476', '11.001.001476.png'),
(4014, '11.001.001477', '11.001.001477.png'),
(4015, '11.001.001478', '11.001.001478.png'),
(4016, '11.001.001479', '11.001.001479.png'),
(4017, '11.001.001480', '11.001.001480.png'),
(4018, '11.001.001481', '11.001.001481.png'),
(4019, '11.001.001482', '11.001.001482.png'),
(4020, '11.001.001483', '11.001.001483.png'),
(4021, '11.001.001484', '11.001.001484.png'),
(4022, '11.001.001485', '11.001.001485.png'),
(4023, '11.001.001486', '11.001.001486.png'),
(4024, '11.001.001487', '11.001.001487.png'),
(4025, '11.001.001488', '11.001.001488.png'),
(4026, '11.001.001489', '11.001.001489.png'),
(4027, '11.001.001490', '11.001.001490.png'),
(4028, '11.001.001491', '11.001.001491.png'),
(4029, '11.001.001492', '11.001.001492.png'),
(4030, '11.001.001493', '11.001.001493.png'),
(4031, '11.001.001494', '11.001.001494.png'),
(4032, '11.001.001495', '11.001.001495.png'),
(4033, '11.001.001496', '11.001.001496.png'),
(4034, '11.001.001497', '11.001.001497.png'),
(4035, '11.001.001498', '11.001.001498.png'),
(4036, '11.001.001499', '11.001.001499.png'),
(4037, '11.001.001500', '11.001.001500.png'),
(4038, '11.001.001501', '11.001.001501.png'),
(4039, '11.001.001502', '11.001.001502.png'),
(4040, '11.001.001503', '11.001.001503.png'),
(4041, '11.001.001504', '11.001.001504.png'),
(4042, '11.001.001505', '11.001.001505.png'),
(4043, '11.001.001506', '11.001.001506.png'),
(4044, '11.001.001507', '11.001.001507.png'),
(4045, '11.001.001508', '11.001.001508.png'),
(4046, '11.001.001509', '11.001.001509.png'),
(4047, '11.001.001510', '11.001.001510.png'),
(4048, '11.001.001511', '11.001.001511.png'),
(4049, '11.001.001512', '11.001.001512.png'),
(4050, '11.001.001513', '11.001.001513.png'),
(4051, '11.001.001514', '11.001.001514.png'),
(4052, '11.001.001515', '11.001.001515.png'),
(4053, '11.001.001516', '11.001.001516.png'),
(4054, '11.001.001517', '11.001.001517.png'),
(4055, '11.001.001518', '11.001.001518.png'),
(4056, '11.001.001519', '11.001.001519.png'),
(4057, '11.001.001520', '11.001.001520.png'),
(4058, '11.001.001521', '11.001.001521.png'),
(4059, '11.001.001522', '11.001.001522.png'),
(4060, '11.001.001523', '11.001.001523.png'),
(4061, '11.001.001524', '11.001.001524.png'),
(4062, '11.001.001525', '11.001.001525.png'),
(4063, '11.001.001526', '11.001.001526.png'),
(4064, '11.001.001527', '11.001.001527.png'),
(4065, '11.001.001528', '11.001.001528.png'),
(4066, '11.001.001529', '11.001.001529.png'),
(4067, '11.001.001530', '11.001.001530.png'),
(4068, '11.001.001531', '11.001.001531.png'),
(4069, '11.001.001532', '11.001.001532.png'),
(4070, '11.001.001533', '11.001.001533.png'),
(4071, '11.001.001534', '11.001.001534.png'),
(4072, '11.001.001535', '11.001.001535.png'),
(4073, '11.001.001536', '11.001.001536.png'),
(4074, '11.001.001537', '11.001.001537.png'),
(4075, '11.001.001538', '11.001.001538.png'),
(4076, '11.001.001539', '11.001.001539.png'),
(4077, '11.001.001540', '11.001.001540.png'),
(4078, '11.001.001541', '11.001.001541.png'),
(4079, '11.001.001542', '11.001.001542.png'),
(4080, '11.001.001543', '11.001.001543.png'),
(4081, '11.001.001544', '11.001.001544.png'),
(4082, '11.001.001545', '11.001.001545.png'),
(4083, '11.001.001546', '11.001.001546.png'),
(4084, '11.001.001547', '11.001.001547.png'),
(4085, '11.001.001548', '11.001.001548.png'),
(4086, '11.001.001549', '11.001.001549.png'),
(4087, '11.001.001550', '11.001.001550.png'),
(4088, '11.001.001551', '11.001.001551.png'),
(4089, '11.001.001552', '11.001.001552.png'),
(4090, '11.001.001553', '11.001.001553.png'),
(4091, '11.001.001554', '11.001.001554.png'),
(4092, '11.001.001555', '11.001.001555.png'),
(4093, '11.001.001556', '11.001.001556.png'),
(4094, '11.001.001557', '11.001.001557.png'),
(4095, '11.001.001558', '11.001.001558.png'),
(4096, '11.001.001559', '11.001.001559.png'),
(4097, '11.001.001560', '11.001.001560.png'),
(4098, '11.001.001561', '11.001.001561.png'),
(4099, '11.001.001562', '11.001.001562.png'),
(4100, '11.001.001563', '11.001.001563.png'),
(4101, '11.001.001564', '11.001.001564.png'),
(4102, '11.001.001565', '11.001.001565.png'),
(4103, '11.001.001566', '11.001.001566.png'),
(4104, '11.001.001567', '11.001.001567.png'),
(4105, '11.001.001568', '11.001.001568.png'),
(4106, '11.001.001569', '11.001.001569.png'),
(4107, '11.001.001570', '11.001.001570.png'),
(4108, '11.001.001571', '11.001.001571.png'),
(4109, '11.001.001572', '11.001.001572.png'),
(4110, '11.001.001573', '11.001.001573.png'),
(4111, '11.001.001574', '11.001.001574.png'),
(4112, '11.001.001575', '11.001.001575.png'),
(4113, '11.001.001576', '11.001.001576.png'),
(4114, '11.001.001577', '11.001.001577.png'),
(4115, '11.001.001578', '11.001.001578.png'),
(4116, '11.001.001579', '11.001.001579.png'),
(4117, '11.001.001580', '11.001.001580.png'),
(4118, '11.001.001581', '11.001.001581.png'),
(4119, '11.001.001582', '11.001.001582.png'),
(4120, '11.001.001583', '11.001.001583.png'),
(4121, '11.001.001584', '11.001.001584.png'),
(4122, '11.001.001585', '11.001.001585.png'),
(4123, '11.001.001586', '11.001.001586.png'),
(4124, '11.001.001587', '11.001.001587.png'),
(4125, '11.001.001588', '11.001.001588.png'),
(4126, '11.001.001589', '11.001.001589.png'),
(4127, '11.001.001590', '11.001.001590.png'),
(4128, '11.001.001591', '11.001.001591.png'),
(4129, '11.001.001592', '11.001.001592.png'),
(4130, '11.001.001593', '11.001.001593.png'),
(4131, '11.001.001594', '11.001.001594.png'),
(4132, '11.001.001595', '11.001.001595.png'),
(4133, '11.001.001596', '11.001.001596.png'),
(4134, '11.001.001597', '11.001.001597.png'),
(4135, '11.001.001598', '11.001.001598.png'),
(4136, '11.001.001599', '11.001.001599.png'),
(4137, '11.001.001600', '11.001.001600.png'),
(4138, '11.001.001601', '11.001.001601.png'),
(4139, '11.001.001602', '11.001.001602.png'),
(4140, '11.001.001603', '11.001.001603.png'),
(4141, '11.001.001604', '11.001.001604.png'),
(4142, '11.001.001605', '11.001.001605.png'),
(4143, '11.001.001606', '11.001.001606.png'),
(4144, '11.001.001607', '11.001.001607.png'),
(4145, '11.001.001608', '11.001.001608.png'),
(4146, '11.001.001609', '11.001.001609.png'),
(4147, '11.001.001610', '11.001.001610.png'),
(4148, '11.001.001611', '11.001.001611.png'),
(4149, '11.001.001612', '11.001.001612.png'),
(4150, '11.001.001613', '11.001.001613.png'),
(4151, '11.001.001614', '11.001.001614.png'),
(4152, '11.001.001615', '11.001.001615.png'),
(4153, '11.001.001616', '11.001.001616.png'),
(4154, '11.001.001617', '11.001.001617.png'),
(4155, '11.001.001618', '11.001.001618.png'),
(4156, '11.001.001619', '11.001.001619.png'),
(4157, '11.001.001620', '11.001.001620.png'),
(4158, '11.001.001621', '11.001.001621.png'),
(4159, '11.001.001622', '11.001.001622.png'),
(4160, '11.001.001623', '11.001.001623.png'),
(4161, '11.001.001624', '11.001.001624.png'),
(4162, '11.001.001625', '11.001.001625.png'),
(4163, '11.001.001626', '11.001.001626.png'),
(4164, '11.001.001627', '11.001.001627.png'),
(4165, '11.001.001628', '11.001.001628.png'),
(4166, '11.001.001629', '11.001.001629.png'),
(4167, '11.001.001630', '11.001.001630.png'),
(4168, '11.001.001631', '11.001.001631.png'),
(4169, '11.001.001632', '11.001.001632.png'),
(4170, '11.001.001633', '11.001.001633.png'),
(4171, '11.001.001634', '11.001.001634.png'),
(4172, '11.001.001635', '11.001.001635.png'),
(4173, '11.001.001636', '11.001.001636.png'),
(4174, '11.001.001637', '11.001.001637.png'),
(4175, '11.001.001638', '11.001.001638.png'),
(4176, '11.001.001639', '11.001.001639.png'),
(4177, '11.001.001640', '11.001.001640.png'),
(4178, '11.001.001641', '11.001.001641.png'),
(4179, '11.001.001642', '11.001.001642.png'),
(4180, '11.001.001643', '11.001.001643.png'),
(4181, '11.001.001644', '11.001.001644.png'),
(4182, '11.001.001645', '11.001.001645.png'),
(4183, '11.001.001646', '11.001.001646.png'),
(4184, '11.001.001647', '11.001.001647.png'),
(4185, '11.001.001648', '11.001.001648.png'),
(4186, '11.001.001649', '11.001.001649.png'),
(4187, '11.001.001650', '11.001.001650.png'),
(4188, '11.001.001651', '11.001.001651.png'),
(4189, '11.001.001652', '11.001.001652.png'),
(4190, '11.001.001653', '11.001.001653.png'),
(4191, '11.001.001654', '11.001.001654.png'),
(4192, '11.001.001655', '11.001.001655.png'),
(4193, '11.001.001656', '11.001.001656.png'),
(4194, '11.001.001657', '11.001.001657.png'),
(4195, '11.001.001658', '11.001.001658.png'),
(4196, '11.001.001659', '11.001.001659.png'),
(4197, '11.001.001660', '11.001.001660.png'),
(4198, '11.001.001661', '11.001.001661.png'),
(4199, '11.001.001662', '11.001.001662.png'),
(4200, '11.001.001663', '11.001.001663.png'),
(4201, '11.001.001664', '11.001.001664.png'),
(4202, '11.001.001665', '11.001.001665.png'),
(4203, '11.001.001666', '11.001.001666.png'),
(4204, '11.001.001667', '11.001.001667.png'),
(4205, '11.001.001668', '11.001.001668.png'),
(4206, '11.001.001669', '11.001.001669.png'),
(4207, '11.001.001670', '11.001.001670.png'),
(4208, '11.001.001671', '11.001.001671.png'),
(4209, '11.001.001672', '11.001.001672.png'),
(4210, '11.001.001673', '11.001.001673.png'),
(4211, '11.001.001674', '11.001.001674.png'),
(4212, '11.001.001675', '11.001.001675.png'),
(4213, '11.001.001676', '11.001.001676.png'),
(4214, '11.001.001677', '11.001.001677.png'),
(4215, '11.001.001678', '11.001.001678.png'),
(4216, '11.001.001679', '11.001.001679.png'),
(4217, '11.001.001680', '11.001.001680.png'),
(4218, '11.001.001681', '11.001.001681.png'),
(4219, '11.001.001682', '11.001.001682.png'),
(4220, '11.001.001683', '11.001.001683.png'),
(4221, '11.001.001684', '11.001.001684.png'),
(4222, '11.001.001685', '11.001.001685.png'),
(4223, '11.001.001686', '11.001.001686.png'),
(4224, '11.001.001687', '11.001.001687.png'),
(4225, '11.001.001688', '11.001.001688.png'),
(4226, '11.001.001689', '11.001.001689.png'),
(4227, '11.001.001690', '11.001.001690.png'),
(4228, '11.001.001691', '11.001.001691.png'),
(4229, '11.001.001692', '11.001.001692.png'),
(4230, '11.001.001693', '11.001.001693.png'),
(4231, '11.001.001694', '11.001.001694.png'),
(4232, '11.001.001695', '11.001.001695.png'),
(4233, '11.001.001696', '11.001.001696.png'),
(4234, '11.001.001697', '11.001.001697.png'),
(4235, '11.001.001698', '11.001.001698.png'),
(4236, '11.001.001699', '11.001.001699.png'),
(4237, '11.001.001700', '11.001.001700.png'),
(4238, '11.001.001701', '11.001.001701.png'),
(4239, '11.001.001702', '11.001.001702.png'),
(4240, '11.001.001703', '11.001.001703.png'),
(4241, '11.001.001704', '11.001.001704.png'),
(4242, '11.001.001705', '11.001.001705.png'),
(4243, '11.001.001706', '11.001.001706.png'),
(4244, '11.001.001707', '11.001.001707.png'),
(4245, '11.001.001708', '11.001.001708.png'),
(4246, '11.001.001709', '11.001.001709.png'),
(4247, '11.001.001710', '11.001.001710.png'),
(4248, '11.001.001711', '11.001.001711.png'),
(4249, '11.001.001712', '11.001.001712.png'),
(4250, '11.001.001713', '11.001.001713.png'),
(4251, '11.001.001714', '11.001.001714.png'),
(4252, '11.001.001715', '11.001.001715.png'),
(4253, '11.001.001716', '11.001.001716.png'),
(4254, '11.001.001717', '11.001.001717.png'),
(4255, '11.001.001718', '11.001.001718.png'),
(4256, '11.001.001719', '11.001.001719.png'),
(4257, '11.001.001720', '11.001.001720.png'),
(4258, '11.001.001721', '11.001.001721.png'),
(4259, '11.001.001722', '11.001.001722.png'),
(4260, '11.001.001723', '11.001.001723.png'),
(4261, '11.001.001724', '11.001.001724.png'),
(4262, '11.001.001725', '11.001.001725.png'),
(4263, '11.001.001726', '11.001.001726.png'),
(4264, '11.001.001727', '11.001.001727.png'),
(4265, '11.001.001728', '11.001.001728.png'),
(4266, '11.001.001729', '11.001.001729.png'),
(4267, '11.001.001730', '11.001.001730.png'),
(4268, '11.001.001731', '11.001.001731.png'),
(4269, '11.001.001732', '11.001.001732.png'),
(4270, '11.001.001733', '11.001.001733.png'),
(4271, '11.001.001734', '11.001.001734.png'),
(4272, '11.001.001735', '11.001.001735.png'),
(4273, '11.001.001736', '11.001.001736.png'),
(4274, '11.001.001737', '11.001.001737.png'),
(4275, '11.001.001738', '11.001.001738.png'),
(4276, '11.001.001739', '11.001.001739.png'),
(4277, '11.001.001740', '11.001.001740.png'),
(4278, '11.001.001741', '11.001.001741.png'),
(4279, '11.001.001742', '11.001.001742.png'),
(4280, '11.001.001743', '11.001.001743.png'),
(4281, '11.001.001744', '11.001.001744.png'),
(4282, '11.001.001745', '11.001.001745.png'),
(4283, '11.001.001746', '11.001.001746.png'),
(4284, '11.001.001747', '11.001.001747.png'),
(4285, '11.001.001748', '11.001.001748.png'),
(4286, '11.001.001749', '11.001.001749.png'),
(4287, '11.001.001750', '11.001.001750.png'),
(4288, '11.001.001751', '11.001.001751.png'),
(4289, '11.001.001752', '11.001.001752.png'),
(4290, '11.001.001753', '11.001.001753.png'),
(4291, '11.001.001754', '11.001.001754.png'),
(4292, '11.001.001755', '11.001.001755.png'),
(4293, '11.001.001756', '11.001.001756.png'),
(4294, '11.001.001757', '11.001.001757.png'),
(4295, '11.001.001758', '11.001.001758.png'),
(4296, '11.001.001759', '11.001.001759.png'),
(4297, '11.001.001760', '11.001.001760.png'),
(4298, '11.001.001761', '11.001.001761.png'),
(4299, '11.001.001762', '11.001.001762.png'),
(4300, '11.001.001763', '11.001.001763.png'),
(4301, '11.001.001764', '11.001.001764.png'),
(4302, '11.001.001765', '11.001.001765.png'),
(4303, '11.001.001766', '11.001.001766.png'),
(4304, '11.001.001767', '11.001.001767.png'),
(4305, '11.001.001768', '11.001.001768.png'),
(4306, '11.001.001769', '11.001.001769.png'),
(4307, '11.001.001770', '11.001.001770.png'),
(4308, '11.001.001771', '11.001.001771.png'),
(4309, '11.001.001772', '11.001.001772.png'),
(4310, '11.001.001773', '11.001.001773.png'),
(4311, '11.001.001774', '11.001.001774.png'),
(4312, '11.001.001775', '11.001.001775.png'),
(4313, '11.001.001776', '11.001.001776.png'),
(4314, '11.001.001777', '11.001.001777.png'),
(4315, '11.001.001778', '11.001.001778.png'),
(4316, '11.001.001779', '11.001.001779.png'),
(4317, '11.001.001780', '11.001.001780.png'),
(4318, '11.001.001781', '11.001.001781.png'),
(4319, '11.001.001782', '11.001.001782.png'),
(4320, '11.001.001783', '11.001.001783.png'),
(4321, '11.001.001784', '11.001.001784.png'),
(4322, '11.001.001785', '11.001.001785.png'),
(4323, '11.001.001786', '11.001.001786.png'),
(4324, '11.001.001787', '11.001.001787.png'),
(4325, '11.001.001788', '11.001.001788.png'),
(4326, '11.001.001789', '11.001.001789.png'),
(4327, '11.001.001790', '11.001.001790.png'),
(4328, '11.001.001791', '11.001.001791.png'),
(4329, '11.001.001792', '11.001.001792.png'),
(4330, '11.001.001793', '11.001.001793.png'),
(4331, '11.001.001794', '11.001.001794.png'),
(4332, '11.001.001795', '11.001.001795.png'),
(4333, '11.001.001796', '11.001.001796.png'),
(4334, '11.001.001797', '11.001.001797.png'),
(4335, '11.001.001798', '11.001.001798.png'),
(4336, '11.001.001799', '11.001.001799.png'),
(4337, '11.001.001800', '11.001.001800.png'),
(4338, '11.001.001801', '11.001.001801.png'),
(4339, '11.001.001802', '11.001.001802.png'),
(4340, '11.001.001803', '11.001.001803.png'),
(4341, '11.001.001804', '11.001.001804.png'),
(4342, '11.001.001805', '11.001.001805.png'),
(4343, '11.001.001806', '11.001.001806.png'),
(4344, '11.001.001807', '11.001.001807.png'),
(4345, '11.001.001808', '11.001.001808.png'),
(4346, '11.001.001809', '11.001.001809.png'),
(4347, '11.001.001810', '11.001.001810.png'),
(4348, '11.001.001811', '11.001.001811.png'),
(4349, '11.001.001812', '11.001.001812.png'),
(4350, '11.001.001813', '11.001.001813.png'),
(4351, '11.001.001814', '11.001.001814.png'),
(4352, '11.001.001815', '11.001.001815.png'),
(4353, '11.001.001816', '11.001.001816.png'),
(4354, '11.001.001817', '11.001.001817.png'),
(4355, '11.001.001818', '11.001.001818.png'),
(4356, '11.001.001819', '11.001.001819.png'),
(4357, '11.001.001820', '11.001.001820.png'),
(4358, '11.001.001821', '11.001.001821.png'),
(4359, '11.001.001822', '11.001.001822.png'),
(4360, '11.001.001823', '11.001.001823.png'),
(4361, '11.001.001824', '11.001.001824.png'),
(4362, '11.001.001825', '11.001.001825.png'),
(4363, '11.001.001826', '11.001.001826.png'),
(4364, '11.001.001827', '11.001.001827.png'),
(4365, '11.001.001828', '11.001.001828.png'),
(4366, '11.001.001829', '11.001.001829.png'),
(4367, '11.001.001830', '11.001.001830.png'),
(4368, '11.001.001831', '11.001.001831.png'),
(4369, '11.001.001832', '11.001.001832.png'),
(4370, '11.001.001833', '11.001.001833.png'),
(4371, '11.001.001834', '11.001.001834.png'),
(4372, '11.001.001835', '11.001.001835.png'),
(4373, '11.001.001836', '11.001.001836.png'),
(4374, '11.001.001837', '11.001.001837.png'),
(4375, '11.001.001838', '11.001.001838.png'),
(4376, '11.001.001839', '11.001.001839.png'),
(4377, '11.001.001840', '11.001.001840.png'),
(4378, '11.001.001841', '11.001.001841.png'),
(4379, '11.001.001842', '11.001.001842.png'),
(4380, '11.001.001843', '11.001.001843.png'),
(4381, '11.001.001844', '11.001.001844.png'),
(4382, '11.001.001845', '11.001.001845.png'),
(4383, '11.001.001846', '11.001.001846.png'),
(4384, '11.001.001847', '11.001.001847.png'),
(4385, '11.001.001848', '11.001.001848.png'),
(4386, '11.001.001849', '11.001.001849.png'),
(4387, '11.001.001850', '11.001.001850.png'),
(4388, '11.001.001851', '11.001.001851.png'),
(4389, '11.001.001852', '11.001.001852.png'),
(4390, '11.001.001853', '11.001.001853.png'),
(4391, '11.001.001854', '11.001.001854.png'),
(4392, '11.001.001855', '11.001.001855.png'),
(4393, '11.001.001856', '11.001.001856.png'),
(4394, '11.001.001857', '11.001.001857.png'),
(4395, '11.001.001858', '11.001.001858.png'),
(4396, '11.001.001859', '11.001.001859.png'),
(4397, '11.001.001860', '11.001.001860.png'),
(4398, '11.001.001861', '11.001.001861.png'),
(4399, '11.001.001862', '11.001.001862.png'),
(4400, '11.001.001863', '11.001.001863.png'),
(4401, '11.001.001864', '11.001.001864.png'),
(4402, '11.001.001865', '11.001.001865.png'),
(4403, '11.001.001866', '11.001.001866.png'),
(4404, '11.001.001867', '11.001.001867.png'),
(4405, '11.001.001868', '11.001.001868.png'),
(4406, '11.001.001869', '11.001.001869.png'),
(4407, '11.001.001870', '11.001.001870.png'),
(4408, '11.001.001871', '11.001.001871.png'),
(4409, '11.001.001872', '11.001.001872.png'),
(4410, '11.001.001873', '11.001.001873.png'),
(4411, '11.001.001874', '11.001.001874.png'),
(4412, '11.001.001875', '11.001.001875.png'),
(4413, '11.001.001876', '11.001.001876.png'),
(4414, '11.001.001877', '11.001.001877.png'),
(4415, '11.001.001878', '11.001.001878.png'),
(4416, '11.001.001879', '11.001.001879.png'),
(4417, '11.001.001880', '11.001.001880.png'),
(4418, '11.001.001881', '11.001.001881.png'),
(4419, '11.001.001882', '11.001.001882.png'),
(4420, '11.001.001883', '11.001.001883.png'),
(4421, '11.001.001884', '11.001.001884.png'),
(4422, '11.001.001885', '11.001.001885.png'),
(4423, '11.001.001886', '11.001.001886.png'),
(4424, '11.001.001887', '11.001.001887.png'),
(4425, '11.001.001888', '11.001.001888.png'),
(4426, '11.001.001889', '11.001.001889.png'),
(4427, '11.001.001890', '11.001.001890.png'),
(4428, '11.001.001891', '11.001.001891.png'),
(4429, '11.001.001892', '11.001.001892.png'),
(4430, '11.001.001893', '11.001.001893.png'),
(4431, '11.001.001894', '11.001.001894.png'),
(4432, '11.001.001895', '11.001.001895.png'),
(4433, '11.001.001896', '11.001.001896.png'),
(4434, '11.001.001897', '11.001.001897.png'),
(4435, '11.001.001898', '11.001.001898.png'),
(4436, '11.001.001899', '11.001.001899.png'),
(4437, '11.001.001900', '11.001.001900.png'),
(4438, '11.001.001901', '11.001.001901.png'),
(4439, '11.001.001902', '11.001.001902.png'),
(4440, '11.001.001903', '11.001.001903.png'),
(4441, '11.001.001904', '11.001.001904.png'),
(4442, '11.001.001905', '11.001.001905.png'),
(4443, '11.001.001906', '11.001.001906.png'),
(4444, '11.001.001907', '11.001.001907.png'),
(4445, '11.001.001908', '11.001.001908.png'),
(4446, '11.001.001909', '11.001.001909.png'),
(4447, '11.001.001910', '11.001.001910.png'),
(4448, '11.001.001911', '11.001.001911.png'),
(4449, '11.001.001912', '11.001.001912.png'),
(4450, '11.001.001913', '11.001.001913.png'),
(4451, '11.001.001914', '11.001.001914.png'),
(4452, '11.001.001915', '11.001.001915.png'),
(4453, '11.001.001916', '11.001.001916.png'),
(4454, '11.001.001917', '11.001.001917.png'),
(4455, '11.001.001918', '11.001.001918.png'),
(4456, '11.001.001919', '11.001.001919.png'),
(4457, '11.001.001920', '11.001.001920.png'),
(4458, '11.001.001921', '11.001.001921.png'),
(4459, '11.001.001922', '11.001.001922.png'),
(4460, '11.001.001923', '11.001.001923.png'),
(4461, '11.001.001924', '11.001.001924.png'),
(4462, '11.001.001925', '11.001.001925.png'),
(4463, '11.001.001926', '11.001.001926.png'),
(4464, '11.001.001927', '11.001.001927.png'),
(4465, '11.001.001928', '11.001.001928.png'),
(4466, '11.001.001929', '11.001.001929.png'),
(4467, '11.001.001930', '11.001.001930.png'),
(4468, '11.001.001931', '11.001.001931.png'),
(4469, '11.001.001932', '11.001.001932.png'),
(4470, '11.001.001933', '11.001.001933.png'),
(4471, '11.001.001934', '11.001.001934.png'),
(4472, '11.001.001935', '11.001.001935.png'),
(4473, '11.001.001936', '11.001.001936.png'),
(4474, '11.001.001937', '11.001.001937.png'),
(4475, '11.001.001938', '11.001.001938.png'),
(4476, '11.001.001939', '11.001.001939.png'),
(4477, '11.001.001940', '11.001.001940.png'),
(4478, '11.001.001941', '11.001.001941.png'),
(4479, '11.001.001942', '11.001.001942.png'),
(4480, '11.001.001943', '11.001.001943.png'),
(4481, '11.001.001944', '11.001.001944.png'),
(4482, '11.001.001945', '11.001.001945.png'),
(4483, '11.001.001946', '11.001.001946.png'),
(4484, '11.001.001947', '11.001.001947.png'),
(4485, '11.001.001948', '11.001.001948.png'),
(4486, '11.001.001949', '11.001.001949.png'),
(4487, '11.001.001950', '11.001.001950.png'),
(4488, '11.001.001951', '11.001.001951.png'),
(4489, '11.001.001952', '11.001.001952.png'),
(4490, '11.001.001953', '11.001.001953.png'),
(4491, '11.001.001954', '11.001.001954.png'),
(4492, '11.001.001955', '11.001.001955.png'),
(4493, '11.001.001956', '11.001.001956.png'),
(4494, '11.001.001957', '11.001.001957.png'),
(4495, '11.001.001958', '11.001.001958.png'),
(4496, '11.001.001959', '11.001.001959.png'),
(4497, '11.001.001960', '11.001.001960.png'),
(4498, '11.001.001961', '11.001.001961.png'),
(4499, '11.001.001962', '11.001.001962.png'),
(4500, '11.001.001963', '11.001.001963.png'),
(4501, '11.001.001964', '11.001.001964.png'),
(4502, '11.001.001965', '11.001.001965.png'),
(4503, '11.001.001966', '11.001.001966.png'),
(4504, '11.001.001967', '11.001.001967.png'),
(4505, '11.001.001968', '11.001.001968.png'),
(4506, '11.001.001969', '11.001.001969.png'),
(4507, '11.001.001970', '11.001.001970.png'),
(4508, '11.001.001971', '11.001.001971.png'),
(4509, '11.001.001972', '11.001.001972.png'),
(4510, '11.001.001973', '11.001.001973.png'),
(4511, '11.001.001974', '11.001.001974.png'),
(4512, '11.001.001975', '11.001.001975.png'),
(4513, '11.001.001976', '11.001.001976.png'),
(4514, '11.001.001977', '11.001.001977.png'),
(4515, '11.001.001978', '11.001.001978.png'),
(4516, '11.001.001979', '11.001.001979.png'),
(4517, '11.001.001980', '11.001.001980.png'),
(4518, '11.001.001981', '11.001.001981.png'),
(4519, '11.001.001982', '11.001.001982.png'),
(4520, '11.001.001983', '11.001.001983.png'),
(4521, '11.001.001984', '11.001.001984.png'),
(4522, '11.001.001985', '11.001.001985.png'),
(4523, '11.001.001986', '11.001.001986.png'),
(4524, '11.001.001987', '11.001.001987.png'),
(4525, '11.001.001988', '11.001.001988.png'),
(4526, '11.001.001989', '11.001.001989.png'),
(4527, '11.001.001990', '11.001.001990.png'),
(4528, '11.001.001991', '11.001.001991.png'),
(4529, '11.001.001992', '11.001.001992.png'),
(4530, '11.001.001993', '11.001.001993.png'),
(4531, '11.001.001994', '11.001.001994.png'),
(4532, '11.001.001995', '11.001.001995.png'),
(4533, '11.001.001996', '11.001.001996.png'),
(4534, '11.001.001997', '11.001.001997.png'),
(4535, '11.001.001998', '11.001.001998.png'),
(4536, '11.001.001999', '11.001.001999.png'),
(4537, '11.001.002000', '11.001.002000.png'),
(4538, '11.001.002001', '11.001.002001.png'),
(4539, '11.001.002002', '11.001.002002.png'),
(4540, '11.001.002003', '11.001.002003.png'),
(4541, '11.001.002004', '11.001.002004.png'),
(4542, '11.001.002005', '11.001.002005.png'),
(4543, '11.001.002006', '11.001.002006.png'),
(4544, '11.001.002007', '11.001.002007.png'),
(4545, '11.001.002008', '11.001.002008.png'),
(4546, '11.001.002009', '11.001.002009.png'),
(4547, '11.001.002010', '11.001.002010.png'),
(4548, '11.001.002011', '11.001.002011.png'),
(4549, '11.001.002012', '11.001.002012.png'),
(4550, '11.001.002013', '11.001.002013.png'),
(4551, '11.001.002014', '11.001.002014.png'),
(4552, '11.001.002015', '11.001.002015.png'),
(4553, '11.001.002016', '11.001.002016.png'),
(4554, '11.001.002017', '11.001.002017.png'),
(4555, '11.001.002018', '11.001.002018.png'),
(4556, '11.001.002019', '11.001.002019.png'),
(4557, '11.001.002020', '11.001.002020.png'),
(4558, '11.001.002021', '11.001.002021.png'),
(4559, '11.001.002022', '11.001.002022.png'),
(4560, '11.001.002023', '11.001.002023.png'),
(4561, '11.001.002024', '11.001.002024.png'),
(4562, '11.001.002025', '11.001.002025.png'),
(4563, '11.001.002026', '11.001.002026.png'),
(4564, '11.001.002027', '11.001.002027.png'),
(4565, '11.001.002028', '11.001.002028.png'),
(4566, '11.001.002029', '11.001.002029.png'),
(4567, '11.001.002030', '11.001.002030.png'),
(4568, '11.001.002031', '11.001.002031.png'),
(4569, '11.001.002032', '11.001.002032.png'),
(4570, '11.001.002033', '11.001.002033.png'),
(4571, '11.001.002034', '11.001.002034.png'),
(4572, '11.001.002035', '11.001.002035.png'),
(4573, '11.001.002036', '11.001.002036.png'),
(4574, '11.001.002037', '11.001.002037.png'),
(4575, '11.001.002038', '11.001.002038.png'),
(4576, '11.001.002039', '11.001.002039.png'),
(4577, '11.001.002040', '11.001.002040.png'),
(4578, '11.001.002041', '11.001.002041.png'),
(4579, '11.001.002042', '11.001.002042.png'),
(4580, '11.001.002043', '11.001.002043.png'),
(4581, '11.001.002044', '11.001.002044.png'),
(4582, '11.001.002045', '11.001.002045.png'),
(4583, '11.001.002046', '11.001.002046.png'),
(4584, '11.001.002047', '11.001.002047.png'),
(4585, '11.001.002048', '11.001.002048.png'),
(4586, '11.001.002049', '11.001.002049.png'),
(4587, '11.001.002050', '11.001.002050.png'),
(4588, '11.001.002051', '11.001.002051.png'),
(4589, '11.001.002052', '11.001.002052.png'),
(4590, '11.001.002053', '11.001.002053.png'),
(4591, '11.001.002054', '11.001.002054.png'),
(4592, '11.001.002055', '11.001.002055.png'),
(4593, '11.001.002056', '11.001.002056.png'),
(4594, '11.001.002057', '11.001.002057.png'),
(4595, '11.001.002058', '11.001.002058.png'),
(4596, '11.001.002059', '11.001.002059.png'),
(4597, '11.001.002060', '11.001.002060.png'),
(4598, '11.001.002061', '11.001.002061.png'),
(4599, '11.001.002062', '11.001.002062.png'),
(4600, '11.001.002063', '11.001.002063.png'),
(4601, '11.001.002064', '11.001.002064.png'),
(4602, '11.001.002065', '11.001.002065.png'),
(4603, '11.001.002066', '11.001.002066.png'),
(4604, '11.001.002067', '11.001.002067.png'),
(4605, '11.001.002068', '11.001.002068.png'),
(4606, '11.001.002069', '11.001.002069.png'),
(4607, '11.001.002070', '11.001.002070.png'),
(4608, '11.001.002071', '11.001.002071.png'),
(4609, '11.001.002072', '11.001.002072.png'),
(4610, '11.001.002073', '11.001.002073.png'),
(4611, '11.001.002074', '11.001.002074.png'),
(4612, '11.001.002075', '11.001.002075.png'),
(4613, '11.001.002076', '11.001.002076.png'),
(4614, '11.001.002077', '11.001.002077.png'),
(4615, '11.001.002078', '11.001.002078.png'),
(4616, '11.001.002079', '11.001.002079.png'),
(4617, '11.001.002080', '11.001.002080.png'),
(4618, '11.001.002081', '11.001.002081.png'),
(4619, '11.001.002082', '11.001.002082.png'),
(4620, '11.001.002083', '11.001.002083.png'),
(4621, '11.001.002084', '11.001.002084.png'),
(4622, '11.001.002085', '11.001.002085.png'),
(4623, '11.001.002086', '11.001.002086.png'),
(4624, '11.001.002087', '11.001.002087.png'),
(4625, '11.001.002088', '11.001.002088.png'),
(4626, '11.001.002089', '11.001.002089.png'),
(4627, '11.001.002090', '11.001.002090.png'),
(4628, '11.001.002091', '11.001.002091.png'),
(4629, '11.001.002092', '11.001.002092.png'),
(4630, '11.001.002093', '11.001.002093.png'),
(4631, '11.001.002094', '11.001.002094.png'),
(4632, '11.001.002095', '11.001.002095.png'),
(4633, '11.001.002096', '11.001.002096.png'),
(4634, '11.001.002097', '11.001.002097.png'),
(4635, '11.001.002098', '11.001.002098.png'),
(4636, '11.001.002099', '11.001.002099.png'),
(4637, '11.001.002100', '11.001.002100.png'),
(4638, '11.001.002101', '11.001.002101.png'),
(4639, '11.001.002102', '11.001.002102.png'),
(4640, '11.001.002103', '11.001.002103.png'),
(4641, '11.001.002104', '11.001.002104.png'),
(4642, '11.001.002105', '11.001.002105.png'),
(4643, '11.001.002106', '11.001.002106.png'),
(4644, '11.001.002107', '11.001.002107.png'),
(4645, '11.001.002108', '11.001.002108.png'),
(4646, '11.001.002109', '11.001.002109.png'),
(4647, '11.001.002110', '11.001.002110.png'),
(4648, '11.001.002111', '11.001.002111.png'),
(4649, '11.001.002112', '11.001.002112.png'),
(4650, '11.001.002113', '11.001.002113.png'),
(4651, '11.001.002114', '11.001.002114.png'),
(4652, '11.001.002115', '11.001.002115.png'),
(4653, '11.001.002116', '11.001.002116.png'),
(4654, '11.001.002117', '11.001.002117.png'),
(4655, '11.001.002118', '11.001.002118.png'),
(4656, '11.001.002119', '11.001.002119.png'),
(4657, '11.001.002120', '11.001.002120.png'),
(4658, '11.001.002121', '11.001.002121.png'),
(4659, '11.001.002122', '11.001.002122.png'),
(4660, '11.001.002123', '11.001.002123.png'),
(4661, '11.001.002124', '11.001.002124.png'),
(4662, '11.001.002125', '11.001.002125.png'),
(4663, '11.001.002126', '11.001.002126.png'),
(4664, '11.001.002127', '11.001.002127.png'),
(4665, '11.001.002128', '11.001.002128.png'),
(4666, '11.001.002129', '11.001.002129.png'),
(4667, '11.001.002130', '11.001.002130.png'),
(4668, '11.001.002131', '11.001.002131.png'),
(4669, '11.001.002132', '11.001.002132.png'),
(4670, '11.001.002133', '11.001.002133.png'),
(4671, '11.001.002134', '11.001.002134.png'),
(4672, '11.001.002135', '11.001.002135.png'),
(4673, '11.001.002136', '11.001.002136.png'),
(4674, '11.001.002137', '11.001.002137.png'),
(4675, '11.001.002138', '11.001.002138.png'),
(4676, '11.001.002139', '11.001.002139.png'),
(4677, '11.001.002140', '11.001.002140.png'),
(4678, '11.001.002141', '11.001.002141.png'),
(4679, '11.001.002142', '11.001.002142.png'),
(4680, '11.001.002143', '11.001.002143.png'),
(4681, '11.001.002144', '11.001.002144.png'),
(4682, '11.001.002145', '11.001.002145.png'),
(4683, '11.001.002146', '11.001.002146.png'),
(4684, '11.001.002147', '11.001.002147.png'),
(4685, '11.001.002148', '11.001.002148.png'),
(4686, '11.001.002149', '11.001.002149.png'),
(4687, '11.001.002150', '11.001.002150.png'),
(4688, '11.001.002151', '11.001.002151.png'),
(4689, '11.001.002152', '11.001.002152.png'),
(4690, '11.001.002153', '11.001.002153.png'),
(4691, '11.001.002154', '11.001.002154.png'),
(4692, '11.001.002155', '11.001.002155.png'),
(4693, '11.001.002156', '11.001.002156.png'),
(4694, '11.001.002157', '11.001.002157.png'),
(4695, '11.001.002158', '11.001.002158.png'),
(4696, '11.001.002159', '11.001.002159.png'),
(4697, '11.001.002160', '11.001.002160.png'),
(4698, '11.001.002161', '11.001.002161.png'),
(4699, '11.001.002162', '11.001.002162.png'),
(4700, '11.001.002163', '11.001.002163.png'),
(4701, '11.001.002164', '11.001.002164.png'),
(4702, '11.001.002165', '11.001.002165.png'),
(4703, '11.001.002166', '11.001.002166.png'),
(4704, '11.001.002167', '11.001.002167.png'),
(4705, '11.001.002168', '11.001.002168.png'),
(4706, '11.001.002169', '11.001.002169.png'),
(4707, '11.001.002170', '11.001.002170.png'),
(4708, '11.001.002171', '11.001.002171.png'),
(4709, '11.001.002172', '11.001.002172.png'),
(4710, '11.001.002173', '11.001.002173.png'),
(4711, '11.001.002174', '11.001.002174.png'),
(4712, '11.001.002175', '11.001.002175.png'),
(4713, '11.001.002176', '11.001.002176.png'),
(4714, '11.001.002177', '11.001.002177.png'),
(4715, '11.001.002178', '11.001.002178.png'),
(4716, '11.001.002179', '11.001.002179.png'),
(4717, '11.001.002180', '11.001.002180.png'),
(4718, '11.001.002181', '11.001.002181.png'),
(4719, '11.001.002182', '11.001.002182.png'),
(4720, '11.001.002183', '11.001.002183.png'),
(4721, '11.001.002184', '11.001.002184.png'),
(4722, '11.001.002185', '11.001.002185.png'),
(4723, '11.001.002186', '11.001.002186.png'),
(4724, '11.001.002187', '11.001.002187.png'),
(4725, '11.001.002188', '11.001.002188.png'),
(4726, '11.001.002189', '11.001.002189.png'),
(4727, '11.001.002190', '11.001.002190.png'),
(4728, '11.001.002191', '11.001.002191.png'),
(4729, '11.001.002192', '11.001.002192.png'),
(4730, '11.001.002193', '11.001.002193.png'),
(4731, '11.001.002194', '11.001.002194.png'),
(4732, '11.001.002195', '11.001.002195.png'),
(4733, '11.001.002196', '11.001.002196.png'),
(4734, '11.001.002197', '11.001.002197.png'),
(4735, '11.001.002198', '11.001.002198.png'),
(4736, '11.001.002199', '11.001.002199.png'),
(4737, '11.001.002200', '11.001.002200.png'),
(4738, '11.001.002201', '11.001.002201.png'),
(4739, '11.001.002202', '11.001.002202.png'),
(4740, '11.001.002203', '11.001.002203.png'),
(4741, '11.001.002204', '11.001.002204.png'),
(4742, '11.001.002205', '11.001.002205.png'),
(4743, '11.001.002206', '11.001.002206.png'),
(4744, '11.001.002207', '11.001.002207.png'),
(4745, '11.001.002208', '11.001.002208.png'),
(4746, '11.001.002209', '11.001.002209.png'),
(4747, '11.001.002210', '11.001.002210.png'),
(4748, '11.001.002211', '11.001.002211.png'),
(4749, '11.001.002212', '11.001.002212.png'),
(4750, '11.001.002213', '11.001.002213.png'),
(4751, '11.001.002214', '11.001.002214.png'),
(4752, '11.001.002215', '11.001.002215.png'),
(4753, '11.001.002216', '11.001.002216.png'),
(4754, '11.001.002217', '11.001.002217.png'),
(4755, '11.001.002218', '11.001.002218.png'),
(4756, '11.001.002219', '11.001.002219.png'),
(4757, '11.001.002220', '11.001.002220.png'),
(4758, '11.001.002221', '11.001.002221.png'),
(4759, '11.001.002222', '11.001.002222.png'),
(4760, '11.001.002223', '11.001.002223.png'),
(4761, '11.001.002224', '11.001.002224.png'),
(4762, '11.001.002225', '11.001.002225.png'),
(4763, '11.001.002226', '11.001.002226.png'),
(4764, '11.001.002227', '11.001.002227.png'),
(4765, '11.001.002228', '11.001.002228.png'),
(4766, '11.001.002229', '11.001.002229.png'),
(4767, '11.001.002230', '11.001.002230.png'),
(4768, '11.001.002231', '11.001.002231.png'),
(4769, '11.001.002232', '11.001.002232.png'),
(4770, '11.001.002233', '11.001.002233.png'),
(4771, '11.001.002234', '11.001.002234.png'),
(4772, '11.001.002235', '11.001.002235.png'),
(4773, '11.001.002236', '11.001.002236.png'),
(4774, '11.001.002237', '11.001.002237.png'),
(4775, '11.001.002238', '11.001.002238.png'),
(4776, '11.001.002239', '11.001.002239.png'),
(4777, '11.001.002240', '11.001.002240.png'),
(4778, '11.001.002241', '11.001.002241.png'),
(4779, '11.001.002242', '11.001.002242.png'),
(4780, '11.001.002243', '11.001.002243.png'),
(4781, '11.001.002244', '11.001.002244.png'),
(4782, '11.001.002245', '11.001.002245.png'),
(4783, '11.001.002246', '11.001.002246.png'),
(4784, '11.001.002247', '11.001.002247.png'),
(4785, '11.001.002248', '11.001.002248.png'),
(4786, '11.001.002249', '11.001.002249.png'),
(4787, '11.001.002250', '11.001.002250.png'),
(4788, '11.001.002251', '11.001.002251.png'),
(4789, '11.001.002252', '11.001.002252.png'),
(4790, '11.001.002253', '11.001.002253.png'),
(4791, '11.001.002254', '11.001.002254.png'),
(4792, '11.001.002255', '11.001.002255.png'),
(4793, '11.001.002256', '11.001.002256.png'),
(4794, '11.001.002257', '11.001.002257.png'),
(4795, '11.001.002258', '11.001.002258.png'),
(4796, '11.001.002259', '11.001.002259.png'),
(4797, '11.001.002260', '11.001.002260.png'),
(4798, '11.001.002261', '11.001.002261.png'),
(4799, '11.001.002262', '11.001.002262.png'),
(4800, '11.001.002263', '11.001.002263.png'),
(4801, '11.001.002264', '11.001.002264.png'),
(4802, '11.001.002265', '11.001.002265.png'),
(4803, '11.001.002266', '11.001.002266.png'),
(4804, '11.001.002267', '11.001.002267.png'),
(4805, '11.001.002268', '11.001.002268.png');
INSERT INTO `anggota` (`id`, `no_anggota`, `qr_file`) VALUES
(4806, '11.001.002269', '11.001.002269.png'),
(4807, '11.001.002270', '11.001.002270.png'),
(4808, '11.001.002271', '11.001.002271.png'),
(4809, '11.001.002272', '11.001.002272.png'),
(4810, '11.001.002273', '11.001.002273.png'),
(4811, '11.001.002274', '11.001.002274.png'),
(4812, '11.001.002275', '11.001.002275.png'),
(4813, '11.001.002276', '11.001.002276.png'),
(4814, '11.001.002277', '11.001.002277.png'),
(4815, '11.001.002278', '11.001.002278.png'),
(4816, '11.001.002279', '11.001.002279.png'),
(4817, '11.001.002280', '11.001.002280.png'),
(4818, '11.001.002281', '11.001.002281.png'),
(4819, '11.001.002282', '11.001.002282.png'),
(4820, '11.001.002283', '11.001.002283.png'),
(4821, '11.001.002284', '11.001.002284.png'),
(4822, '11.001.002285', '11.001.002285.png'),
(4823, '11.001.002286', '11.001.002286.png'),
(4824, '11.001.002287', '11.001.002287.png'),
(4825, '11.001.002288', '11.001.002288.png'),
(4826, '11.001.002289', '11.001.002289.png'),
(4827, '11.001.002290', '11.001.002290.png'),
(4828, '11.001.002291', '11.001.002291.png'),
(4829, '11.001.002292', '11.001.002292.png'),
(4830, '11.001.002293', '11.001.002293.png'),
(4831, '11.001.002294', '11.001.002294.png'),
(4832, '11.001.002295', '11.001.002295.png'),
(4833, '11.001.002296', '11.001.002296.png'),
(4834, '11.001.002297', '11.001.002297.png'),
(4835, '11.001.002298', '11.001.002298.png'),
(4836, '11.001.002299', '11.001.002299.png'),
(4837, '11.001.002300', '11.001.002300.png'),
(4838, '11.001.002301', '11.001.002301.png'),
(4839, '11.001.002302', '11.001.002302.png'),
(4840, '11.001.002303', '11.001.002303.png'),
(4841, '11.001.002304', '11.001.002304.png'),
(4842, '11.001.002305', '11.001.002305.png'),
(4843, '11.001.002306', '11.001.002306.png'),
(4844, '11.001.002307', '11.001.002307.png'),
(4845, '11.001.002308', '11.001.002308.png'),
(4846, '11.001.002309', '11.001.002309.png'),
(4847, '11.001.002310', '11.001.002310.png'),
(4848, '11.001.002311', '11.001.002311.png'),
(4849, '11.001.002312', '11.001.002312.png'),
(4850, '11.001.002313', '11.001.002313.png'),
(4851, '11.001.002314', '11.001.002314.png'),
(4852, '11.001.002315', '11.001.002315.png'),
(4853, '11.001.002316', '11.001.002316.png'),
(4854, '11.001.002317', '11.001.002317.png'),
(4855, '11.001.002318', '11.001.002318.png'),
(4856, '11.001.002319', '11.001.002319.png'),
(4857, '11.001.002320', '11.001.002320.png'),
(4858, '11.001.002321', '11.001.002321.png'),
(4859, '11.001.002322', '11.001.002322.png'),
(4860, '11.001.002323', '11.001.002323.png'),
(4861, '11.001.002324', '11.001.002324.png'),
(4862, '11.001.002325', '11.001.002325.png'),
(4863, '11.001.002326', '11.001.002326.png'),
(4864, '11.001.002327', '11.001.002327.png'),
(4865, '11.001.002328', '11.001.002328.png'),
(4866, '11.001.002329', '11.001.002329.png'),
(4867, '11.001.002330', '11.001.002330.png'),
(4868, '11.001.002331', '11.001.002331.png'),
(4869, '11.001.002332', '11.001.002332.png'),
(4870, '11.001.002333', '11.001.002333.png'),
(4871, '11.001.002334', '11.001.002334.png'),
(4872, '11.001.002335', '11.001.002335.png'),
(4873, '11.001.002336', '11.001.002336.png'),
(4874, '11.001.002337', '11.001.002337.png'),
(4875, '11.001.002338', '11.001.002338.png'),
(4876, '11.001.002339', '11.001.002339.png'),
(4877, '11.001.002340', '11.001.002340.png'),
(4878, '11.001.002341', '11.001.002341.png'),
(4879, '11.001.002342', '11.001.002342.png'),
(4880, '11.001.002343', '11.001.002343.png'),
(4881, '11.001.002344', '11.001.002344.png'),
(4882, '11.001.002345', '11.001.002345.png'),
(4883, '11.001.002346', '11.001.002346.png'),
(4884, '11.001.002347', '11.001.002347.png'),
(4885, '11.001.002348', '11.001.002348.png'),
(4886, '11.001.002349', '11.001.002349.png'),
(4887, '11.001.002350', '11.001.002350.png'),
(4888, '11.001.002351', '11.001.002351.png'),
(4889, '11.001.002352', '11.001.002352.png'),
(4890, '11.001.002353', '11.001.002353.png'),
(4891, '11.001.002354', '11.001.002354.png'),
(4892, '11.001.002355', '11.001.002355.png'),
(4893, '11.001.002356', '11.001.002356.png'),
(4894, '11.001.002357', '11.001.002357.png'),
(4895, '11.001.002358', '11.001.002358.png'),
(4896, '11.001.002359', '11.001.002359.png'),
(4897, '11.001.002360', '11.001.002360.png'),
(4898, '11.001.002361', '11.001.002361.png'),
(4899, '11.001.002362', '11.001.002362.png'),
(4900, '11.001.002363', '11.001.002363.png'),
(4901, '11.001.002364', '11.001.002364.png'),
(4902, '11.001.002365', '11.001.002365.png'),
(4903, '11.001.002366', '11.001.002366.png'),
(4904, '11.001.002367', '11.001.002367.png'),
(4905, '11.001.002368', '11.001.002368.png'),
(4906, '11.001.002369', '11.001.002369.png'),
(4907, '11.001.002370', '11.001.002370.png'),
(4908, '11.001.002371', '11.001.002371.png'),
(4909, '11.001.002372', '11.001.002372.png'),
(4910, '11.001.002373', '11.001.002373.png'),
(4911, '11.001.002374', '11.001.002374.png'),
(4912, '11.001.002375', '11.001.002375.png'),
(4913, '11.001.002376', '11.001.002376.png'),
(4914, '11.001.002377', '11.001.002377.png'),
(4915, '11.001.002378', '11.001.002378.png'),
(4916, '11.001.002379', '11.001.002379.png'),
(4917, '11.001.002380', '11.001.002380.png'),
(4918, '11.001.002381', '11.001.002381.png'),
(4919, '11.001.002382', '11.001.002382.png'),
(4920, '11.001.002383', '11.001.002383.png'),
(4921, '11.001.002384', '11.001.002384.png'),
(4922, '11.001.002385', '11.001.002385.png'),
(4923, '11.001.002386', '11.001.002386.png'),
(4924, '11.001.002387', '11.001.002387.png'),
(4925, '11.001.002388', '11.001.002388.png'),
(4926, '11.001.002389', '11.001.002389.png'),
(4927, '11.001.002390', '11.001.002390.png'),
(4928, '11.001.002391', '11.001.002391.png'),
(4929, '11.001.002392', '11.001.002392.png'),
(4930, '11.001.002393', '11.001.002393.png'),
(4931, '11.001.002394', '11.001.002394.png'),
(4932, '11.001.002395', '11.001.002395.png'),
(4933, '11.001.002396', '11.001.002396.png'),
(4934, '11.001.002397', '11.001.002397.png'),
(4935, '11.001.002398', '11.001.002398.png'),
(4936, '11.001.002399', '11.001.002399.png'),
(4937, '11.001.002400', '11.001.002400.png'),
(4938, '11.001.002401', '11.001.002401.png'),
(4939, '11.001.002402', '11.001.002402.png'),
(4940, '11.001.002403', '11.001.002403.png'),
(4941, '11.001.002404', '11.001.002404.png'),
(4942, '11.001.002405', '11.001.002405.png'),
(4943, '11.001.002406', '11.001.002406.png'),
(4944, '11.001.002407', '11.001.002407.png'),
(4945, '11.001.002408', '11.001.002408.png'),
(4946, '11.001.002409', '11.001.002409.png'),
(4947, '11.001.002410', '11.001.002410.png'),
(4948, '11.001.002411', '11.001.002411.png'),
(4949, '11.001.002412', '11.001.002412.png'),
(4950, '11.001.002413', '11.001.002413.png'),
(4951, '11.001.002414', '11.001.002414.png'),
(4952, '11.001.002415', '11.001.002415.png'),
(4953, '11.001.002416', '11.001.002416.png'),
(4954, '11.001.002417', '11.001.002417.png'),
(4955, '11.001.002418', '11.001.002418.png'),
(4956, '11.001.002419', '11.001.002419.png'),
(4957, '11.001.002420', '11.001.002420.png'),
(4958, '11.001.002421', '11.001.002421.png'),
(4959, '11.001.002422', '11.001.002422.png'),
(4960, '11.001.002423', '11.001.002423.png'),
(4961, '11.001.002424', '11.001.002424.png'),
(4962, '11.001.002425', '11.001.002425.png'),
(4963, '11.001.002426', '11.001.002426.png'),
(4964, '11.001.002427', '11.001.002427.png'),
(4965, '11.001.002428', '11.001.002428.png'),
(4966, '11.001.002429', '11.001.002429.png'),
(4967, '11.001.002430', '11.001.002430.png'),
(4968, '11.001.002431', '11.001.002431.png'),
(4969, '11.001.002432', '11.001.002432.png'),
(4970, '11.001.002433', '11.001.002433.png'),
(4971, '11.001.002434', '11.001.002434.png'),
(4972, '11.001.002435', '11.001.002435.png'),
(4973, '11.001.002436', '11.001.002436.png'),
(4974, '11.001.002437', '11.001.002437.png'),
(4975, '11.001.002438', '11.001.002438.png'),
(4976, '11.001.002439', '11.001.002439.png'),
(4977, '11.001.002440', '11.001.002440.png'),
(4978, '11.001.002441', '11.001.002441.png'),
(4979, '11.001.002442', '11.001.002442.png'),
(4980, '11.001.002443', '11.001.002443.png'),
(4981, '11.001.002444', '11.001.002444.png'),
(4982, '11.001.002445', '11.001.002445.png'),
(4983, '11.001.002446', '11.001.002446.png'),
(4984, '11.001.002447', '11.001.002447.png'),
(4985, '11.001.002448', '11.001.002448.png'),
(4986, '11.001.002449', '11.001.002449.png'),
(4987, '11.001.002450', '11.001.002450.png'),
(4988, '11.001.002451', '11.001.002451.png'),
(4989, '11.001.002452', '11.001.002452.png'),
(4990, '11.001.002453', '11.001.002453.png'),
(4991, '11.001.002454', '11.001.002454.png'),
(4992, '11.001.002455', '11.001.002455.png'),
(4993, '11.001.002456', '11.001.002456.png'),
(4994, '11.001.002457', '11.001.002457.png'),
(4995, '11.001.002458', '11.001.002458.png'),
(4996, '11.001.002459', '11.001.002459.png'),
(4997, '11.001.002460', '11.001.002460.png'),
(4998, '11.001.002461', '11.001.002461.png'),
(4999, '11.001.002462', '11.001.002462.png'),
(5000, '11.001.002463', '11.001.002463.png'),
(5001, '11.001.002464', '11.001.002464.png'),
(5002, '11.001.002465', '11.001.002465.png'),
(5003, '11.001.002466', '11.001.002466.png'),
(5004, '11.001.002467', '11.001.002467.png'),
(5005, '11.001.002468', '11.001.002468.png'),
(5006, '11.001.002469', '11.001.002469.png'),
(5007, '11.001.002470', '11.001.002470.png'),
(5008, '11.001.002471', '11.001.002471.png'),
(5009, '11.001.002472', '11.001.002472.png'),
(5010, '11.001.002473', '11.001.002473.png'),
(5011, '11.001.002474', '11.001.002474.png'),
(5012, '11.001.002475', '11.001.002475.png'),
(5013, '11.001.002476', '11.001.002476.png'),
(5014, '11.001.002477', '11.001.002477.png'),
(5015, '11.001.002478', '11.001.002478.png'),
(5016, '11.001.002479', '11.001.002479.png'),
(5017, '11.001.002480', '11.001.002480.png'),
(5018, '11.001.002481', '11.001.002481.png'),
(5019, '11.001.002482', '11.001.002482.png'),
(5020, '11.001.002483', '11.001.002483.png'),
(5021, '11.001.002484', '11.001.002484.png'),
(5022, '11.001.002485', '11.001.002485.png'),
(5023, '11.001.002486', '11.001.002486.png'),
(5024, '11.001.002487', '11.001.002487.png'),
(5025, '11.001.002488', '11.001.002488.png'),
(5026, '11.001.002489', '11.001.002489.png'),
(5027, '11.001.002490', '11.001.002490.png'),
(5028, '11.001.002491', '11.001.002491.png'),
(5029, '11.001.002492', '11.001.002492.png'),
(5030, '11.001.002493', '11.001.002493.png'),
(5031, '11.001.002494', '11.001.002494.png'),
(5032, '11.001.002495', '11.001.002495.png'),
(5033, '11.001.002496', '11.001.002496.png'),
(5034, '11.001.002497', '11.001.002497.png'),
(5035, '11.001.002498', '11.001.002498.png'),
(5036, '11.001.002499', '11.001.002499.png'),
(5037, '11.001.002500', '11.001.002500.png'),
(5038, '11.001.002501', '11.001.002501.png'),
(5039, '11.001.002502', '11.001.002502.png'),
(5040, '11.001.002503', '11.001.002503.png'),
(5041, '11.001.002504', '11.001.002504.png'),
(5042, '11.001.002505', '11.001.002505.png'),
(5043, '11.001.002506', '11.001.002506.png'),
(5044, '11.001.002507', '11.001.002507.png'),
(5045, '11.001.002508', '11.001.002508.png'),
(5046, '11.001.002509', '11.001.002509.png'),
(5047, '11.001.002510', '11.001.002510.png'),
(5048, '11.001.002511', '11.001.002511.png'),
(5049, '11.001.002512', '11.001.002512.png'),
(5050, '11.001.002513', '11.001.002513.png'),
(5051, '11.001.002514', '11.001.002514.png'),
(5052, '11.001.002515', '11.001.002515.png'),
(5053, '11.001.002516', '11.001.002516.png'),
(5054, '11.001.002517', '11.001.002517.png'),
(5055, '11.001.002518', '11.001.002518.png'),
(5056, '11.001.002519', '11.001.002519.png'),
(5057, '11.001.002520', '11.001.002520.png'),
(5058, '11.001.002521', '11.001.002521.png'),
(5059, '11.001.002522', '11.001.002522.png'),
(5060, '11.001.002523', '11.001.002523.png'),
(5061, '11.001.002524', '11.001.002524.png'),
(5062, '11.001.002525', '11.001.002525.png'),
(5063, '11.001.002526', '11.001.002526.png'),
(5064, '11.001.002527', '11.001.002527.png'),
(5065, '11.001.002528', '11.001.002528.png'),
(5066, '11.001.002529', '11.001.002529.png'),
(5067, '11.001.002530', '11.001.002530.png'),
(5068, '11.001.002531', '11.001.002531.png'),
(5069, '11.001.002532', '11.001.002532.png'),
(5070, '11.001.002533', '11.001.002533.png'),
(5071, '11.001.002534', '11.001.002534.png'),
(5072, '11.001.002535', '11.001.002535.png'),
(5073, '11.001.002536', '11.001.002536.png'),
(5074, '11.001.002537', '11.001.002537.png'),
(5075, '11.001.002538', '11.001.002538.png'),
(5076, '11.001.002539', '11.001.002539.png'),
(5077, '11.001.002540', '11.001.002540.png'),
(5078, '11.001.002541', '11.001.002541.png'),
(5079, '11.001.002542', '11.001.002542.png'),
(5080, '11.001.002543', '11.001.002543.png'),
(5081, '11.001.002544', '11.001.002544.png'),
(5082, '11.001.002545', '11.001.002545.png'),
(5083, '11.001.002546', '11.001.002546.png'),
(5084, '11.001.002547', '11.001.002547.png'),
(5085, '11.001.002548', '11.001.002548.png'),
(5086, '11.001.002549', '11.001.002549.png'),
(5087, '11.001.002550', '11.001.002550.png'),
(5088, '11.001.002551', '11.001.002551.png'),
(5089, '11.001.002552', '11.001.002552.png'),
(5090, '11.001.002553', '11.001.002553.png'),
(5091, '11.001.002554', '11.001.002554.png'),
(5092, '11.001.002555', '11.001.002555.png'),
(5093, '11.001.002556', '11.001.002556.png'),
(5094, '11.001.002557', '11.001.002557.png'),
(5095, '11.001.002558', '11.001.002558.png'),
(5096, '11.001.002559', '11.001.002559.png'),
(5097, '11.001.002560', '11.001.002560.png'),
(5098, '11.001.002561', '11.001.002561.png'),
(5099, '11.001.002562', '11.001.002562.png'),
(5100, '11.001.002563', '11.001.002563.png'),
(5101, '11.001.002564', '11.001.002564.png'),
(5102, '11.001.002565', '11.001.002565.png'),
(5103, '11.001.002566', '11.001.002566.png'),
(5104, '11.001.002567', '11.001.002567.png'),
(5105, '11.001.002568', '11.001.002568.png'),
(5106, '11.001.002569', '11.001.002569.png'),
(5107, '11.001.002570', '11.001.002570.png'),
(5108, '11.001.002571', '11.001.002571.png'),
(5109, '11.001.002572', '11.001.002572.png'),
(5110, '11.001.002573', '11.001.002573.png'),
(5111, '11.001.002574', '11.001.002574.png'),
(5112, '11.001.002575', '11.001.002575.png'),
(5113, '11.001.002576', '11.001.002576.png'),
(5114, '11.001.002577', '11.001.002577.png'),
(5115, '11.001.002578', '11.001.002578.png'),
(5116, '11.001.002579', '11.001.002579.png'),
(5117, '11.001.002580', '11.001.002580.png'),
(5118, '11.001.002581', '11.001.002581.png'),
(5119, '11.001.002582', '11.001.002582.png'),
(5120, '11.001.002583', '11.001.002583.png'),
(5121, '11.001.002584', '11.001.002584.png'),
(5122, '11.001.002585', '11.001.002585.png'),
(5123, '11.001.002586', '11.001.002586.png'),
(5124, '11.001.002587', '11.001.002587.png'),
(5125, '11.001.002588', '11.001.002588.png'),
(5126, '11.001.002589', '11.001.002589.png'),
(5127, '11.001.002590', '11.001.002590.png'),
(5128, '11.001.002591', '11.001.002591.png'),
(5129, '11.001.002592', '11.001.002592.png'),
(5130, '11.001.002593', '11.001.002593.png'),
(5131, '11.001.002594', '11.001.002594.png'),
(5132, '11.001.002595', '11.001.002595.png'),
(5133, '11.001.002596', '11.001.002596.png'),
(5134, '11.001.002597', '11.001.002597.png'),
(5135, '11.001.002598', '11.001.002598.png'),
(5136, '11.001.002599', '11.001.002599.png'),
(5137, '11.001.002600', '11.001.002600.png'),
(5138, '11.001.002601', '11.001.002601.png'),
(5139, '11.001.002602', '11.001.002602.png'),
(5140, '11.001.002603', '11.001.002603.png'),
(5141, '11.001.002604', '11.001.002604.png'),
(5142, '11.001.002605', '11.001.002605.png'),
(5143, '11.001.002606', '11.001.002606.png'),
(5144, '11.001.002607', '11.001.002607.png'),
(5145, '11.001.002608', '11.001.002608.png'),
(5146, '11.001.002609', '11.001.002609.png'),
(5147, '11.001.002610', '11.001.002610.png'),
(5148, '11.001.002611', '11.001.002611.png'),
(5149, '11.001.002612', '11.001.002612.png'),
(5150, '11.001.002613', '11.001.002613.png'),
(5151, '11.001.002614', '11.001.002614.png'),
(5152, '11.001.002615', '11.001.002615.png'),
(5153, '11.001.002616', '11.001.002616.png'),
(5154, '11.001.002617', '11.001.002617.png'),
(5155, '11.001.002618', '11.001.002618.png'),
(5156, '11.001.002619', '11.001.002619.png'),
(5157, '11.001.002620', '11.001.002620.png'),
(5158, '11.001.002621', '11.001.002621.png'),
(5159, '11.001.002622', '11.001.002622.png'),
(5160, '11.001.002623', '11.001.002623.png'),
(5161, '11.001.002624', '11.001.002624.png'),
(5162, '11.001.002625', '11.001.002625.png'),
(5163, '11.001.002626', '11.001.002626.png'),
(5164, '11.001.002627', '11.001.002627.png'),
(5165, '11.001.002628', '11.001.002628.png'),
(5166, '11.001.002629', '11.001.002629.png'),
(5167, '11.001.002630', '11.001.002630.png'),
(5168, '11.001.002631', '11.001.002631.png'),
(5169, '11.001.002632', '11.001.002632.png'),
(5170, '11.001.002633', '11.001.002633.png'),
(5171, '11.001.002634', '11.001.002634.png'),
(5172, '11.001.002635', '11.001.002635.png'),
(5173, '11.001.002636', '11.001.002636.png'),
(5174, '11.001.002637', '11.001.002637.png'),
(5175, '11.001.002638', '11.001.002638.png'),
(5176, '11.001.002639', '11.001.002639.png'),
(5177, '11.001.002640', '11.001.002640.png'),
(5178, '11.001.002641', '11.001.002641.png'),
(5179, '11.001.002642', '11.001.002642.png'),
(5180, '11.001.002643', '11.001.002643.png'),
(5181, '11.001.002644', '11.001.002644.png'),
(5182, '11.001.002645', '11.001.002645.png'),
(5183, '11.001.002646', '11.001.002646.png'),
(5184, '11.001.002647', '11.001.002647.png'),
(5185, '11.001.002648', '11.001.002648.png'),
(5186, '11.001.002649', '11.001.002649.png'),
(5187, '11.001.002650', '11.001.002650.png'),
(5188, '11.001.002651', '11.001.002651.png'),
(5189, '11.001.002652', '11.001.002652.png'),
(5190, '11.001.002653', '11.001.002653.png'),
(5191, '11.001.002654', '11.001.002654.png'),
(5192, '11.001.002655', '11.001.002655.png'),
(5193, '11.001.002656', '11.001.002656.png'),
(5194, '11.001.002657', '11.001.002657.png'),
(5195, '11.001.002658', '11.001.002658.png'),
(5196, '11.001.002659', '11.001.002659.png'),
(5197, '11.001.002660', '11.001.002660.png'),
(5198, '11.001.002661', '11.001.002661.png'),
(5199, '11.001.002662', '11.001.002662.png'),
(5200, '11.001.002663', '11.001.002663.png'),
(5201, '11.001.002664', '11.001.002664.png'),
(5202, '11.001.002665', '11.001.002665.png'),
(5203, '11.001.002666', '11.001.002666.png'),
(5204, '11.001.002667', '11.001.002667.png'),
(5205, '11.001.002668', '11.001.002668.png'),
(5206, '11.001.002669', '11.001.002669.png'),
(5207, '11.001.002670', '11.001.002670.png'),
(5208, '11.001.002671', '11.001.002671.png'),
(5209, '11.001.002672', '11.001.002672.png'),
(5210, '11.001.002673', '11.001.002673.png'),
(5211, '11.001.002674', '11.001.002674.png'),
(5212, '11.001.002675', '11.001.002675.png'),
(5213, '11.001.002676', '11.001.002676.png'),
(5214, '11.001.002677', '11.001.002677.png'),
(5215, '11.001.002678', '11.001.002678.png'),
(5216, '11.001.002679', '11.001.002679.png'),
(5217, '11.001.002680', '11.001.002680.png'),
(5218, '11.001.002681', '11.001.002681.png'),
(5219, '11.001.002682', '11.001.002682.png'),
(5220, '11.001.002683', '11.001.002683.png'),
(5221, '11.001.002684', '11.001.002684.png'),
(5222, '11.001.002685', '11.001.002685.png'),
(5223, '11.001.002686', '11.001.002686.png'),
(5224, '11.001.002687', '11.001.002687.png'),
(5225, '11.001.002688', '11.001.002688.png'),
(5226, '11.001.002689', '11.001.002689.png'),
(5227, '11.001.002690', '11.001.002690.png'),
(5228, '11.001.002691', '11.001.002691.png'),
(5229, '11.001.002692', '11.001.002692.png'),
(5230, '11.001.002693', '11.001.002693.png'),
(5231, '11.001.002694', '11.001.002694.png'),
(5232, '11.001.002695', '11.001.002695.png'),
(5233, '11.001.002696', '11.001.002696.png'),
(5234, '11.001.002697', '11.001.002697.png'),
(5235, '11.001.002698', '11.001.002698.png'),
(5236, '11.001.002699', '11.001.002699.png'),
(5237, '11.001.002700', '11.001.002700.png'),
(5238, '11.001.002701', '11.001.002701.png'),
(5239, '11.001.002702', '11.001.002702.png'),
(5240, '11.001.002703', '11.001.002703.png'),
(5241, '11.001.002704', '11.001.002704.png'),
(5242, '11.001.002705', '11.001.002705.png'),
(5243, '11.001.002706', '11.001.002706.png'),
(5244, '11.001.002707', '11.001.002707.png'),
(5245, '11.001.002708', '11.001.002708.png'),
(5246, '11.001.002709', '11.001.002709.png'),
(5247, '11.001.002710', '11.001.002710.png'),
(5248, '11.001.002711', '11.001.002711.png'),
(5249, '11.001.002712', '11.001.002712.png'),
(5250, '11.001.002713', '11.001.002713.png'),
(5251, '11.001.002714', '11.001.002714.png'),
(5252, '11.001.002715', '11.001.002715.png'),
(5253, '11.001.002716', '11.001.002716.png'),
(5254, '11.001.002717', '11.001.002717.png'),
(5255, '11.001.002718', '11.001.002718.png'),
(5256, '11.001.002719', '11.001.002719.png'),
(5257, '11.001.002720', '11.001.002720.png'),
(5258, '11.001.002721', '11.001.002721.png'),
(5259, '11.001.002722', '11.001.002722.png'),
(5260, '11.001.002723', '11.001.002723.png'),
(5261, '11.001.002724', '11.001.002724.png'),
(5262, '11.001.002725', '11.001.002725.png'),
(5263, '11.001.002726', '11.001.002726.png'),
(5264, '11.001.002727', '11.001.002727.png'),
(5265, '11.001.002728', '11.001.002728.png'),
(5266, '11.001.002729', '11.001.002729.png'),
(5267, '11.001.002730', '11.001.002730.png'),
(5268, '11.001.002731', '11.001.002731.png'),
(5269, '11.001.002732', '11.001.002732.png'),
(5270, '11.001.002733', '11.001.002733.png'),
(5271, '11.001.002734', '11.001.002734.png'),
(5272, '11.001.002735', '11.001.002735.png'),
(5273, '11.001.002736', '11.001.002736.png'),
(5274, '11.001.002737', '11.001.002737.png'),
(5275, '11.001.002738', '11.001.002738.png'),
(5276, '11.001.002739', '11.001.002739.png'),
(5277, '11.001.002740', '11.001.002740.png'),
(5278, '11.001.002741', '11.001.002741.png'),
(5279, '11.001.002742', '11.001.002742.png'),
(5280, '11.001.002743', '11.001.002743.png'),
(5281, '11.001.002744', '11.001.002744.png'),
(5282, '11.001.002745', '11.001.002745.png'),
(5283, '11.001.002746', '11.001.002746.png'),
(5284, '11.001.002747', '11.001.002747.png'),
(5285, '11.001.002748', '11.001.002748.png'),
(5286, '11.001.002749', '11.001.002749.png'),
(5287, '11.001.002750', '11.001.002750.png'),
(5288, '11.001.002751', '11.001.002751.png'),
(5289, '11.001.002752', '11.001.002752.png'),
(5290, '11.001.002753', '11.001.002753.png'),
(5291, '11.001.002754', '11.001.002754.png'),
(5292, '11.001.002755', '11.001.002755.png'),
(5293, '11.001.002756', '11.001.002756.png'),
(5294, '11.001.002757', '11.001.002757.png'),
(5295, '11.001.002758', '11.001.002758.png'),
(5296, '11.001.002759', '11.001.002759.png'),
(5297, '11.001.002760', '11.001.002760.png'),
(5298, '11.001.002761', '11.001.002761.png'),
(5299, '11.001.002762', '11.001.002762.png'),
(5300, '11.001.002763', '11.001.002763.png'),
(5301, '11.001.002764', '11.001.002764.png'),
(5302, '11.001.002765', '11.001.002765.png'),
(5303, '11.001.002766', '11.001.002766.png'),
(5304, '11.001.002767', '11.001.002767.png'),
(5305, '11.001.002768', '11.001.002768.png'),
(5306, '11.001.002769', '11.001.002769.png'),
(5307, '11.001.002770', '11.001.002770.png'),
(5308, '11.001.002771', '11.001.002771.png'),
(5309, '11.001.002772', '11.001.002772.png'),
(5310, '11.001.002773', '11.001.002773.png'),
(5311, '11.001.002774', '11.001.002774.png'),
(5312, '11.001.002775', '11.001.002775.png'),
(5313, '11.001.002776', '11.001.002776.png'),
(5314, '11.001.002777', '11.001.002777.png'),
(5315, '11.001.002778', '11.001.002778.png'),
(5316, '11.001.002779', '11.001.002779.png'),
(5317, '11.001.002780', '11.001.002780.png'),
(5318, '11.001.002781', '11.001.002781.png'),
(5319, '11.001.002782', '11.001.002782.png'),
(5320, '11.001.002783', '11.001.002783.png'),
(5321, '11.001.002784', '11.001.002784.png'),
(5322, '11.001.002785', '11.001.002785.png'),
(5323, '11.001.002786', '11.001.002786.png'),
(5324, '11.001.002787', '11.001.002787.png'),
(5325, '11.001.002788', '11.001.002788.png'),
(5326, '11.001.002789', '11.001.002789.png'),
(5327, '11.001.002790', '11.001.002790.png'),
(5328, '11.001.002791', '11.001.002791.png'),
(5329, '11.001.002792', '11.001.002792.png'),
(5330, '11.001.002793', '11.001.002793.png'),
(5331, '11.001.002794', '11.001.002794.png'),
(5332, '11.001.002795', '11.001.002795.png'),
(5333, '11.001.002796', '11.001.002796.png'),
(5334, '11.001.002797', '11.001.002797.png'),
(5335, '11.001.002798', '11.001.002798.png'),
(5336, '11.001.002799', '11.001.002799.png'),
(5337, '11.001.002800', '11.001.002800.png'),
(5338, '11.001.002801', '11.001.002801.png'),
(5339, '11.001.002802', '11.001.002802.png'),
(5340, '11.001.002803', '11.001.002803.png'),
(5341, '11.001.002804', '11.001.002804.png'),
(5342, '11.001.002805', '11.001.002805.png'),
(5343, '11.001.002806', '11.001.002806.png'),
(5344, '11.001.002807', '11.001.002807.png'),
(5345, '11.001.002808', '11.001.002808.png'),
(5346, '11.001.002809', '11.001.002809.png'),
(5347, '11.001.002810', '11.001.002810.png'),
(5348, '11.001.002811', '11.001.002811.png'),
(5349, '11.001.002812', '11.001.002812.png'),
(5350, '11.001.002813', '11.001.002813.png'),
(5351, '11.001.002814', '11.001.002814.png'),
(5352, '11.001.002815', '11.001.002815.png'),
(5353, '11.001.002816', '11.001.002816.png'),
(5354, '11.001.002817', '11.001.002817.png'),
(5355, '11.001.002818', '11.001.002818.png'),
(5356, '11.001.002819', '11.001.002819.png'),
(5357, '11.001.002820', '11.001.002820.png'),
(5358, '11.001.002821', '11.001.002821.png'),
(5359, '11.001.002822', '11.001.002822.png'),
(5360, '11.001.002823', '11.001.002823.png'),
(5361, '11.001.002824', '11.001.002824.png'),
(5362, '11.001.002825', '11.001.002825.png'),
(5363, '11.001.002826', '11.001.002826.png'),
(5364, '11.001.002827', '11.001.002827.png'),
(5365, '11.001.002828', '11.001.002828.png'),
(5366, '11.001.002829', '11.001.002829.png'),
(5367, '11.001.002830', '11.001.002830.png'),
(5368, '11.001.002831', '11.001.002831.png'),
(5369, '11.001.002832', '11.001.002832.png'),
(5370, '11.001.002833', '11.001.002833.png'),
(5371, '11.001.002834', '11.001.002834.png'),
(5372, '11.001.002835', '11.001.002835.png'),
(5373, '11.001.002836', '11.001.002836.png'),
(5374, '11.001.002837', '11.001.002837.png'),
(5375, '11.001.002838', '11.001.002838.png'),
(5376, '11.001.002839', '11.001.002839.png'),
(5377, '11.001.002840', '11.001.002840.png'),
(5378, '11.001.002841', '11.001.002841.png'),
(5379, '11.001.002842', '11.001.002842.png'),
(5380, '11.001.002843', '11.001.002843.png'),
(5381, '11.001.002844', '11.001.002844.png'),
(5382, '11.001.002845', '11.001.002845.png'),
(5383, '11.001.002846', '11.001.002846.png'),
(5384, '11.001.002847', '11.001.002847.png'),
(5385, '11.001.002848', '11.001.002848.png'),
(5386, '11.001.002849', '11.001.002849.png'),
(5387, '11.001.002850', '11.001.002850.png'),
(5388, '11.001.002851', '11.001.002851.png'),
(5389, '11.001.002852', '11.001.002852.png'),
(5390, '11.001.002853', '11.001.002853.png'),
(5391, '11.001.002854', '11.001.002854.png'),
(5392, '11.001.002855', '11.001.002855.png'),
(5393, '11.001.002856', '11.001.002856.png'),
(5394, '11.001.002857', '11.001.002857.png'),
(5395, '11.001.002858', '11.001.002858.png'),
(5396, '11.001.002859', '11.001.002859.png'),
(5397, '11.001.002860', '11.001.002860.png'),
(5398, '11.001.002861', '11.001.002861.png'),
(5399, '11.001.002862', '11.001.002862.png'),
(5400, '11.001.002863', '11.001.002863.png'),
(5401, '11.001.002864', '11.001.002864.png'),
(5402, '11.001.002865', '11.001.002865.png'),
(5403, '11.001.002866', '11.001.002866.png'),
(5404, '11.001.002867', '11.001.002867.png'),
(5405, '11.001.002868', '11.001.002868.png'),
(5406, '11.001.002869', '11.001.002869.png'),
(5407, '11.001.002870', '11.001.002870.png'),
(5408, '11.001.002871', '11.001.002871.png'),
(5409, '11.001.002872', '11.001.002872.png'),
(5410, '11.001.002873', '11.001.002873.png'),
(5411, '11.001.002874', '11.001.002874.png'),
(5412, '11.001.002875', '11.001.002875.png'),
(5413, '11.001.002876', '11.001.002876.png'),
(5414, '11.001.002877', '11.001.002877.png'),
(5415, '11.001.002878', '11.001.002878.png'),
(5416, '11.001.002879', '11.001.002879.png'),
(5417, '11.001.002880', '11.001.002880.png'),
(5418, '11.001.002881', '11.001.002881.png'),
(5419, '11.001.002882', '11.001.002882.png'),
(5420, '11.001.002883', '11.001.002883.png'),
(5421, '11.001.002884', '11.001.002884.png'),
(5422, '11.001.002885', '11.001.002885.png'),
(5423, '11.001.002886', '11.001.002886.png'),
(5424, '11.001.002887', '11.001.002887.png'),
(5425, '11.001.002888', '11.001.002888.png'),
(5426, '11.001.002889', '11.001.002889.png'),
(5427, '11.001.002890', '11.001.002890.png'),
(5428, '11.001.002891', '11.001.002891.png'),
(5429, '11.001.002892', '11.001.002892.png'),
(5430, '11.001.002893', '11.001.002893.png'),
(5431, '11.001.002894', '11.001.002894.png'),
(5432, '11.001.002895', '11.001.002895.png'),
(5433, '11.001.002896', '11.001.002896.png'),
(5434, '11.001.002897', '11.001.002897.png'),
(5435, '11.001.002898', '11.001.002898.png'),
(5436, '11.001.002899', '11.001.002899.png'),
(5437, '11.001.002900', '11.001.002900.png'),
(5438, '11.001.002901', '11.001.002901.png'),
(5439, '11.001.002902', '11.001.002902.png'),
(5440, '11.001.002903', '11.001.002903.png'),
(5441, '11.001.002904', '11.001.002904.png'),
(5442, '11.001.002905', '11.001.002905.png'),
(5443, '11.001.002906', '11.001.002906.png'),
(5444, '11.001.002907', '11.001.002907.png'),
(5445, '11.001.002908', '11.001.002908.png'),
(5446, '11.001.002909', '11.001.002909.png'),
(5447, '11.001.002910', '11.001.002910.png'),
(5448, '11.001.002911', '11.001.002911.png'),
(5449, '11.001.002912', '11.001.002912.png'),
(5450, '11.001.002913', '11.001.002913.png'),
(5451, '11.001.002914', '11.001.002914.png'),
(5452, '11.001.002915', '11.001.002915.png'),
(5453, '11.001.002916', '11.001.002916.png'),
(5454, '11.001.002917', '11.001.002917.png'),
(5455, '11.001.002918', '11.001.002918.png'),
(5456, '11.001.002919', '11.001.002919.png'),
(5457, '11.001.002920', '11.001.002920.png'),
(5458, '11.001.002921', '11.001.002921.png'),
(5459, '11.001.002922', '11.001.002922.png'),
(5460, '11.001.002923', '11.001.002923.png'),
(5461, '11.001.002924', '11.001.002924.png'),
(5462, '11.001.002925', '11.001.002925.png'),
(5463, '11.001.002926', '11.001.002926.png'),
(5464, '11.001.002927', '11.001.002927.png'),
(5465, '11.001.002928', '11.001.002928.png'),
(5466, '11.001.002929', '11.001.002929.png'),
(5467, '11.001.002930', '11.001.002930.png'),
(5468, '11.001.002931', '11.001.002931.png'),
(5469, '11.001.002932', '11.001.002932.png'),
(5470, '11.001.002933', '11.001.002933.png'),
(5471, '11.001.002934', '11.001.002934.png'),
(5472, '11.001.002935', '11.001.002935.png'),
(5473, '11.001.002936', '11.001.002936.png'),
(5474, '11.001.002937', '11.001.002937.png'),
(5475, '11.001.002938', '11.001.002938.png'),
(5476, '11.001.002939', '11.001.002939.png'),
(5477, '11.001.002940', '11.001.002940.png'),
(5478, '11.001.002941', '11.001.002941.png'),
(5479, '11.001.002942', '11.001.002942.png'),
(5480, '11.001.002943', '11.001.002943.png'),
(5481, '11.001.002944', '11.001.002944.png'),
(5482, '11.001.002945', '11.001.002945.png'),
(5483, '11.001.002946', '11.001.002946.png'),
(5484, '11.001.002947', '11.001.002947.png'),
(5485, '11.001.002948', '11.001.002948.png'),
(5486, '11.001.002949', '11.001.002949.png'),
(5487, '11.001.002950', '11.001.002950.png'),
(5488, '11.001.002951', '11.001.002951.png'),
(5489, '11.001.002952', '11.001.002952.png'),
(5490, '11.001.002953', '11.001.002953.png'),
(5491, '11.001.002954', '11.001.002954.png'),
(5492, '11.001.002955', '11.001.002955.png'),
(5493, '11.001.002956', '11.001.002956.png'),
(5494, '11.001.002957', '11.001.002957.png'),
(5495, '11.001.002958', '11.001.002958.png'),
(5496, '11.001.002959', '11.001.002959.png'),
(5497, '11.001.002960', '11.001.002960.png'),
(5498, '11.001.002961', '11.001.002961.png'),
(5499, '11.001.002962', '11.001.002962.png'),
(5500, '11.001.002963', '11.001.002963.png'),
(5501, '11.001.002964', '11.001.002964.png'),
(5502, '11.001.002965', '11.001.002965.png'),
(5503, '11.001.002966', '11.001.002966.png'),
(5504, '11.001.002967', '11.001.002967.png'),
(5505, '11.001.002968', '11.001.002968.png'),
(5506, '11.001.002969', '11.001.002969.png'),
(5507, '11.001.002970', '11.001.002970.png'),
(5508, '11.001.002971', '11.001.002971.png'),
(5509, '11.001.002972', '11.001.002972.png'),
(5510, '11.001.002973', '11.001.002973.png'),
(5511, '11.001.002974', '11.001.002974.png'),
(5512, '11.001.002975', '11.001.002975.png'),
(5513, '11.001.002976', '11.001.002976.png'),
(5514, '11.001.002977', '11.001.002977.png'),
(5515, '11.001.002978', '11.001.002978.png'),
(5516, '11.001.002979', '11.001.002979.png'),
(5517, '11.001.002980', '11.001.002980.png'),
(5518, '11.001.002981', '11.001.002981.png'),
(5519, '11.001.002982', '11.001.002982.png'),
(5520, '11.001.002983', '11.001.002983.png'),
(5521, '11.001.002984', '11.001.002984.png'),
(5522, '11.001.002985', '11.001.002985.png'),
(5523, '11.001.002986', '11.001.002986.png'),
(5524, '11.001.002987', '11.001.002987.png'),
(5525, '11.001.002988', '11.001.002988.png'),
(5526, '11.001.002989', '11.001.002989.png'),
(5527, '11.001.002990', '11.001.002990.png'),
(5528, '11.001.002991', '11.001.002991.png'),
(5529, '11.001.002992', '11.001.002992.png'),
(5530, '11.001.002993', '11.001.002993.png'),
(5531, '11.001.002994', '11.001.002994.png'),
(5532, '11.001.002995', '11.001.002995.png'),
(5533, '11.001.002996', '11.001.002996.png'),
(5534, '11.001.002997', '11.001.002997.png'),
(5535, '11.001.002998', '11.001.002998.png'),
(5536, '11.001.002999', '11.001.002999.png'),
(5537, '11.001.003000', '11.001.003000.png'),
(5538, '11.001.003001', '11.001.003001.png'),
(5539, '11.001.003002', '11.001.003002.png'),
(5540, '11.001.003003', '11.001.003003.png'),
(5541, '11.001.003004', '11.001.003004.png'),
(5542, '11.001.003005', '11.001.003005.png'),
(5543, '11.001.003006', '11.001.003006.png'),
(5544, '11.001.003007', '11.001.003007.png'),
(5545, '11.001.003008', '11.001.003008.png'),
(5546, '11.001.003009', '11.001.003009.png'),
(5547, '11.001.003010', '11.001.003010.png'),
(5548, '11.001.003011', '11.001.003011.png'),
(5549, '11.001.003012', '11.001.003012.png'),
(5550, '11.001.003013', '11.001.003013.png'),
(5551, '11.001.003014', '11.001.003014.png'),
(5552, '11.001.003015', '11.001.003015.png'),
(5553, '11.001.003016', '11.001.003016.png'),
(5554, '11.001.003017', '11.001.003017.png'),
(5555, '11.001.003018', '11.001.003018.png'),
(5556, '11.001.003019', '11.001.003019.png'),
(5557, '11.001.003020', '11.001.003020.png'),
(5558, '11.001.003021', '11.001.003021.png'),
(5559, '11.001.003022', '11.001.003022.png'),
(5560, '11.001.003023', '11.001.003023.png'),
(5561, '11.001.003024', '11.001.003024.png'),
(5562, '11.001.003025', '11.001.003025.png'),
(5563, '11.001.003026', '11.001.003026.png'),
(5564, '11.001.003027', '11.001.003027.png'),
(5565, '11.001.003028', '11.001.003028.png'),
(5566, '11.001.003029', '11.001.003029.png'),
(5567, '11.001.003030', '11.001.003030.png'),
(5568, '11.001.003031', '11.001.003031.png'),
(5569, '11.001.003032', '11.001.003032.png'),
(5570, '11.001.003033', '11.001.003033.png'),
(5571, '11.001.003034', '11.001.003034.png'),
(5572, '11.001.003035', '11.001.003035.png'),
(5573, '11.001.003036', '11.001.003036.png'),
(5574, '11.001.003037', '11.001.003037.png'),
(5575, '11.001.003038', '11.001.003038.png'),
(5576, '11.001.003039', '11.001.003039.png'),
(5577, '11.001.003040', '11.001.003040.png'),
(5578, '11.001.003041', '11.001.003041.png'),
(5579, '11.001.003042', '11.001.003042.png'),
(5580, '11.001.003043', '11.001.003043.png'),
(5581, '11.001.003044', '11.001.003044.png'),
(5582, '11.001.003045', '11.001.003045.png'),
(5583, '11.001.003046', '11.001.003046.png'),
(5584, '11.001.003047', '11.001.003047.png'),
(5585, '11.001.003048', '11.001.003048.png'),
(5586, '11.001.003049', '11.001.003049.png'),
(5587, '11.001.003050', '11.001.003050.png'),
(5588, '11.001.003051', '11.001.003051.png'),
(5589, '11.001.003052', '11.001.003052.png'),
(5590, '11.001.003053', '11.001.003053.png'),
(5591, '11.001.003054', '11.001.003054.png'),
(5592, '11.001.003055', '11.001.003055.png'),
(5593, '11.001.003056', '11.001.003056.png'),
(5594, '11.001.003057', '11.001.003057.png'),
(5595, '11.001.003058', '11.001.003058.png'),
(5596, '11.001.003059', '11.001.003059.png'),
(5597, '11.001.003060', '11.001.003060.png'),
(5598, '11.001.003061', '11.001.003061.png'),
(5599, '11.001.003062', '11.001.003062.png'),
(5600, '11.001.003063', '11.001.003063.png'),
(5601, '11.001.003064', '11.001.003064.png'),
(5602, '11.001.003065', '11.001.003065.png'),
(5603, '11.001.003066', '11.001.003066.png'),
(5604, '11.001.003067', '11.001.003067.png'),
(5605, '11.001.003068', '11.001.003068.png'),
(5606, '11.001.003069', '11.001.003069.png'),
(5607, '11.001.003070', '11.001.003070.png'),
(5608, '11.001.003071', '11.001.003071.png'),
(5609, '11.001.003072', '11.001.003072.png'),
(5610, '11.001.003073', '11.001.003073.png'),
(5611, '11.001.003074', '11.001.003074.png'),
(5612, '11.001.003075', '11.001.003075.png'),
(5613, '11.001.003076', '11.001.003076.png'),
(5614, '11.001.003077', '11.001.003077.png'),
(5615, '11.001.003078', '11.001.003078.png'),
(5616, '11.001.003079', '11.001.003079.png'),
(5617, '11.001.003080', '11.001.003080.png'),
(5618, '11.001.003081', '11.001.003081.png'),
(5619, '11.001.003082', '11.001.003082.png'),
(5620, '11.001.003083', '11.001.003083.png'),
(5621, '11.001.003084', '11.001.003084.png'),
(5622, '11.001.003085', '11.001.003085.png'),
(5623, '11.001.003086', '11.001.003086.png'),
(5624, '11.001.003087', '11.001.003087.png'),
(5625, '11.001.003088', '11.001.003088.png'),
(5626, '11.001.003089', '11.001.003089.png'),
(5627, '11.001.003090', '11.001.003090.png'),
(5628, '11.001.003091', '11.001.003091.png'),
(5629, '11.001.003092', '11.001.003092.png'),
(5630, '11.001.003093', '11.001.003093.png'),
(5631, '11.001.003094', '11.001.003094.png'),
(5632, '11.001.003095', '11.001.003095.png'),
(5633, '11.001.003096', '11.001.003096.png'),
(5634, '11.001.003097', '11.001.003097.png'),
(5635, '11.001.003098', '11.001.003098.png'),
(5636, '11.001.003099', '11.001.003099.png'),
(5637, '11.001.003100', '11.001.003100.png'),
(5638, '11.001.003101', '11.001.003101.png'),
(5639, '11.001.003102', '11.001.003102.png'),
(5640, '11.001.003103', '11.001.003103.png'),
(5641, '11.001.003104', '11.001.003104.png'),
(5642, '11.001.003105', '11.001.003105.png'),
(5643, '11.001.003106', '11.001.003106.png'),
(5644, '11.001.003107', '11.001.003107.png'),
(5645, '11.001.003108', '11.001.003108.png'),
(5646, '11.001.003109', '11.001.003109.png'),
(5647, '11.001.003110', '11.001.003110.png'),
(5648, '11.001.003111', '11.001.003111.png'),
(5649, '11.001.003112', '11.001.003112.png'),
(5650, '11.001.003113', '11.001.003113.png'),
(5651, '11.001.003114', '11.001.003114.png'),
(5652, '11.001.003115', '11.001.003115.png'),
(5653, '11.001.003116', '11.001.003116.png'),
(5654, '11.001.003117', '11.001.003117.png'),
(5655, '11.001.003118', '11.001.003118.png'),
(5656, '11.001.003119', '11.001.003119.png'),
(5657, '11.001.003120', '11.001.003120.png'),
(5658, '11.001.003121', '11.001.003121.png'),
(5659, '11.001.003122', '11.001.003122.png'),
(5660, '11.001.003123', '11.001.003123.png'),
(5661, '11.001.003124', '11.001.003124.png'),
(5662, '11.001.003125', '11.001.003125.png'),
(5663, '11.001.003126', '11.001.003126.png'),
(5664, '11.001.003127', '11.001.003127.png'),
(5665, '11.001.003128', '11.001.003128.png'),
(5666, '11.001.003129', '11.001.003129.png'),
(5667, '11.001.003130', '11.001.003130.png'),
(5668, '11.001.003131', '11.001.003131.png'),
(5669, '11.001.003132', '11.001.003132.png'),
(5670, '11.001.003133', '11.001.003133.png'),
(5671, '11.001.003134', '11.001.003134.png'),
(5672, '11.001.003135', '11.001.003135.png'),
(5673, '11.001.003136', '11.001.003136.png'),
(5674, '11.001.003137', '11.001.003137.png'),
(5675, '11.001.003138', '11.001.003138.png'),
(5676, '11.001.003139', '11.001.003139.png'),
(5677, '11.001.003140', '11.001.003140.png'),
(5678, '11.001.003141', '11.001.003141.png'),
(5679, '11.001.003142', '11.001.003142.png'),
(5680, '11.001.003143', '11.001.003143.png'),
(5681, '11.001.003144', '11.001.003144.png'),
(5682, '11.001.003145', '11.001.003145.png'),
(5683, '11.001.003146', '11.001.003146.png'),
(5684, '11.001.003147', '11.001.003147.png'),
(5685, '11.001.003148', '11.001.003148.png'),
(5686, '11.001.003149', '11.001.003149.png'),
(5687, '11.001.003150', '11.001.003150.png'),
(5688, '11.001.003151', '11.001.003151.png'),
(5689, '11.001.003152', '11.001.003152.png'),
(5690, '11.001.003153', '11.001.003153.png'),
(5691, '11.001.003154', '11.001.003154.png'),
(5692, '11.001.003155', '11.001.003155.png'),
(5693, '11.001.003156', '11.001.003156.png'),
(5694, '11.001.003157', '11.001.003157.png'),
(5695, '11.001.003158', '11.001.003158.png'),
(5696, '11.001.003159', '11.001.003159.png'),
(5697, '11.001.003160', '11.001.003160.png'),
(5698, '11.001.003161', '11.001.003161.png'),
(5699, '11.001.003162', '11.001.003162.png'),
(5700, '11.001.003163', '11.001.003163.png'),
(5701, '11.001.003164', '11.001.003164.png'),
(5702, '11.001.003165', '11.001.003165.png'),
(5703, '11.001.003166', '11.001.003166.png'),
(5704, '11.001.003167', '11.001.003167.png'),
(5705, '11.001.003168', '11.001.003168.png'),
(5706, '11.001.003169', '11.001.003169.png'),
(5707, '11.001.003170', '11.001.003170.png'),
(5708, '11.001.003171', '11.001.003171.png'),
(5709, '11.001.003172', '11.001.003172.png'),
(5710, '11.001.003173', '11.001.003173.png'),
(5711, '11.001.003174', '11.001.003174.png'),
(5712, '11.001.003175', '11.001.003175.png'),
(5713, '11.001.003176', '11.001.003176.png'),
(5714, '11.001.003177', '11.001.003177.png'),
(5715, '11.001.003178', '11.001.003178.png'),
(5716, '11.001.003179', '11.001.003179.png'),
(5717, '11.001.003180', '11.001.003180.png'),
(5718, '11.001.003181', '11.001.003181.png'),
(5719, '11.001.003182', '11.001.003182.png'),
(5720, '11.001.003183', '11.001.003183.png'),
(5721, '11.001.003184', '11.001.003184.png'),
(5722, '11.001.003185', '11.001.003185.png'),
(5723, '11.001.003186', '11.001.003186.png'),
(5724, '11.001.003187', '11.001.003187.png'),
(5725, '11.001.003188', '11.001.003188.png'),
(5726, '11.001.003189', '11.001.003189.png'),
(5727, '11.001.003190', '11.001.003190.png'),
(5728, '11.001.003191', '11.001.003191.png'),
(5729, '11.001.003192', '11.001.003192.png'),
(5730, '11.001.003193', '11.001.003193.png'),
(5731, '11.001.003194', '11.001.003194.png'),
(5732, '11.001.003195', '11.001.003195.png'),
(5733, '11.001.003196', '11.001.003196.png'),
(5734, '11.001.003197', '11.001.003197.png'),
(5735, '11.001.003198', '11.001.003198.png'),
(5736, '11.001.003199', '11.001.003199.png'),
(5737, '11.001.003200', '11.001.003200.png');

-- --------------------------------------------------------

--
-- Table structure for table `config_global`
--

CREATE TABLE `config_global` (
  `ID` tinyint(2) NOT NULL,
  `name` varchar(200) NOT NULL,
  `address` text NOT NULL,
  `phone` varchar(100) NOT NULL,
  `email` varchar(250) NOT NULL,
  `info` varchar(200) NOT NULL,
  `konversi_poin` decimal(10,1) NOT NULL,
  `news` text NOT NULL,
  `sort` int(11) NOT NULL,
  `flag` tinyint(1) NOT NULL DEFAULT '0',
  `image` varchar(250) NOT NULL,
  `since` date NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `config_global`
--

INSERT INTO `config_global` (`ID`, `name`, `address`, `phone`, `email`, `info`, `konversi_poin`, `news`, `sort`, `flag`, `image`, `since`) VALUES
(1, 'Koperasi Maju', '', '', '', '', '0.1', '', 1, 0, 'koperasi_maju.jpg', '2017-03-01');

-- --------------------------------------------------------

--
-- Table structure for table `jenis_jurnal`
--

CREATE TABLE `jenis_jurnal` (
  `id` int(11) NOT NULL,
  `jenis` varchar(3) NOT NULL,
  `keterangan` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `jenis_jurnal`
--

INSERT INTO `jenis_jurnal` (`id`, `jenis`, `keterangan`) VALUES
(1, 'GJ', 'General Journal'),
(2, 'PJ', 'Purchase Journal');

-- --------------------------------------------------------

--
-- Table structure for table `jenis_persediaan`
--

CREATE TABLE `jenis_persediaan` (
  `id` int(11) NOT NULL,
  `jenis_persediaan` varchar(75) NOT NULL,
  `is_purchase` int(11) NOT NULL,
  `is_sales` int(11) NOT NULL,
  `is_used` int(11) NOT NULL,
  `is_setengah_jadi` int(11) NOT NULL,
  `is_bahan_baku` int(11) NOT NULL,
  `is_barang_jadi` int(11) NOT NULL,
  `is_barang_jadi_awal` int(11) NOT NULL,
  `is_sparepart` int(11) NOT NULL,
  `is_fixed_asset` int(11) NOT NULL,
  `id_coa_persediaan` int(11) NOT NULL,
  `id_coa_biaya_persediaan` int(11) NOT NULL,
  `id_penjualan` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `jenis_persediaan`
--

INSERT INTO `jenis_persediaan` (`id`, `jenis_persediaan`, `is_purchase`, `is_sales`, `is_used`, `is_setengah_jadi`, `is_bahan_baku`, `is_barang_jadi`, `is_barang_jadi_awal`, `is_sparepart`, `is_fixed_asset`, `id_coa_persediaan`, `id_coa_biaya_persediaan`, `id_penjualan`) VALUES
(1, 'Bahan Baku', 1, 0, 1, 0, 1, 0, 0, 0, 0, 14, 0, 0),
(2, 'Barang Setengah Jadi', 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0),
(3, 'Barang Pemeliharaan / Sparepart', 1, 0, 1, 0, 0, 0, 0, 1, 0, 19, 75, 0),
(4, 'Barang Jadi', 0, 1, 0, 0, 0, 1, 0, 0, 0, 19, 0, 50),
(5, 'Barang Jadi Awal Produksi', 0, 0, 0, 0, 0, 0, 1, 0, 0, 19, 0, 0),
(6, 'Aktiva Tetap', 1, 0, 0, 0, 0, 0, 0, 0, 1, 21, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `log_activity`
--

CREATE TABLE `log_activity` (
  `ID` int(11) NOT NULL,
  `activity` varchar(255) NOT NULL,
  `id_detail` int(11) NOT NULL,
  `id_admin` int(11) NOT NULL,
  `date_in` datetime NOT NULL,
  `id_spareparts` int(11) NOT NULL COMMENT 'Only to product',
  `qty` double NOT NULL COMMENT 'Only to product',
  `qty_in` double NOT NULL,
  `qty_out` double NOT NULL,
  `status` smallint(6) NOT NULL,
  `status_read` tinyint(4) NOT NULL COMMENT '0:Unread, 1:Read ',
  `note` text NOT NULL,
  `sort` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `log_activity`
--

INSERT INTO `log_activity` (`ID`, `activity`, `id_detail`, `id_admin`, `date_in`, `id_spareparts`, `qty`, `qty_in`, `qty_out`, `status`, `status_read`, `note`, `sort`) VALUES
(1, 'Spareparts', 0, 1, '2018-07-14 08:14:53', 1, 100, 100, 0, 1, 0, 'Input First Stock', 1),
(2, 'Spareparts', 0, 1, '2018-07-14 15:11:51', 1, 105, 5, 0, 1, 0, 'Add Qty Spareparts', 2),
(7, 'Spareparts', 0, 1, '2018-07-14 15:20:15', 2, 20, 20, 0, 1, 0, 'Input First Stock', 7),
(12, 'Spareparts', 0, 1, '2018-07-14 19:58:36', 3, 560000, 560000, 0, 3, 0, 'Add Price Spareparts', 12),
(13, 'Spareparts', 0, 1, '2018-07-14 20:09:21', 3, 10, 10, 0, 1, 0, 'Input First Stock', 13),
(14, 'Spareparts', 0, 1, '2018-07-14 20:14:01', 3, 550000, 0, 10000, 2, 0, 'Reduce Price Spareparts', 14),
(15, 'Spareparts', 0, 1, '2018-07-14 20:26:48', 3, 15, 5, 0, 1, 0, 'Add Qty Spareparts', 15),
(16, 'Spareparts', 0, 1, '2018-07-15 08:50:07', 3, 500000, 0, 50000, 2, 0, 'Reduce Price Spareparts', 16),
(17, 'Spareparts', 0, 1, '2018-07-15 08:50:44', 3, 550000, 50000, 0, 3, 0, 'Add Price Spareparts', 17),
(18, 'Spareparts', 0, 1, '2018-07-15 08:53:15', 4, 20, 20, 0, 1, 0, 'Input First Stock', 18),
(29, 'Spareparts', 0, 1, '2018-07-15 19:26:06', 5, 100, 100, 0, 1, 0, 'Input First Stock', 29),
(51, 'Jobs', 1, 1, '2018-08-01 21:06:11', 0, 0, 0, 0, 0, 0, 'Unprocess Jobs', 51),
(37, 'Spareparts', 0, 1, '2018-07-16 10:48:53', 3, 15, 1, 0, 1, 0, 'Add Qty Spareparts', 37),
(78, 'Service', 4, 1, '2018-08-19 22:49:59', 0, 0, 0, 0, 0, 0, 'Create New Service', 78),
(75, 'Service', 4, 1, '2018-08-19 22:49:59', 0, 0, 0, 0, 0, 0, 'Create New Service', 75),
(76, 'Jobs', 5, 1, '2018-08-19 22:49:59', 0, 0, 0, 0, 0, 0, 'Unprocess Jobs', 76),
(77, 'Spareparts', 7, 1, '2018-08-19 22:49:59', 7, 1, 0, 0, 0, 0, 'Request New Spareparts', 77),
(50, 'Spareparts', 0, 1, '2018-07-16 11:55:09', 6, 25, 25, 0, 1, 0, 'Input First Stock', 50),
(74, 'Spareparts', 6, 1, '2018-08-19 22:49:59', 1, 1, 0, 0, 0, 0, 'Request New Spareparts', 74),
(68, 'Service', 2, 1, '2018-08-12 21:08:20', 0, 0, 0, 0, 0, 0, 'Create New Service', 68),
(69, 'Jobs', 3, 1, '2018-08-14 23:07:35', 0, 0, 0, 0, 0, 0, 'Unprocess Jobs', 69),
(70, 'Spareparts', 4, 1, '2018-08-14 23:07:36', 4, 1, 0, 0, 0, 0, 'Request New Spareparts', 70),
(71, 'Service', 3, 1, '2018-08-14 23:07:36', 0, 0, 0, 0, 0, 0, 'Create New Service', 71),
(72, 'Jobs', 4, 1, '2018-08-19 22:49:59', 0, 0, 0, 0, 0, 0, 'Unprocess Jobs', 72),
(73, 'Spareparts', 5, 1, '2018-08-19 22:49:59', 3, 1, 0, 0, 0, 0, 'Request New Spareparts', 73),
(66, 'Jobs', 2, 1, '2018-08-12 21:08:20', 0, 0, 0, 0, 0, 0, 'Unprocess Jobs', 66),
(67, 'Spareparts', 3, 1, '2018-08-12 21:08:20', 3, 1, 0, 0, 0, 0, 'Request New Spareparts', 67),
(62, 'Spareparts', 2, 1, '2018-08-02 15:31:33', 1, 1, 0, 0, 3, 0, 'Update Status Service to Done', 62),
(63, 'Spareparts', 0, 1, '2018-08-02 15:31:33', 1, 103, 0, 1, 0, 0, 'Update Status Service to Done', 63),
(64, 'Spareparts', 1, 1, '2018-08-02 15:31:33', 3, 1, 0, 0, 3, 0, 'Update Status Service to Done', 64),
(65, 'Spareparts', 0, 1, '2018-08-02 15:31:33', 3, 14, 0, 1, 0, 0, 'Update Status Service to Done', 65),
(59, 'Spareparts', 1, 1, '2018-08-01 21:59:01', 3, 1, 1, 0, 3, 0, 'Update Status to Ready', 59),
(60, 'Service', 1, 1, '2018-08-02 15:31:33', 0, 0, 0, 0, 0, 0, 'Update Status Service to Done', 60),
(61, 'Jobs', 1, 1, '2018-08-02 15:31:33', 0, 0, 0, 0, 3, 0, 'Update Status Service to Done', 61),
(52, 'Spareparts', 1, 1, '2018-08-01 21:06:11', 3, 1, 0, 0, 0, 0, 'Request New Spareparts', 52),
(53, 'Spareparts', 2, 1, '2018-08-01 21:06:11', 1, 1, 0, 0, 0, 0, 'Request New Spareparts', 53),
(54, 'Service', 1, 1, '2018-08-01 21:06:11', 0, 0, 0, 0, 0, 0, 'Create New Service', 54),
(55, 'Service', 1, 1, '2018-08-01 21:28:36', 0, 0, 0, 0, 0, 0, 'Update Status Service to Process', 55),
(56, 'Jobs', 1, 1, '2018-08-01 21:28:36', 0, 0, 0, 0, 1, 0, 'Update Status Service to Process', 56),
(57, 'Spareparts', 2, 1, '2018-08-01 21:28:36', 1, 1, 0, 0, 1, 0, 'Update Status Service to Process', 57),
(58, 'Spareparts', 1, 1, '2018-08-01 21:28:36', 3, 1, 0, 0, 1, 0, 'Update Status Service to Process', 58),
(79, 'Service', 4, 1, '2019-01-05 18:52:03', 0, 0, 0, 0, 0, 0, 'Update Status Service to Process', 79),
(80, 'Jobs', 4, 1, '2019-01-05 18:52:03', 0, 0, 0, 0, 1, 0, 'Update Status Service to Process', 80),
(81, 'Spareparts', 6, 1, '2019-01-05 18:52:03', 1, 1, 0, 0, 1, 0, 'Update Status Service to Process', 81),
(82, 'Spareparts', 5, 1, '2019-01-05 18:52:03', 3, 1, 0, 0, 1, 0, 'Update Status Service to Process', 82),
(83, 'Jobs', 5, 1, '2019-01-05 18:52:03', 0, 0, 0, 0, 1, 0, 'Update Status Service to Process', 83),
(84, 'Spareparts', 7, 1, '2019-01-05 18:52:03', 7, 1, 0, 0, 1, 0, 'Update Status Service to Process', 84);

-- --------------------------------------------------------

--
-- Table structure for table `msbulan`
--

CREATE TABLE `msbulan` (
  `id` int(11) NOT NULL,
  `bulan` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `msbulan`
--

INSERT INTO `msbulan` (`id`, `bulan`) VALUES
(1, 'January'),
(2, 'February'),
(3, 'March'),
(4, 'April'),
(5, 'May'),
(6, 'June'),
(7, 'July'),
(8, 'August'),
(9, 'September'),
(10, 'October'),
(11, 'November'),
(12, 'December');

-- --------------------------------------------------------

--
-- Table structure for table `msparameter_persediaan`
--

CREATE TABLE `msparameter_persediaan` (
  `id` int(11) NOT NULL,
  `comp_name` varchar(150) NOT NULL,
  `pembuat_persediaan` varchar(50) NOT NULL,
  `pemeriksa_persediaan` varchar(50) NOT NULL,
  `manager` varchar(50) NOT NULL,
  `lokasi` varchar(30) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `msparameter_persediaan`
--

INSERT INTO `msparameter_persediaan` (`id`, `comp_name`, `pembuat_persediaan`, `pemeriksa_persediaan`, `manager`, `lokasi`) VALUES
(1, 'PT. BPR MAGGA JAYA UTAMA', 'Jesslyn', 'Desi Sari Dewi', 'Alice Elizabeth Marlie', 'Tangerang');

-- --------------------------------------------------------

--
-- Table structure for table `mspemasok`
--

CREATE TABLE `mspemasok` (
  `id` int(11) NOT NULL,
  `nama` varchar(75) NOT NULL,
  `alamat` varchar(254) NOT NULL,
  `no_hp1` varchar(20) NOT NULL,
  `no_hp2` varchar(20) NOT NULL,
  `email` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `created_by` varchar(10) NOT NULL,
  `updated_at` datetime NOT NULL,
  `updated_by` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

--
-- Dumping data for table `mspemasok`
--

INSERT INTO `mspemasok` (`id`, `nama`, `alamat`, `no_hp1`, `no_hp2`, `email`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES
(19, 'PT. Jaya Baya Abadi', '', '', '', '', '2022-01-25 16:01:46', 'Admin', '0000-00-00 00:00:00', '');

-- --------------------------------------------------------

--
-- Table structure for table `mspersediaan`
--

CREATE TABLE `mspersediaan` (
  `id` int(11) NOT NULL,
  `kode_barang` varchar(10) NOT NULL,
  `nama_barang` varchar(150) NOT NULL,
  `jenis_persediaan` int(11) NOT NULL,
  `stok_awal` int(11) NOT NULL,
  `satuan` int(11) NOT NULL,
  `created_by` varchar(10) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_by` varchar(10) NOT NULL,
  `updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mspersediaan`
--

INSERT INTO `mspersediaan` (`id`, `kode_barang`, `nama_barang`, `jenis_persediaan`, `stok_awal`, `satuan`, `created_by`, `created_at`, `updated_by`, `updated_at`) VALUES
(175, 'TL01', 'Tailing', 1, 10000, 1, 'admin', '0000-00-00 00:00:00', 'Admin', '2022-04-22 10:58:18'),
(181, 'BSJ01', 'Barang Setengah Jadi', 2, 0, 1, 'Admin', '2022-01-25 07:17:53', '', '0000-00-00 00:00:00'),
(186, 'BJ01', 'Pasir', 5, 0, 1, 'Admin', '2022-02-06 12:48:01', 'Admin', '2022-03-13 15:50:10'),
(187, 'BJ02', 'Timah', 4, 0, 1, '', '0000-00-00 00:00:00', 'Admin', '2022-04-01 10:57:00'),
(188, 'BJ03', 'Zircon', 4, 0, 1, '', '0000-00-00 00:00:00', 'Admin', '2022-04-01 10:57:16'),
(189, 'BJ04', 'Ilmenite', 5, 0, 1, '', '0000-00-00 00:00:00', 'Admin', '2022-04-01 10:57:30'),
(190, 'BJ05', 'Monazite', 4, 0, 1, '', '0000-00-00 00:00:00', 'Admin', '2022-04-01 10:57:46'),
(191, 'SP01', 'Sparepart Meja Goyang', 3, 0, 6, 'Admin', '2022-03-03 16:58:50', '', '0000-00-00 00:00:00'),
(192, 'FT01', 'Furniture Kantor', 6, 0, 6, 'Admin', '2022-03-04 09:54:47', '', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `mst_barang`
--

CREATE TABLE `mst_barang` (
  `id` int(11) NOT NULL,
  `kode_barang` varchar(30) NOT NULL,
  `nama_barang` varchar(150) NOT NULL,
  `kategori_barang` int(11) NOT NULL,
  `satuan` int(11) NOT NULL,
  `status_bagus` varchar(5) NOT NULL,
  `status_perbaikan` varchar(5) NOT NULL,
  `status_rusak` varchar(5) NOT NULL,
  `pengecekan_terakhir` date NOT NULL,
  `dicek_oleh` varchar(150) NOT NULL,
  `pengguna` varchar(150) NOT NULL,
  `jumlah_unit` int(11) NOT NULL,
  `tanggal_perolehan` date NOT NULL,
  `lokasi_barang` varchar(150) NOT NULL,
  `is_stok` varchar(5) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mst_barang`
--

INSERT INTO `mst_barang` (`id`, `kode_barang`, `nama_barang`, `kategori_barang`, `satuan`, `status_bagus`, `status_perbaikan`, `status_rusak`, `pengecekan_terakhir`, `dicek_oleh`, `pengguna`, `jumlah_unit`, `tanggal_perolehan`, `lokasi_barang`, `is_stok`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(10, 'KB001', 'Printer', 9, 3, '', 'on', '', '2023-05-17', 'yansen', 'ika', 9, '2023-05-17', 'ruang 1', 'on', '2023-05-17 10:42:58', 'Admin', '2023-05-29 07:41:29', 'Admin'),
(11, 'KB002', 'Tinta', 9, 1, 'on', '', '', '2023-05-17', 'yansen', 'ika', 9, '2023-05-18', 'ruang 1', 'on', '2023-05-17 10:48:48', 'Admin', '2023-05-31 01:59:33', 'Admin'),
(12, 'KB003', 'Langganan Akun Canva Pro', 20, 1, '', 'on', '', '2023-05-17', 'yansen', 'ika', 9, '2023-05-17', 'ruang 1', 'on', '2023-05-17 10:55:41', 'Admin', '2023-05-29 07:42:46', 'Admin'),
(13, 'KB004', 'AQUA BOTOL 600 ML', 9, 1, 'on', '', '', '2023-05-17', 'yansen', 'ika', 9, '2023-05-17', 'ruang 1', 'on', '2023-05-17 10:56:45', 'Admin', '2023-05-29 08:02:45', 'Admin'),
(14, 'KB006', 'Printer', 8, 1, '', 'on', '', '2023-05-17', 'yansen', 'ika', 9, '2023-05-17', 'ruang 1', 'on', '2023-05-17 10:57:25', 'Admin', '2023-05-29 08:03:08', 'Admin'),
(15, 'KB005', 'Printer', 9, 1, '', '', 'on', '2023-05-17', 'yansen', 'ika', 9, '2023-05-17', 'ruang 1', 'on', '2023-05-17 10:58:14', 'Admin', '2023-05-29 08:02:59', 'Admin'),
(16, 'ATK001', 'Pulpen Standard Hitam', 17, 1, 'on', '', '', '2023-05-25', 'Mariam', 'IT', 1500, '2023-05-29', 'IT', 'on', '2023-05-29 07:46:26', 'Admin', '0000-00-00 00:00:00', ''),
(17, '0010/KSP-AT/M/IV/2023', 'Modem Mobile wifi XL GO', 9, 3, 'on', '', '', '2023-05-24', 'mariam', 'bagian PPA Mikro Kecil', 1, '2023-05-04', 'lt. 3 ruang PPA Mikro Kecil', 'on', '2023-05-29 08:04:43', 'mariam', '2023-06-05 02:49:56', 'Admin'),
(18, '001/KSP-AT/V/2023', 'LAPTOP ASUS', 9, 3, 'on', '', '', '2023-06-20', 'Mariam', 'ika aprilia', 1, '2023-06-02', 'ruang 3', 'on', '2023-06-06 02:51:26', 'Admin', '0000-00-00 00:00:00', ''),
(19, '001/KSP-AT/V/2023', 'LAPTOP ASUS', 9, 3, 'on', '', '', '2023-06-20', 'siti mariam', 'ika', 1, '2023-06-02', 'ruang 3', 'on', '2023-06-06 02:51:26', 'Admin', '2023-06-06 02:53:39', 'Admin'),
(20, '22', 'Laptop', 1, 1, 'on', '', '', '2023-06-15', 'Mari', 'Orik', 8, '2023-07-01', 'Tamboran', 'on', '2023-06-15 04:58:01', 'Admin', '2023-06-15 04:59:07', 'Admin');

-- --------------------------------------------------------

--
-- Table structure for table `mst_divisi`
--

CREATE TABLE `mst_divisi` (
  `id` int(11) NOT NULL,
  `divisi` varchar(30) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mst_divisi`
--

INSERT INTO `mst_divisi` (`id`, `divisi`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(1, 'Group Head', '2023-05-25 05:22:26', 'Admin', '0000-00-00 00:00:00', ''),
(2, 'Penunjang Usaha', '2023-05-25 05:22:42', 'Admin', '0000-00-00 00:00:00', ''),
(3, 'Sekretariat', '2023-05-25 05:22:55', 'Admin', '0000-00-00 00:00:00', ''),
(4, 'Akuntansi & Keuangan', '2023-05-25 05:23:15', 'Admin', '0000-00-00 00:00:00', '');

-- --------------------------------------------------------

--
-- Table structure for table `mst_kantor`
--

CREATE TABLE `mst_kantor` (
  `id` int(11) NOT NULL,
  `nama_kantor` varchar(50) NOT NULL,
  `alamat` varchar(150) NOT NULL,
  `no_telepon` varchar(50) NOT NULL,
  `is_kp` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mst_kantor`
--

INSERT INTO `mst_kantor` (`id`, `nama_kantor`, `alamat`, `no_telepon`, `is_kp`) VALUES
(1, 'Kantor Pusat', '', '', 1),
(2, 'Kantor Cabang Ayodya', '', '', 2),
(3, 'Kantor Kas 1', '', '', 2),
(4, 'Kantor Kas 2', '-', '-', 2);

-- --------------------------------------------------------

--
-- Table structure for table `mst_kategori`
--

CREATE TABLE `mst_kategori` (
  `id` int(11) NOT NULL,
  `kategori` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mst_kategori`
--

INSERT INTO `mst_kategori` (`id`, `kategori`) VALUES
(1, 'Kategori 1');

-- --------------------------------------------------------

--
-- Table structure for table `mst_koperasi`
--

CREATE TABLE `mst_koperasi` (
  `id` int(11) NOT NULL,
  `nama_koperasi` varchar(150) NOT NULL,
  `nama_alias` varchar(150) NOT NULL,
  `alamat` varchar(250) NOT NULL,
  `wakil_koperasi` varchar(150) NOT NULL,
  `jabatan` varchar(150) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mst_koperasi`
--

INSERT INTO `mst_koperasi` (`id`, `nama_koperasi`, `nama_alias`, `alamat`, `wakil_koperasi`, `jabatan`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(1, 'KOPERASI SIMPAN PINJAM MAJU WIJAYA', 'KOPERASI MAJU', 'Jalan Kembangan Raya Blok JJ Puri Indah, Kel: Kembangan Selatan, Kec: Kembangan, Kota: Jakarta Barat', 'NJO HENDWI WIJAYA', 'Ketua Koperasi', '2022-07-20 05:41:48', 'Admin', '0000-00-00 00:00:00', '');

-- --------------------------------------------------------

--
-- Table structure for table `mst_kurir`
--

CREATE TABLE `mst_kurir` (
  `id` int(11) NOT NULL,
  `kurir` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mst_kurir`
--

INSERT INTO `mst_kurir` (`id`, `kurir`) VALUES
(1, 'JNE'),
(2, 'Si Cepat');

-- --------------------------------------------------------

--
-- Table structure for table `mst_merek`
--

CREATE TABLE `mst_merek` (
  `id` int(11) NOT NULL,
  `merek` varchar(250) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mst_merek`
--

INSERT INTO `mst_merek` (`id`, `merek`) VALUES
(9, 'CHARLES & KEITH'),
(13, 'REEBOK'),
(14, 'SKECHERS'),
(15, 'NOCHE'),
(16, 'HUSH PUPPIES'),
(17, 'AIRWALK'),
(19, 'MANGO');

-- --------------------------------------------------------

--
-- Table structure for table `mst_model`
--

CREATE TABLE `mst_model` (
  `id` int(11) NOT NULL,
  `model` varchar(90) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mst_model`
--

INSERT INTO `mst_model` (`id`, `model`) VALUES
(1, 'ACV'),
(2, 'ADDV');

-- --------------------------------------------------------

--
-- Table structure for table `mst_pasal`
--

CREATE TABLE `mst_pasal` (
  `id` int(11) NOT NULL,
  `pasal` int(11) NOT NULL,
  `judul` varchar(150) NOT NULL,
  `isi_pasal` text NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(15) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(15) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mst_pasal`
--

INSERT INTO `mst_pasal` (`id`, `pasal`, `judul`, `isi_pasal`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(1, 1, 'JUMLAH PINJAMAN DAN TUJUAN PENGGUNAAN ', '<ol>\r\n	<li style=\"text-align: justify;\">KOPERASI dengan ini memberikan pinjaman kepada PEMINJAM dan sebaliknya PEMINJAM mengakui benar-benar telah menerima pinjaman dari KOPERASI dan mengakui secara sah telah berhutang dari KOPERASI sebesar <strong>[jumlah_fasilitas]&nbsp;</strong><strong>[terbilang_fasilitas]</strong> di kantor KOPERASI. Untuk penerimaan jumlah uang tersebut, <strong>Perjanjian ini dinyatakan berlaku pula sebagai kwitansi atau tanda penerimaan yang sah.</strong></li>\r\n	<li style=\"text-align: justify;\">PEMINJAM berjanji menggunakan pinjaman yang diterima dari KOPERASI sebagaimana dimaksud dalam perjanjian ini semata-mata untuk tujuan [jenis_fasilitas].</li>\r\n</ol>\r\n', '2022-07-11 23:58:35', 'Admin', '2022-07-20 04:29:37', 'Admin'),
(2, 2, 'BUNGA, PROVISI, ADMINISTRASI', '<p style=\"text-align:justify\">Sehubungan dengan pemberian pinjaman pada Pasal 1 Ayat 1, PEMINJAM wajib membayar kepada KOPERASI:</p>\r\n\r\n<ol start=\"1\" style=\"list-style-type:lower-alpha\">\r\n	<li style=\"text-align:justify\"><strong>Bunga sebesar :</strong>&nbsp; <strong>[bunga_pinjaman]</strong>&nbsp;<strong>% [terbilang_bunga_pinjaman]&nbsp;</strong><br />\r\n	Untuk setiap bulan, dihitung dari nominal pinjaman, dengan ketentuan bunga selalu ditetapkan penuh satu bulan meskipun pada bulan yang sedang berjalan, hutang tersebut dilunasi.</li>\r\n	<li style=\"text-align:justify\"><strong>Provisi sebesar :&nbsp;</strong>&nbsp;<strong>[provisi]</strong>&nbsp;<strong>% [terbilang_provisi]&nbsp;</strong><br />\r\n	Dibayar satu kali pada saat pinjaman terealisasi, dihitung dari jumlah seluruh pinjaman yang diberikan.</li>\r\n	<li style=\"text-align:justify\"><strong>Biaya Administrasi sebesar :&nbsp;</strong>&nbsp;<strong>[administrasi]&nbsp;% [terbilang_administrasi]&nbsp;</strong><br />\r\n	Dibayar satu kali pada saat pinjaman terealisasi, dihitung dari jumlah seluruh pinjaman yang diberikan.</li>\r\n</ol>\r\n', '2022-07-12 00:08:03', 'Admin', '2022-07-22 15:45:52', 'Admin'),
(3, 3, 'JANGKA WAKTU PINJAMAN', '<p style=\"text-align: justify;\">Sehubungan dengan pemberian pinjaman pada Pasal 1 Ayat 1, maka jangka waktu PINJAMAN di KOPERASI adalah :</p>\r\n\r\n<ol>\r\n	<li style=\"text-align: justify;\">Jangka waktu pinjaman dalam perjanjian &nbsp;ini adalah <strong>[jangka_waktu]&nbsp;</strong><strong>(</strong><strong>[terbilang_jangka_waktu]</strong><strong>) bulan</strong> terhitung sejak tanggal <strong>[tanggal_awal]&nbsp;</strong>dan berakhir tanggal <strong>[tanggal_akhir]</strong><strong>.</strong></li>\r\n</ol>\r\n\r\n<p style=\"text-align: justify;\">Pembayaran kembali atas angsuran, harus dilakukan oleh PEMINJAM kepada KOPERASI, dengan cara pembayaran yang telah disepakati oleh PARA PIHAK, sebanyak<strong> [jangka_waktu] ([terbilang_jangka_waktu]) kali angsuran bulanan</strong> secara berturut-turut tanpa putus.&nbsp;</p>\r\n', '2022-07-20 04:01:08', 'Admin', '2022-07-20 04:30:14', 'Admin'),
(4, 4, 'PEMBAYARAN POKOK DAN BUNGA', '<p style=\"text-align:justify\">Sehubungan dengan pemberian pinjaman pada Pasal 1 Ayat 1, maka PEMINJAM harus membayar angsuran PINJAMAN seperti yang disebutkan dibawah ini :</p>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify\">Pembayaran angsuran yang <strong>harus dibayar pada setiap bulan sebesar</strong><strong> Rp </strong><strong>[cicilan]</strong><strong>,- (</strong><strong>terbilang_cicilan</strong><strong>)<em>, </em></strong>dengan rincian : <strong>pokok pinjaman sebesar Rp </strong><strong>[cicilan_pokok]</strong>,-; <strong>bunga sebesar Rp </strong><strong>[cicilan_bunga]</strong><strong>,-</strong>; dan <strong>simpanan wajib Rp [simpanan_wajib],-.</strong></li>\r\n	<li style=\"text-align:justify\">Pembayaran angsuran pokok dan bunga yang harus dilakukan selambat-lambatnya setiap tanggal <strong>[tanggal_jatuh_tempo]&nbsp;</strong><strong>(</strong><strong>[terbilang_tanggal_jatuh_tempo]) </strong>setiap bulannya<strong>. </strong>Pembayaran angsuran tersebut untuk pertama kalinya dilakukan pada tanggal <strong>[tanggal_mulai_cicilan]&nbsp;</strong>dan berakhir pada tanggal <strong>[tanggal_akhir_cicilan].</strong></li>\r\n	<li style=\"text-align:justify\">Pembayaran yang dimaksud dalam ayat 1 dapat dilakukan dengan cara pembayaran tunai dan/atau mendebet rekening PEMINJAM. PEMINJAM dengan ini memberi kuasa penuh kepada KOPERASI untuk setiap saat mendebet rekening tabungan PEMINJAM kepada KOPERASI yang jumlahnya setiap kali akan ditetapkan oleh KOPERASI dan menggunakan jumlah uang tersebut untuk pembayaran bunga setiap bulan atau untuk membayar pelunasan sebagian atau seluruhnya jumlah pinjaman yang terhutang berikut biaya, denda dan lain-lain yang timbul sehubungan dengan perjanjian ini.</li>\r\n	<li style=\"text-align:justify\">Setiap pembayaran yang sudah dilakukan oleh PEMINJAM kepada KOPERASI, tidak dapat diminta atau ditarik kembali dengan alasan apapun, sehingga apabila PEMINJAM melakukan sekaligus beberapa pembayaran, maka angsuran tersebut akan diiperhitungkan sebagai pembayaran bulan berikutnya. Semua pembayaran harus dilakukan oleh PEMINJAM kepada KOPERASI di kantor KOPERASI atau kuasanya yang sah dengan mendapat tanda penerimaan yang sah oleh KOPERASI.</li>\r\n	<li style=\"text-align:justify\">Jika pada tanggal jatuh tempo pembayaran tersebut bukan merupakan hari kerja KOPERASI, maka pembayaran angsuran harus dilakukan 1 (satu) hari sebelumnya.</li>\r\n</ol>\r\n\r\n<p style=\"text-align:justify\">PEMINJAM dengan ini memberi kuasa kepada KOPERASI untuk mendebet dan membebani rekening simpanan harian milik PEMINJAM nomor <strong>[nomor_anggota]</strong> atas nama <strong>[nama_anggota]&nbsp;</strong>yang ada pada KSP Maju Wijaya dengan biaya-biaya, denda, bunga, dan angsuran pokok. Setiap pembebanan seperti dimaksud ataupun setoran PEMINJAM akan diperhitungkan terlebih dahulu untuk pembayaran kewajiban PEMINJAM dengan urutan prioritas: biaya-biaya, denda, tunggakan bunga dan tunggakan pokok.</p>\r\n', '2022-07-20 04:07:48', 'Admin', '2022-07-22 16:20:53', 'Admin'),
(5, 5, 'JAMINAN', '<p style=\"text-align: justify;\">Guna menjamin kepastian bahwa PEMINJAM akan melunasi seluruh kewajibannya kepada KOPERASI secara tertib dan sebagaimana mestinya, serta setiap dan jumlah uang yang karena sebab apapun juga terhutang dan wajib dibayar oleh PEMINJAM kepada KOPERASI, baik hari ini maupun dikemudian hari, baik yang timbul berdasarkan perjanjian ini maupun yang akan dibuat, dan setiap perubahan, penambahan dan/atau perpanjangan dikemudian hari, maka PEMINJAM dengan ini memberikan Jaminan Kebendaan kepada KOPERASI, atas barang-barang tersebut dibawah ini:</p>\r\n\r\n<p style=\"margin-left: 0.5in; text-align: center;\"><strong>[detail_jaminan]</strong></p>\r\n\r\n<div style=\"clear: both; text-align: justify;\">Untuk selanjutnya disebut <strong>Barang Jaminan</strong>. Pengikatan atas Barang Jaminan tersebut, termaktub dalam Pasal 6 perjanjian ini.</div>\r\n\r\n<ol>\r\n	<li style=\"text-align: justify;\">PEMINJAM menjamin kepada KOPERASI, bahwa Barang Jaminan mana benar merupakan hak milik dari PEMINJAM sendiri, bebas dari segala sitaan, tidak sedang diagunkan dengan cara bagaimanapun juga kepada pihak lain, tidak tersangkut suatu perkara atau sengketa, dan tidak ada pihak lain yang ikut mempunyai hak atas Barang Jaminan tersebut. PEMINJAM akan mengambil alih segala tanggung jawab dalam bentuk apapun, sebagai akibat dari tuntutan atau gugatan yang menyangkut Barang Jaminan tersebut dari pihak manapun.</li>\r\n	<li style=\"text-align: justify;\">Segala harta kekayaan PEMINJAM, baik yang bergerak maupun yang tidak bergerak, yang sudah ada maupun yang akan ada dikemudian hari, menjadi jaminan untuk pelunasan seluruh hutang PEMINJAM kepada KOPERASI baik pokok pinjaman, bunga, provisi, denda-denda maupun biaya-biaya yang timbul karena perjanjian pinjaman ini maupun yang akan dibuat beserta setiap perubahan penambahan atau perpanjangan dikemudian hari.</li>\r\n</ol>\r\n', '2022-07-20 04:13:51', 'Admin', '2022-07-20 04:31:08', 'Admin'),
(6, 6, 'PENGIKATAN JAMINAN', '<ol>\r\n	<li style=\"text-align:justify\">Untuk Jaminan berupa <strong>[jaminan]</strong>, maka PEMINJAM dengan ini menyerahkan Hak Milik atas kendaraan tersebut kepada KOPERASI. Pengikatan jaminan tersebut sudah termasuk dalam perjanjian ini dan/atau akan dibuat tambahan dalam suatu akta Notaris, Akta mana merupakan bagian dari dan karenanya merupakan satu kesatuan yang tidak dapat dipisahkan dari Perjanjian ini dan dengan mengindahkan ketentuan-ketentuan sebagai berikut :\r\n	<ol start=\"1\" style=\"list-style-type: lower-alpha;\">\r\n		<li>Hak kepemilikan kendaraan bermotor tersebut beralih dari PEMINJAM kepada KOPERASI secara serta merta. Kendaraan tersebut tetap berada ditangan PEMINJAM, tetapi PEMINJAM tidak lagi sebagai pemilik kendaraan, melainkan hanya Pinjam Pakai saja, walaupun kendaraan tersebut atas nama PEMINJAM<strong>.</strong></li>\r\n		<li>KOPERASI atau kuasanya, berhak untuk sewaktu-waktu, jika dianggap perlu memasuki tempat-tempat dimana kendaraan tersebut disimpan atau terdapat dan/atau diduga oleh KOPERASI berada disuatu tempat tertentu untuk memeriksa serta melihat keadaannya. Atas biaya PEMINJAM, KOPERASI berhak melakukan tindakan yang seharusnya dilakukan oleh PEMINJAM, agar kendaran tersebut tetap dalam keadaan baik dan terpelihara, yaitu dalam hal PEMINJAM lalai melakukannya sendiri.</li>\r\n		<li>PEMINJAM bertanggung jawab penuh atas setiap kehilangan, kerusakan, penyusutan, kemunduran nilai, kerugian yang terjadi atas kendaraan. Dan atas setiap ongkos yang timbul dari penguasaan, penyiapan, pemakaian, pemeliharaan, perubahan yang dilakukan PEMINJAM atas kendaraan yang dipegang oleh PEMINJAM sebagai pihak yang meminjam kendaraan dari KOPERASI</li>\r\n		<li>PEMINJAM selanjutnya wajib membela kepentingan KOPERASI, membayar ganti rugi kepada KOPERASI dan membebaskan KOPERASI dari setiap dan semua gugatan, tuntutan, tindakan, kerugian, tanggungjawab atau pengeluaran (termasuk biaya Pengadilan, ongkos wakil KOPERASI untuk melaksanakan Perjanjian) yang dapat diderita KOPERASI berdasarkan pemeliharaan, penyimpanan, pemakaian, pelaksanaan, pemilikan atau setiap tindakan yang diambil sehubungan dengan hal-hal&nbsp; tersebut.</li>\r\n		<li>Hak kepemilikan atas kendaraan bermotor seperti tercantum dalam ayat 1 huruf a pasal ini, akan beralih kembali menjadi milik PEMINJAM, pada saat PEMINJAM telah melunasi seluruh kewajibannya kepada KOPERASI.</li>\r\n	</ol>\r\n	</li>\r\n	<li style=\"text-align:justify\">PEMINJAM dilarang menjual, menghibahkan, menjaminkan / mengagunkan kembali memindah tangankan atau menyewakan Barang Jaminan tersebut kepada pihak lain dengan cara dan alasan apapun tanpa persetujuan tertulis dari KOPERASI, atau mengenai cara dan jangka waktu dan pembayaran dimuka uang sewa, seperti termaktub dalam pasal 1185 Kitab Undang-undang Hukum Perdata. PEMINJAM berkewajiban memelihara dengan sebaik-baiknya secara rutin akan memberikan laporan tertulis kepada pihak Koperasi mengenai keadaan tersebut.</li>\r\n</ol>\r\n', '2022-07-20 04:19:58', 'Admin', '2022-07-22 15:46:32', 'Admin'),
(7, 7, 'PENGAMANAN JAMINAN', '<ol>\r\n	<li style=\"text-align:justify\">KOPERASI berhak untuk melakukan dan/atau menyuruh melakukan tindakan-tindakan untuk <strong>mengamankan kepentingan KOPERASI atas barang jaminan </strong>dan dengan ini PEMINJAM memberikan kuasa dengan Hak Substitusi kepada KOPERASI:\r\n	<ol start=\"1\" style=\"list-style-type: lower-alpha;\">\r\n		<li style=\"text-align:justify\">Untuk mengambil jaminan kendaraan bermotor dimanapun dan/atau ditempat siapapun dan dari tangan siapapun kendaraan tersebut berada.</li>\r\n	</ol>\r\n	</li>\r\n	<li style=\"text-align:justify\">Untuk maksud dalam ayat 1 pasal ini, PEMINJAM dikenakan biaya-biaya pengamanan barang jaminan yang akan ditetapkan kemudian oleh KOPERASI.</li>\r\n</ol>\r\n', '2022-07-20 04:23:41', 'Admin', '2022-07-22 15:36:15', 'Admin'),
(8, 8, 'KEADAAN LALAI DAN DENDA KETERLAMBATAN', '<ol>\r\n	<li style=\"text-align: justify;\">PEMINJAM dikatakan lalai melakukan kewajiban pembayaran sebagaimana ditentukan dalam Pasal 4 perjanjian ini, apabila PEMINJAM tidak melakukan kewajiban pembayaran angsuran pokok pinjaman dan bunga pada tanggal pembayaran yang telah ditetapkan.</li>\r\n	<li style=\"text-align: justify;\">Kelalaian pembayaran sudah cukup terbukti dengan berlalunya waktu pembayaran yang telah ditentukan, dalam hal ini KOPERASI tidak perlu melakukan sesuatu termasuk tetapi tidak terbatas pada pemberitahuan, peringatan atau somasi.</li>\r\n	<li style=\"text-align: justify;\">Terhadap kelalaian itu, PEMINJAM wajib membayar kepada KOPERASI denda setiap hari dihitung dari setiap keterlambatan pembayaran angsuran hutang, sebesar 2 &permil; (Dua permil) dari pokok pinjaman dan bunga yang sudah jatuh tempo.</li>\r\n	<li style=\"text-align: justify;\">Denda mana seluruhnya harus dibayar seketika dan sekaligus saat ditagih oleh KOPERASI. Apabila sampai jangka waktu Periode Pinjaman ini sudah berakhir tetapi PEMINJAM belum juga melunasi hutangnya sampai selesai, maka, bunga, provisi dan denda-denda yang telah ditentukan dalam perjanjian pinjaman ini tetap berlaku demikian juga persyaratannya, dan KOPERASI berhak memperhitungkan pula denda (<em>penalty overdue</em>) yang harus dibayar oleh PEMINJAM kepada KOPERASI sebesar 1 % (satu persen) setiap hari dihitung dari jumlah hutang yang belum dilunasi baik hutang pokok, bunga, provisi dan biaya-biaya lainnya, denda mana seluruhnya harus dibayar seketika dan sekaligus kepada KOPERASI.</li>\r\n	<li style=\"text-align: justify;\">Apabila PEMINJAM masih mempunyai tunggakan bunga pinjaman dan atau denda, maka setiap setoran PEMINJAM kepada KOPERASI akan diperhitungkan terlebih dahulu sebagai pembayaran atas tunggakan bunga pinjaman dan/atau denda-denda yang sudah jatuh tempo.</li>\r\n</ol>\r\n', '2022-07-20 04:25:17', 'Admin', '2022-07-20 04:32:50', 'Admin'),
(9, 9, 'PENAGIHAN SEKETIKA DAN SEKALIGUS', '<p style=\"text-align: justify;\">Menyimpang dari ketentuan dalam Pasal 3 diatas, KOPERASI berhak menagih seluruh piutangnya kepada PEMINJAM seketika dan sekaligus tanpa somasi lagi, sehingga suatu peringatan dengan surat juru sita atau surat lainnya tidak diperlukan lagi, <strong>apabila</strong> timbul salah satu peristiwa seperti dibawah ini;</p>\r\n\r\n<ol style=\"list-style-type:lower-alpha\">\r\n	<li style=\"text-align: justify;\"><strong>PEMINJAM menunggak selama 30 (tiga puluh) hari</strong> dari jadwal yang pembayarannya telah diperjanjikan dan atas tunggakan tersebut PEMINJAM tidak memberikan penjelasan.</li>\r\n	<li style=\"text-align: justify;\">Bilamana PEMINJAM meninggal dunia, kecuali apabila para ahli warisnya dan/atau yang mendapatkan hak daripadanya dapat memenuhi kewajiban-kewajibannya menurut hukum dan undang-undang</li>\r\n	<li style=\"text-align: justify;\">Peminjam dinyatakan pailit, ditaruh di bawah pengampuan (onder curatele gestald), meminta penundaan pembayaran (Surseance Van Betaling).</li>\r\n	<li style=\"text-align: justify;\">PEMINJAM meninggalkan tempat tinggalnya / pergi ketempat lain yang tidak diketahui untuk waktu yang lama dan tidak diketahui untuk waktu yang lama dan tidak tertentu, melakukan atau terlibat dalam suatu perbuatan / peristiwa yang menurut pertimbangan KOPERASI dapat membahayakan pemberian pinjaman tersebut, ditangkap pihak yang berwajib atau dijatuhi hukuman penjara.</li>\r\n	<li style=\"text-align: justify;\">Bilamana barang yang masih berstatus barang yang dijaminkan oleh PEMINJAM berdasarkan Perjanjian ini dipindah tangankan dengan cara apapun kepada pihak lain tanpa persetujuan KOPERASI.</li>\r\n</ol>\r\n', '2022-07-20 04:25:57', 'Admin', '2022-07-20 04:33:13', 'Admin'),
(10, 10, 'DENDA PENALTI', '<p style=\"text-align: justify;\">Apabila PEMINJAM melunasi hutangnya lebih awal dari jangka waktu yang telah diperjanjikan, maka PEMINJAM akan dikenakan penalty sebesar 3% (<em>tiga persen</em>) dari hutang pokok tersisa.</p>\r\n', '2022-07-20 04:26:35', 'Admin', '2022-07-20 04:29:16', 'Admin'),
(11, 11, 'PERUBAHAN SUKU BUNGA', '<p style=\"text-align: justify;\">KOPERASI berhak sewaktu-waktu, mengubah tingkat suku bunga pinjaman tanpa persetujuan dan pemberitahuan terlebih dahulu dari PEMINJAM, Dalam hal terjadi perubahan tingkat suku bunga pinjaman, maka perubahan tersebut akan diberlakukan secara otomatis, dan PEMINJAM dengan ini menyetujui perubahan tingkat suku bunga yang ditetapkan oleh KOPERASI.</p>\r\n', '2022-07-20 04:26:55', 'Admin', '2022-07-20 04:28:55', 'Admin'),
(12, 12, 'PENYIMPANAN BUKTI KEPEMILIKAN JAMINAN', '<p style=\"text-align: justify;\">Semua surat-surat dan bukti-bukti kepemilikan Barang Jaminan yang tersebut dalam Pasal 5 wajib diserahkan oleh PEMINJAM kepada KOPERASI untuk disimpan oleh KOPERASI. Setiap perubahan atau penggantian Barang Jaminan tersebut diatas serta perubahan atau perpanjangan Perjanjian ini dapat dilakukan berdasarkan kesepakatan tertulis antara PEMINJAM dengan KOPERASI.</p>\r\n', '2022-07-20 04:27:17', 'Admin', '2022-07-20 04:27:56', 'Admin'),
(13, 13, 'EKSEKUSI JAMINAN', '<p style=\"text-align: justify;\">Bilamana PEMINJAM lalai melakukan kewajibannya sesuai dengan Perjanjian ini, maka KOPERASI berhak tanpa perantara Pengadilan dan dengan mengesampingkan ketentuan-ketentuan yang termaktub dalam pasal 1266 dan 1267 Kitab Undang-undang Hukum Perdata, untuk langsung mengeksekusi Barang Jaminan tersebut baik dimuka umum maupun dibawah tangan, dengan harga yang dipandang cukup untuk pelunasan hutang PEMINJAM. Berkaitan dengan hal tersebut, PEMINJAM dengan ini memberi kuasa mutlak dengan hak subtitusi penuh kepada KOPERASI untuk menjual Barang Jaminan tersebut. Setelah penjualan dilaksanakan, hasil penjualan digunakan untuk melunasi seluruh hutang PEMINJAM berikut bunga, provisi, denda-denda dan biaya-biaya lainnya, dengan ketentuan jika masih ada kelebihan KOPERASI akan menyerahkan sisa uang tersebut kepada PEMINJAM, sedangkan jika hasil penjualan tersebut tidak mencukupi untuk pelunasan hutang PEMINJAM, maka PEMINJAM berkewajiban untuk melunasi seluruh hutangnya sampai selesai.</p>\r\n', '2022-07-20 04:27:38', 'Admin', '0000-00-00 00:00:00', ''),
(14, 14, 'BIAYA - BIAYA', '<p style=\"text-align: justify;\">Semua biaya yang bersangkutan dengan Perjanjian ini baik sekarang atau dikemudian hari, termasuk tetapi tidak terbatas pada, biaya-biaya materai, biaya-biaya akta notaris, biaya pengacara, biaya pengadilan, biaya penagihan, biaya-biaya komisi kepada pihak ketiga yang menyangkut realisasi penggunaan dan penjualan Barang Jaminan, dan biaya-biaya lainya yang menyangkut Barang Jaminan tersebut, menjadi beban PEMINJAM. Biaya-biaya tersebut akan merupakan hutang PEMINJAM yang harus dibayar seketika dan sekaligus saat ditagih oleh KOPERASI. Apabila KOPERASI telah membayarkan lebih dahulu biaya-biaya tersebut, maka PEMINJAM dengan ini, mengakui bahwa jumlah yang telah dibayarkan lebih dahulu itu, seluruhnya menjadi beban PEMINJAM, dan merupakan hutang PEMINJAM yang harus dibayar seluruhnya seketika dan sekaligus saat ditagih oleh KOPERASI</p>\r\n', '2022-07-20 04:35:21', 'Admin', '0000-00-00 00:00:00', ''),
(15, 15, 'ASURANSI', '<p style=\"text-align: justify;\">KOPERASI berhak mengasuransikan untuk dan atas namanya sendiri Barang Jaminan, baik yang telah ada maupun akan diserahkan oleh PEMINJAM kepada KOPERASI berdasarkan Perjanjian ini, maupun yang akan dibuat beserta setiap perubahan, penambahan atau perpanjangan dikemudian hari, terhadap resiko kebakaran atau resiko-resiko lainnya yang dianggap perlu oleh KOPERASI. Semua biaya-biaya asuransi tersebut menjadi beban PEMINJAM dan harus dibayar seketika dan sekaligus saat ditagih oleh KOPERASI</p>\r\n', '2022-07-20 04:35:56', 'Admin', '0000-00-00 00:00:00', ''),
(16, 16, 'PENUTUP', '<ol>\r\n	<li style=\"text-align: justify;\">Kuasa-kuasa yang diberikan oleh PEMINJAM kepada KOPERASI di dalam atau berdasarkan Perjanjian ini merupakan bagian yang tidak terpisahkan dari perjanjian ini dan dengan demikian kuasa-kuasa tersebut tidak dapat dicabut atau berakhir karena sebab-sebab yang termaktub dalam pasal 1813 Kitab Undang-undang Hukum Perdata.</li>\r\n	<li style=\"text-align: justify;\">PEMINJAM menyatakan dengan ini menanggung semua akibat dari semua Perjanjian ini dan perjanjian-perjanjian lainnya yang bersangkutan yang telah atau akan dibuat dikemudian hari dan PEMINJAM menyatakan tunduk terhadap peraturan-peraturan dari KOPERASI, baik yang telah ada atau dibuat dikemudian serta perubahan-perubahannya, walaupun tidak disebutkan dalam Perjanjian ini secara tersendiri</li>\r\n	<li style=\"text-align: justify;\">Apabila satu atau lebih dari ketentuan dalam Perjanjian ini tidak dapat berlaku dan atau bertentangan dengan Peraturan dan Perundang-undang yang ada, maka keabsahan dan kekuatan ketentuan-ketentuan lainnya dalam Perjanjian ini tidak akan terkena atau dikurangi dan dapat berlaku sesuai dengan Undang-undang yang ada.</li>\r\n	<li style=\"text-align: justify;\">Hal-hal yang belum cukup diatur dalam Perjanjian ini akan di selesaikan secara musyawarah dan mufakat atas persetujuan PARA PIHAK. Penyerahan kembali Barang Jaminan yang dinyatakan di dalam Perjanjian ini dilakukan setelah PEMINJAM melunasi seluruh hutangnya kepada KOPERASI, dan harus dilakukan dengan penandatanganan Berita Acara Penyerahan Barang Jaminan atau dengan surat kuasa bermeterai cukup.</li>\r\n	<li style=\"text-align: justify;\">Mengenai segala urusan dari Perjanjian ini dan segala akibat serta pelaksanaannya, PARA PIHAK memilih domisili hukum yang tetap di Kantor Panitera Pengadilan Negeri Kelas I Jakarta.</li>\r\n	<li style=\"text-align: justify;\">Perjanjian ini mulai berlaku dan mengikat sejak tanggal ditandatanganinya oleh PARA PIHAK dan berakhir sampai seluruh fasilitas pinjaman&nbsp; dan atau semua jumlah hutang termasuk pokok pinjaman, bunga, denda dan biaya-biaya lain yang timbul berkaitan dengan pinjaman ini telah dibayar lunas oleh PEMINJAM.</li>\r\n</ol>\r\n', '2022-07-20 04:36:18', 'Admin', '0000-00-00 00:00:00', '');

-- --------------------------------------------------------

--
-- Table structure for table `mst_pengurus`
--

CREATE TABLE `mst_pengurus` (
  `id` int(11) NOT NULL,
  `pengurus` varchar(75) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mst_pengurus`
--

INSERT INTO `mst_pengurus` (`id`, `pengurus`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(2, 'Mariam', '2023-06-12 14:35:02', 'Admin', '0000-00-00 00:00:00', ''),
(3, 'Ika Aprilia', '2023-06-12 14:35:22', 'Admin', '2023-06-12 14:36:18', 'Admin'),
(4, 'Viona', '2023-06-12 14:35:30', 'Admin', '0000-00-00 00:00:00', ''),
(5, 'Njo Hendwi Wijaya', '2023-06-12 14:35:50', 'Admin', '0000-00-00 00:00:00', '');

-- --------------------------------------------------------

--
-- Table structure for table `mst_satuan`
--

CREATE TABLE `mst_satuan` (
  `id` int(11) NOT NULL,
  `satuan` varchar(10) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mst_satuan`
--

INSERT INTO `mst_satuan` (`id`, `satuan`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(1, 'Pcs', '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(2, 'Bungkus', '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(3, 'Unit', '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(0, 'packs', '2023-06-06 03:18:32', 'Admin', '2023-06-06 03:18:54', 'Admin');

-- --------------------------------------------------------

--
-- Table structure for table `mst_satuan_copy`
--

CREATE TABLE `mst_satuan_copy` (
  `id` int(11) NOT NULL,
  `satuan` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mst_satuan_copy`
--

INSERT INTO `mst_satuan_copy` (`id`, `satuan`) VALUES
(1, 'Ton'),
(2, 'Karung'),
(3, 'Kg');

-- --------------------------------------------------------

--
-- Table structure for table `mst_status_member`
--

CREATE TABLE `mst_status_member` (
  `id` int(11) NOT NULL,
  `status_member` varchar(30) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mst_status_member`
--

INSERT INTO `mst_status_member` (`id`, `status_member`) VALUES
(1, 'LANGGANAN'),
(2, 'BARU');

-- --------------------------------------------------------

--
-- Table structure for table `mst_status_repair`
--

CREATE TABLE `mst_status_repair` (
  `id` int(11) NOT NULL,
  `status_repair` varchar(100) NOT NULL,
  `color` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mst_status_repair`
--

INSERT INTO `mst_status_repair` (`id`, `status_repair`, `color`) VALUES
(1, 'Order Baru', 'orange'),
(2, 'Kirim Estimasi Pekerjaan', 'yellow'),
(3, 'Dibatalkan Oleh Member', 'red'),
(4, 'Dibatalkan Oleh Admin', 'red'),
(5, 'Penawaran Disetujui', 'blue'),
(6, 'Pekerjaan Selesai', 'green'),
(7, 'Menunggu Pembayaran', 'pink'),
(8, 'Pembayaran Diterima', 'cyan');

-- --------------------------------------------------------

--
-- Table structure for table `mst_status_terima`
--

CREATE TABLE `mst_status_terima` (
  `id` int(11) NOT NULL,
  `status` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mst_status_terima`
--

INSERT INTO `mst_status_terima` (`id`, `status`) VALUES
(1, 'Diterima'),
(2, 'Belum Diterima');

-- --------------------------------------------------------

--
-- Table structure for table `mst_ukuran`
--

CREATE TABLE `mst_ukuran` (
  `id` int(11) NOT NULL,
  `ukuran` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mst_ukuran`
--

INSERT INTO `mst_ukuran` (`id`, `ukuran`) VALUES
(2, 'L'),
(3, 'M'),
(4, '12 x 14');

-- --------------------------------------------------------

--
-- Table structure for table `mst_user_kantor`
--

CREATE TABLE `mst_user_kantor` (
  `id` int(11) NOT NULL,
  `id_kantor` int(11) NOT NULL,
  `id_user` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mst_user_kantor`
--

INSERT INTO `mst_user_kantor` (`id`, `id_kantor`, `id_user`) VALUES
(9, 1, 1),
(10, 1, 2),
(11, 2, 2);

-- --------------------------------------------------------

--
-- Table structure for table `mst_vendor`
--

CREATE TABLE `mst_vendor` (
  `id` int(11) NOT NULL,
  `nama_vendor` varchar(50) NOT NULL,
  `alamat_vendor` varchar(150) NOT NULL,
  `email_vendor` varchar(75) NOT NULL,
  `no_rek_vendor` varchar(30) NOT NULL,
  `nama_rekening` varchar(75) NOT NULL,
  `hp_vendor` varchar(30) NOT NULL,
  `jenis_produk` varchar(75) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mst_vendor`
--

INSERT INTO `mst_vendor` (`id`, `nama_vendor`, `alamat_vendor`, `email_vendor`, `no_rek_vendor`, `nama_rekening`, `hp_vendor`, `jenis_produk`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(1, 'PT. Maju Sejahtera', 'Sangiang', 'maju79@gmail.com', '0071531570', 'Meliyana', '08221255225', 'Perlengkapan Komputer', '2023-05-19 04:33:18', 'Admin', '2023-05-24 05:32:24', 'Admin'),
(2, 'Canva', '-', '-', '0071531570', 'PT. Canva', '-', '-', '2023-05-27 17:11:30', 'Admin', '0000-00-00 00:00:00', ''),
(3, 'PT. MARIAM SEJAHTERA SUKSES', 'Jl. Puri Kembangan Elok', 'mmsuksesmakmur@gmail.com', '1234567567', 'MARIAM SEJAHTERA SUKSES', '01231122', 'Alat Tulis', '2023-05-29 07:44:11', 'Admin', '0000-00-00 00:00:00', ''),
(4, 'pt sejahtera makmur', 'jl suka maju jaya no.08', 'makmur23@gmail.com', '2345719474 - BCA', 'pt sejahtera makmur', '02198764578', 'kursi dan meja', '2023-06-06 03:04:27', 'Admin', '2023-06-19 08:46:46', 'Admin');

-- --------------------------------------------------------

--
-- Table structure for table `mst_warna`
--

CREATE TABLE `mst_warna` (
  `id` int(11) NOT NULL,
  `warna` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mst_warna`
--

INSERT INTO `mst_warna` (`id`, `warna`) VALUES
(1, 'Merah'),
(2, 'Hitam'),
(3, 'MAROON'),
(4, 'Cream');

-- --------------------------------------------------------

--
-- Table structure for table `ms_city`
--

CREATE TABLE `ms_city` (
  `ID` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `id_province` int(11) NOT NULL,
  `publish` tinyint(4) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `ms_city`
--

INSERT INTO `ms_city` (`ID`, `name`, `id_province`, `publish`) VALUES
(1, 'Kab. Bengkayang', 1, 1),
(2, 'Kab. Kapuas Hulu', 1, 1),
(3, 'Kab. Kayong Utara', 1, 1),
(4, 'Kab. Ketapang', 1, 1),
(5, 'Kab. Landak', 1, 1),
(6, 'Kab. Melawi', 1, 1),
(7, 'Kab. Pontianak', 1, 1),
(8, 'Kab. Sambas', 1, 1),
(9, 'Kab. Sanggau', 1, 1),
(10, 'Kab. Sekadau', 1, 1),
(11, 'Kab. Sintang', 1, 1),
(12, 'Kota Pontianak', 1, 1),
(13, 'Kota Singkawang', 1, 1),
(14, 'Kab. Balangan', 2, 1),
(15, 'Kab. Banjar', 2, 1),
(16, 'Kab. Barito Kuala', 2, 1),
(17, 'Kab. Hulu Sungai Selatan', 2, 1),
(18, 'Kab. Hulu Sungai Tengah', 2, 1),
(19, 'Kab. Hulu Sungai Utara', 2, 1),
(20, 'Kab. Kotabaru', 2, 1),
(21, 'Kab. Tabalong', 2, 1),
(22, 'Kab. Tanah Bumbu', 2, 1),
(23, 'Kab. Tanah Laut', 2, 1),
(24, 'Kab. Tapin', 2, 1),
(25, 'Kota Banjarbaru', 2, 1),
(26, 'Kota Banjarmasin', 2, 1),
(27, 'Kab. Barito Selatan', 3, 1),
(28, 'Kab. Barito Timur', 3, 1),
(29, 'Kab. Barito Utara', 3, 1),
(30, 'Kab. Gunung Mas', 3, 1),
(31, 'Kab. Kapuas', 3, 1),
(32, 'Kab. Katingan', 3, 1),
(33, 'Kab. Kotawaringin Barat', 3, 1),
(34, 'Kab. Kotawaringin Timur', 3, 1),
(35, 'Kab. Lamandau', 3, 1),
(36, 'Kab. Murung Raya', 3, 1),
(37, 'Kab. Pulang Pisau', 3, 1),
(38, 'Kab. Seruyan', 3, 1),
(39, 'Kab. Sukamara', 3, 1),
(40, 'Kota Palangkaraya', 3, 1),
(41, 'Kab. Kutai Barat', 4, 1),
(42, 'Kab. Kutai Kartanegara', 4, 1),
(43, 'Kab. Pasir', 4, 1),
(44, 'Kab. Penajam Paser Utara', 4, 1),
(45, 'Kota Balikpapan', 4, 1),
(46, 'Kota Samarinda', 4, 1),
(47, 'Kab. Belitung', 5, 1),
(48, 'Kab. Belitung Timur', 5, 1),
(49, 'Kab. Natuna', 6, 1),
(50, 'Kab. Kepulauan Anamabas', 6, 1),
(51, 'Kab. Marauke', 7, 1),
(52, 'Kab. Kutai Timur', 4, 1),
(53, 'Kab. Mahakam Ulu', 4, 1),
(54, 'Kab. Nunukan', 8, 1),
(55, 'Kab. Tana Tidung', 8, 1),
(56, 'Kab. Bulungan', 8, 1),
(57, 'Kab. Bangka Tengah', 9, 1),
(58, 'Kota Pangkal Pinang', 9, 1),
(59, 'Kab. Bangka Selatan', 9, 1),
(60, 'Kab. Bintan', 10, 1),
(61, 'Kab. Karimun', 10, 1),
(62, 'Kota Batam', 10, 1),
(63, 'Kota Tanjung Pinang', 10, 1),
(64, 'Kab. Malinau', 11, 1),
(65, 'Kota Bontang', 12, 1),
(66, 'Kota Tarakan', 12, 1),
(67, 'Kab. Boven Digoel', 13, 1),
(68, 'Kab. Mappi', 13, 1),
(69, 'Kab. Bantaeng', 14, 1),
(70, 'Kab. Bone', 14, 1),
(71, 'Kab. Bulukumba', 14, 1),
(72, 'Kab. Gowa', 14, 1),
(73, 'Kab. Jeneponto', 14, 1),
(74, 'Kab. Maros', 14, 1),
(75, 'Kab. Sinjai', 14, 1),
(76, 'Kab. Takalar', 14, 1),
(77, 'Kota Makasar', 14, 1),
(78, 'Kab. Barru', 14, 1),
(79, 'Kab. Luwu', 14, 1),
(80, 'Kab. Berau', 12, 1),
(81, 'Kab. Bombana', 15, 1),
(82, 'Kab. Kolaka', 15, 1),
(83, 'Kab. Muna', 15, 1),
(84, 'Kota Bau Bau', 15, 1),
(85, 'Kab. Kolaka Timur', 15, 1),
(86, 'Kab. Bangka', 16, 1),
(87, 'Kab. Bangka Barat', 16, 1),
(88, 'Kab. Lingga', 17, 1),
(89, 'Kab. Batanghari', 18, 1),
(90, 'Kab. Muaro Jambi', 18, 1),
(91, 'Kab. Tanjung Jabung Barat', 18, 1),
(92, 'Kab. Tanjung Jabung Timur', 18, 1),
(93, 'Kota Jambi', 18, 1),
(94, 'Kab. Tebo', 18, 1),
(95, 'Kab. Asmat', 19, 1),
(96, 'Kab. Puncak Jaya', 19, 1),
(97, 'Kab. Paniae', 19, 1),
(98, 'Kab. Jayawijaya', 19, 1),
(99, 'Kab. Tolikara', 19, 1),
(100, 'Kab. Yahukimo', 19, 1),
(101, 'Kota Jayapura', 19, 1),
(102, 'Kab. Lanny Jaya', 19, 1),
(103, 'Kab. Membramo Tengah', 19, 1),
(104, 'Kab. Yalimo', 19, 1),
(105, 'Kab. Puncak', 19, 1),
(106, 'Kab. Intan Jaya', 19, 1),
(107, 'Kab. Bengkalis', 20, 1),
(108, 'Kab. Indragiri Hilir', 20, 1),
(109, 'Kab. Siak', 20, 1),
(110, 'Kota Dumai', 20, 1),
(111, 'Kab. Pangkajene Kepulauan', 21, 1),
(112, 'Kab. Enrekang', 21, 1),
(113, 'Kab. Luwu Utara', 21, 1),
(114, 'Kab. Pinrang', 21, 1),
(115, 'Kab. Soppeng', 21, 1),
(116, 'Kab. Wajo', 21, 1),
(117, 'Kota Palopo', 21, 1),
(118, 'Kota Pare Pare', 21, 1),
(119, 'Kab. Tanah Toraja', 21, 1),
(120, 'Kab. Toraja Utara', 21, 1),
(121, 'Kab. Ogan Komering Ilir', 22, 1),
(122, 'Kota Palembang', 22, 1),
(123, 'Kab. Cirebon', 23, 1),
(124, 'Kota Cirebon', 23, 1),
(125, 'Kab. Bekasi', 23, 1),
(126, 'Kab. Karawang', 23, 1),
(127, 'Kab. Kuningan', 23, 1),
(128, 'Kab. Majalengka', 23, 1),
(129, 'Kota Banjar', 23, 1),
(130, 'Kota Tasikmalaya', 23, 1),
(131, 'Kab. Banyumas', 24, 1),
(132, 'Kab. Batang', 24, 1),
(133, 'Kab. Blora', 24, 1),
(134, 'Kab. Boyolali', 24, 1),
(135, 'Kab. Brebes', 24, 1),
(136, 'Kab. Kendal', 24, 1),
(137, 'Kab. Pekalongan', 24, 1),
(138, 'Kab. Pemalang', 24, 1),
(139, 'Kab. Purbalingga', 24, 1),
(140, 'Kab. Semarang', 24, 1),
(141, 'Kab. Sragen', 24, 1),
(142, 'Kab. Temanggung', 24, 1),
(143, 'Kota Magelang', 24, 1),
(144, 'Kota Pekalongan', 24, 1),
(145, 'Kota Salatiga', 24, 1),
(146, 'Kota Semarang', 24, 1),
(147, 'Kota Tegal', 24, 1),
(148, 'Kab. Banjarnegara', 24, 1),
(149, 'Kab. Cilacap', 24, 1),
(150, 'Kab. Wonosobo', 24, 1),
(151, 'Kab. Bangkalan', 25, 1),
(152, 'Kab. Bojonegoro', 25, 1),
(153, 'Kab. Bondowoso', 25, 1),
(154, 'Kab. Gresik', 25, 1),
(155, 'Kab. Jombang', 25, 1),
(156, 'Kab. Lamongan', 25, 1),
(157, 'Kab. Madiun', 25, 1),
(158, 'Kab. Magetan', 25, 1),
(159, 'Kab. Mojokerto', 25, 1),
(160, 'Kab. Nganjuk', 25, 1),
(161, 'Kab. Ngawi', 25, 1),
(162, 'Kab. Pamekasan', 25, 1),
(163, 'Kab. Pasuruan', 25, 1),
(164, 'Kab. Sampang', 25, 1),
(165, 'Kab. Sidoarjo', 25, 1),
(166, 'Kab. Situbondo', 25, 1),
(167, 'Kab. Sumenep', 25, 1),
(168, 'Kab. Tuban', 25, 1),
(169, 'Kota Madiun', 25, 1),
(170, 'Kota Mojokerto', 25, 1),
(171, 'Kota Pasuruan', 25, 1),
(172, 'Kota Probolinggo', 25, 1),
(173, 'Kota Surabaya', 25, 1),
(174, 'Kab. Banyuwangi', 25, 1),
(175, 'Kab. Blitar', 25, 1),
(176, 'Kab. Kediri', 25, 1),
(177, 'Kab. Lumajang', 25, 1),
(178, 'Kab. Malang', 25, 1),
(179, 'Kab. Ponorogo', 25, 1),
(180, 'Kab. Tulungagung', 25, 1),
(181, 'Kota Batu', 25, 1),
(182, 'Kota Blitar', 25, 1),
(183, 'Kota Kediri', 25, 1),
(184, 'Kota Malang', 25, 1),
(185, 'Kab. Sorong Selatan', 26, 1),
(186, 'Kab. Raja Ampat', 26, 1),
(187, 'Kab. Teluk Bintuni', 26, 1),
(188, 'Kab. Teluk Wandoma', 26, 1),
(189, 'Kab. Bangli', 27, 1),
(190, 'Kab. Buleleng', 27, 1),
(191, 'Kab. Jembrana', 27, 1),
(192, 'Kab. Klungkung', 27, 1),
(193, 'Kab. Tabanan', 27, 1),
(194, 'Kab. Bima', 28, 1),
(195, 'Kab. Lombok Timur', 28, 1),
(196, 'Kab. Sumbawa', 28, 1),
(197, 'Kab. Sumbawa Barat', 28, 1),
(198, 'Kab. Dompu', 28, 1),
(199, 'Kab. Lombok Utara', 28, 1),
(200, 'Kab. Ende', 29, 1),
(201, 'Kab. Flores Timur', 29, 1),
(202, 'Kab. Manggarai', 29, 1),
(203, 'Kab. Manggarai Timur', 29, 1),
(204, 'Kab. Ngada', 29, 1),
(205, 'Kab. Sikka', 29, 1),
(206, 'Kab. Sumba Timur', 29, 1),
(207, 'Kab. Alor', 29, 1),
(208, 'Kab. Lembata', 29, 1),
(209, 'Kab. Nagekeo', 29, 1),
(210, 'Kab. Sumba Tengah', 29, 1),
(211, 'Kab. Timor Tengah Selatan', 29, 1),
(212, 'Kab. Timor Tengah Utara', 29, 1),
(213, 'Kab. Mamasa', 30, 1),
(214, 'Kab. Buton', 31, 1),
(215, 'Kab. Kolaka Utara', 31, 1),
(216, 'Kan. Konawe Selatan', 31, 1),
(217, 'Kab. Wakatobi', 31, 1),
(218, 'Kab. Buton Utara', 31, 1),
(219, 'Kab. Indragir Hulu', 32, 1),
(220, 'Kab. Pelalawan', 32, 1),
(221, 'Kab. Rokan Hilir', 32, 1),
(222, 'Kab. Kampar', 32, 1),
(223, 'Kab. Kuantan Singingi', 32, 1),
(224, 'Kab. Rokan Hulu', 32, 1),
(225, 'Kota Pekanbaru', 32, 1),
(226, 'Kab. Selayar', 33, 1),
(227, 'Kab. Luwu Timur', 33, 1),
(228, 'Kab. Sidenreng Rappang', 33, 1),
(229, 'Kab. Ogan Ilir', 34, 1),
(230, 'Kab. Banyuasin', 34, 1),
(231, 'Kab. Muaraenim', 34, 1),
(232, 'Kab. Musi Banyuasin', 34, 1),
(233, 'Kab. Ogan Komering Ulu', 34, 1),
(234, 'Kab. Ogan Koreming Ulu Ti', 34, 1),
(235, 'Kota Prabumulih', 34, 1),
(236, 'Kab. Musi Rawas', 34, 1),
(237, 'Kab. Penukal Abad Lematang', 34, 1),
(238, 'Kab. Musi Rawas Utara', 34, 1),
(239, 'Kab. Kepulauan Seribu', 35, 1),
(240, 'Kota Jakarta Barat', 35, 1),
(241, 'Kota Jakarta Pusat', 35, 1),
(242, 'Kota Jakarta Selatan', 35, 1),
(243, 'Kota Jakarta Timur', 35, 1),
(244, 'Kota Jakarta Utara', 35, 1),
(245, 'Kab. Bungo', 36, 1),
(246, 'Kab. Sarolangun', 36, 1),
(247, 'Kab. Merangin', 36, 1),
(248, 'Kab. Bandung', 37, 1),
(249, 'Kab. Bandung Barat', 37, 1),
(250, 'Kab. Bogor', 37, 1),
(251, 'Kab. Ciamis', 37, 1),
(252, 'Kab. Cianjur', 37, 1),
(253, 'Kab. Garut', 37, 1),
(254, 'Kab. Purwakarta', 37, 1),
(255, 'Kab. Sukabumi', 37, 1),
(256, 'Kab. Tasikmalaya', 37, 1),
(257, 'Kota Bekasi', 37, 1),
(258, 'Kota Bogor', 37, 1),
(259, 'Kota Depok', 37, 1),
(260, 'Kab. Kebumen', 38, 1),
(261, 'Kab. Magelang', 38, 1),
(262, 'Kab. Purworejo', 38, 1),
(263, 'Kab. Sukoharjo', 38, 1),
(264, 'Kab. Tegal', 38, 1),
(265, 'Kab. Wonogiri', 38, 1),
(266, 'Kab. Jember', 39, 1),
(267, 'Kab. Probolinggo', 39, 1),
(268, 'Kab. Pacitan', 39, 1),
(269, 'Kab. Trenggalek', 39, 1),
(270, 'Kab. Lampung Tengah', 40, 1),
(271, 'Kab. Lampung Timur', 40, 1),
(272, 'Kab. Lampung Utara', 40, 1),
(273, 'Kab. Tulang Bawang', 40, 1),
(274, 'Kab. Way Kanan', 40, 1),
(275, 'Kota Metro', 40, 1),
(276, 'Kab. Lampung Selatan', 40, 1),
(277, 'Kab. Pesawaran', 40, 1),
(278, 'Kota Bandar Lampung', 40, 1),
(279, 'Kab. Pringsewu', 40, 1),
(280, 'Kab. Tulang Bawang Barat', 40, 1),
(281, 'Kota Lhokseumawe', 41, 1),
(282, 'Kab. Aceh Tamiang', 41, 1),
(283, 'Kab. Bener Meriah', 41, 1),
(284, 'Kota Langsa', 41, 1),
(285, 'Kab. Fak Fak', 42, 1),
(286, 'Kab. Sorong', 42, 1),
(287, 'Kab. Manokwari', 42, 1),
(288, 'Kab. Manokwari Selatan', 42, 1),
(289, 'Kab. Pegunungan Arfak', 42, 1),
(290, 'Kab. Mayhrat', 42, 1),
(291, 'Kab. Mamuju Utara', 43, 1),
(292, 'Kab. Mamuju', 43, 1),
(293, 'Kab. Morowali', 44, 1),
(294, 'Kab. Banggai Kepulauan', 44, 1),
(295, 'Kab. Donggala', 44, 1),
(296, 'Kab. Tojo Una Una', 44, 1),
(297, 'Kab. Banggai', 44, 1),
(298, 'Kab. Parigi Moutong', 44, 1),
(299, 'Kab. Banggai Laut', 44, 1),
(300, 'Kab. Morowali Utara', 44, 1),
(301, 'Kab. Sigi', 44, 1),
(302, 'Kab. Konawe', 45, 1),
(303, 'Kab. Dharmasraya', 46, 1),
(304, 'Kota Payakumbuh', 46, 1),
(305, 'Kab. Sijunjung', 46, 1),
(306, 'Kab. Asahan', 47, 1),
(307, 'Kab. Batubara', 47, 1),
(308, 'Kab. Deli Serdang', 47, 1),
(309, 'Kab. Labuhan Batu', 47, 1),
(310, 'Kab. Serdang Bedagai', 47, 1),
(311, 'Kota Binjai', 47, 1),
(312, 'Kota Medan', 47, 1),
(313, 'Kota Tanjung Balai', 47, 1),
(314, 'Kota Tebing Tinggi', 47, 1),
(315, 'Kab. Angkola Sipirok', 47, 1),
(316, 'Kota Pematang Siantar', 47, 1),
(317, 'Kab. Labuhan Batu Selatan', 47, 1),
(318, 'Kab. Labuhan Batu Utara', 47, 1),
(319, 'Kab. Badung', 48, 1),
(320, 'Kab. Gianyar', 48, 1),
(321, 'Kota Denpasar', 48, 1),
(322, 'Kab. Karangasem', 48, 1),
(323, 'Kab. Lebak', 49, 1),
(324, 'Kab. Serang', 49, 1),
(325, 'Kab. Tangerang', 49, 1),
(326, 'Kota Cilegon', 49, 1),
(327, 'Kota Serang', 49, 1),
(328, 'Kota Tangerang Selatan', 49, 1),
(329, 'Kab. Gunung Kidul', 50, 1),
(330, 'Kab. Kulon Progo', 50, 1),
(331, 'Kab. Sleman', 50, 1),
(332, 'Kota Yogyakarta', 50, 1),
(333, 'Kab. Halmahera Tengah', 51, 1),
(334, 'Kab. Halmahera Timur', 51, 1),
(335, 'Kab. Halmahera Selatan', 51, 1),
(336, 'Kab. Kepulauan Sula', 51, 1),
(337, 'Kab. Lombok Tengah', 52, 1),
(338, 'Kota Bima', 52, 1),
(339, 'Kab. Lombok Barat', 52, 1),
(340, 'Kab. Kupang', 53, 1),
(341, 'Kab. Manggarai Barat', 53, 1),
(342, 'Kab. Rote Ndao', 53, 1),
(343, 'Kab. Belu', 53, 1),
(344, 'Kab. Sumba Barat', 53, 1),
(345, 'Kab. Sumba Barat Daya', 53, 1),
(346, 'Kab. Biak Numfor', 54, 1),
(347, 'Kab. Waropen', 54, 1),
(348, 'Kab. Keerom', 54, 1),
(349, 'Kab. Membramo Raya', 54, 1),
(350, 'Kab. Nduga', 54, 1),
(351, 'Kab. Dogiyagi', 54, 1),
(352, 'Kab. Deiyai', 54, 1),
(353, 'Kab. Bengkulu Selatan', 55, 1),
(354, 'Kab. Seluma', 55, 1),
(355, 'Kab. Maluku Barat Daya', 56, 1),
(356, 'Kab. Buru Selatan', 56, 1),
(357, 'Kab. Kepulauan Aru', 56, 1),
(358, 'Kab. Bolaang Mongondow', 57, 1),
(359, 'Kab. Bolaang Mongondow UT', 57, 1),
(360, 'Kab. Minahasa Selatan', 57, 1),
(361, 'Kota Kotamobagu', 57, 1),
(362, 'Kota Manado', 57, 1),
(363, 'Kab. Bolaang Mongodow Selatan', 57, 1),
(364, 'Kab. Bolaang Mongodow Timur', 57, 1),
(365, 'Kab. Sumedang', 58, 1),
(366, 'Kab. Subang', 58, 1),
(367, 'Kota Bandung', 58, 1),
(368, 'Kota Cimahi', 58, 1),
(369, 'Kota Sukabumi', 58, 1),
(370, 'Kab. Rembang', 59, 1),
(371, 'Kab. Klaten', 59, 1),
(372, 'Kab. Aceh Utara', 60, 1),
(373, 'Kab. Aceh Tengah', 60, 1),
(374, 'Kab. Aceh Timur', 60, 1),
(375, 'Kab. Bireuen', 60, 1),
(376, 'Kab. Aceh Barat', 60, 1),
(377, 'Kab. Aceh Barat Daya', 60, 1),
(378, 'Kab. Aceh Besar', 60, 1),
(379, 'Kab. Aceh Jaya', 60, 1),
(380, 'Kab. Aceh Selatan', 60, 1),
(381, 'Kab. Aceh Singkil', 60, 1),
(382, 'Kab. Aceh Tenggara', 60, 1),
(383, 'Kab. Gayo Lues', 60, 1),
(384, 'Kab. Naganraya', 60, 1),
(385, 'Kab. Pidie', 60, 1),
(386, 'Kab. Pidie Jaya', 60, 1),
(387, 'Kab. Dimeulue', 60, 1),
(388, 'Kota Banda Aceh', 60, 1),
(389, 'Kota Sabang', 60, 1),
(390, 'Kota Subulussalam', 60, 1),
(391, 'Kab. Mimika', 61, 1),
(392, 'Kab. Pegunungan Bintang', 61, 1),
(393, 'Kab. Supiori', 61, 1),
(394, 'Kab. Yapen Waropen', 61, 1),
(395, 'Kab. Jayapura', 61, 1),
(396, 'Kab. Nabire', 61, 1),
(397, 'Kab. Sarmi', 61, 1),
(398, 'Kab. Kaimana', 62, 1),
(399, 'Kota Sorong', 62, 1),
(400, 'Kab. Tambrau', 62, 1),
(401, 'Kab. Konawe Utara', 63, 1),
(402, 'Kota Kendari', 63, 1),
(403, 'Kab. Pasaman', 64, 1),
(404, 'Kab. Lima Puluh Kota', 64, 1),
(405, 'Kab. Pasaman Barat', 64, 1),
(406, 'Kab. Sawahlunto', 64, 1),
(407, 'Kab. Tanah Datar', 64, 1),
(408, 'Kota Sawahlunto', 64, 1),
(409, 'Kab. Agam', 64, 1),
(410, 'Kab. Kepulauan Mentawai', 64, 1),
(411, 'Kab. Padang Pariaman', 64, 1),
(412, 'Kab. Pesisir Selatan', 64, 1),
(413, 'Kab. Solok', 64, 1),
(414, 'Kab. Solok Selatan', 64, 1),
(415, 'Kota Bukittinggi', 64, 1),
(416, 'Kota Padang', 64, 1),
(417, 'Kota Padang Panjang', 64, 1),
(418, 'Kota Pariaman', 64, 1),
(419, 'Kota Solok', 64, 1),
(420, 'Kab. Lahat', 65, 1),
(421, 'Kab. Empat Lawang', 65, 1),
(422, 'Kab. Ogan Komering Ulu SE', 65, 1),
(423, 'Kota Lubuklinggau', 65, 1),
(424, 'Kota Pagar Alam', 65, 1),
(425, 'Kab. Langkat', 66, 1),
(426, 'Kab. Dairi', 66, 1),
(427, 'Kab. Karo', 66, 1),
(428, 'Kab. Mandialing Natal', 66, 1),
(429, 'Kab. Padang Lawas', 66, 1),
(430, 'Kab. Pakpak Brahat', 66, 1),
(431, 'Kab. Samosir', 66, 1),
(432, 'Kab. Simalungun', 66, 1),
(433, 'Kab. Tapanuli Selatan', 66, 1),
(434, 'Kab. Toba Samosir', 66, 1),
(435, 'Kota Padang Sidempuan', 66, 1),
(436, 'Kab. Humbang Hasundutan', 66, 1),
(437, 'Kab. Nias', 66, 1),
(438, 'Kab. Nias Selatan', 66, 1),
(439, 'Kab. Tapanuli Tengah', 66, 1),
(440, 'Kab. Tapanuli Utara', 66, 1),
(441, 'Kota Sibolga', 66, 1),
(442, 'Kab. Padang Lawas Utara', 66, 1),
(443, 'Kab. Nias Utara', 66, 1),
(444, 'Kab. Nias Barat', 66, 1),
(445, 'Kab. Gunung Sitoli', 66, 1),
(446, 'Kab. Bantul', 67, 1),
(447, 'Kab. Maluku Tengah', 68, 1),
(448, 'Kab. Maluku Tenggara', 68, 1),
(449, 'Kab. Seram Bagian Barat', 68, 1),
(450, 'Kota Tual', 68, 1),
(451, 'Kab. Buru', 68, 1),
(452, 'Kab. Maluku Tenggara Barat', 68, 1),
(453, 'Kab. Seram Bagian Timur', 68, 1),
(454, 'Kota Ambon', 68, 1),
(455, 'Kota Kupang', 69, 1),
(456, 'Kab. Sabu Raijua', 69, 1),
(457, 'Kab. Majene', 70, 1),
(458, 'Kab. Polewali Mandar', 70, 1),
(459, 'Kab. Poso', 71, 1),
(460, 'Kota Palu', 71, 1),
(461, 'Kab. Buol', 71, 1),
(462, 'Kab. Toli Toli', 71, 1),
(463, 'Kab. Bengkulu Utara', 72, 1),
(464, 'Kab. Kaur', 72, 1),
(465, 'Kab. Kepahiang', 72, 1),
(466, 'Kab. Lebong', 72, 1),
(467, 'Kab. Mukomuko', 72, 1),
(468, 'Kab. Rejang Lebong', 72, 1),
(469, 'Kota Bengkulu', 72, 1),
(470, 'Kab. Bengkulu Tengah', 72, 1),
(471, 'Kab. Boalemo', 73, 1),
(472, 'Kab. Bone Bolango', 73, 1),
(473, 'Kab. Gorontalo', 73, 1),
(474, 'Kab. Gorontalo Utara', 73, 1),
(475, 'Kab. Pohuwato', 73, 1),
(476, 'Kota Gorontalo', 73, 1),
(477, 'Kab. Kerinci', 74, 1),
(478, 'Kab. Merangin', 74, 1),
(479, 'Kab. Sungai Penuh', 74, 1),
(480, 'Kab. Lampung Barat', 75, 1),
(481, 'Kab. Tanggamus', 75, 1),
(482, 'Kab. Pesisir Barat', 75, 1),
(483, 'Kab. Halmahera Barat', 76, 1),
(484, 'Kab. Halmahera Utara', 76, 1),
(485, 'Kota Ternate', 76, 1),
(486, 'Kota Tidore', 76, 1),
(487, 'Kab. Pulau Morotai', 76, 1),
(488, 'Kota Mataram', 77, 1),
(489, 'Kab. Kepulauan Sangihe', 78, 1),
(490, 'Kab. Kepulauan Sitaro', 78, 1),
(491, 'Kab. Kepulauan Talaud', 78, 1),
(492, 'Kab. Minahasa', 78, 1),
(493, 'Kab. Minahasa Tenggara', 78, 1),
(494, 'Kab. Minahasa Utara', 78, 1),
(495, 'Kota Bitung', 78, 1),
(496, 'Kota Tomohon', 78, 1);

-- --------------------------------------------------------

--
-- Table structure for table `ms_customer`
--

CREATE TABLE `ms_customer` (
  `ID` int(11) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `tlp` varchar(30) NOT NULL,
  `alamat` text NOT NULL,
  `id_provinsi` int(50) NOT NULL,
  `id_kab` int(11) NOT NULL,
  `id_kec` int(11) NOT NULL,
  `id_pos` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `ms_customer`
--

INSERT INTO `ms_customer` (`ID`, `nama`, `tlp`, `alamat`, `id_provinsi`, `id_kab`, `id_kec`, `id_pos`) VALUES
(7, 'ERIKA', '0987654321', 'JANUR INDAH', 31, 3172, 317206, 7),
(4, 'Joko', '0818123456', 'tes', 0, 0, 0, 4),
(5, 'Yessy', '08978998793', 'kelapa gading', 31, 3172, 317206, 5);

-- --------------------------------------------------------

--
-- Table structure for table `ms_menu`
--

CREATE TABLE `ms_menu` (
  `ID` int(11) NOT NULL,
  `parent_number` int(11) DEFAULT NULL,
  `menu_level` tinyint(4) NOT NULL,
  `sort` tinyint(4) NOT NULL,
  `name` char(50) CHARACTER SET latin1 NOT NULL,
  `component` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `controller` char(50) COLLATE latin1_general_ci NOT NULL,
  `type` char(2) COLLATE latin1_general_ci NOT NULL,
  `publish` tinyint(4) NOT NULL,
  `icon` varchar(250) COLLATE latin1_general_ci NOT NULL,
  `icon_aps` varchar(100) COLLATE latin1_general_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Dumping data for table `ms_menu`
--

INSERT INTO `ms_menu` (`ID`, `parent_number`, `menu_level`, `sort`, `name`, `component`, `controller`, `type`, `publish`, `icon`, `icon_aps`) VALUES
(1, 0, 1, 90, 'Setting', 'UtilityPage', '#', 'B', 1, 'icon-settings', 'md-settings'),
(2, 1, 2, 2, 'Menu', 'UtilityMenuPage', 'menu/index', 'B', 1, '', ''),
(3, 1, 2, 3, 'User', 'UtilityGroupPage', 'group/index', 'B', 1, '', ''),
(5, 1, 2, 5, 'Change Password', 'ChangePassword', 'group/change_password', 'B', 1, '', ''),
(8, 0, 1, 1, 'Dashboard', 'DashboardPage', 'dashboard/index', 'B', 1, 'icon-home', 'md-speedometer'),
(25, 0, 1, 9, 'Memo', 'TransactionPage', 'transaction', 'B', 0, 'fa fa-file-text-o', 'md-swap'),
(6, 0, 1, 8, 'Master Data', 'MasterPage', 'master', 'B', 0, 'fa fa-folder-open-o', 'md-archive'),
(20, 0, 1, 10, 'Finance', 'ReportPage', 'finance/account_reconcile', 'B', 0, 'fa fa-credit-card', 'md-card'),
(15, 1, 2, 6, 'Config', 'ConfigGlobal', 'master/config', 'B', 0, '', ''),
(42, 0, 1, 11, 'Report', 'LaporanPage', 'laporan', 'B', 0, 'fa fa-archive', 'md-archive'),
(79, 42, 2, 79, 'Laporan Persediaan', '', 'laporan/persediaan', 'B', 0, '', ''),
(117, 1, 2, 117, 'Kategori Barang', '', 'setting/kategori_barang', 'B', 0, '', ''),
(82, 42, 2, 82, 'Laporan Mutasi Barang', '', 'laporan/mutasi_barang', 'B', 0, '', ''),
(118, 1, 2, 118, 'Satuan', '', 'setting/satuan', 'B', 0, '', ''),
(127, 123, 2, 127, 'Daftar Memo Pengajuan', '', 'transaksi_pengajuan/daftar_memo_pengajuan', 'B', 1, '', ''),
(114, 6, 2, 114, 'Data Vendor', '', 'master_vendor/data_vendor', 'B', 1, '', ''),
(121, 1, 2, 121, 'Divisi', '', 'setting/divisi', 'B', 0, '', ''),
(122, 25, 2, 122, 'Memo Informasi', '', 'transaksi_pengajuan/memo_informasi', 'B', 1, '', ''),
(113, 6, 2, 113, 'Data Barang', '', 'master_barang/data_barang', 'B', 1, '', ''),
(115, 25, 2, 115, 'Memo Pengajuan', '', 'transaksi_pengajuan/memo_pengajuan', 'B', 1, '', ''),
(128, 1, 2, 127, 'Pengurus', '', 'setting/pengurus', 'B', 0, '', ''),
(123, 0, 1, 12, 'Barang Masuk', '', 'transaction', 'B', 0, 'fa fa-cart-plus', ''),
(124, 0, 1, 13, 'Barang Keluar', '', 'transaction', 'B', 0, 'fa fa-archive', ''),
(125, 124, 2, 126, 'Daftar Pengeluaran', '', 'transaksi_pengeluaran/daftar_pengeluaran', 'B', 1, '', ''),
(126, 124, 2, 125, 'Pengeluaran Barang', '', 'transaksi_pengeluaran/pengeluaran_barang', 'B', 1, '', ''),
(129, 0, 1, 5, 'Cuti', '', 'Cuti', 'B', 1, 'icon-calendar', ''),
(130, 0, 1, 6, 'Kegiatan Luar Kantor', '', 'Kunjungan', 'B', 1, 'icon-plane', ''),
(131, 129, 2, 127, 'Kebijakan Cuti', '', 'Cuti/kebijakan_cuti', 'B', 1, '', ''),
(132, 129, 2, 127, 'Cuti Tahunan', '', 'Cuti/cuti_tahunan', 'B', 1, '', ''),
(133, 0, 1, 7, 'Pendaftaran', '', 'Pendaftaran', 'B', 0, 'fa fa-calendar', ''),
(134, 0, 1, 3, 'Pengelola', '', 'Pengelola', 'B', 1, 'icon-users', ''),
(135, 134, 2, 3, 'Daftar Pengelola', '', 'Pengelola/daftar_pengelola', 'B', 1, '', ''),
(136, 130, 2, 127, 'Pengajuan Kunjungan', '', 'Kunjungan/pengajuan', 'B', 1, '', ''),
(137, 0, 1, 89, 'Order Baru', '', 'Order', 'B', 0, 'fa fa-calendar', ''),
(138, 137, 2, 127, 'Order', '', 'Order/pesanan_baru', 'B', 1, '', ''),
(139, 0, 1, 88, 'Jurnal', '', 'Jurnal', 'B', 0, 'fa fa-book', ''),
(140, 139, 2, 127, 'Jurnal Baru', '', 'Jurnal/jurnal_baru', 'B', 1, '', ''),
(141, 139, 2, 127, 'Daftar Jurnal', '', 'Jurnal/daftar_jurnal', 'B', 1, '', ''),
(142, 0, 1, 87, 'Pembelian', '', 'Pembelian', 'B', 0, 'fa fa-cart-plus', ''),
(143, 142, 2, 120, 'Purchase Order', '', 'Pembelian/purchase_order', 'B', 1, '', ''),
(144, 142, 2, 121, 'Terima Barang', '', 'Pembelian/daftar_po', 'B', 1, '', ''),
(145, 0, 1, 80, 'Persediaan', '', 'Persediaan', 'B', 0, 'fa fa-briefcase', ''),
(146, 145, 2, 127, 'Barang Persediaan', '', 'Persediaan/barang_persediaan', 'B', 1, '', ''),
(147, 0, 1, 81, 'Supplier', '', 'Supplier', 'B', 0, 'fa fa-building-o', ''),
(148, 147, 2, 127, 'Daftar Supplier', '', 'Supplier/daftar_supplier', 'B', 1, '', ''),
(149, 142, 2, 122, 'Terima Invoice', '', 'Pembelian/daftar_terima', 'B', 1, '', ''),
(150, 129, 2, 127, 'Permohonan Cuti', '', 'Cuti/permohonan_cuti', 'B', 1, '', ''),
(151, 129, 2, 127, 'Daftar Permohonan', '', 'Cuti/daftar_permohonan', 'B', 1, '', ''),
(152, 129, 2, 127, 'Permohonan Ijin', '', 'Cuti/permohonan_ijin', 'B', 1, '', ''),
(153, 129, 2, 127, 'Informasi Sakit', '', 'Cuti/informasi_sakit', 'B', 1, '', ''),
(154, 129, 2, 127, 'Upload Surat Sakit', '', 'Cuti/surat_sakit', 'B', 1, '', ''),
(155, 129, 2, 127, 'Riwayat Permohonan', '', 'Cuti/riwayat_permohonan', 'B', 1, '', ''),
(156, 130, 2, 127, 'Daftar Kunjungan', '', 'Kunjungan/daftar_kunjungan', 'B', 1, '', ''),
(157, 130, 2, 127, 'Riwayat Kunjungan', '', 'Kunjungan/riwayat_kunjungan', 'B', 1, '', ''),
(158, 0, 1, 89, 'Lembur', '', 'Lembur', 'B', 1, 'icon-calendar', ''),
(159, 158, 2, 127, 'Pengajuan Lembur', '', 'Lembur/pengajuan_lembur', 'B', 1, '', ''),
(160, 134, 2, 127, 'Struktur Jabatan', '', 'Pengelola/struktur_jabatan', 'B', 0, '', ''),
(161, 158, 2, 127, 'Daftar Pengajuan', '', 'Lembur/daftar_pengajuan', 'B', 1, '', ''),
(162, 0, 1, 2, 'Kehadiran', '', 'Absensi', 'B', 1, 'icon-briefcase', ''),
(163, 162, 2, 127, 'Mesin Presensi', '', 'Absensi/mesin_presensi', 'B', 1, '', '');

-- --------------------------------------------------------

--
-- Table structure for table `ms_province`
--

CREATE TABLE `ms_province` (
  `ID` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `publish` tinyint(4) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `ms_province`
--

INSERT INTO `ms_province` (`ID`, `name`, `publish`) VALUES
(1, 'Kalimantan Barat', 1),
(2, 'Kalimantan Selatan', 1),
(3, 'Kalimantan Tengah', 1),
(4, 'Kalimantan Timur', 1),
(5, 'Kepulauan Bangka Belitung', 1),
(6, 'Kepulauan Riau', 1),
(7, 'Papua', 1),
(8, 'Kalimantan Utara', 1),
(14, 'Sulawesi Selatan', 1),
(15, 'Sulawesi Tenggara', 1),
(18, 'Jambi', 1),
(20, 'Riau', 1),
(22, 'Sumatra Selatan', 1),
(23, 'Jawa Barat', 1),
(24, 'Jawa Tengah', 1),
(25, 'Jawa Timur', 1),
(27, 'Bali', 1),
(28, 'Nusa Tenggara Barat', 1),
(29, 'Nusa Tenggara Timur', 1),
(30, 'Sulawesi Barat', 1),
(35, 'Daerah Khusus Ibukota Jakarta', 1),
(40, 'Lampung', 1),
(44, 'Sulawesi Tengah', 1),
(46, 'Sumatra Barat', 1),
(47, 'Sumatra Utara', 1),
(49, 'Banten', 1),
(50, 'Daerah Istimewa Yogyakarta', 1),
(51, 'Maluku Utara', 1),
(55, 'Bengkulu', 1),
(56, 'Maluku', 1),
(57, 'Sulawesi Utara', 1),
(60, 'Nanggroe Aceh Darussalam', 1),
(62, 'Papua Barat', 1),
(73, 'Gorontalo', 1);

-- --------------------------------------------------------

--
-- Table structure for table `m_agama`
--

CREATE TABLE `m_agama` (
  `id` int(11) NOT NULL,
  `agama` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `m_agama`
--

INSERT INTO `m_agama` (`id`, `agama`) VALUES
(1, 'Islam'),
(2, 'Kristen'),
(3, 'Katolik'),
(4, 'Hindu'),
(5, 'Konghucu'),
(6, 'Buddha');

-- --------------------------------------------------------

--
-- Table structure for table `m_cuti_tahunan`
--

CREATE TABLE `m_cuti_tahunan` (
  `id` int(11) NOT NULL,
  `id_pengelola` int(11) NOT NULL,
  `tahun_cuti` varchar(4) NOT NULL,
  `cuti_tahun_ini` int(11) NOT NULL,
  `sisa_cuti_tahun_lalu` int(11) NOT NULL,
  `sisa_cuti_2_tahun_lalu` int(11) NOT NULL,
  `ijin` int(11) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `m_cuti_tahunan`
--

INSERT INTO `m_cuti_tahunan` (`id`, `id_pengelola`, `tahun_cuti`, `cuti_tahun_ini`, `sisa_cuti_tahun_lalu`, `sisa_cuti_2_tahun_lalu`, `ijin`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(2, 1, '2023', 12, 0, 0, 3, '2023-11-15 12:02:14', 'Admin', '0000-00-00 00:00:00', ''),
(3, 2, '2023', 12, 0, 0, 3, '2023-11-15 12:02:26', 'Admin', '0000-00-00 00:00:00', ''),
(4, 4, '2023', 12, 2, 1, 3, '2023-11-17 14:50:31', 'Admin', '0000-00-00 00:00:00', '');

-- --------------------------------------------------------

--
-- Table structure for table `m_detail_kebijakan_cuti`
--

CREATE TABLE `m_detail_kebijakan_cuti` (
  `id` int(11) NOT NULL,
  `id_header` int(11) NOT NULL,
  `tanggal` date NOT NULL,
  `keterangan` varchar(150) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `m_detail_kebijakan_cuti`
--

INSERT INTO `m_detail_kebijakan_cuti` (`id`, `id_header`, `tanggal`, `keterangan`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(1, 2, '2023-01-23', 'Cuti Bersama Tahun Baru Imlek', '2023-11-14 15:37:46', 'Admin', '0000-00-00 00:00:00', ''),
(2, 3, '2023-01-01', 'Tahun Baru 2023', '2023-11-17 15:09:02', 'Admin', '0000-00-00 00:00:00', ''),
(3, 2, '2023-08-18', 'Cuti Bersama Kemerdekaan RI', '2023-11-17 15:11:35', 'Admin', '0000-00-00 00:00:00', '');

-- --------------------------------------------------------

--
-- Table structure for table `m_divisi`
--

CREATE TABLE `m_divisi` (
  `id` int(11) NOT NULL,
  `divisi` varchar(50) NOT NULL,
  `is_active_tab` int(11) NOT NULL,
  `tab_id1` varchar(10) NOT NULL,
  `tab_id2` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `m_divisi`
--

INSERT INTO `m_divisi` (`id`, `divisi`, `is_active_tab`, `tab_id1`, `tab_id2`) VALUES
(1, 'PA - Mikro Kecil', 1, '#tab_1', 'tab_1'),
(2, 'PA - Menengah Besar', 0, '#tab_2', 'tab_2'),
(3, 'Penunjang Pelayanan Anggota', 0, '#tab_3', 'tab_3'),
(4, 'Penunjang Usaha', 0, '#tab_4', 'tab_4');

-- --------------------------------------------------------

--
-- Table structure for table `m_dokter`
--

CREATE TABLE `m_dokter` (
  `id` int(11) NOT NULL,
  `kode_dokter` varchar(10) NOT NULL,
  `inisial_dokter` varchar(5) NOT NULL,
  `nama_dokter` varchar(150) NOT NULL,
  `spesialis` int(11) NOT NULL,
  `jenis_kel` varchar(10) NOT NULL,
  `tempat_lahir` varchar(50) NOT NULL,
  `tanggal_lahir` date NOT NULL,
  `alamat` varchar(150) NOT NULL,
  `rt` varchar(3) NOT NULL,
  `rw` varchar(3) NOT NULL,
  `kelurahan` varchar(30) NOT NULL,
  `kecamatan` varchar(30) NOT NULL,
  `kota` varchar(30) NOT NULL,
  `agama` varchar(20) NOT NULL,
  `pendidikan` varchar(5) NOT NULL,
  `status_kerja` int(11) NOT NULL,
  `telepon` varchar(30) NOT NULL,
  `no_hp` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `notes` varchar(250) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `m_jabatan`
--

CREATE TABLE `m_jabatan` (
  `id` int(11) NOT NULL,
  `kode_struktur` varchar(10) NOT NULL,
  `nama_pengelola` varchar(75) NOT NULL,
  `jabatan` varchar(150) NOT NULL,
  `struktur_parent` int(11) NOT NULL,
  `struktur_level` int(11) NOT NULL,
  `struktur_path` varchar(254) NOT NULL,
  `is_header` int(11) NOT NULL,
  `status` varchar(15) NOT NULL,
  `is_kadiv` varchar(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `m_jabatan`
--

INSERT INTO `m_jabatan` (`id`, `kode_struktur`, `nama_pengelola`, `jabatan`, `struktur_parent`, `struktur_level`, `struktur_path`, `is_header`, `status`, `is_kadiv`) VALUES
(1, '01', 'Sidhi Agustiana Taniman', 'Kepala Divisi PA Mikro Kecil', 0, 0, '01', 1, 'Aktif', 'Ya'),
(2, '02', 'Ika', 'HRD', 1, 1, '01/02', 0, 'Aktif', 'Tidak'),
(3, '03', 'Yansen', 'IT', 1, 1, '01/03', 0, 'Aktif', 'Tidak');

-- --------------------------------------------------------

--
-- Table structure for table `m_jadwal`
--

CREATE TABLE `m_jadwal` (
  `id` int(11) NOT NULL,
  `hari` varchar(20) NOT NULL,
  `jam_masuk` varchar(5) NOT NULL,
  `jam_pulang` varchar(5) NOT NULL,
  `jam_istirahat_keluar` varchar(5) NOT NULL,
  `jam_istirahat_masuk` varchar(5) NOT NULL,
  `toleransi_telat` int(2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `m_jadwal`
--

INSERT INTO `m_jadwal` (`id`, `hari`, `jam_masuk`, `jam_pulang`, `jam_istirahat_keluar`, `jam_istirahat_masuk`, `toleransi_telat`) VALUES
(1, 'Senin', '08:00', '17:00', '12:00', '13:00', 5),
(2, 'Selasa', '08:00', '17:00', '12:00', '13:00', 5),
(3, 'Rabu', '08:00', '17:00', '12:00', '13:00', 5),
(4, 'Kamis', '08:00', '17:00', '12:00', '13:00', 5),
(5, 'Jumat', '08:00', '17:30', '11:30', '13:00', 5);

-- --------------------------------------------------------

--
-- Table structure for table `m_jenis_cuti`
--

CREATE TABLE `m_jenis_cuti` (
  `id` int(11) NOT NULL,
  `jenis_cuti` varchar(30) NOT NULL,
  `is_cuti_tahunan` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `m_jenis_cuti`
--

INSERT INTO `m_jenis_cuti` (`id`, `jenis_cuti`, `is_cuti_tahunan`) VALUES
(1, 'Sakit', 0),
(2, 'Ijin', 0),
(3, 'Cuti Tahunan', 0);

-- --------------------------------------------------------

--
-- Table structure for table `m_kebijakan_cuti`
--

CREATE TABLE `m_kebijakan_cuti` (
  `id` int(11) NOT NULL,
  `nama` varchar(150) NOT NULL,
  `tanggal_awal` date NOT NULL,
  `tanggal_akhir` date NOT NULL,
  `deskripsi` varchar(250) NOT NULL,
  `jumlah_cuti` int(11) NOT NULL,
  `is_cuti_tahunan` int(11) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `m_kebijakan_cuti`
--

INSERT INTO `m_kebijakan_cuti` (`id`, `nama`, `tanggal_awal`, `tanggal_akhir`, `deskripsi`, `jumlah_cuti`, `is_cuti_tahunan`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(2, 'Cuti Bersama 2023', '2023-01-01', '2023-12-31', 'Cuti Bersama Tahun 2023', 2, 1, '2023-11-14 14:54:57', 'Admin', '2023-11-17 15:11:35', 'Admin'),
(3, 'Libur Nasional 2023', '2023-01-01', '2023-12-31', '', 1, 0, '2023-11-14 15:52:52', 'Admin', '2023-11-17 15:09:02', 'Admin');

-- --------------------------------------------------------

--
-- Table structure for table `m_kelompok_menu`
--

CREATE TABLE `m_kelompok_menu` (
  `id` int(11) NOT NULL,
  `kelompok_menu` varchar(30) NOT NULL,
  `is_active_tab` int(11) NOT NULL,
  `tab_id1` varchar(10) NOT NULL,
  `tab_id2` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `m_kelompok_menu`
--

INSERT INTO `m_kelompok_menu` (`id`, `kelompok_menu`, `is_active_tab`, `tab_id1`, `tab_id2`) VALUES
(1, 'Makanan', 1, '#tab_1', 'tab_1'),
(2, 'Minuman', 0, '#tab_2', 'tab_2');

-- --------------------------------------------------------

--
-- Table structure for table `m_klinik`
--

CREATE TABLE `m_klinik` (
  `id` int(11) NOT NULL,
  `nama_klinik` varchar(150) NOT NULL,
  `alamat` varchar(250) NOT NULL,
  `telepon` varchar(20) NOT NULL,
  `email` varchar(50) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `m_klinik`
--

INSERT INTO `m_klinik` (`id`, `nama_klinik`, `alamat`, `telepon`, `email`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(1, 'Dharmawangsa 8 - Dharmawangsa Square', 'Dharmawangsa Square Lt. 2', '021 8', 'admin@dw8dentalcare.id', '2023-09-29 16:32:57', 'Admin', '2023-09-29 16:33:11', 'Admin'),
(2, 'Dharmawangsa 8 - RS Mitra Bintaro', 'RS Mitra Bintaro', '021', 'mitra@dw8dentalcare.id', '2023-09-29 16:35:33', 'Admin', '0000-00-00 00:00:00', ''),
(3, 'Dharmawangsa 8 - RS. Brawijaya', 'RS Brawijaya', '021', 'brawijaya@dw8dentalcare.id', '2023-09-29 16:36:03', 'Admin', '0000-00-00 00:00:00', '');

-- --------------------------------------------------------

--
-- Table structure for table `m_meja`
--

CREATE TABLE `m_meja` (
  `id` int(11) NOT NULL,
  `no_meja` varchar(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `m_meja`
--

INSERT INTO `m_meja` (`id`, `no_meja`) VALUES
(1, '01'),
(2, '02'),
(3, '03'),
(4, '04'),
(5, '05');

-- --------------------------------------------------------

--
-- Table structure for table `m_menu_resto`
--

CREATE TABLE `m_menu_resto` (
  `id` int(11) NOT NULL,
  `kode_menu` varchar(20) NOT NULL,
  `nama_menu` varchar(150) NOT NULL,
  `kelompok_menu` int(11) NOT NULL,
  `harga` decimal(10,0) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `m_menu_resto`
--

INSERT INTO `m_menu_resto` (`id`, `kode_menu`, `nama_menu`, `kelompok_menu`, `harga`) VALUES
(1, 'M.001', 'Nasi Goreng', 1, '18000'),
(2, 'M.002', 'Bihun Goreng Seafood', 1, '19000'),
(3, 'M.003', 'Juice Alpukat', 2, '15000'),
(4, 'M.004', 'Es Teh Manis', 2, '5000'),
(5, 'M.005', 'Kwetiaw Goreng Seafood', 1, '25000'),
(6, 'M.006', 'Toge Cah Ikan Asin', 1, '10000'),
(7, 'M.007', 'Ayam Mentega Lada Hitam', 1, '30000');

-- --------------------------------------------------------

--
-- Table structure for table `m_pasien`
--

CREATE TABLE `m_pasien` (
  `id` int(11) NOT NULL,
  `no_mr` varchar(15) NOT NULL,
  `nama` varchar(75) NOT NULL,
  `panggilan` varchar(30) NOT NULL,
  `jenis_kel` varchar(10) NOT NULL,
  `tgl_daftar` date NOT NULL,
  `dokter` int(11) NOT NULL,
  `tempat_lahir` varchar(30) NOT NULL,
  `tanggal_lahir` date NOT NULL,
  `alamat` varchar(150) NOT NULL,
  `rt` varchar(3) NOT NULL,
  `rw` varchar(3) NOT NULL,
  `kelurahan` varchar(30) NOT NULL,
  `kecamatan` varchar(30) NOT NULL,
  `kota` varchar(30) NOT NULL,
  `alamat_kantor` varchar(250) NOT NULL,
  `agama` varchar(10) NOT NULL,
  `pendidikan` varchar(10) NOT NULL,
  `pekerjaan` varchar(75) NOT NULL,
  `telepon` varchar(20) NOT NULL,
  `no_hp` varchar(20) NOT NULL,
  `email` varchar(30) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `m_pengelola`
--

CREATE TABLE `m_pengelola` (
  `id` int(11) NOT NULL,
  `id_pengelola` varchar(10) NOT NULL,
  `NIP` varchar(10) NOT NULL,
  `nama_lengkap` varchar(75) NOT NULL,
  `referentor` varchar(75) NOT NULL,
  `divisi` int(11) NOT NULL,
  `jabatan` varchar(50) NOT NULL,
  `tempat_lahir` varchar(50) NOT NULL,
  `tanggal_lahir` date NOT NULL,
  `jenis_kelamin` int(11) DEFAULT NULL,
  `golongan_darah` varchar(5) NOT NULL,
  `warga_negara` varchar(20) NOT NULL,
  `agama` int(11) NOT NULL,
  `alamat` varchar(250) DEFAULT NULL,
  `status_rumah` int(11) DEFAULT NULL,
  `no_tlp_rumah` varchar(30) DEFAULT NULL,
  `no_hp` varchar(30) DEFAULT NULL,
  `email` varchar(30) DEFAULT NULL,
  `no_ktp` varchar(30) DEFAULT NULL,
  `berlaku_ktp` date DEFAULT NULL,
  `no_jamsostek` varchar(30) DEFAULT NULL,
  `no_npwp` varchar(30) DEFAULT NULL,
  `jenis_sim` varchar(5) DEFAULT NULL,
  `kendaraan` varchar(20) DEFAULT NULL,
  `status_kendaraan` int(11) DEFAULT NULL,
  `foto_pengelola` varchar(150) NOT NULL,
  `qr_code` varchar(150) NOT NULL,
  `is_active` int(11) NOT NULL,
  `status_pengelola` int(11) DEFAULT NULL,
  `tgl_resign` date NOT NULL,
  `persetujuan_lembur` int(11) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `m_pengelola`
--

INSERT INTO `m_pengelola` (`id`, `id_pengelola`, `NIP`, `nama_lengkap`, `referentor`, `divisi`, `jabatan`, `tempat_lahir`, `tanggal_lahir`, `jenis_kelamin`, `golongan_darah`, `warga_negara`, `agama`, `alamat`, `status_rumah`, `no_tlp_rumah`, `no_hp`, `email`, `no_ktp`, `berlaku_ktp`, `no_jamsostek`, `no_npwp`, `jenis_sim`, `kendaraan`, `status_kendaraan`, `foto_pengelola`, `qr_code`, `is_active`, `status_pengelola`, `tgl_resign`, `persetujuan_lembur`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(5, 'KMW-0012', '000012', 'Ivana Miharja Kusumah', '', 2, 'Kepala Divisi PA Menengah Besar', 'Cianjur', '1986-03-23', 2, '', 'Indonesia', 6, NULL, NULL, NULL, '08113538603', 'ivana.miharja@koperasimaju.com', '3203016303860005', '0000-00-00', '', '26.111.062.1.406.000', '', '', NULL, '', 'KMW-0012.png', 1, 1, '0000-00-00', 0, '2023-12-11 07:19:59', 'Admin', '0000-00-00 00:00:00', ''),
(6, 'KMW-0013', '000013', 'Michael Gianna', '', 1, 'Wakil Kepala Divisi PA Mikro Kecil', 'Jakarta', '1985-12-07', 1, '', 'Indonesia', 6, NULL, NULL, NULL, '087781926385', 'indrapala@ymail.com', '3671070712850007', '0000-00-00', '', '46.101.557.0.402.000', '', '', NULL, '', 'KMW-0013.png', 1, 1, '0000-00-00', 0, '2023-12-11 07:37:11', 'Admin', '0000-00-00 00:00:00', ''),
(7, 'KMW-0016', '000016', 'Yuliana', '', 3, 'Bagian Admin Pinjaman', 'Tanjung Karang', '1974-04-08', 2, '', 'Indonesia', 6, NULL, NULL, NULL, '081389676766', 'yuliana_buddhis@yahoo.com', '1871094804740001', '0000-00-00', '', '54.481.105.2.324.000', '', '', NULL, '', 'KMW-0016.png', 1, 1, '0000-00-00', 0, '2023-12-11 07:25:06', 'Admin', '0000-00-00 00:00:00', ''),
(8, 'KMW-0018', '000018', 'Desy Natalia', '', 1, '', 'Tangerang', '1992-12-09', 2, '', 'Indonesia', 6, 'Jl. Imam Bonjol Gg. Eretan No. 30', NULL, '', '087774742188', 'desy_dkarvel@yahoo.co.id', '3671074912920006', '0000-00-00', '', '44.429.992.9.402.000', '', '', NULL, '', 'KMW-0018.png', 1, 1, '0000-00-00', 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(9, 'KMW-0019', '000019', 'Damayanti', '', 3, 'Kepala Divisi PPA', 'Pati', '1988-12-22', 2, '', 'Indonesia', 6, NULL, NULL, NULL, '085692421638', 'dhammay@yahoo.com', '3318086212880001', '0000-00-00', '', '26.672.327.9-507.000 ', '', '', NULL, '', 'KMW-0019.png', 1, 1, '0000-00-00', 0, '2023-12-11 07:23:11', 'Admin', '0000-00-00 00:00:00', ''),
(10, 'KMW-0020', '000020', 'Sidhi Agustiana Taniman', '', 1, '', 'Karawang', '1992-08-20', 1, '', 'Indonesia', 6, 'Warudoyong Utara', NULL, '', '081517748381', 'Dio_taniman@yahoo.com', '3215062008920001', '0000-00-00', '', '73.089.645.3.408.000', '', '', NULL, '', 'KMW-0020.png', 1, 1, '0000-00-00', 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(11, 'KMW-0023', '000023', 'Antonius Novandi', '', 3, 'Wakil Kepala Divisi PPA', 'Tangerang', '1997-01-27', 1, '', 'Indonesia', 2, NULL, NULL, NULL, '089696977339', 'antoniusnovandi18@yahoo.co.id', '3671072701970003', '0000-00-00', '', '85.117.157.9.402.000', '', '', NULL, '', 'KMW-0023.png', 1, 1, '0000-00-00', 0, '2023-12-11 07:21:50', 'Admin', '0000-00-00 00:00:00', ''),
(12, 'KMW-0024', '000024', 'Nadya Septyani Taniman', '', 4, 'Kepala Bagian Akuntansi dan Keuangan', 'Karawang', '1997-09-24', 2, '', 'Indonesia', 6, NULL, NULL, NULL, '081517748382', 'nadyaseptiani252@gmail.com', '3215066409970001', '0000-00-00', '', '81.625.928.7-408.000', '', '', NULL, '', 'KMW-0024.png', 1, 1, '0000-00-00', 0, '2023-12-11 07:25:39', 'Admin', '0000-00-00 00:00:00', ''),
(13, 'KMW-0025', '000025', 'Pipit Adi Utomo', '', 1, '', 'Jepara', '1992-06-01', 1, '', 'Indonesia', 6, 'Banjaran', NULL, '', '085727910228', 'adiyutomo@gmail.com', '3320070106920004', '0000-00-00', '', '85.030.147.4.516.000', '', '', NULL, '', 'KMW-0025.png', 1, 1, '0000-00-00', 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(14, 'KMW-0026', '000026', 'Willson Liukarya', '', 1, '', 'Tangerang', '1999-07-12', 1, '', 'Indonesia', 6, 'Jln. Villa Tomang Baru Blok K4/36', NULL, '', '089654781713', 'Liukarya@gmail.com', '3603121207000001', '0000-00-00', '', '91.327.884.2-418.000', '', '', NULL, '', 'KMW-0026.png', 1, 1, '0000-00-00', 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(15, 'KMW-0027', '000027', 'Krishna Adi Putra', '', 1, '', 'Jakarta', '2001-09-10', 1, '', 'Indonesia', 6, 'Jl. Jelambar Timur No.39', NULL, '', '08811949077', 'adiputrakrishna@gmail.com', '3173021009010003', '0000-00-00', '', '93.741.344.1-036.000', '', '', NULL, '', 'KMW-0027.png', 1, 1, '0000-00-00', 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(16, 'KMW-0030', '000030', 'Cesare Alvaro Sukarya', '', 1, '', 'Karawang', '2001-08-06', 1, '', 'Indonesia', 6, 'Kalijaya II', NULL, '', '085218013338', 'cesarealvarozzz@gmail.com', '3215060608010003', '0000-00-00', '', '92.925.356.5-408.000', '', '', NULL, '', 'KMW-0030.png', 1, 1, '0000-00-00', 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(17, 'KMW-0032', '000032', 'Bernadetta Vivian Agita', '', 4, 'Bagian Akuntansi dan Keuangan', 'Banjarbaru', '1997-08-19', 2, '', 'Indonesia', 3, NULL, NULL, NULL, '082124617592', 'vivianagita19@gmail.com', '3603125908970006', '0000-00-00', '', '53.022.779.2-418.000', '', '', NULL, '', 'KMW-0032.png', 1, 1, '0000-00-00', 0, '2023-12-11 07:22:09', 'Admin', '0000-00-00 00:00:00', ''),
(18, 'KMW-0033', '000033', 'Riswan Yotan', '', 1, '', 'Tangerang', '1999-12-15', 1, '', 'Indonesia', 6, 'Kp. Kresek No. 6', NULL, '', '088211444123', 'Riswanyo2@gmail.com', '3603141512990001', '0000-00-00', '', '86.806.161.5-418.000', '', '', NULL, '', 'KMW-0033.png', 1, 1, '0000-00-00', 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(19, 'KMW-0034', '000034', 'Siti Mariam', '', 1, '', 'Jakarta', '2002-09-16', 2, '', 'Indonesia', 1, 'Srengseng', NULL, '', '089654430887', 'mariamsiti509@gmail.com', '3173085609020005', '0000-00-00', '', '53.027.017.2-039.000', '', '', NULL, '', 'KMW-0034.png', 1, 1, '0000-00-00', 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(20, 'KMW-0035', '000035', 'Shienna Velinda', '', 1, '', 'Bandung', '1992-11-26', 2, '', 'Indonesia', 6, 'Jl. Sukanegla Gang Maja III No. 167 D', NULL, '', '089656861399', 'shiennav@gmail.com', '3273206611920001', '0000-00-00', '', '84.818.631.8-429.000', '', '', NULL, '', 'KMW-0035.png', 1, 1, '0000-00-00', 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(21, 'KMW-0036', '000036', 'Darmayana Putra', '', 1, '', 'Jakarta', '1997-12-29', 1, '', 'Indonesia', 6, 'Villa Grand Tomang Blok D5 No.09', NULL, '', '+62 812-8831-3605', 'darmayana.putra29@gmail.com', '3603122912970010', '0000-00-00', '', '65.283.912.7.418.000', '', '', NULL, '', 'KMW-0036.png', 1, 1, '0000-00-00', 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(22, 'KMW-0038', '000038', 'Ria Puspitasari', '', 1, '', 'Teluk Dalem', '1997-05-24', 2, '', 'Indonesia', 6, 'Dusun II Desa Teluk Dalem', NULL, '', '081311769534', 'riapuspita568@gmail.com', '1807166405970002', '0000-00-00', '', '65.268.619.7.321.000', '', '', NULL, '', 'KMW-0038.png', 1, 1, '0000-00-00', 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(23, 'KMW-0039', '000039', 'Juan Dwitama Putra', '', 1, '', 'Tangerang', '2004-06-01', 1, '', 'Indonesia', 6, 'Pondok Bahagia', NULL, '', '08811819199', 'juandwitama2004@gmail.com', '3603130106040004', '0000-00-00', '', '60.797.915.0.418.000', '', '', NULL, '', 'KMW-0039.png', 1, 1, '0000-00-00', 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(24, 'KMW-0040', '000040', 'Andri Gunawan', '', 2, 'Bagian PA Menengah Besar', 'Pangkal Pinang', '1997-10-22', 1, '', 'Indonesia', 5, NULL, NULL, NULL, '081369789776', 'andrigunawan@outlook.com', '1971010903970001', '0000-00-00', '', '61.743.019.4-034.000', '', '', NULL, '', 'KMW-0040.png', 1, 1, '0000-00-00', 0, '2023-12-11 07:21:34', 'Admin', '0000-00-00 00:00:00', ''),
(25, 'KMW-0041', '000041', 'Wilson Kohar', '', 1, '', 'Tangerang', '2003-04-17', 1, '', 'Indonesia', 6, 'Perum Permata Tangerang Blok FE No.22', NULL, '', '087777943183', 'wilsonkohar1743@gmail.com', '3603121704030004', '0000-00-00', '', '61.906.544.4-418.000', '', '', NULL, '', 'KMW-0041.png', 1, 1, '0000-00-00', 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(26, 'KMW-0042', '000042', 'Yosephine Hannie Wirya', '', 1, '', 'Padang', '1985-02-20', 2, '', 'Indonesia', 6, 'Apt. Puri Garden Unit 1602 ', NULL, '', '+62 812-6621-8799', 'hannie.wirya@gmail.com', '1371036002850002', '0000-00-00', '', '08.102.682.5-201.000', '', '', NULL, '', 'KMW-0042.png', 1, 1, '0000-00-00', 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(27, 'KMW-0043', '000043', 'Bernadetha Nainggolan', '', 1, '', 'Tapian Nauli', '1996-12-25', 2, '', 'Indonesia', 3, 'Perum Permata Tangerang Blok FE No.22', NULL, '', '0823-8487-2332', 'bernadetha.golan25@gmail.com', '1217066512960003', '0000-00-00', '', '76.007.263.7-435.000', '', '', NULL, '', 'KMW-0043.png', 1, 1, '0000-00-00', 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(28, 'KMW-0044', '000044', 'Ika Murni Kristin Lase', '', 1, '', 'Marafala Sibohou', '2001-01-11', 2, '', 'Indonesia', 2, 'Jl. Surya Lingk V ', NULL, '', '+62 822-7792-0972', 'ikamurny01@gmail.com', '1204035101010005', '0000-00-00', '', '40.590.954.0-086.000', '', '', NULL, '', 'KMW-0044.png', 1, 1, '0000-00-00', 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(29, 'KMW-0045', '000045', 'Yansent Christianto', '', 4, 'Bagian IT Support', 'Jakarta', '2000-12-25', 1, '', 'Indonesia', 5, NULL, NULL, NULL, '0821 2132 3388', 'yansent.christianto@gmail.com', '1901032512000001', '0000-00-00', '', '40.438.277.2-034.000', '', '', NULL, '', 'KMW-0045.png', 1, 1, '0000-00-00', 0, '2023-12-11 07:26:19', 'Admin', '0000-00-00 00:00:00', ''),
(30, 'KMW-0046', '000046', 'Seto Bodhi Karuna', '', 1, '', 'Jepara', '1998-07-07', 1, '', 'Indonesia', 6, 'Ds. Tanjung', NULL, '', '082190111690', 'setobodhikaruna@gmail.com', '3320070707980000', '0000-00-00', '', '39.264.365.6-418.000', '', '', NULL, '', 'KMW-0046.png', 1, 1, '0000-00-00', 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(31, 'KMW-0047', '000047', 'Vindi Handayani Gea', '', 1, '', 'Sibaibai', '2000-07-22', 2, '', 'Indonesia', 3, 'Dusun Sibaibai', NULL, '', '085359255181', 'vindygea@gmail.com', '1309094609990001', '0000-00-00', '', '40.712.571..5-205.000', '', '', NULL, '', 'KMW-0047.png', 1, 1, '0000-00-00', 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(32, 'KMW-0048', '000048', 'Michael Fiheely', '', 1, '', 'Tangerang', '2001-03-23', 1, '', 'Indonesia', 6, 'Perumahan duta indah residence, cluster alexandrite, blok ax 5 No.77', NULL, '', '081226277373', 'mfihelly@gmail.com', '3671092303010003', '0000-00-00', '', '95.132.720.4-404.000', '', '', NULL, '', 'KMW-0048.png', 1, 1, '0000-00-00', 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(33, 'KMW-0049', '000049', 'Ika Aprilia', '', 1, '', 'Wonosobo', '1993-04-29', 2, '', 'Indonesia', 6, 'Banjaran', NULL, '', '085877717600', 'apriliadevika@gmail.com', '3307096904930003', '0000-00-00', '', '81.091.452.3.533.000', '', '', NULL, '', 'KMW-0049.png', 1, 1, '0000-00-00', 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', ''),
(34, 'KMW-0050', '000050', 'Sinthia Veronica', '', 1, '', 'Tangerang', '1999-08-07', 2, '', 'Indonesia', 3, 'Villa Tomang Baru Blok L1 No27', NULL, '', '085158336279', 'veronicasinthia@gmail.com', '3603124708990005', '0000-00-00', '', '96.570.637.7-418.000', '', '', NULL, '', 'KMW-0050.png', 1, 1, '0000-00-00', 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', '');

-- --------------------------------------------------------

--
-- Table structure for table `m_periode_cuti`
--

CREATE TABLE `m_periode_cuti` (
  `id` int(11) NOT NULL,
  `periode_cuti` varchar(4) NOT NULL,
  `tanggal_awal` date NOT NULL,
  `tanggal_akhir` date NOT NULL,
  `is_aktif` int(11) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `m_periode_cuti`
--

INSERT INTO `m_periode_cuti` (`id`, `periode_cuti`, `tanggal_awal`, `tanggal_akhir`, `is_aktif`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(1, '2023', '2023-01-01', '2023-12-31', 1, '2023-11-17 20:47:30', 'admin', '2023-11-17 20:47:38', 'admin');

-- --------------------------------------------------------

--
-- Table structure for table `m_status_cuti`
--

CREATE TABLE `m_status_cuti` (
  `id` int(11) NOT NULL,
  `status_cuti` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `m_status_cuti`
--

INSERT INTO `m_status_cuti` (`id`, `status_cuti`) VALUES
(1, 'Disetujui'),
(2, 'Ditolak');

-- --------------------------------------------------------

--
-- Table structure for table `order_detail`
--

CREATE TABLE `order_detail` (
  `id` int(11) NOT NULL,
  `id_header` int(11) NOT NULL,
  `id_menu` int(11) NOT NULL,
  `jumlah` int(11) NOT NULL,
  `harga` decimal(10,0) NOT NULL,
  `total` decimal(10,0) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `order_detail`
--

INSERT INTO `order_detail` (`id`, `id_header`, `id_menu`, `jumlah`, `harga`, `total`, `create_at`, `create_by`) VALUES
(146, 35, 1, 1, '18000', '18000', '2023-10-05 11:34:46', 'Admin'),
(147, 35, 2, 1, '19000', '19000', '2023-10-05 11:34:48', 'Admin'),
(148, 35, 3, 1, '15000', '15000', '2023-10-05 11:34:50', 'Admin'),
(149, 35, 4, 2, '5000', '10000', '2023-10-05 11:34:51', 'Admin'),
(153, 35, 0, 1, '0', '0', '2023-10-05 11:58:18', 'Admin'),
(154, 35, 0, 1, '0', '0', '2023-10-05 11:58:35', 'Admin'),
(155, 35, 0, 1, '0', '0', '2023-10-05 11:58:55', 'Admin'),
(156, 36, 1, 2, '18000', '36000', '2023-10-05 11:59:20', 'Admin'),
(157, 36, 3, 1, '15000', '15000', '2023-10-05 11:59:31', 'Admin'),
(158, 36, 4, 1, '5000', '5000', '2023-10-05 11:59:32', 'Admin'),
(159, 36, 0, 1, '0', '0', '2023-10-05 11:59:45', 'Admin'),
(160, 37, 0, 1, '0', '0', '2023-10-05 11:59:54', 'Admin'),
(161, 37, 0, 1, '0', '0', '2023-10-05 11:59:56', 'Admin'),
(162, 37, 0, 1, '0', '0', '2023-10-05 11:59:57', 'Admin'),
(163, 37, 2, 5, '19000', '95000', '2023-10-05 12:00:18', 'Admin'),
(165, 36, 0, 1, '0', '0', '2023-10-05 12:18:26', 'Admin'),
(166, 36, 0, 1, '0', '0', '2023-10-05 12:21:43', 'Admin'),
(167, 36, 0, 1, '0', '0', '2023-10-05 12:22:06', 'Admin'),
(168, 36, 0, 1, '0', '0', '2023-10-05 12:22:46', 'Admin'),
(169, 36, 0, 1, '0', '0', '2023-10-05 12:23:49', 'Admin'),
(170, 36, 0, 1, '0', '0', '2023-10-05 12:25:45', 'Admin'),
(171, 36, 0, 1, '0', '0', '2023-10-05 12:26:34', 'Admin'),
(172, 36, 0, 1, '0', '0', '2023-10-05 12:28:02', 'Admin'),
(173, 36, 0, 1, '0', '0', '2023-10-05 12:28:23', 'Admin'),
(174, 36, 0, 1, '0', '0', '2023-10-05 12:28:52', 'Admin'),
(175, 36, 0, 1, '0', '0', '2023-10-05 17:02:08', 'Admin'),
(176, 36, 0, 1, '0', '0', '2023-10-05 17:17:46', 'Admin'),
(177, 36, 0, 1, '0', '0', '2023-10-05 17:24:32', 'Admin'),
(178, 36, 0, 1, '0', '0', '2023-10-05 17:30:06', 'Admin'),
(179, 36, 0, 1, '0', '0', '2023-10-05 17:40:31', 'Admin'),
(180, 36, 0, 1, '0', '0', '2023-10-05 17:47:13', 'Admin'),
(181, 36, 0, 1, '0', '0', '2023-10-05 18:00:51', 'Admin'),
(182, 36, 0, 1, '0', '0', '2023-10-05 18:36:12', 'Admin'),
(183, 36, 0, 1, '0', '0', '2023-10-05 18:39:16', 'Admin'),
(184, 36, 0, 1, '0', '0', '2023-10-05 18:41:12', 'Admin'),
(185, 36, 0, 1, '0', '0', '2023-10-05 18:45:04', 'Admin'),
(186, 36, 0, 1, '0', '0', '2023-10-05 18:57:48', 'Admin'),
(187, 36, 0, 1, '0', '0', '2023-10-05 19:06:40', 'Admin'),
(188, 36, 0, 1, '0', '0', '2023-10-05 19:09:22', 'Admin'),
(189, 36, 0, 1, '0', '0', '2023-10-05 19:09:36', 'Admin'),
(190, 36, 0, 1, '0', '0', '2023-10-05 19:12:16', 'Admin'),
(191, 36, 0, 1, '0', '0', '2023-10-05 19:12:51', 'Admin'),
(192, 40, 0, 1, '0', '0', '2023-10-06 16:46:32', 'Admin'),
(193, 40, 6, 1, '10000', '10000', '2023-10-06 16:46:34', 'Admin'),
(194, 40, 5, 1, '25000', '25000', '2023-10-06 16:46:36', 'Admin'),
(195, 40, 3, 1, '15000', '15000', '2023-10-06 16:46:40', 'Admin'),
(196, 40, 7, 1, '30000', '30000', '2023-10-06 16:47:18', 'Admin'),
(197, 40, 0, 1, '0', '0', '2023-10-06 16:47:23', 'Admin'),
(198, 41, 6, 1, '10000', '10000', '2023-10-09 12:31:20', 'Admin'),
(199, 41, 5, 1, '25000', '25000', '2023-10-09 12:31:21', 'Admin'),
(200, 41, 7, 2, '30000', '60000', '2023-10-09 12:31:22', 'Admin'),
(202, 41, 4, 3, '5000', '15000', '2023-10-09 12:31:38', 'Admin'),
(203, 42, 1, 1, '18000', '18000', '2023-10-23 13:43:11', 'Admin'),
(204, 42, 2, 2, '19000', '38000', '2023-10-23 13:43:12', 'Admin'),
(205, 42, 4, 5, '5000', '25000', '2023-10-23 13:43:34', 'Admin'),
(206, 44, 5, 1, '25000', '25000', '2023-11-11 03:08:19', 'Admin'),
(207, 45, 1, 1, '18000', '18000', '2023-11-19 17:40:25', 'Admin'),
(214, 45, 5, 1, '25000', '25000', '2023-11-19 17:41:09', 'Admin'),
(215, 45, 6, 1, '10000', '10000', '2023-11-19 17:41:12', 'Admin');

-- --------------------------------------------------------

--
-- Table structure for table `order_header`
--

CREATE TABLE `order_header` (
  `id` int(11) NOT NULL,
  `tgl_order` date NOT NULL,
  `no_meja` varchar(10) NOT NULL,
  `status` varchar(10) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `order_header`
--

INSERT INTO `order_header` (`id`, `tgl_order`, `no_meja`, `status`, `create_at`, `create_by`) VALUES
(35, '2023-10-05', '02', 'booked', '2023-10-05 11:34:43', 'Admin'),
(36, '2023-10-05', '04', 'booked', '2023-10-05 11:59:18', 'Admin'),
(37, '2023-10-05', '01', 'booked', '2023-10-05 11:59:52', 'Admin'),
(38, '2023-10-05', '03', 'paid', '2023-10-05 12:01:13', 'Admin'),
(39, '2023-10-05', '03', 'booked', '2023-10-05 12:01:57', 'Admin'),
(40, '2023-10-06', '02', 'booked', '2023-10-06 16:46:29', 'Admin'),
(41, '2023-10-09', '03', 'booked', '2023-10-09 12:31:15', 'Admin'),
(42, '2023-10-23', '01', 'booked', '2023-10-23 13:43:06', 'Admin'),
(43, '2023-11-08', '02', 'booked', '2023-11-08 08:59:55', 'Admin'),
(44, '2023-11-11', '02', 'booked', '2023-11-11 03:08:12', 'Admin'),
(45, '2023-11-19', '03', 'booked', '2023-11-19 17:40:23', 'Admin');

-- --------------------------------------------------------

--
-- Table structure for table `parameter_coa`
--

CREATE TABLE `parameter_coa` (
  `id` int(11) NOT NULL,
  `jenis` varchar(150) NOT NULL,
  `id_coa` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `parameter_coa`
--

INSERT INTO `parameter_coa` (`id`, `jenis`, `id_coa`) VALUES
(1, 'Hutang Terima Barang', 12),
(2, 'Piutang Kirim Barang', 38),
(3, 'Biaya Produksi', 79),
(4, 'HPP', 39);

-- --------------------------------------------------------

--
-- Table structure for table `purchase_order_detail`
--

CREATE TABLE `purchase_order_detail` (
  `id` int(11) NOT NULL,
  `id_header` int(11) NOT NULL,
  `id_barang` int(11) NOT NULL,
  `jumlah` int(11) NOT NULL,
  `harga` decimal(18,0) NOT NULL,
  `total` decimal(18,0) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(10) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `purchase_order_detail`
--

INSERT INTO `purchase_order_detail` (`id`, `id_header`, `id_barang`, `jumlah`, `harga`, `total`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(11, 19, 175, 150, '350000', '52500000', '2023-10-29 20:21:33', 'Admin', '0000-00-00 00:00:00', ''),
(12, 20, 175, 200, '300000', '60000000', '2023-10-29 20:21:58', 'Admin', '0000-00-00 00:00:00', ''),
(13, 21, 175, 70, '350000', '24500000', '2023-10-30 21:37:57', 'Admin', '0000-00-00 00:00:00', '');

-- --------------------------------------------------------

--
-- Table structure for table `purchase_order_header`
--

CREATE TABLE `purchase_order_header` (
  `id` int(11) NOT NULL,
  `id_supplier` int(11) NOT NULL,
  `tgl_po` date NOT NULL,
  `no_po_system` varchar(20) NOT NULL,
  `memo` varchar(75) NOT NULL,
  `status` varchar(20) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(10) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `purchase_order_header`
--

INSERT INTO `purchase_order_header` (`id`, `id_supplier`, `tgl_po`, `no_po_system`, `memo`, `status`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(19, 19, '2023-10-09', '231009.PO0001', 'PO 1', 'RECEIVED', '2023-10-29 20:21:23', 'Admin', '2023-10-29 20:22:56', 'Admin'),
(20, 19, '2023-10-18', '231018.PO0002', 'PO 2', 'RECEIVED', '2023-10-29 20:21:50', 'Admin', '2023-10-29 20:23:59', 'Admin'),
(21, 19, '2023-10-20', '231020.PO0003', 'PO 3', 'PURCHASE', '2023-10-30 21:37:44', 'Admin', '0000-00-00 00:00:00', '');

-- --------------------------------------------------------

--
-- Table structure for table `surat_ket_sakit`
--

CREATE TABLE `surat_ket_sakit` (
  `id` int(11) NOT NULL,
  `id_pengelola` int(11) NOT NULL,
  `id_permohonan_sakit` int(11) NOT NULL,
  `keterangan_file` varchar(150) NOT NULL,
  `nama_file` varchar(150) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `surat_ket_sakit`
--

INSERT INTO `surat_ket_sakit` (`id`, `id_pengelola`, `id_permohonan_sakit`, `keterangan_file`, `nama_file`, `create_at`, `create_by`) VALUES
(2, 4, 16, 'surat dokter', 'A__HANDOKO_T1.pdf', '2023-11-24 22:11:16', 'siddhi');

-- --------------------------------------------------------

--
-- Table structure for table `terima_inv_detail`
--

CREATE TABLE `terima_inv_detail` (
  `id` int(11) NOT NULL,
  `id_header` int(11) NOT NULL,
  `id_barang` int(11) NOT NULL,
  `jumlah` int(11) NOT NULL,
  `harga` decimal(10,0) NOT NULL,
  `total` decimal(10,0) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(10) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `terima_inv_detail`
--

INSERT INTO `terima_inv_detail` (`id`, `id_header`, `id_barang`, `jumlah`, `harga`, `total`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(19, 10, 175, 1000, '250000', '250000000', '2023-10-23 18:24:30', 'Admin', '2023-10-23 18:24:37', 'Admin'),
(20, 10, 175, 1500, '200000', '300000000', '2023-10-23 18:24:30', 'Admin', '2023-10-23 18:24:41', 'Admin'),
(22, 11, 175, 100, '270000', '27000000', '2023-10-23 18:25:49', 'Admin', '2023-10-23 21:56:16', 'Admin'),
(23, 12, 175, 1000, '300000', '300000000', '2023-10-23 18:31:23', 'Admin', '2023-10-23 18:31:33', 'Admin'),
(24, 13, 175, 200, '300000', '60000000', '2023-10-24 10:56:06', 'Admin', '2023-10-24 10:56:13', 'Admin');

-- --------------------------------------------------------

--
-- Table structure for table `terima_inv_header`
--

CREATE TABLE `terima_inv_header` (
  `id` int(11) NOT NULL,
  `id_sj` int(11) NOT NULL,
  `id_supplier` int(11) NOT NULL,
  `tgl_invoice` date NOT NULL,
  `no_inv_system` varchar(20) NOT NULL,
  `no_inv_supplier` varchar(20) NOT NULL,
  `memo` varchar(150) NOT NULL,
  `status` varchar(20) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(10) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `terima_inv_header`
--

INSERT INTO `terima_inv_header` (`id`, `id_sj`, `id_supplier`, `tgl_invoice`, `no_inv_system`, `no_inv_supplier`, `memo`, `status`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(10, 6, 19, '2023-10-22', '231022.IV0001', 'INV 01 ', 'tes invoice', 'JOURNAL', '2023-10-23 18:24:30', 'Admin', '0000-00-00 00:00:00', ''),
(11, 8, 19, '2023-10-20', '231020.IV0002', 'INV 02', 'tes invoice 2', 'JOURNAL', '2023-10-23 18:25:48', 'Admin', '0000-00-00 00:00:00', ''),
(12, 7, 19, '2023-10-23', '231023.IV0003', 'INV 03', 'tes invoice 3', 'JOURNAL', '2023-10-23 18:31:23', 'Admin', '0000-00-00 00:00:00', ''),
(13, 13, 19, '2023-10-21', '231021.IV0004', 'INV 03a', 'terima inv', 'JOURNAL', '2023-10-24 10:56:05', 'Admin', '0000-00-00 00:00:00', '');

-- --------------------------------------------------------

--
-- Table structure for table `terima_sj_detail`
--

CREATE TABLE `terima_sj_detail` (
  `id` int(11) NOT NULL,
  `id_header` int(11) NOT NULL,
  `id_barang` int(11) NOT NULL,
  `jumlah` int(11) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(10) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `terima_sj_detail`
--

INSERT INTO `terima_sj_detail` (`id`, `id_header`, `id_barang`, `jumlah`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(10, 20, 175, 150, '2023-10-29 20:22:56', 'Admin', '0000-00-00 00:00:00', ''),
(11, 21, 175, 200, '2023-10-29 20:23:59', 'Admin', '0000-00-00 00:00:00', '');

-- --------------------------------------------------------

--
-- Table structure for table `terima_sj_header`
--

CREATE TABLE `terima_sj_header` (
  `id` int(11) NOT NULL,
  `id_po` int(11) NOT NULL,
  `id_supplier` int(11) NOT NULL,
  `tgl_terima` date NOT NULL,
  `no_sj_system` varchar(20) NOT NULL,
  `no_sj_supplier` varchar(20) NOT NULL,
  `memo` varchar(75) NOT NULL,
  `status` varchar(20) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(10) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `terima_sj_header`
--

INSERT INTO `terima_sj_header` (`id`, `id_po`, `id_supplier`, `tgl_terima`, `no_sj_system`, `no_sj_supplier`, `memo`, `status`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(20, 19, 19, '2023-10-09', '231009.SJ0001', 'SJ.0001', 'tes', 'RECEIVED', '2023-10-29 20:22:56', 'Admin', '0000-00-00 00:00:00', ''),
(21, 20, 19, '2023-10-18', '231018.SJ0002', 'SJ.0002', '', 'RECEIVED', '2023-10-29 20:23:59', 'Admin', '0000-00-00 00:00:00', '');

-- --------------------------------------------------------

--
-- Table structure for table `trx_memo_informasi`
--

CREATE TABLE `trx_memo_informasi` (
  `id` int(11) NOT NULL,
  `id_pengajuan` int(11) NOT NULL,
  `tgl_memo` date NOT NULL,
  `kepada` int(11) NOT NULL,
  `dari` int(11) NOT NULL,
  `catatan` varchar(200) NOT NULL,
  `diajukan` int(11) NOT NULL,
  `diperiksa` int(11) NOT NULL,
  `disetujui1` int(11) NOT NULL,
  `disetujui2` int(11) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `trx_memo_informasi`
--

INSERT INTO `trx_memo_informasi` (`id`, `id_pengajuan`, `tgl_memo`, `kepada`, `dari`, `catatan`, `diajukan`, `diperiksa`, `disetujui1`, `disetujui2`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(1, 1, '2023-05-26', 4, 3, 'Pembelian printer dan tintanya', 0, 0, 0, 0, '0000-00-00 00:00:00', '', '2023-05-26 19:20:04', 'Admin'),
(2, 2, '0000-00-00', 0, 0, '', 0, 0, 0, 0, '2023-05-27 17:13:48', 'Admin', '0000-00-00 00:00:00', ''),
(3, 3, '0000-00-00', 0, 0, '', 0, 0, 0, 0, '2023-05-29 07:44:43', 'Admin', '0000-00-00 00:00:00', ''),
(4, 4, '0000-00-00', 0, 0, '', 0, 0, 0, 0, '2023-05-29 07:47:26', 'Admin', '0000-00-00 00:00:00', ''),
(5, 5, '2023-06-05', 4, 3, 'Pembelian AQUA BOTOL 600 ML', 0, 0, 0, 0, '2023-05-29 08:05:55', 'mariam', '2023-06-05 02:42:02', 'Admin'),
(6, 6, '0000-00-00', 0, 0, 'Pulpen Standard Hitam', 0, 0, 0, 0, '2023-05-29 08:07:09', 'mariam', '2023-06-05 02:40:40', 'Admin'),
(7, 7, '0000-00-00', 0, 0, '', 0, 0, 0, 0, '2023-05-29 08:09:06', 'mariam', '0000-00-00 00:00:00', ''),
(8, 8, '0000-00-00', 0, 0, '', 0, 0, 0, 0, '2023-05-31 01:37:24', 'Admin', '0000-00-00 00:00:00', ''),
(9, 9, '0000-00-00', 0, 0, '', 0, 0, 0, 0, '2023-05-31 10:19:57', 'Admin', '0000-00-00 00:00:00', ''),
(10, 10, '2023-06-05', 4, 3, 'Langganan Akun Canva Pro', 2, 3, 4, 5, '2023-06-05 09:59:27', 'Admin', '2023-06-12 15:13:58', 'Admin'),
(11, 11, '0000-00-00', 0, 0, '', 0, 0, 0, 0, '2023-06-05 10:05:09', 'Admin', '0000-00-00 00:00:00', ''),
(12, 12, '0000-00-00', 0, 0, 'Printer, Pulpen Standard Hitam', 0, 0, 0, 0, '2023-06-05 10:16:52', 'Admin', '2023-06-12 08:36:06', 'Admin'),
(13, 13, '0000-00-00', 0, 0, '', 0, 0, 0, 0, '2023-06-12 08:40:23', 'Admin', '0000-00-00 00:00:00', ''),
(14, 14, '2023-06-13', 4, 3, 'Pembelian Printer Epson', 3, 4, 5, 0, '2023-06-13 06:50:28', 'Admin', '2023-06-13 07:08:14', 'Admin'),
(15, 15, '2023-06-15', 4, 3, 'Pemblian 4 pcs Tinta untuk mariam, yensen, vivi, nadya', 2, 3, 4, 5, '2023-06-15 04:40:38', 'Admin', '2023-06-15 04:44:34', 'Admin'),
(16, 16, '0000-00-00', 0, 0, '', 0, 0, 0, 0, '2023-06-15 04:42:21', 'Admin', '0000-00-00 00:00:00', ''),
(17, 17, '2023-06-15', 4, 2, 'Modem Mobile wifi XL GO', 3, 4, 2, 0, '2023-06-15 04:55:01', 'Admin', '2023-07-14 06:33:35', 'Admin'),
(18, 18, '0000-00-00', 0, 0, '', 0, 0, 0, 0, '2023-06-15 06:08:12', 'Admin', '0000-00-00 00:00:00', ''),
(19, 19, '0000-00-00', 0, 0, '', 0, 0, 0, 0, '2023-06-15 06:12:11', 'Admin', '0000-00-00 00:00:00', '');

-- --------------------------------------------------------

--
-- Table structure for table `trx_pengajuan_detail`
--

CREATE TABLE `trx_pengajuan_detail` (
  `id` int(11) NOT NULL,
  `id_pengajuan` int(11) NOT NULL,
  `id_barang` int(11) NOT NULL,
  `jumlah` int(11) NOT NULL,
  `harga_satuan` decimal(18,0) NOT NULL,
  `total` decimal(18,0) NOT NULL,
  `pengguna` varchar(30) NOT NULL,
  `tgl_diterima` date NOT NULL,
  `jumlah_diterima` int(11) NOT NULL,
  `status_diterima` int(11) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `trx_pengajuan_detail`
--

INSERT INTO `trx_pengajuan_detail` (`id`, `id_pengajuan`, `id_barang`, `jumlah`, `harga_satuan`, `total`, `pengguna`, `tgl_diterima`, `jumlah_diterima`, `status_diterima`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(3, 1, 10, 2, '1300000', '2600000', 'ika', '2023-05-20', 2, 1, '2023-05-19 12:14:32', 'Admin', '2023-05-25 09:38:42', 'Admin'),
(4, 1, 11, 1, '500000', '500000', 'yansen', '2023-05-20', 1, 1, '2023-05-19 12:14:32', 'Admin', '2023-05-20 04:33:40', 'Admin'),
(5, 2, 12, 12, '75000', '900000', 'mariam', '2023-05-27', 12, 1, '2023-05-27 17:14:15', 'Admin', '2023-05-27 18:18:41', 'Admin'),
(6, 4, 16, 50, '1000', '50000', 'IT', '2023-05-30', 5, 1, '2023-05-29 07:48:03', 'Admin', '2023-05-29 08:10:25', 'mariam'),
(7, 5, 13, 5, '2000', '10000', 'bagian PPA Mikro Kecil', '0000-00-00', 0, 2, '2023-05-29 08:06:24', 'mariam', '2023-05-31 02:00:15', 'Admin'),
(8, 6, 16, 5, '2000', '10000', 'bagian PPA Mikro Kecil', '0000-00-00', 0, 0, '2023-05-29 08:07:30', 'mariam', '0000-00-00 00:00:00', ''),
(9, 7, 16, 100, '5000', '500000', 'mariam', '0000-00-00', 0, 0, '2023-05-29 08:09:23', 'mariam', '0000-00-00 00:00:00', ''),
(10, 9, 13, 1, '5000', '5000', 'IT', '0000-00-00', 0, 0, '2023-05-31 10:22:13', 'Admin', '0000-00-00 00:00:00', ''),
(11, 10, 12, 1, '75000', '75000', 'Siti Mariam', '2023-06-06', 1, 1, '2023-06-05 10:02:04', 'Admin', '2023-06-05 10:11:59', 'Admin'),
(12, 12, 16, 20, '5000', '100000', 'Siti Mariam', '2023-06-06', 20, 1, '2023-06-05 10:17:10', 'Admin', '2023-06-06 01:46:22', 'Admin'),
(13, 12, 15, 1, '700000', '700000', 'Siti Mariam', '0000-00-00', 0, 0, '2023-06-05 10:21:13', 'Admin', '0000-00-00 00:00:00', ''),
(14, 13, 16, 10, '1000', '10000', 'PPU - Siti Mariam', '2023-06-12', 10, 1, '2023-06-12 08:40:49', 'Admin', '2023-06-12 08:41:53', 'Admin'),
(15, 14, 15, 1, '5500000', '5500000', 'IT', '2023-06-13', 1, 1, '2023-06-13 06:50:43', 'Admin', '2023-06-13 07:03:15', 'Admin'),
(16, 15, 11, 4, '70000', '280000', 'Siti Mariam, nadya, vivi, yens', '2023-06-15', 4, 1, '2023-06-15 04:41:13', 'Admin', '2023-06-15 04:42:13', 'Admin'),
(17, 17, 17, 1, '5500000', '5500000', 'IT', '0000-00-00', 0, 0, '2023-06-15 04:55:12', 'Admin', '2023-06-15 04:55:18', 'Admin');

-- --------------------------------------------------------

--
-- Table structure for table `trx_pengajuan_header`
--

CREATE TABLE `trx_pengajuan_header` (
  `id` int(11) NOT NULL,
  `tgl_pengajuan` date NOT NULL,
  `id_vendor` int(11) NOT NULL,
  `kepada` int(11) NOT NULL,
  `pemohon` int(11) NOT NULL,
  `catatan` varchar(200) NOT NULL,
  `diajukan` int(11) NOT NULL,
  `direkomendasi` int(11) NOT NULL,
  `disetujui` int(11) NOT NULL,
  `ditindaklanjut` int(11) NOT NULL,
  `memo_siap` int(11) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `trx_pengajuan_header`
--

INSERT INTO `trx_pengajuan_header` (`id`, `tgl_pengajuan`, `id_vendor`, `kepada`, `pemohon`, `catatan`, `diajukan`, `direkomendasi`, `disetujui`, `ditindaklanjut`, `memo_siap`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(1, '2023-05-19', 1, 1, 2, 'Catatan 2', 0, 0, 0, 0, 1, '2023-05-19 10:17:33', 'Admin', '2023-05-25 14:43:10', 'Admin'),
(2, '2023-05-26', 2, 1, 2, 'Untuk menunjang pembuatan design berita, poster dan design publikasi lainnya', 0, 0, 0, 0, 0, '2023-05-27 17:13:48', 'Admin', '2023-05-27 18:08:43', 'Admin'),
(3, '2023-05-29', 3, 3, 4, 'Pembelian Alat Tulis Kantor', 0, 0, 0, 0, 0, '2023-05-29 07:44:43', 'Admin', '0000-00-00 00:00:00', ''),
(4, '2023-05-29', 3, 3, 4, 'Pembelian ATK', 0, 0, 0, 0, 0, '2023-05-29 07:47:26', 'Admin', '2023-05-29 07:56:43', 'Admin'),
(5, '2023-05-08', 3, 1, 3, 'untuk di ruang 3', 0, 0, 0, 0, 1, '2023-05-29 08:05:55', 'mariam', '2023-05-31 02:00:27', 'Admin'),
(6, '2023-05-23', 1, 4, 3, 'vybg', 0, 0, 0, 0, 1, '2023-05-29 08:07:09', 'mariam', '2023-06-05 02:40:40', 'Admin'),
(7, '2023-05-29', 2, 1, 3, 'vtygy', 0, 0, 0, 0, 0, '2023-05-29 08:09:06', 'mariam', '0000-00-00 00:00:00', ''),
(8, '2023-05-31', 3, 1, 4, 'Beli alat tulis kantor', 0, 0, 0, 0, 0, '2023-05-31 01:37:24', 'Admin', '0000-00-00 00:00:00', ''),
(9, '2023-05-31', 2, 4, 4, 'asdad', 0, 0, 0, 0, 0, '2023-05-31 10:19:57', 'Admin', '0000-00-00 00:00:00', ''),
(10, '2023-06-05', 2, 1, 3, 'digunakan untuk ruang 2 (siti mariam dan ika aprilia)', 0, 0, 0, 0, 1, '2023-06-05 09:59:27', 'Admin', '2023-06-05 10:12:47', 'Admin'),
(11, '2023-06-05', 2, 1, 1, 'FSDF', 0, 0, 0, 0, 0, '2023-06-05 10:05:09', 'Admin', '0000-00-00 00:00:00', ''),
(12, '2023-06-05', 1, 1, 3, 'pembelian buku untuk di ruang 3', 0, 0, 0, 0, 1, '2023-06-05 10:16:52', 'Admin', '2023-06-12 08:36:06', 'Admin'),
(13, '2023-06-12', 1, 3, 2, 'Pembelian ATK', 2, 3, 4, 5, 0, '2023-06-12 08:40:23', 'Admin', '2023-06-12 14:58:40', 'Admin'),
(14, '2023-06-13', 1, 2, 4, 'Pembelian ', 3, 2, 2, 4, 1, '2023-06-13 06:50:28', 'Admin', '2023-06-13 07:04:58', 'Admin'),
(15, '2023-06-15', 3, 1, 3, 'pembelian 4pcs mouse untuk mariam, vivi, nadya, yensen', 2, 3, 4, 2, 1, '2023-06-15 04:40:38', 'Admin', '2023-06-15 04:43:23', 'Admin'),
(16, '2023-06-21', 4, 1, 2, 'dwwd', 2, 3, 2, 3, 0, '2023-06-15 04:42:21', 'Admin', '0000-00-00 00:00:00', ''),
(17, '2023-06-15', 2, 3, 2, 'Pembelian Ini Itu', 3, 5, 4, 4, 1, '2023-06-15 04:55:01', 'Admin', '2023-06-15 06:42:21', 'Admin'),
(18, '2023-06-15', 3, 3, 3, '', 2, 3, 5, 2, 0, '2023-06-15 06:08:12', 'Admin', '0000-00-00 00:00:00', ''),
(19, '2023-06-15', 4, 4, 1, '--', 4, 3, 2, 5, 0, '2023-06-15 06:12:11', 'Admin', '0000-00-00 00:00:00', '');

-- --------------------------------------------------------

--
-- Table structure for table `trx_pengeluaran`
--

CREATE TABLE `trx_pengeluaran` (
  `id` int(11) NOT NULL,
  `tgl_keluar` date NOT NULL,
  `digunakan_oleh` varchar(75) NOT NULL,
  `id_barang` int(11) NOT NULL,
  `jumlah` int(11) NOT NULL,
  `catatan` varchar(200) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `trx_pengeluaran`
--

INSERT INTO `trx_pengeluaran` (`id`, `tgl_keluar`, `digunakan_oleh`, `id_barang`, `jumlah`, `catatan`, `create_at`, `create_by`, `update_at`, `update_by`) VALUES
(2, '2023-05-23', 'Ika', 10, 1, '', '2023-05-23 15:38:53', 'Admin', '0000-00-00 00:00:00', ''),
(3, '2023-05-29', 'tes', 13, 1, 'tes', '2023-05-29 09:47:46', 'Admin', '0000-00-00 00:00:00', ''),
(4, '2023-05-29', 'tes', 13, 1, '', '2023-05-29 10:10:10', 'Admin', '0000-00-00 00:00:00', ''),
(5, '2023-05-29', 'tes', 13, 1, '', '2023-05-29 10:11:13', 'Admin', '0000-00-00 00:00:00', ''),
(6, '2023-05-29', 'tes', 13, 1, '', '2023-05-29 10:14:35', 'Admin', '0000-00-00 00:00:00', ''),
(10, '2023-05-30', 'nicky', 16, 10, 'tes', '2023-05-30 04:57:22', 'Admin', '0000-00-00 00:00:00', ''),
(11, '2023-05-30', 'nicky', 10, 1, 'tes', '2023-05-30 04:58:30', 'Admin', '0000-00-00 00:00:00', ''),
(12, '2023-05-29', 'tes', 13, 1, '', '2023-05-30 07:12:24', 'Admin', '0000-00-00 00:00:00', ''),
(13, '2023-06-05', 'Yansent', 17, 1, 'Digunakan untuk ruang 3', '2023-06-05 02:46:19', 'Admin', '0000-00-00 00:00:00', ''),
(14, '2023-06-06', 'siti mariam', 10, 1, 'untuk sekretariat', '2023-06-06 01:49:26', 'Admin', '0000-00-00 00:00:00', ''),
(15, '2023-06-15', 'Yansent', 13, 1, 'asd', '2023-06-15 04:05:43', 'Admin', '0000-00-00 00:00:00', ''),
(16, '2023-06-15', 'siti mariam', 11, 4, 'jinu', '2023-06-15 04:46:37', 'Admin', '0000-00-00 00:00:00', ''),
(17, '2023-06-09', 'wdwd', 10, 1, 'wdwd', '2023-06-15 04:46:55', 'Admin', '0000-00-00 00:00:00', ''),
(18, '2023-07-06', 'saya', 14, 2, '--', '2023-06-15 06:14:08', 'Admin', '0000-00-00 00:00:00', ''),
(19, '2023-07-06', 'saya', 14, 2, '--', '2023-06-15 06:14:12', 'Admin', '0000-00-00 00:00:00', ''),
(20, '2023-06-16', 'siti mariam', 19, 1, '', '2023-06-16 08:43:52', 'Admin', '0000-00-00 00:00:00', ''),
(21, '2023-06-16', 'siti mariam', 19, 1, 'safca', '2023-06-16 08:43:52', 'Admin', '0000-00-00 00:00:00', ''),
(22, '2023-06-16', 'siti mariam', 19, 1, '', '2023-06-16 08:43:52', 'Admin', '0000-00-00 00:00:00', ''),
(23, '2023-06-16', 'siti mariam', 15, 1, 'safca', '2023-06-16 08:43:53', 'Admin', '0000-00-00 00:00:00', '');

-- --------------------------------------------------------

--
-- Table structure for table `tr_absen`
--

CREATE TABLE `tr_absen` (
  `id` int(11) NOT NULL,
  `tanggal` date NOT NULL,
  `id_pengelola` varchar(20) NOT NULL,
  `absen_masuk` datetime NOT NULL,
  `foto_masuk` varchar(150) NOT NULL,
  `absen_pulang` datetime NOT NULL,
  `foto_pulang` varchar(150) NOT NULL,
  `istirahat_keluar` datetime NOT NULL,
  `foto_istirahat_keluar` varchar(150) NOT NULL,
  `istirahat_masuk` datetime NOT NULL,
  `foto_istirahat_masuk` varchar(150) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `tr_absen`
--

INSERT INTO `tr_absen` (`id`, `tanggal`, `id_pengelola`, `absen_masuk`, `foto_masuk`, `absen_pulang`, `foto_pulang`, `istirahat_keluar`, `foto_istirahat_keluar`, `istirahat_masuk`, `foto_istirahat_masuk`) VALUES
(63, '2023-12-11', 'KMW-0018', '2023-12-11 23:49:36', 'photo_1702313376.png', '0000-00-00 00:00:00', '', '2023-12-11 23:51:12', 'photo_1702313472.png', '2023-12-11 23:53:31', 'photo_1702313611.png');

-- --------------------------------------------------------

--
-- Table structure for table `tr_permohonan_cuti`
--

CREATE TABLE `tr_permohonan_cuti` (
  `id` int(11) NOT NULL,
  `id_pengelola` int(11) NOT NULL,
  `sisa_cuti` int(11) NOT NULL,
  `tgl_permohonan` date NOT NULL,
  `keperluan` varchar(150) NOT NULL,
  `tgl_permohonan_mulai` date NOT NULL,
  `tgl_permohonan_akhir` date NOT NULL,
  `lama_cuti` int(11) NOT NULL,
  `tindakan_hrd` int(11) NOT NULL,
  `tgl_tindakan` date NOT NULL,
  `catatan` varchar(150) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tr_permohonan_ijin`
--

CREATE TABLE `tr_permohonan_ijin` (
  `id` int(11) NOT NULL,
  `id_pengelola` int(11) NOT NULL,
  `sisa_ijin` int(11) NOT NULL,
  `tgl_permohonan` date NOT NULL,
  `keperluan` varchar(150) NOT NULL,
  `tgl_ijin` date NOT NULL,
  `jam_ijin_mulai` varchar(5) NOT NULL,
  `jam_ijin_akhir` varchar(5) NOT NULL,
  `lama_ijin` int(11) NOT NULL,
  `tindakan_hrd` int(11) NOT NULL,
  `tgl_tindakan` date NOT NULL,
  `catatan` varchar(150) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tr_permohonan_kunjungan`
--

CREATE TABLE `tr_permohonan_kunjungan` (
  `id` int(11) NOT NULL,
  `id_pengelola` int(11) NOT NULL,
  `tgl_dinas` date NOT NULL,
  `jam_pergi` varchar(5) NOT NULL,
  `jam_pulang` varchar(5) NOT NULL,
  `is_anggota` int(1) NOT NULL,
  `nama_anggota` varchar(150) NOT NULL,
  `keperluan` varchar(200) NOT NULL,
  `lokasi_kunjungan` varchar(200) NOT NULL,
  `tindakan_hrd` int(11) NOT NULL,
  `tgl_tindakan` date NOT NULL,
  `catatan` varchar(150) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tr_permohonan_lembur`
--

CREATE TABLE `tr_permohonan_lembur` (
  `id` int(11) NOT NULL,
  `id_pengelola` int(11) NOT NULL,
  `tgl_permohonan` date NOT NULL,
  `keperluan` varchar(150) NOT NULL,
  `tgl_lembur` date NOT NULL,
  `jam_mulai` varchar(5) NOT NULL,
  `jam_akhir` varchar(5) NOT NULL,
  `lama_lembur` varchar(30) NOT NULL,
  `tindakan_kadiv` int(11) NOT NULL,
  `tgl_tindakan_kadiv` date NOT NULL,
  `tindakan_hrd` int(11) NOT NULL,
  `tgl_tindakan_hrd` date NOT NULL,
  `catatan` varchar(150) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tr_permohonan_sakit`
--

CREATE TABLE `tr_permohonan_sakit` (
  `id` int(11) NOT NULL,
  `id_pengelola` int(11) NOT NULL,
  `tgl_permohonan` date NOT NULL,
  `keterangan_sakit` varchar(150) NOT NULL,
  `tgl_sakit_awal` date NOT NULL,
  `tgl_sakit_akhir` date NOT NULL,
  `lama_sakit` int(11) NOT NULL,
  `tindakan_hrd` int(11) NOT NULL,
  `tgl_tindakan` date NOT NULL,
  `catatan` varchar(150) NOT NULL,
  `create_at` datetime NOT NULL,
  `create_by` varchar(20) NOT NULL,
  `update_at` datetime NOT NULL,
  `update_by` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `user`
--

CREATE TABLE `user` (
  `ID` int(11) NOT NULL,
  `id_group` int(11) NOT NULL,
  `head_of` tinyint(4) NOT NULL COMMENT 'if user as head of',
  `name` char(50) CHARACTER SET latin1 DEFAULT NULL,
  `password` char(41) CHARACTER SET latin1 DEFAULT NULL,
  `since` date NOT NULL,
  `sort` int(11) NOT NULL,
  `id_pengelola` int(11) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Dumping data for table `user`
--

INSERT INTO `user` (`ID`, `id_group`, `head_of`, `name`, `password`, `since`, `sort`, `id_pengelola`) VALUES
(1, 1, 0, 'Admin', '6116afedcb0bc31083935c1c262ff4c9', '2017-04-01', 1, NULL),
(2, 2, 0, 'rical', '125a7e9426a1e702b0178978a567e72e', '2020-05-19', 2, NULL),
(3, 3, 0, 'mariam', '6116afedcb0bc31083935c1c262ff4c9', '2023-05-29', 3, NULL),
(4, 4, 0, 'siddhi', '6116afedcb0bc31083935c1c262ff4c9', '2023-11-17', 4, 4),
(5, 4, 0, 'yansen', '6116afedcb0bc31083935c1c262ff4c9', '2023-11-29', 5, 1),
(6, 4, 0, 'ika', '6116afedcb0bc31083935c1c262ff4c9', '2023-11-29', 6, 2);

-- --------------------------------------------------------

--
-- Table structure for table `user_group`
--

CREATE TABLE `user_group` (
  `ID` int(11) NOT NULL,
  `name` varchar(250) COLLATE latin1_general_ci NOT NULL,
  `sort` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Dumping data for table `user_group`
--

INSERT INTO `user_group` (`ID`, `name`, `sort`) VALUES
(1, 'Super Admin', 1),
(2, 'Admin', 2),
(3, 'Sekretariat', 3),
(4, 'Pengelola', 4);

-- --------------------------------------------------------

--
-- Table structure for table `user_group_detail`
--

CREATE TABLE `user_group_detail` (
  `ID` int(11) NOT NULL,
  `id_group` int(11) NOT NULL,
  `id_menu` int(11) NOT NULL,
  `read_flg` tinyint(1) NOT NULL,
  `sort` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Dumping data for table `user_group_detail`
--

INSERT INTO `user_group_detail` (`ID`, `id_group`, `id_menu`, `read_flg`, `sort`) VALUES
(400, 2, 1, 1, 400),
(24, 1, 19, 1, 24),
(25, 1, 18, 1, 25),
(26, 1, 17, 1, 26),
(28, 1, 1, 1, 28),
(29, 1, 15, 1, 29),
(30, 1, 5, 1, 30),
(31, 1, 20, 1, 31),
(32, 1, 16, 1, 32),
(34, 1, 3, 1, 34),
(35, 1, 25, 1, 35),
(38, 1, 2, 1, 38),
(39, 1, 6, 1, 39),
(42, 1, 8, 1, 42),
(399, 2, 2, 1, 399),
(398, 2, 3, 1, 398),
(397, 2, 5, 1, 397),
(396, 2, 6, 1, 396),
(395, 2, 8, 1, 395),
(394, 2, 15, 1, 394),
(393, 2, 20, 1, 393),
(392, 2, 25, 1, 392),
(391, 2, 42, 1, 391),
(386, 2, 79, 1, 386),
(468, 1, 117, 1, 468),
(383, 2, 82, 1, 383),
(300, 1, 79, 1, 300),
(467, 2, 117, 0, 467),
(312, 1, 82, 1, 312),
(470, 1, 118, 1, 470),
(469, 2, 118, 0, 469),
(462, 1, 114, 1, 462),
(461, 2, 114, 0, 461),
(515, 1, 127, 1, 515),
(514, 2, 127, 0, 514),
(476, 1, 121, 1, 476),
(475, 2, 121, 0, 475),
(460, 1, 113, 1, 460),
(459, 2, 113, 0, 459),
(518, 1, 128, 1, 518),
(517, 2, 128, 0, 517),
(478, 1, 122, 1, 478),
(477, 2, 122, 0, 477),
(464, 1, 115, 1, 464),
(463, 2, 115, 0, 463),
(479, 3, 122, 1, 479),
(480, 3, 121, 1, 480),
(513, 3, 127, 0, 513),
(483, 3, 118, 1, 483),
(484, 3, 117, 1, 484),
(516, 3, 128, 0, 516),
(486, 3, 115, 1, 486),
(487, 3, 114, 1, 487),
(488, 3, 113, 1, 488),
(489, 3, 82, 1, 489),
(490, 3, 79, 1, 490),
(491, 3, 42, 1, 491),
(492, 3, 25, 1, 492),
(493, 3, 20, 1, 493),
(494, 3, 15, 1, 494),
(495, 3, 8, 1, 495),
(496, 3, 6, 1, 496),
(497, 3, 5, 1, 497),
(498, 3, 3, 1, 498),
(499, 3, 2, 1, 499),
(500, 3, 1, 1, 500),
(501, 3, 123, 0, 501),
(502, 2, 123, 0, 502),
(503, 1, 123, 1, 503),
(504, 3, 124, 0, 504),
(505, 2, 124, 0, 505),
(506, 1, 124, 1, 506),
(507, 3, 125, 0, 507),
(508, 2, 125, 0, 508),
(509, 1, 125, 1, 509),
(510, 3, 126, 0, 510),
(511, 2, 126, 0, 511),
(512, 1, 126, 1, 512),
(519, 3, 129, 0, 519),
(520, 2, 129, 0, 520),
(521, 1, 129, 1, 521),
(522, 3, 130, 0, 522),
(523, 2, 130, 0, 523),
(524, 1, 130, 1, 524),
(525, 3, 131, 0, 525),
(526, 2, 131, 0, 526),
(527, 1, 131, 1, 527),
(528, 3, 132, 0, 528),
(529, 2, 132, 0, 529),
(530, 1, 132, 1, 530),
(531, 3, 133, 0, 531),
(532, 2, 133, 0, 532),
(533, 1, 133, 1, 533),
(534, 3, 134, 0, 534),
(535, 2, 134, 0, 535),
(536, 1, 134, 1, 536),
(537, 3, 135, 0, 537),
(538, 2, 135, 0, 538),
(539, 1, 135, 1, 539),
(540, 3, 136, 0, 540),
(541, 2, 136, 0, 541),
(542, 1, 136, 1, 542),
(543, 3, 137, 0, 543),
(544, 2, 137, 0, 544),
(545, 1, 137, 1, 545),
(546, 3, 138, 0, 546),
(547, 2, 138, 0, 547),
(548, 1, 138, 1, 548),
(549, 3, 139, 0, 549),
(550, 2, 139, 0, 550),
(551, 1, 139, 1, 551),
(552, 3, 140, 0, 552),
(553, 2, 140, 0, 553),
(554, 1, 140, 1, 554),
(555, 3, 141, 0, 555),
(556, 2, 141, 0, 556),
(557, 1, 141, 1, 557),
(558, 3, 142, 0, 558),
(559, 2, 142, 0, 559),
(560, 1, 142, 1, 560),
(561, 3, 143, 0, 561),
(562, 2, 143, 0, 562),
(563, 1, 143, 1, 563),
(564, 3, 144, 0, 564),
(565, 2, 144, 0, 565),
(566, 1, 144, 1, 566),
(567, 3, 145, 0, 567),
(568, 2, 145, 0, 568),
(569, 1, 145, 1, 569),
(570, 3, 143, 0, 570),
(571, 2, 143, 0, 571),
(572, 1, 143, 1, 572),
(573, 3, 144, 0, 573),
(574, 2, 144, 0, 574),
(575, 1, 144, 1, 575),
(576, 3, 145, 0, 576),
(577, 2, 145, 0, 577),
(578, 1, 145, 1, 578),
(579, 3, 146, 0, 579),
(580, 2, 146, 0, 580),
(581, 1, 146, 1, 581),
(582, 3, 147, 0, 582),
(583, 2, 147, 0, 583),
(584, 1, 147, 1, 584),
(585, 3, 148, 0, 585),
(586, 2, 148, 0, 586),
(587, 1, 148, 1, 587),
(588, 3, 149, 0, 588),
(589, 2, 149, 0, 589),
(590, 1, 149, 1, 590),
(591, 4, 149, 0, 591),
(592, 4, 148, 0, 592),
(593, 4, 147, 0, 593),
(594, 4, 146, 0, 594),
(595, 4, 145, 0, 595),
(596, 4, 144, 0, 596),
(597, 4, 143, 0, 597),
(598, 4, 142, 0, 598),
(599, 4, 141, 0, 599),
(600, 4, 140, 0, 600),
(601, 4, 139, 0, 601),
(602, 4, 138, 0, 602),
(603, 4, 137, 0, 603),
(604, 4, 136, 1, 604),
(605, 4, 135, 0, 605),
(606, 4, 134, 0, 606),
(607, 4, 133, 0, 607),
(608, 4, 132, 0, 608),
(609, 4, 131, 0, 609),
(610, 4, 130, 1, 610),
(611, 4, 129, 1, 611),
(612, 4, 128, 0, 612),
(613, 4, 127, 0, 613),
(614, 4, 126, 0, 614),
(615, 4, 125, 0, 615),
(616, 4, 124, 0, 616),
(617, 4, 123, 0, 617),
(618, 4, 122, 0, 618),
(619, 4, 121, 0, 619),
(620, 4, 118, 0, 620),
(621, 4, 117, 0, 621),
(622, 4, 115, 0, 622),
(623, 4, 114, 0, 623),
(624, 4, 113, 0, 624),
(625, 4, 82, 0, 625),
(626, 4, 79, 0, 626),
(627, 4, 42, 0, 627),
(628, 4, 25, 0, 628),
(629, 4, 20, 0, 629),
(630, 4, 15, 0, 630),
(631, 4, 8, 1, 631),
(632, 4, 6, 0, 632),
(633, 4, 5, 1, 633),
(634, 4, 3, 0, 634),
(635, 4, 2, 0, 635),
(636, 4, 1, 1, 636),
(637, 4, 150, 1, 637),
(638, 3, 150, 0, 638),
(639, 2, 150, 0, 639),
(640, 1, 150, 1, 640),
(641, 4, 151, 0, 641),
(642, 3, 151, 0, 642),
(643, 2, 151, 0, 643),
(644, 1, 151, 1, 644),
(645, 4, 152, 1, 645),
(646, 3, 152, 0, 646),
(647, 2, 152, 0, 647),
(648, 1, 152, 1, 648),
(649, 4, 153, 1, 649),
(650, 3, 153, 0, 650),
(651, 2, 153, 0, 651),
(652, 1, 153, 1, 652),
(653, 4, 154, 1, 653),
(654, 3, 154, 0, 654),
(655, 2, 154, 0, 655),
(656, 1, 154, 1, 656),
(657, 4, 155, 1, 657),
(658, 3, 155, 0, 658),
(659, 2, 155, 0, 659),
(660, 1, 155, 1, 660),
(661, 4, 156, 0, 661),
(662, 3, 156, 0, 662),
(663, 2, 156, 0, 663),
(664, 1, 156, 1, 664),
(665, 4, 157, 1, 665),
(666, 3, 157, 0, 666),
(667, 2, 157, 0, 667),
(668, 1, 157, 1, 668),
(669, 4, 158, 1, 669),
(670, 3, 158, 0, 670),
(671, 2, 158, 0, 671),
(672, 1, 158, 1, 672),
(673, 4, 159, 1, 673),
(674, 3, 159, 0, 674),
(675, 2, 159, 0, 675),
(676, 1, 159, 1, 676),
(677, 4, 159, 1, 677),
(678, 3, 159, 0, 678),
(679, 2, 159, 0, 679),
(680, 1, 159, 1, 680),
(681, 4, 160, 0, 681),
(682, 3, 160, 0, 682),
(683, 2, 160, 0, 683),
(684, 1, 160, 1, 684),
(685, 4, 161, 1, 685),
(686, 3, 161, 0, 686),
(687, 2, 161, 0, 687),
(688, 1, 161, 1, 688),
(692, 1, 162, 1, 692),
(691, 2, 162, 0, 691),
(690, 3, 162, 0, 690),
(689, 4, 162, 0, 689),
(693, 4, 163, 0, 693),
(694, 3, 163, 0, 694),
(695, 2, 163, 0, 695),
(696, 1, 163, 1, 696);

--
-- Indexes for dumped tables
--

--
-- Indexes for table `acc_coa`
--
ALTER TABLE `acc_coa`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `acc_journal`
--
ALTER TABLE `acc_journal`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `acc_journal_detail`
--
ALTER TABLE `acc_journal_detail`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `anggota`
--
ALTER TABLE `anggota`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `config_global`
--
ALTER TABLE `config_global`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `jenis_jurnal`
--
ALTER TABLE `jenis_jurnal`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `jenis_persediaan`
--
ALTER TABLE `jenis_persediaan`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `mspemasok`
--
ALTER TABLE `mspemasok`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `mspersediaan`
--
ALTER TABLE `mspersediaan`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `mst_barang`
--
ALTER TABLE `mst_barang`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `mst_divisi`
--
ALTER TABLE `mst_divisi`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `mst_kategori`
--
ALTER TABLE `mst_kategori`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `mst_koperasi`
--
ALTER TABLE `mst_koperasi`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `mst_pengurus`
--
ALTER TABLE `mst_pengurus`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `mst_satuan_copy`
--
ALTER TABLE `mst_satuan_copy`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `mst_status_member`
--
ALTER TABLE `mst_status_member`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `mst_status_repair`
--
ALTER TABLE `mst_status_repair`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `mst_status_terima`
--
ALTER TABLE `mst_status_terima`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `mst_vendor`
--
ALTER TABLE `mst_vendor`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `ms_menu`
--
ALTER TABLE `ms_menu`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `m_agama`
--
ALTER TABLE `m_agama`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `m_cuti_tahunan`
--
ALTER TABLE `m_cuti_tahunan`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `m_detail_kebijakan_cuti`
--
ALTER TABLE `m_detail_kebijakan_cuti`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `m_divisi`
--
ALTER TABLE `m_divisi`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `m_dokter`
--
ALTER TABLE `m_dokter`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `m_jabatan`
--
ALTER TABLE `m_jabatan`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `m_jadwal`
--
ALTER TABLE `m_jadwal`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `m_jenis_cuti`
--
ALTER TABLE `m_jenis_cuti`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `m_kebijakan_cuti`
--
ALTER TABLE `m_kebijakan_cuti`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `m_kelompok_menu`
--
ALTER TABLE `m_kelompok_menu`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `m_klinik`
--
ALTER TABLE `m_klinik`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `m_meja`
--
ALTER TABLE `m_meja`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `m_menu_resto`
--
ALTER TABLE `m_menu_resto`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `m_pasien`
--
ALTER TABLE `m_pasien`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `m_pengelola`
--
ALTER TABLE `m_pengelola`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `m_periode_cuti`
--
ALTER TABLE `m_periode_cuti`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `m_status_cuti`
--
ALTER TABLE `m_status_cuti`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `order_detail`
--
ALTER TABLE `order_detail`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `order_header`
--
ALTER TABLE `order_header`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `parameter_coa`
--
ALTER TABLE `parameter_coa`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `purchase_order_detail`
--
ALTER TABLE `purchase_order_detail`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `purchase_order_header`
--
ALTER TABLE `purchase_order_header`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `surat_ket_sakit`
--
ALTER TABLE `surat_ket_sakit`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `terima_inv_detail`
--
ALTER TABLE `terima_inv_detail`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `terima_inv_header`
--
ALTER TABLE `terima_inv_header`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `terima_sj_detail`
--
ALTER TABLE `terima_sj_detail`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `terima_sj_header`
--
ALTER TABLE `terima_sj_header`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `trx_memo_informasi`
--
ALTER TABLE `trx_memo_informasi`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `trx_pengajuan_detail`
--
ALTER TABLE `trx_pengajuan_detail`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `trx_pengajuan_header`
--
ALTER TABLE `trx_pengajuan_header`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `trx_pengeluaran`
--
ALTER TABLE `trx_pengeluaran`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tr_absen`
--
ALTER TABLE `tr_absen`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tr_permohonan_cuti`
--
ALTER TABLE `tr_permohonan_cuti`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tr_permohonan_ijin`
--
ALTER TABLE `tr_permohonan_ijin`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tr_permohonan_kunjungan`
--
ALTER TABLE `tr_permohonan_kunjungan`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tr_permohonan_lembur`
--
ALTER TABLE `tr_permohonan_lembur`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tr_permohonan_sakit`
--
ALTER TABLE `tr_permohonan_sakit`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `user`
--
ALTER TABLE `user`
  ADD PRIMARY KEY (`ID`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `acc_coa`
--
ALTER TABLE `acc_coa`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=119;

--
-- AUTO_INCREMENT for table `acc_journal`
--
ALTER TABLE `acc_journal`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=363;

--
-- AUTO_INCREMENT for table `acc_journal_detail`
--
ALTER TABLE `acc_journal_detail`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=123;

--
-- AUTO_INCREMENT for table `anggota`
--
ALTER TABLE `anggota`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5738;

--
-- AUTO_INCREMENT for table `jenis_jurnal`
--
ALTER TABLE `jenis_jurnal`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `jenis_persediaan`
--
ALTER TABLE `jenis_persediaan`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `mspemasok`
--
ALTER TABLE `mspemasok`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=20;

--
-- AUTO_INCREMENT for table `mspersediaan`
--
ALTER TABLE `mspersediaan`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=193;

--
-- AUTO_INCREMENT for table `mst_barang`
--
ALTER TABLE `mst_barang`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=21;

--
-- AUTO_INCREMENT for table `mst_divisi`
--
ALTER TABLE `mst_divisi`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `mst_kategori`
--
ALTER TABLE `mst_kategori`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `mst_koperasi`
--
ALTER TABLE `mst_koperasi`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `mst_pengurus`
--
ALTER TABLE `mst_pengurus`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `mst_satuan_copy`
--
ALTER TABLE `mst_satuan_copy`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `mst_status_member`
--
ALTER TABLE `mst_status_member`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `mst_status_repair`
--
ALTER TABLE `mst_status_repair`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `mst_status_terima`
--
ALTER TABLE `mst_status_terima`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `mst_vendor`
--
ALTER TABLE `mst_vendor`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `ms_menu`
--
ALTER TABLE `ms_menu`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=164;

--
-- AUTO_INCREMENT for table `m_agama`
--
ALTER TABLE `m_agama`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `m_cuti_tahunan`
--
ALTER TABLE `m_cuti_tahunan`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `m_detail_kebijakan_cuti`
--
ALTER TABLE `m_detail_kebijakan_cuti`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `m_divisi`
--
ALTER TABLE `m_divisi`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `m_dokter`
--
ALTER TABLE `m_dokter`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `m_jabatan`
--
ALTER TABLE `m_jabatan`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `m_jadwal`
--
ALTER TABLE `m_jadwal`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `m_jenis_cuti`
--
ALTER TABLE `m_jenis_cuti`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `m_kebijakan_cuti`
--
ALTER TABLE `m_kebijakan_cuti`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `m_kelompok_menu`
--
ALTER TABLE `m_kelompok_menu`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `m_klinik`
--
ALTER TABLE `m_klinik`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `m_meja`
--
ALTER TABLE `m_meja`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `m_menu_resto`
--
ALTER TABLE `m_menu_resto`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `m_pasien`
--
ALTER TABLE `m_pasien`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `m_pengelola`
--
ALTER TABLE `m_pengelola`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=35;

--
-- AUTO_INCREMENT for table `m_periode_cuti`
--
ALTER TABLE `m_periode_cuti`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `m_status_cuti`
--
ALTER TABLE `m_status_cuti`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `order_detail`
--
ALTER TABLE `order_detail`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=216;

--
-- AUTO_INCREMENT for table `order_header`
--
ALTER TABLE `order_header`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=46;

--
-- AUTO_INCREMENT for table `parameter_coa`
--
ALTER TABLE `parameter_coa`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `purchase_order_detail`
--
ALTER TABLE `purchase_order_detail`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14;

--
-- AUTO_INCREMENT for table `purchase_order_header`
--
ALTER TABLE `purchase_order_header`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=22;

--
-- AUTO_INCREMENT for table `surat_ket_sakit`
--
ALTER TABLE `surat_ket_sakit`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `terima_inv_detail`
--
ALTER TABLE `terima_inv_detail`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=25;

--
-- AUTO_INCREMENT for table `terima_inv_header`
--
ALTER TABLE `terima_inv_header`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14;

--
-- AUTO_INCREMENT for table `terima_sj_detail`
--
ALTER TABLE `terima_sj_detail`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `terima_sj_header`
--
ALTER TABLE `terima_sj_header`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=22;

--
-- AUTO_INCREMENT for table `trx_memo_informasi`
--
ALTER TABLE `trx_memo_informasi`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=20;

--
-- AUTO_INCREMENT for table `trx_pengajuan_detail`
--
ALTER TABLE `trx_pengajuan_detail`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=18;

--
-- AUTO_INCREMENT for table `trx_pengajuan_header`
--
ALTER TABLE `trx_pengajuan_header`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=20;

--
-- AUTO_INCREMENT for table `trx_pengeluaran`
--
ALTER TABLE `trx_pengeluaran`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=24;

--
-- AUTO_INCREMENT for table `tr_absen`
--
ALTER TABLE `tr_absen`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=64;

--
-- AUTO_INCREMENT for table `tr_permohonan_cuti`
--
ALTER TABLE `tr_permohonan_cuti`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `tr_permohonan_ijin`
--
ALTER TABLE `tr_permohonan_ijin`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `tr_permohonan_kunjungan`
--
ALTER TABLE `tr_permohonan_kunjungan`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `tr_permohonan_lembur`
--
ALTER TABLE `tr_permohonan_lembur`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `tr_permohonan_sakit`
--
ALTER TABLE `tr_permohonan_sakit`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `user`
--
ALTER TABLE `user`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
