var socket  = require( 'socket.io' );
var express = require('express');
var app     = express();
var server  = require('http').createServer(app);
var io      = socket.listen( server );
var port    = process.env.PORT || 3000;

server.listen(port, function () {
  console.log('Server listening at port %d', port);
});


io.on('connection', function (socket) {

  socket.on( 'count_message_service', function( data ) {
    io.sockets.emit( 'count_message_service', {
    	count_message_service: data.count_message_service
    });
  });

  socket.on( 'count_message_spareparts', function( data ) {
    io.sockets.emit( 'count_message_spareparts', {
    	count_message_spareparts: data.count_message_spareparts
    });
  });



  socket.on( 'new_notification_service', function( data ) {
    io.sockets.emit( 'new_notification_service', {
      id_detail: data.id_detail,
      activity: data.activity,
      date_in: data.date_in,
      admin_name: data.admin_name,
      note: data.note,
    });
  });

  socket.on('new_notification_spareparts', function( data )
  {
    io.sockets.emit( 'new_notification_service',
    {
      url_spareparts: data.url_spareparts,
      name_spareparts : data.name_spareparts,
      date_in_spareparts: data.date_in_spareparts,
      admin_name_spareparts: data.admin_name_spareparts,
      note_spareparts: data.note_spareparts,
    });
  });




  socket.on( 'update_count_message', function( data ) {
    io.sockets.emit( 'update_count_message', {
    	update_count_message: data.update_count_message
    });
  });


  socket.on( 'new_count_notif', function( data ) {
    io.sockets.emit( 'new_count_notif', {
    	new_count_notif: data.new_count_notif
    });
  });

  socket.on('new_notif', function( data ) {
    io.sockets.emit( 'new_notif', {
    	name: data.name,
    	desc: data.desc,
    	detail: data.detail,
    	publish: data.publish,
		  menuid: data.menuid,
    	ID: data.ID
    });
  });

  socket.on( 'new_admin', function( data ) {
    io.sockets.emit( 'new_admin', {
      name_admin: data.name_admin,
      email_admin: data.email_admin,
      image_admin: data.image_admin,
      id_admin: data.id_admin
    });
  });


});
